package org.wildfly.extension.messaging.activemq.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.modules.ModuleLoadException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.as.controller.RunningMode;
import java.lang.RuntimeException;
import org.jboss.as.controller.PathElement;
import org.jboss.logging.BasicLogger;
import org.jboss.msc.service.StartException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import org.jboss.modules.ModuleNotFoundException;
import javax.annotation.Generated;
import org.jboss.as.controller.OperationFailedException;
import javax.jms.IllegalStateRuntimeException;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceController.State;
import org.jboss.as.controller.PathAddress;
import java.lang.Throwable;
import org.jboss.dmr.ModelType;
import java.lang.Object;
import java.util.Arrays;
import org.jboss.dmr.ModelNode;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-05-01T09:06:23+0000")
public class MessagingLogger_$logger extends DelegatingBasicLogger implements MessagingLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = MessagingLogger_$logger.class.getName();
    public MessagingLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void aioInfo() {
        super.log.logf(FQCN, INFO, null, aioInfo$str());
    }
    private static final String aioInfo = "WFLYMSGAMQ0001: AIO wasn't located on this platform, it will fall back to using pure Java NIO.";
    protected String aioInfo$str() {
        return aioInfo;
    }
    @Override
    public final void boundJndiName(final String jndiName) {
        super.log.logf(FQCN, INFO, null, boundJndiName$str(), jndiName);
    }
    private static final String boundJndiName = "WFLYMSGAMQ0002: Bound messaging object to jndi name %s";
    protected String boundJndiName$str() {
        return boundJndiName;
    }
    @Override
    public final void errorStoppingJmsServer(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorStoppingJmsServer$str());
    }
    private static final String errorStoppingJmsServer = "WFLYMSGAMQ0003: Exception while stopping JMS server";
    protected String errorStoppingJmsServer$str() {
        return errorStoppingJmsServer;
    }
    @Override
    public final void failedToDestroy(final Throwable cause, final String description, final String name) {
        super.log.logf(FQCN, WARN, cause, failedToDestroy$str(), description, name);
    }
    private static final String failedToDestroy = "WFLYMSGAMQ0004: Failed to destroy %s: %s";
    protected String failedToDestroy$str() {
        return failedToDestroy;
    }
    @Override
    public final void failedToDestroy(final String description, final String name) {
        super.log.logf(FQCN, WARN, null, failedToDestroy$str(), description, name);
    }
    @Override
    public final void revertOperationFailed(final Throwable cause, final String className, final String operation, final PathAddress address) {
        super.log.logf(FQCN, ERROR, cause, revertOperationFailed$str(), className, operation, address);
    }
    private static final String revertOperationFailed = "WFLYMSGAMQ0005: %s caught exception attempting to revert operation %s at address %s";
    protected String revertOperationFailed$str() {
        return revertOperationFailed;
    }
    @Override
    public final void unboundJndiName(final String jndiName) {
        super.log.logf(FQCN, INFO, null, unboundJndiName$str(), jndiName);
    }
    private static final String unboundJndiName = "WFLYMSGAMQ0006: Unbound messaging object to jndi name %s";
    protected String unboundJndiName$str() {
        return unboundJndiName;
    }
    @Override
    public final void couldNotCloseFile(final String file, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, couldNotCloseFile$str(), file);
    }
    private static final String couldNotCloseFile = "WFLYMSGAMQ0007: Could not close file %s";
    protected String couldNotCloseFile$str() {
        return couldNotCloseFile;
    }
    @Override
    public final void failedToUnbindJndiName(final String jndiName, final long timeout, final String timeUnit) {
        super.log.logf(FQCN, WARN, null, failedToUnbindJndiName$str(), jndiName, timeout, timeUnit);
    }
    private static final String failedToUnbindJndiName = "WFLYMSGAMQ0008: Failed to unbind messaging object bound to jndi name %s in %d %s";
    protected String failedToUnbindJndiName$str() {
        return failedToUnbindJndiName;
    }
    @Override
    public final void startedService(final String type, final String name) {
        super.log.logf(FQCN, INFO, null, startedService$str(), type, name);
    }
    private static final String startedService = "WFLYMSGAMQ0011: Started %s %s";
    protected String startedService$str() {
        return startedService;
    }
    @Override
    public final void stoppedService(final String type, final String name) {
        super.log.logf(FQCN, INFO, null, stoppedService$str(), type, name);
    }
    private static final String stoppedService = "WFLYMSGAMQ0012: Stopped %s %s";
    protected String stoppedService$str() {
        return stoppedService;
    }
    @Override
    public final void unknownPooledConnectionFactoryAttribute(final String name) {
        super.log.logf(FQCN, WARN, null, unknownPooledConnectionFactoryAttribute$str(), name);
    }
    private static final String unknownPooledConnectionFactoryAttribute = "WFLYMSGAMQ0015: Ignoring %s property that is not a known property for pooled connection factory.";
    protected String unknownPooledConnectionFactoryAttribute$str() {
        return unknownPooledConnectionFactoryAttribute;
    }
    @Override
    public final void registeredHTTPUpgradeHandler(final String name, final String acceptor) {
        super.log.logf(FQCN, INFO, null, registeredHTTPUpgradeHandler$str(), name, acceptor);
    }
    private static final String registeredHTTPUpgradeHandler = "WFLYMSGAMQ0016: Registered HTTP upgrade for %s protocol handled by %s acceptor";
    protected String registeredHTTPUpgradeHandler$str() {
        return registeredHTTPUpgradeHandler;
    }
    @Override
    public final void connectorForPooledConnectionFactory(final String name, final String connectorName) {
        super.log.logf(FQCN, WARN, null, connectorForPooledConnectionFactory$str(), name, connectorName);
    }
    private static final String connectorForPooledConnectionFactory = "WFLYMSGAMQ0018: No connectors were explicitly defined for the pooled connection factory %s. Using %s as the connector.";
    protected String connectorForPooledConnectionFactory$str() {
        return connectorForPooledConnectionFactory;
    }
    private static final String cannotBindJndiName = "WFLYMSGAMQ0022: Cannot bind a null or empty string as jndi name";
    protected String cannotBindJndiName$str() {
        return cannotBindJndiName;
    }
    @Override
    public final IllegalArgumentException cannotBindJndiName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotBindJndiName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotUnbindJndiName = "WFLYMSGAMQ0025: Cannot unbind a null or empty string as jndi name";
    protected String cannotUnbindJndiName$str() {
        return cannotUnbindJndiName;
    }
    @Override
    public final IllegalArgumentException cannotUnbindJndiName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotUnbindJndiName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String childResourceAlreadyExists = "WFLYMSGAMQ0026: A child resource of type %1$s already exists; the messaging subsystem only allows a single resource of type %1$s";
    protected String childResourceAlreadyExists$str() {
        return childResourceAlreadyExists;
    }
    @Override
    public final String childResourceAlreadyExists(final String type) {
        return String.format(getLoggingLocale(), childResourceAlreadyExists$str(), type);
    }
    private static final String connectorNotDefined = "WFLYMSGAMQ0027: Connector %s not defined";
    protected String connectorNotDefined$str() {
        return connectorNotDefined;
    }
    @Override
    public final IllegalStateException connectorNotDefined(final String connectorName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), connectorNotDefined$str(), connectorName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreate = "WFLYMSGAMQ0028: Failed to create %s";
    protected String failedToCreate$str() {
        return failedToCreate;
    }
    @Override
    public final StartException failedToCreate(final Throwable cause, final String name) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToCreate$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToFindBroadcastSocketBinding = "WFLYMSGAMQ0029: Failed to find SocketBinding for broadcast binding: %s";
    protected String failedToFindBroadcastSocketBinding$str() {
        return failedToFindBroadcastSocketBinding;
    }
    @Override
    public final StartException failedToFindBroadcastSocketBinding(final String name) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToFindBroadcastSocketBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToFindConnectorSocketBinding = "WFLYMSGAMQ0030: Failed to find SocketBinding for connector: %s";
    protected String failedToFindConnectorSocketBinding$str() {
        return failedToFindConnectorSocketBinding;
    }
    @Override
    public final StartException failedToFindConnectorSocketBinding(final String name) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToFindConnectorSocketBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToFindDiscoverySocketBinding = "WFLYMSGAMQ0031: Failed to find SocketBinding for discovery binding: %s";
    protected String failedToFindDiscoverySocketBinding$str() {
        return failedToFindDiscoverySocketBinding;
    }
    @Override
    public final StartException failedToFindDiscoverySocketBinding(final String name) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToFindDiscoverySocketBinding$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToShutdownServer = "WFLYMSGAMQ0032: Failed to shutdown %s server";
    protected String failedToShutdownServer$str() {
        return failedToShutdownServer;
    }
    @Override
    public final RuntimeException failedToShutdownServer(final Throwable cause, final String server) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToShutdownServer$str(), server), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToStartService = "WFLYMSGAMQ0033: Failed to start service";
    protected String failedToStartService$str() {
        return failedToStartService;
    }
    @Override
    public final StartException failedToStartService(final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToStartService$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalValue = "WFLYMSGAMQ0036: Illegal value %s for element %s";
    protected String illegalValue$str() {
        return illegalValue;
    }
    @Override
    public final String illegalValue(final Object value, final String element) {
        return String.format(getLoggingLocale(), illegalValue$str(), value, element);
    }
    private static final String immutableResource = "WFLYMSGAMQ0037: Resource is immutable";
    protected String immutableResource$str() {
        return immutableResource;
    }
    @Override
    public final UnsupportedOperationException immutableResource() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), immutableResource$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalid = "WFLYMSGAMQ0038: %s is invalid";
    protected String invalid$str() {
        return invalid;
    }
    @Override
    public final String invalid(final Object obj) {
        return String.format(getLoggingLocale(), invalid$str(), obj);
    }
    private static final String invalidAttributeType = "WFLYMSGAMQ0039: Attribute %s has unexpected type %s";
    protected String invalidAttributeType$str() {
        return invalidAttributeType;
    }
    @Override
    public final IllegalStateException invalidAttributeType(final String name, final ModelType type) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidAttributeType$str(), name, type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidServiceState = "WFLYMSGAMQ0042: Service %s is not in state %s, it is in state %s";
    protected String invalidServiceState$str() {
        return invalidServiceState;
    }
    @Override
    public final IllegalStateException invalidServiceState(final ServiceName service, final State validState, final State currentState) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidServiceState$str(), service, validState, currentState));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jndiNameAlreadyRegistered = "WFLYMSGAMQ0043: JNDI name %s is already registered";
    protected String jndiNameAlreadyRegistered$str() {
        return jndiNameAlreadyRegistered;
    }
    @Override
    public final String jndiNameAlreadyRegistered(final String jndiName) {
        return String.format(getLoggingLocale(), jndiNameAlreadyRegistered$str(), jndiName);
    }
    private static final String required1 = "WFLYMSGAMQ0045: %s is required";
    protected String required1$str() {
        return required1;
    }
    @Override
    public final String required(final Object obj) {
        return String.format(getLoggingLocale(), required1$str(), obj);
    }
    private static final String required2 = "WFLYMSGAMQ0046: Either %s or %s is required";
    protected String required2$str() {
        return required2;
    }
    @Override
    public final String required(final Object obj1, final Object obj2) {
        return String.format(getLoggingLocale(), required2$str(), obj1, obj2);
    }
    private static final String nullVar = "WFLYMSGAMQ0047: %s is null";
    protected String nullVar$str() {
        return nullVar;
    }
    @Override
    public final IllegalArgumentException nullVar(final String varName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullVar$str(), varName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedAttribute = "WFLYMSGAMQ0050: Read support for attribute %s was not properly implemented";
    protected String unsupportedAttribute$str() {
        return unsupportedAttribute;
    }
    @Override
    public final IllegalStateException unsupportedAttribute(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unsupportedAttribute$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedOperation = "WFLYMSGAMQ0052: Support for operation %s was not properly implemented";
    protected String unsupportedOperation$str() {
        return unsupportedOperation;
    }
    @Override
    public final IllegalStateException unsupportedOperation(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unsupportedOperation$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedRuntimeAttribute = "WFLYMSGAMQ0053: Runtime handling for %s is not implemented";
    protected String unsupportedRuntimeAttribute$str() {
        return unsupportedRuntimeAttribute;
    }
    @Override
    public final UnsupportedOperationException unsupportedRuntimeAttribute(final String name) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedRuntimeAttribute$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String activeMQServerNotInstalled = "WFLYMSGAMQ0054: No ActiveMQ Server is available under name %s";
    protected String activeMQServerNotInstalled$str() {
        return activeMQServerNotInstalled;
    }
    @Override
    public final OperationFailedException activeMQServerNotInstalled(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), activeMQServerNotInstalled$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotParseDeployment = "WFLYMSGAMQ0055: Could not parse file %s";
    protected String couldNotParseDeployment$str() {
        return couldNotParseDeployment;
    }
    @Override
    public final DeploymentUnitProcessingException couldNotParseDeployment(final String file, final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), couldNotParseDeployment$str(), file), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String operationNotValid = "WFLYMSGAMQ0056: Handler cannot handle operation %s";
    protected String operationNotValid$str() {
        return operationNotValid;
    }
    @Override
    public final IllegalStateException operationNotValid(final String operation) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), operationNotValid$str(), operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDestinationRegisteredForAddress = "WFLYMSGAMQ0057: No message destination registered at address %s";
    protected String noDestinationRegisteredForAddress$str() {
        return noDestinationRegisteredForAddress;
    }
    @Override
    public final String noDestinationRegisteredForAddress(final PathAddress address) {
        return String.format(getLoggingLocale(), noDestinationRegisteredForAddress$str(), address);
    }
    private static final String securityDomainContextNotSet = "WFLYMSGAMQ0058: SecurityDomainContext has not been set";
    protected String securityDomainContextNotSet$str() {
        return securityDomainContextNotSet;
    }
    @Override
    public final IllegalStateException securityDomainContextNotSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), securityDomainContextNotSet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToRecover = "WFLYMSGAMQ0060: Failed to recover %s";
    protected String failedToRecover$str() {
        return failedToRecover;
    }
    @Override
    public final OperationFailedException failedToRecover(final Throwable cause, final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), failedToRecover$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canNotRegisterResourceOfType = "WFLYMSGAMQ0063: Resources of type %s cannot be registered";
    protected String canNotRegisterResourceOfType$str() {
        return canNotRegisterResourceOfType;
    }
    @Override
    public final UnsupportedOperationException canNotRegisterResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), canNotRegisterResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canNotRemoveResourceOfType = "WFLYMSGAMQ0064: Resources of type %s cannot be removed";
    protected String canNotRemoveResourceOfType$str() {
        return canNotRemoveResourceOfType;
    }
    @Override
    public final UnsupportedOperationException canNotRemoveResourceOfType(final String childType) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), canNotRemoveResourceOfType$str(), childType));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverInBackupMode = "WFLYMSGAMQ0066: Resource at the address %s can not be managed, the server is in backup mode";
    protected String serverInBackupMode$str() {
        return serverInBackupMode;
    }
    @Override
    public final String serverInBackupMode(final PathAddress address) {
        return String.format(getLoggingLocale(), serverInBackupMode$str(), address);
    }
    private static final String wrongConnectorRefInBroadCastGroup = "WFLYMSGAMQ0067: The broadcast group '%s' defines reference to nonexistent connector '%s'. Available connectors '%s'.";
    protected String wrongConnectorRefInBroadCastGroup$str() {
        return wrongConnectorRefInBroadCastGroup;
    }
    @Override
    public final OperationFailedException wrongConnectorRefInBroadCastGroup(final String bgName, final String connectorRef, final java.util.Collection<String> presentConnectors) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), wrongConnectorRefInBroadCastGroup$str(), bgName, connectorRef, presentConnectors));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String callNotPermittedOnInjectedJMSContext = "WFLYMSGAMQ0068: It is not permitted to call this method on injected JMSContext (see JMS 2.0 spec, §12.4.5).";
    protected String callNotPermittedOnInjectedJMSContext$str() {
        return callNotPermittedOnInjectedJMSContext;
    }
    @Override
    public final IllegalStateRuntimeException callNotPermittedOnInjectedJMSContext() {
        final IllegalStateRuntimeException result = new IllegalStateRuntimeException(String.format(getLoggingLocale(), callNotPermittedOnInjectedJMSContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noMatchingExpiryAddress(final String address, final String addressSettings) {
        super.log.logf(FQCN, WARN, null, noMatchingExpiryAddress$str(), address, addressSettings);
    }
    private static final String noMatchingExpiryAddress = "WFLYMSGAMQ0071: There is no resource matching the expiry-address %s for the address-settings %s, expired messages from destinations matching this address-setting will be lost!";
    protected String noMatchingExpiryAddress$str() {
        return noMatchingExpiryAddress;
    }
    @Override
    public final void noMatchingDeadLetterAddress(final String address, final String addressSettings) {
        super.log.logf(FQCN, WARN, null, noMatchingDeadLetterAddress$str(), address, addressSettings);
    }
    private static final String noMatchingDeadLetterAddress = "WFLYMSGAMQ0072: There is no resource matching the dead-letter-address %s for the address-settings %s, undelivered messages from destinations matching this address-setting will be lost!";
    protected String noMatchingDeadLetterAddress$str() {
        return noMatchingDeadLetterAddress;
    }
    private static final String canNotRemoveLastJNDIName = "WFLYMSGAMQ0073: Can not remove JNDI name %s. The resource must have at least one JNDI name";
    protected String canNotRemoveLastJNDIName$str() {
        return canNotRemoveLastJNDIName;
    }
    @Override
    public final String canNotRemoveLastJNDIName(final String jndiName) {
        return String.format(getLoggingLocale(), canNotRemoveLastJNDIName$str(), jndiName);
    }
    @Override
    public final void aioInfoLinux() {
        super.log.logf(FQCN, INFO, null, aioInfoLinux$str());
    }
    private static final String aioInfoLinux = "WFLYMSGAMQ0075: AIO wasn't located on this platform, it will fall back to using pure Java NIO. Your platform is Linux, install LibAIO to enable the AIO journal and achieve optimal performance.";
    protected String aioInfoLinux$str() {
        return aioInfoLinux;
    }
    private static final String duplicateElements = "WFLYMSGAMQ0076: Parameter %s contains duplicate elements [%s]";
    protected String duplicateElements$str() {
        return duplicateElements;
    }
    @Override
    public final OperationFailedException duplicateElements(final String parameterName, final ModelNode elements) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), duplicateElements$str(), parameterName, elements));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String canNotRemoveUnknownEntry = "WFLYMSGAMQ0077: Can not remove unknown entry %s";
    protected String canNotRemoveUnknownEntry$str() {
        return canNotRemoveUnknownEntry;
    }
    @Override
    public final OperationFailedException canNotRemoveUnknownEntry(final String entry) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), canNotRemoveUnknownEntry$str(), entry));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String onlyOneChildIsAllowed = "WFLYMSGAMQ0078: Only one %s child resource is allowed, found children: %s";
    protected String onlyOneChildIsAllowed$str() {
        return onlyOneChildIsAllowed;
    }
    @Override
    public final OperationFailedException onlyOneChildIsAllowed(final String childType, final java.util.Set<String> childrenNames) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), onlyOneChildIsAllowed$str(), childType, childrenNames));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexedChildResourceRegistrationNotAvailable = "WFLYMSGAMQ0079: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return indexedChildResourceRegistrationNotAvailable;
    }
    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(final PathElement address) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), indexedChildResourceRegistrationNotAvailable$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String discoveryGroupIsNotDefined = "WFLYMSGAMQ0080: Discovery group %s is not defined";
    protected String discoveryGroupIsNotDefined$str() {
        return discoveryGroupIsNotDefined;
    }
    @Override
    public final StartException discoveryGroupIsNotDefined(final String discoveryGroupName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), discoveryGroupIsNotDefined$str(), discoveryGroupName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedBroadcastGroupConfigurationForLegacy = "WFLYMSGAMQ0081: Unsupported type of broadcast group configuration for legacy resource: %s";
    protected String unsupportedBroadcastGroupConfigurationForLegacy$str() {
        return unsupportedBroadcastGroupConfigurationForLegacy;
    }
    @Override
    public final StartException unsupportedBroadcastGroupConfigurationForLegacy(final String broadcastGroupConfigurationClassName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unsupportedBroadcastGroupConfigurationForLegacy$str(), broadcastGroupConfigurationClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedConnectorFactoryForLegacy = "WFLYMSGAMQ0082: Unsupported type of connector factory for legacy resource: %s";
    protected String unsupportedConnectorFactoryForLegacy$str() {
        return unsupportedConnectorFactoryForLegacy;
    }
    @Override
    public final StartException unsupportedConnectorFactoryForLegacy(final String connectorFactoryClassName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), unsupportedConnectorFactoryForLegacy$str(), connectorFactoryClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String managementOperationAllowedOnlyInRunningMode = "WFLYMSGAMQ0083: The %s operation can not be performed: the server must be in %s mode";
    protected String managementOperationAllowedOnlyInRunningMode$str() {
        return managementOperationAllowedOnlyInRunningMode;
    }
    @Override
    public final OperationFailedException managementOperationAllowedOnlyInRunningMode(final String operationName, final RunningMode mode) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), managementOperationAllowedOnlyInRunningMode$str(), operationName, mode));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noInVMConnector = "WFLYMSGAMQ0084: The server does not define any in-vm connector. One is required to be able to import a journal";
    protected String noInVMConnector$str() {
        return noInVMConnector;
    }
    @Override
    public final OperationFailedException noInVMConnector() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noInVMConnector$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadClassFromModule = "WFLYMSGAMQ0085: Unable to load class %s from module %s";
    protected String unableToLoadClassFromModule$str() {
        return unableToLoadClassFromModule;
    }
    @Override
    public final OperationFailedException unableToLoadClassFromModule(final String className, final String moduleName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToLoadClassFromModule$str(), className, moduleName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadModule = "WFLYMSGAMQ0086: Unable to load module %s";
    protected String unableToLoadModule$str() {
        return unableToLoadModule;
    }
    @Override
    public final OperationFailedException unableToLoadModule(final String moduleName, final ModuleLoadException cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToLoadModule$str(), moduleName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadConnectorServiceFactoryClass = "WFLYMSGAMQ0087: Unable to load connector service factory class: %s";
    protected String unableToLoadConnectorServiceFactoryClass$str() {
        return unableToLoadConnectorServiceFactoryClass;
    }
    @Override
    public final OperationFailedException unableToLoadConnectorServiceFactoryClass(final String factroyClass) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unableToLoadConnectorServiceFactoryClass$str(), factroyClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidModularParameterValue = "WFLYMSGAMQ0088: %s is an invalid value for parameter %s, it should be multiple of %s";
    protected String invalidModularParameterValue$str() {
        return invalidModularParameterValue;
    }
    @Override
    public final OperationFailedException invalidModularParameterValue(final long size, final String parameterName, final long modular) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), invalidModularParameterValue$str(), size, parameterName, modular));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void invalidConfiguration(final PathAddress address, final String definedAttribute, final java.util.List<String> otherAttributes) {
        super.log.logf(FQCN, WARN, null, invalidConfiguration$str(), address, definedAttribute, otherAttributes);
    }
    private static final String invalidConfiguration = "WFLYMSGAMQ0089: Resource at %s is not correctly configured: when its attribute %s is defined, the other attributes %s will not be taken into account";
    protected String invalidConfiguration$str() {
        return invalidConfiguration;
    }
    private static final String invalidNullSecurityDomain = "WFLYMSGAMQ0090: The Elytron security domain cannot be null";
    protected String invalidNullSecurityDomain$str() {
        return invalidNullSecurityDomain;
    }
    @Override
    public final IllegalArgumentException invalidNullSecurityDomain() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNullSecurityDomain$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedAuthenticationWithException(final Throwable cause, final String username, final String message) {
        super.log.logf(FQCN, DEBUG, cause, failedAuthenticationWithException$str(), username, message);
    }
    private static final String failedAuthenticationWithException = "WFLYMSGAMQ0091: Failed to authenticate username %s. Exception message: %s";
    protected String failedAuthenticationWithException$str() {
        return failedAuthenticationWithException;
    }
    @Override
    public final void failedAuthentication(final String username) {
        super.log.logf(FQCN, DEBUG, null, failedAuthentication$str(), username);
    }
    private static final String failedAuthentication = "WFLYMSGAMQ0092: Failed to authenticate username %s: cannot verify username/password pair";
    protected String failedAuthentication$str() {
        return failedAuthentication;
    }
    @Override
    public final void failedAuthorization(final String username) {
        super.log.logf(FQCN, DEBUG, null, failedAuthorization$str(), username);
    }
    private static final String failedAuthorization = "WFLYMSGAMQ0093: Failed to authorize username %s: missing permissions";
    protected String failedAuthorization$str() {
        return failedAuthorization;
    }
    @Override
    public final void jdbcDatabaseDialectDetectionFailed(final String databaseDialects) {
        super.log.logf(FQCN, WARN, null, jdbcDatabaseDialectDetectionFailed$str(), databaseDialects);
    }
    private static final String jdbcDatabaseDialectDetectionFailed = "WFLYMSGAMQ0094: Unable to detect database dialect from connection metadata or JDBC driver name. Please configure this manually using the 'journal-database' property in your configuration.  Known database dialect strings are %s";
    protected String jdbcDatabaseDialectDetectionFailed$str() {
        return jdbcDatabaseDialectDetectionFailed;
    }
    @Override
    public final void multipleClientMappingsFound(final String socketBindingName, final String transportConfigName, final String host, final int port) {
        super.log.logf(FQCN, WARN, null, multipleClientMappingsFound$str(), socketBindingName, transportConfigName, host, port);
    }
    private static final String multipleClientMappingsFound = "WFLYMSGAMQ0095: Multiple client-mapping found in [%s] socket binding used by ActiveMQ [%s] transport configuration. Using address: [host: %s, port %s]";
    protected String multipleClientMappingsFound$str() {
        return multipleClientMappingsFound;
    }
    private static final String operationNotAllowedOnJdbcStore = "WFLYMSGAMQ0096: The %s operation can not be performed on a JDBC store journal";
    protected String operationNotAllowedOnJdbcStore$str() {
        return operationNotAllowedOnJdbcStore;
    }
    @Override
    public final OperationFailedException operationNotAllowedOnJdbcStore(final String operationName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), operationNotAllowedOnJdbcStore$str(), operationName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSocketBinding = "WFLYMSGAMQ0097: There is no socket-binding or outbound-socket-binding configured with the name %s";
    protected String noSocketBinding$str() {
        return noSocketBinding;
    }
    @Override
    public final OperationFailedException noSocketBinding(final String connectorSocketBinding) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noSocketBinding$str(), connectorSocketBinding));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String moduleNotFound = "WFLYMSGAMQ0098: Unable to load module %s - the module or one of its dependencies is missing [%s]";
    protected String moduleNotFound$str() {
        return moduleNotFound;
    }
    @Override
    public final OperationFailedException moduleNotFound(final String moduleName, final String missingModule, final ModuleNotFoundException e) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), moduleNotFound$str(), moduleName, missingModule), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
