package org.wildfly.extension.core.management.logging;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-25T13:21:52+0000")
public class CoreManagementLogger_$logger extends DelegatingBasicLogger implements CoreManagementLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = CoreManagementLogger_$logger.class.getName();
    public CoreManagementLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String processStateInitError = "WFLYCM0002: Error initializing the process state listener %s";
    protected String processStateInitError$str() {
        return processStateInitError;
    }
    @Override
    public final String processStateInitError(final Throwable t, final String name) {
        return String.format(getLoggingLocale(), processStateInitError$str(), name);
    }
    @Override
    public final void processStateInvokationError(final Throwable t, final String name) {
        super.log.logf(FQCN, ERROR, t, processStateInvokationError$str(), name);
    }
    private static final String processStateInvokationError = "WFLYCM0003: Error invoking the process state listener %s";
    protected String processStateInvokationError$str() {
        return processStateInvokationError;
    }
    @Override
    public final void processStateTimeoutError(final Throwable t, final String name) {
        super.log.logf(FQCN, ERROR, t, processStateTimeoutError$str(), name);
    }
    private static final String processStateTimeoutError = "WFLYCM0004: The process state listener %s took to much time to complete.";
    protected String processStateTimeoutError$str() {
        return processStateTimeoutError;
    }
    @Override
    public final void processStateCleanupError(final Throwable t, final String name) {
        super.log.logf(FQCN, ERROR, t, processStateCleanupError$str(), name);
    }
    private static final String processStateCleanupError = "WFLYCM0005: Error cleaning up for the process state listener %s";
    protected String processStateCleanupError$str() {
        return processStateCleanupError;
    }
    private static final String errorToLoadModule = "WFLYCM0006: Error to load module %s";
    protected String errorToLoadModule$str() {
        return errorToLoadModule;
    }
    @Override
    public final OperationFailedException errorToLoadModule(final String moduleID) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), errorToLoadModule$str(), moduleID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorToLoadModuleClass = "WFLYCM0007: Error to load class %s from module %s";
    protected String errorToLoadModuleClass$str() {
        return errorToLoadModuleClass;
    }
    @Override
    public final OperationFailedException errorToLoadModuleClass(final String className, final String moduleID) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), errorToLoadModuleClass$str(), className, moduleID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorToInstantiateClassInstanceFromModule = "WFLYCM0008: Error to instantiate instance of class %s from module %s";
    protected String errorToInstantiateClassInstanceFromModule$str() {
        return errorToInstantiateClassInstanceFromModule;
    }
    @Override
    public final OperationFailedException errorToInstantiateClassInstanceFromModule(final String className, final String moduleID) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), errorToInstantiateClassInstanceFromModule$str(), className, moduleID));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
