package org.wildfly.client.config._private;

import java.util.Locale;
import java.io.Serializable;
import java.net.MalformedURLException;
import javax.annotation.Generated;
import org.wildfly.client.config.XMLLocation;
import javax.xml.namespace.QName;
import java.lang.NumberFormatException;
import java.lang.String;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.wildfly.client.config.ConfigXMLParseException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2018-08-28T12:32:29-0400")
public class ConfigMessages_$bundle implements ConfigMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected ConfigMessages_$bundle() {}
    public static final ConfigMessages_$bundle INSTANCE = new ConfigMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String parseError = "CONF0001: An unspecified XML parse error occurred";
    protected String parseError$str() {
        return parseError;
    }
    @Override
    public final String parseError() {
        return String.format(getLoggingLocale(), parseError$str());
    }
    private static final String closeNotSupported = "CONF0002: Calling close() on XMLConfigurationReader is not supported";
    protected String closeNotSupported$str() {
        return closeNotSupported;
    }
    @Override
    public final UnsupportedOperationException closeNotSupported() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), closeNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedDocumentEnd = "CONF0003: Unexpected end of document";
    protected String unexpectedDocumentEnd$str() {
        return unexpectedDocumentEnd;
    }
    @Override
    public final ConfigXMLParseException unexpectedDocumentEnd(final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), unexpectedDocumentEnd$str()), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedContent = "CONF0004: Unexpected content of type \"%s\"";
    protected String unexpectedContent$str() {
        return unexpectedContent;
    }
    @Override
    public final ConfigXMLParseException unexpectedContent(final String eventType, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), unexpectedContent$str(), eventType), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedElement2 = "CONF0005: Unexpected element \"%s\" in namespace \"%s\" encountered";
    protected String unexpectedElement2$str() {
        return unexpectedElement2;
    }
    @Override
    public final ConfigXMLParseException unexpectedElement(final String localName, final String namespaceUri, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), unexpectedElement2$str(), localName, namespaceUri), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedElement1 = "CONF0005: Unexpected element \"%s\" (no namespace) encountered";
    protected String unexpectedElement1$str() {
        return unexpectedElement1;
    }
    @Override
    public final ConfigXMLParseException unexpectedElement(final String localName, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), unexpectedElement1$str(), localName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedStartOrEndElement = "CONF0006: Expected start or end element, found \"%s\"";
    protected String expectedStartOrEndElement$str() {
        return expectedStartOrEndElement;
    }
    @Override
    public final ConfigXMLParseException expectedStartOrEndElement(final String eventTypeName, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), expectedStartOrEndElement$str(), eventTypeName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedStartElement = "CONF0007: Expected start element, found \"%s\"";
    protected String expectedStartElement$str() {
        return expectedStartElement;
    }
    @Override
    public final ConfigXMLParseException expectedStartElement(final String eventTypeName, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), expectedStartElement$str(), eventTypeName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String textCannotContainElements = "CONF0008: Text content cannot contain elements";
    protected String textCannotContainElements$str() {
        return textCannotContainElements;
    }
    @Override
    public final ConfigXMLParseException textCannotContainElements(final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), textCannotContainElements$str()), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedEventType = "CONF0009: Expected event type \"%s\", found \"%s\"";
    protected String expectedEventType$str() {
        return expectedEventType;
    }
    @Override
    public final ConfigXMLParseException expectedEventType(final String expectedEventTypeName, final String eventTypeName, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), expectedEventType$str(), expectedEventTypeName, eventTypeName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedNamespace = "CONF0010: Expected namespace URI \"%s\", found \"%s\"";
    protected String expectedNamespace$str() {
        return expectedNamespace;
    }
    @Override
    public final ConfigXMLParseException expectedNamespace(final String expectedNamespaceURI, final String actualNamespaceURI, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), expectedNamespace$str(), expectedNamespaceURI, actualNamespaceURI), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedLocalName = "CONF0011: Expected local name \"%s\", found \"%s\"";
    protected String expectedLocalName$str() {
        return expectedLocalName;
    }
    @Override
    public final ConfigXMLParseException expectedLocalName(final String expectedLocalName, final String actualLocalName, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), expectedLocalName$str(), expectedLocalName, actualLocalName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReadInput = "CONF0012: Failed to read from input source";
    protected String failedToReadInput$str() {
        return failedToReadInput;
    }
    @Override
    public final ConfigXMLParseException failedToReadInput(final XMLLocation location, final IOException cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), failedToReadInput$str()), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCloseInput = "CONF0013: Failed to close input source";
    protected String failedToCloseInput$str() {
        return failedToCloseInput;
    }
    @Override
    public final ConfigXMLParseException failedToCloseInput(final XMLLocation location, final IOException cause) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), failedToCloseInput$str()), location, cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidUrl = "CONF0014: Invalid configuration file URL";
    protected String invalidUrl$str() {
        return invalidUrl;
    }
    @Override
    public final ConfigXMLParseException invalidUrl(final XMLLocation location, final MalformedURLException e) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), invalidUrl$str()), location, e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedAttribute = "CONF0015: Unexpected attribute \"%s\" encountered";
    protected String unexpectedAttribute$str() {
        return unexpectedAttribute;
    }
    @Override
    public final ConfigXMLParseException unexpectedAttribute(final QName name, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), unexpectedAttribute$str(), name), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingRequiredElement = "CONF0016: Missing required element \"%2$s\" from namespace \"%s\"";
    protected String missingRequiredElement$str() {
        return missingRequiredElement;
    }
    @Override
    public final ConfigXMLParseException missingRequiredElement(final String namespaceUri, final String localName, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), missingRequiredElement$str(), namespaceUri, localName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingRequiredAttribute = "CONF0017: Missing required attribute \"%2$s\" from namespace \"%s\"";
    protected String missingRequiredAttribute$str() {
        return missingRequiredAttribute;
    }
    @Override
    public final ConfigXMLParseException missingRequiredAttribute(final String namespaceUri, final String localName, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), missingRequiredAttribute$str(), namespaceUri, localName), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String intParseException = "CONF0018: Failed to parse integer value of attribute \"%s\"";
    protected String intParseException$str() {
        return intParseException;
    }
    @Override
    public final ConfigXMLParseException intParseException(final NumberFormatException e, final QName attributeName, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), intParseException$str(), attributeName), location, e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String uriParseException = "CONF0019: Failed to parse URI value of attribute \"%s\"";
    protected String uriParseException$str() {
        return uriParseException;
    }
    @Override
    public final ConfigXMLParseException uriParseException(final URISyntaxException e, final QName attributeName, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), uriParseException$str(), attributeName), location, e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expressionParseException = "CONF0020: Failed to parse expression value of attribute \"%s\"";
    protected String expressionParseException$str() {
        return expressionParseException;
    }
    @Override
    public final ConfigXMLParseException expressionParseException(final IllegalArgumentException ex, final QName attributeName, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), expressionParseException$str(), attributeName), location, ex);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expressionTextParseException = "CONF0021: Failed to parse expression text";
    protected String expressionTextParseException$str() {
        return expressionTextParseException;
    }
    @Override
    public final ConfigXMLParseException expressionTextParseException(final IllegalArgumentException ex, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), expressionTextParseException$str()), location, ex);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String numericAttributeValueOutOfRange = "CONF0022: Numeric value of attribute \"%s\" is out of range; actual value is \"%s\" but the value must not be less than %d or more than %d";
    protected String numericAttributeValueOutOfRange$str() {
        return numericAttributeValueOutOfRange;
    }
    @Override
    public final ConfigXMLParseException numericAttributeValueOutOfRange(final QName attributeName, final String actualValue, final long minValue, final long maxValue, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), numericAttributeValueOutOfRange$str(), attributeName, actualValue, minValue, maxValue), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String inetAddressParseException = "CONF0023: Failed to parse IP address value of attribute \"%s\": \"%s\" is not a valid IP address";
    protected String inetAddressParseException$str() {
        return inetAddressParseException;
    }
    @Override
    public final ConfigXMLParseException inetAddressParseException(final QName attributeName, final String address, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), inetAddressParseException$str(), attributeName, address), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cidrAddressParseException = "CONF0024: Failed to parse CIDR address value of attribute \"%s\": \"%s\" is not a valid CIDR address";
    protected String cidrAddressParseException$str() {
        return cidrAddressParseException;
    }
    @Override
    public final ConfigXMLParseException cidrAddressParseException(final QName attributeName, final String address, final XMLLocation location) {
        final ConfigXMLParseException result = new ConfigXMLParseException(String.format(getLoggingLocale(), cidrAddressParseException$str(), attributeName, address), location);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
