/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LoggingConfigurationUpdater;
import org.apache.activemq.artemis.core.server.reload.ReloadCallback;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.logmanager.config.LogContextConfiguration;

public class LoggingConfigurationFileReloader
implements ReloadCallback {
    private final Lock lock = new ReentrantLock();
    private final Logger.AttachmentKey<LoggingConfigurationUpdater> KEY = new Logger.AttachmentKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload(URL uri) throws Exception {
        ActiveMQServerLogger.LOGGER.reloadingConfiguration("logging");
        LoggingConfigurationUpdater updater = this.getOrCreateUpdater();
        if (updater == null) {
            ActiveMQServerLogger.LOGGER.loggingReloadFailed(uri.toString(), null);
            return;
        }
        try (InputStream in = uri.openStream();){
            this.lock.lock();
            updater.configure(in);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.loggingReloadFailed(uri.toString(), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private LoggingConfigurationUpdater getOrCreateUpdater() {
        LogContext logContext = LogContext.getLogContext();
        Logger rootLogger = logContext.getLogger("");
        LoggingConfigurationUpdater updater = (LoggingConfigurationUpdater)rootLogger.getAttachment(this.KEY);
        if (updater == null) {
            LogContextConfiguration logContextConfiguration = this.getOrCreateConfiguration(rootLogger);
            if (logContextConfiguration == null) {
                return null;
            }
            updater = new LoggingConfigurationUpdater(logContextConfiguration);
            LoggingConfigurationUpdater appearing = (LoggingConfigurationUpdater)rootLogger.attachIfAbsent(this.KEY, (Object)updater);
            if (appearing != null) {
                updater = appearing;
            }
        }
        return updater;
    }

    private LogContextConfiguration getOrCreateConfiguration(Logger rootLogger) {
        Configurator appearing;
        Configurator configurator = (Configurator)rootLogger.getAttachment(Configurator.ATTACHMENT_KEY);
        if (configurator == null && (appearing = (Configurator)rootLogger.attachIfAbsent(Configurator.ATTACHMENT_KEY, (Object)(configurator = new PropertyConfigurator(rootLogger.getLogContext())))) != null) {
            configurator = appearing;
        }
        if (configurator instanceof PropertyConfigurator) {
            return ((PropertyConfigurator)configurator).getLogContextConfiguration();
        }
        return null;
    }
}

