/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupResource;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;
import org.jboss.migration.wfly10.config.task.management.profile.AddProfileTaskBuilder;
import org.jboss.migration.wfly10.config.task.management.resource.ManageableResourceBuildParameters;
import org.jboss.migration.wfly10.config.task.management.subsystem.AddSubsystemResourceSubtaskBuilder;
import org.jboss.migration.wfly10.config.task.management.subsystem.AddSubsystemResources;

public class AddLoadBalancerProfile<S>
extends AddProfileTaskBuilder<S> {
    public AddLoadBalancerProfile() {
        super("load-balancer");
        this.subtasks.subtask(new AddLoadBalancerSocketBindingsGroup());
        this.addSubsystemSubtasks(new AddSubsystemResources[]{new AddSubsystemResources("org.wildfly.extension.io", new AddIOSubsystemConfig()), new AddSubsystemResources("org.wildfly.extension.undertow", new AddUndertowSubsystemConfig()), new AddSubsystemResources("org.jboss.as.logging", new AddLoggingSubsystemConfig())});
    }

    public static class AddLoggingSubsystemConfig<S>
    extends AddSubsystemResourceSubtaskBuilder<S> {
        protected AddLoggingSubsystemConfig() {
            super("logging");
            this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        }

        protected void addConfiguration(ManageableResourceBuildParameters<S, SubsystemResource.Parent> params, TaskContext taskContext) {
            super.addConfiguration(params, taskContext);
            ManageableServerConfiguration configuration = params.getServerConfiguration();
            PathAddress subsystemPathAddress = ((SubsystemResource.Parent)params.getResource()).getSubsystemResourcePathAddress(this.getSubsystem());
            PathAddress patternFormatterPATTERNPathAddress = subsystemPathAddress.append("pattern-formatter", "PATTERN");
            ModelNode patternFormatterPATTERNOp = Util.createAddOperation((PathAddress)patternFormatterPATTERNPathAddress);
            patternFormatterPATTERNOp.get("pattern").set("%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n");
            configuration.executeManagementOperation(patternFormatterPATTERNOp);
            PathAddress patternFormatterCOLORPATTERNPathAddress = subsystemPathAddress.append("pattern-formatter", "COLOR-PATTERN");
            ModelNode patternFormatterCOLORPATTERNOp = Util.createAddOperation((PathAddress)patternFormatterCOLORPATTERNPathAddress);
            patternFormatterCOLORPATTERNOp.get("pattern").set("%K{level}%d{HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n");
            configuration.executeManagementOperation(patternFormatterCOLORPATTERNOp);
            PathAddress consoleHandlerCONSOLEPathAddress = subsystemPathAddress.append("console-handler", "CONSOLE");
            ModelNode consoleHandlerCONSOLEOp = Util.createAddOperation((PathAddress)consoleHandlerCONSOLEPathAddress);
            consoleHandlerCONSOLEOp.get("level").set("INFO");
            configuration.executeManagementOperation(consoleHandlerCONSOLEOp);
            PathAddress periodicRotatingFileHandlerFILEPathAddress = subsystemPathAddress.append("periodic-rotating-file-handler", "FILE");
            ModelNode periodicRotatingFileHandlerFILEOp = Util.createAddOperation((PathAddress)periodicRotatingFileHandlerFILEPathAddress);
            periodicRotatingFileHandlerFILEOp.get("autoflush").set(true);
            periodicRotatingFileHandlerFILEOp.get("append").set(true);
            ModelNode file = new ModelNode();
            file.get("relative-to").set("jboss.server.log.dir");
            file.get("path").set("server.log");
            periodicRotatingFileHandlerFILEOp.get("file").set(file);
            periodicRotatingFileHandlerFILEOp.get("suffix").set(".yyyy-MM-dd");
            periodicRotatingFileHandlerFILEOp.get("named-formatter").set("PATTERN");
            configuration.executeManagementOperation(periodicRotatingFileHandlerFILEOp);
            PathAddress comArjunaLoggerPathAddress = subsystemPathAddress.append("logger", "com.arjuna");
            ModelNode comArjunaLoggerOp = Util.createAddOperation((PathAddress)comArjunaLoggerPathAddress);
            comArjunaLoggerOp.get("level").set("WARN");
            configuration.executeManagementOperation(comArjunaLoggerOp);
            PathAddress orgJbossAsConfigLoggerPathAddress = subsystemPathAddress.append("logger", "org.jboss.as.config");
            ModelNode orgJbossAsConfigLoggerOp = Util.createAddOperation((PathAddress)orgJbossAsConfigLoggerPathAddress);
            orgJbossAsConfigLoggerOp.get("level").set("DEBUG");
            configuration.executeManagementOperation(orgJbossAsConfigLoggerOp);
            PathAddress sunRmiLoggerPathAddress = subsystemPathAddress.append("logger", "sun.rmi");
            ModelNode sunRmiLoggerOp = Util.createAddOperation((PathAddress)sunRmiLoggerPathAddress);
            sunRmiLoggerOp.get("level").set("WARN");
            configuration.executeManagementOperation(sunRmiLoggerOp);
            PathAddress rootLoggerROOTPathAddress = subsystemPathAddress.append("root-logger", "ROOT");
            ModelNode rootLoggerROOTOp = Util.createAddOperation((PathAddress)rootLoggerROOTPathAddress);
            rootLoggerROOTOp.get("level").set("INFO");
            rootLoggerROOTOp.get("handlers").setEmptyList().add("CONSOLE").add("FILE");
            configuration.executeManagementOperation(rootLoggerROOTOp);
        }
    }

    public static class AddUndertowSubsystemConfig<S>
    extends AddSubsystemResourceSubtaskBuilder<S> {
        protected AddUndertowSubsystemConfig() {
            super("undertow");
            this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        }

        protected void addConfiguration(ManageableResourceBuildParameters<S, SubsystemResource.Parent> params, TaskContext taskContext) {
            ManageableServerConfiguration configuration = params.getServerConfiguration();
            Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
            PathAddress subsystemPathAddress = ((SubsystemResource.Parent)params.getResource()).getSubsystemResourcePathAddress(this.getSubsystem());
            compositeOperationBuilder.addStep(Util.createAddOperation((PathAddress)subsystemPathAddress));
            PathAddress defaultServletContainerPathAddress = subsystemPathAddress.append("servlet-container", "default");
            compositeOperationBuilder.addStep(Util.createAddOperation((PathAddress)defaultServletContainerPathAddress));
            PathAddress configurationFilterPathAddress = subsystemPathAddress.append("configuration", "filter");
            compositeOperationBuilder.addStep(Util.createAddOperation((PathAddress)configurationFilterPathAddress));
            PathAddress modClusterLoadBalancerPathAddress = configurationFilterPathAddress.append("mod-cluster", "load-balancer");
            ModelNode modClusterLoadBalancerOp = Util.createAddOperation((PathAddress)modClusterLoadBalancerPathAddress);
            modClusterLoadBalancerOp.get("management-socket-binding").set("mcmp-management");
            modClusterLoadBalancerOp.get("advertise-socket-binding").set("modcluster");
            modClusterLoadBalancerOp.get("enable-http2").set(true);
            modClusterLoadBalancerOp.get("max-retries").set(3);
            compositeOperationBuilder.addStep(modClusterLoadBalancerOp);
            PathAddress configurationHandlerPathAddress = subsystemPathAddress.append("configuration", "handler");
            compositeOperationBuilder.addStep(Util.createAddOperation((PathAddress)configurationHandlerPathAddress));
            PathAddress serverDefaultServerPathAddress = subsystemPathAddress.append("server", "default-server");
            compositeOperationBuilder.addStep(Util.createAddOperation((PathAddress)serverDefaultServerPathAddress));
            PathAddress hostDefaultHostPathAddress = serverDefaultServerPathAddress.append("host", "default-host");
            ModelNode hostDefaultHostOp = Util.createAddOperation((PathAddress)hostDefaultHostPathAddress);
            hostDefaultHostOp.get("alias").setEmptyList().add("localhost");
            compositeOperationBuilder.addStep(hostDefaultHostOp);
            PathAddress filterRefLoadBalancerPathAddress = hostDefaultHostPathAddress.append("filter-ref", "load-balancer");
            compositeOperationBuilder.addStep(Util.createAddOperation((PathAddress)filterRefLoadBalancerPathAddress));
            PathAddress httpListenerDefaultPathAddress = serverDefaultServerPathAddress.append("http-listener", "default");
            ModelNode httpListenerDefaultOp = Util.createAddOperation((PathAddress)httpListenerDefaultPathAddress);
            httpListenerDefaultOp.get("socket-binding").set("http");
            httpListenerDefaultOp.get("redirect-socket").set("https");
            httpListenerDefaultOp.get("enable-http2").set(true);
            compositeOperationBuilder.addStep(httpListenerDefaultOp);
            PathAddress httpListenerManagementPathAddress = serverDefaultServerPathAddress.append("http-listener", "management");
            ModelNode httpListenerManagementOp = Util.createAddOperation((PathAddress)httpListenerManagementPathAddress);
            httpListenerManagementOp.get("socket-binding").set("mcmp-management");
            httpListenerManagementOp.get("enable-http2").set(true);
            compositeOperationBuilder.addStep(httpListenerManagementOp);
            PathAddress bufferCacheDefaultPathAddress = subsystemPathAddress.append("buffer-cache", "default");
            compositeOperationBuilder.addStep(Util.createAddOperation((PathAddress)bufferCacheDefaultPathAddress));
            configuration.executeManagementOperation(compositeOperationBuilder.build().getOperation());
        }
    }

    public static class AddIOSubsystemConfig<S>
    extends AddSubsystemResourceSubtaskBuilder<S> {
        protected AddIOSubsystemConfig() {
            super("io");
            this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        }

        protected void addConfiguration(ManageableResourceBuildParameters<S, SubsystemResource.Parent> params, TaskContext taskContext) {
            super.addConfiguration(params, taskContext);
            ManageableServerConfiguration configuration = params.getServerConfiguration();
            PathAddress subsystemPathAddress = ((SubsystemResource.Parent)params.getResource()).getSubsystemResourcePathAddress(this.getSubsystem());
            PathAddress workerDefaultPathAddress = subsystemPathAddress.append("worker", "default");
            configuration.executeManagementOperation(Util.createAddOperation((PathAddress)workerDefaultPathAddress));
            PathAddress bufferPoolDefaultPathAddress = subsystemPathAddress.append("buffer-pool", "default");
            configuration.executeManagementOperation(Util.createAddOperation((PathAddress)bufferPoolDefaultPathAddress));
        }
    }

    public static class AddLoadBalancerSocketBindingsGroup<S>
    extends ManageableServerConfigurationLeafTask.Builder<S> {
        private static final String SOCKET_BINDING_GROUP_NAME = "load-balancer-sockets";

        protected AddLoadBalancerSocketBindingsGroup() {
            this.name("add-load-balancer-sockets");
            this.skipPolicyBuilders(new TaskSkipPolicy.Builder[]{buildParameters -> TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet(), buildParameters -> context -> buildParameters.getServerConfiguration().hasSocketBindingGroupResource(SOCKET_BINDING_GROUP_NAME)});
            this.runBuilder(params -> context -> {
                ManageableServerConfiguration configuration = params.getServerConfiguration();
                PathAddress socketBindingGroupPathAddress = configuration.getSocketBindingGroupResourcePathAddress(SOCKET_BINDING_GROUP_NAME);
                ModelNode socketBindingGroupOp = Util.createAddOperation((PathAddress)socketBindingGroupPathAddress);
                socketBindingGroupOp.get("default-interface").set("public");
                configuration.executeManagementOperation(socketBindingGroupOp);
                SocketBindingGroupResource socketBindingGroupResource = configuration.getSocketBindingGroupResource(SOCKET_BINDING_GROUP_NAME);
                PathAddress httpPathAddress = socketBindingGroupResource.getSocketBindingResourcePathAddress("http");
                ModelNode httpOp = Util.createAddOperation((PathAddress)httpPathAddress);
                httpOp.get("port").set(new ValueExpression("${jboss.http.port:8080}"));
                configuration.executeManagementOperation(httpOp);
                PathAddress httpsPathAddress = socketBindingGroupResource.getSocketBindingResourcePathAddress("https");
                ModelNode httpsOp = Util.createAddOperation((PathAddress)httpsPathAddress);
                httpsOp.get("port").set(new ValueExpression("${jboss.https.port:8443}"));
                configuration.executeManagementOperation(httpsOp);
                PathAddress mcmpManagementPathAddress = socketBindingGroupResource.getSocketBindingResourcePathAddress("mcmp-management");
                ModelNode mcmpManagementOp = Util.createAddOperation((PathAddress)mcmpManagementPathAddress);
                mcmpManagementOp.get("interface").set("private");
                mcmpManagementOp.get("port").set(new ValueExpression("${jboss.mcmp.port:8090}"));
                configuration.executeManagementOperation(mcmpManagementOp);
                PathAddress modclusterPathAddress = socketBindingGroupResource.getSocketBindingResourcePathAddress("modcluster");
                ModelNode modclusterOp = Util.createAddOperation((PathAddress)modclusterPathAddress);
                modclusterOp.get("interface").set("private");
                modclusterOp.get("multicast-address").set(new ValueExpression("${jboss.modcluster.multicast.address:224.0.1.105}"));
                modclusterOp.get("multicast-port").set(23364);
                configuration.executeManagementOperation(modclusterOp);
                return ServerMigrationTaskResult.SUCCESS;
            });
        }
    }
}

