/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.dns;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.jgroups.Address;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.dns.DNSResolver;
import org.jgroups.protocols.dns.DefaultDNSResolver;
import org.jgroups.stack.IpAddress;

class AddressedDNSResolver
extends DefaultDNSResolver {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());

    AddressedDNSResolver(DirContext context) {
        super(context);
    }

    public AddressedDNSResolver(String dnsContextFactory, String dnsAddress) throws NamingException {
        super(dnsContextFactory, dnsAddress);
    }

    @Override
    protected List<Address> resolveAEntries(String dnsQuery) {
        ArrayList<Address> addresses = new ArrayList<Address>();
        try {
            Attributes attributes = this.getDnsContext().getAttributes(dnsQuery, new String[]{DNSResolver.DNSRecordType.A.toString()});
            if (attributes != null && attributes.getAll().hasMoreElements()) {
                NamingEnumeration<?> namingEnumeration = attributes.get(DNSResolver.DNSRecordType.A.toString()).getAll();
                while (namingEnumeration.hasMoreElements()) {
                    try {
                        addresses.add(new IpAddress(namingEnumeration.nextElement().toString()));
                    }
                    catch (Exception e) {
                        log.trace("non critical DNS resolution error", e);
                    }
                }
            }
        }
        catch (NamingException ex) {
            log.trace("no DNS records for query %s, ex: %a", dnsQuery, ex);
        }
        return addresses;
    }
}

