/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.datasources.agroal;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.supplier.AgroalDataSourceConfigurationSupplier;
import io.agroal.api.security.SimplePassword;
import io.agroal.api.transaction.TransactionIntegration;
import io.agroal.narayana.NarayanaTransactionIntegration;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.Principal;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.ietf.jgss.GSSException;
import org.jboss.as.naming.ImmediateManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.extension.datasources.agroal.logging.AgroalLogger;
import org.wildfly.extension.datasources.agroal.logging.LoggingDataSourceListener;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.AuthenticationContext;
import org.wildfly.security.auth.client.AuthenticationContextConfigurationClient;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.credential.GSSKerberosCredential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.transaction.client.ContextTransactionManager;

public class DataSourceService
implements Service<AgroalDataSource>,
Supplier<AgroalDataSource> {
    private static final AuthenticationContextConfigurationClient AUTH_CONFIG_CLIENT = (AuthenticationContextConfigurationClient)AccessController.doPrivileged(AuthenticationContextConfigurationClient.ACTION);
    private final String dataSourceName;
    private final String jndiName;
    private final boolean jta;
    private final boolean connectable;
    private final boolean xa;
    private final AgroalDataSourceConfigurationSupplier dataSourceConfiguration;
    private AgroalDataSource agroalDataSource;
    private InjectedValue<Class> driverInjector = new InjectedValue();
    private InjectedValue<AuthenticationContext> authenticationContextInjector = new InjectedValue();
    private InjectedValue<ExceptionSupplier<CredentialSource, Exception>> credentialSourceSupplierInjector = new InjectedValue();
    private InjectedValue<TransactionSynchronizationRegistry> transactionSynchronizationRegistryInjector = new InjectedValue();

    public DataSourceService(String dataSourceName, String jndiName, boolean jta, boolean connectable, boolean xa, AgroalDataSourceConfigurationSupplier dataSourceConfiguration) {
        this.dataSourceName = dataSourceName;
        this.jndiName = jndiName;
        this.jta = jta;
        this.connectable = connectable;
        this.xa = xa;
        this.dataSourceConfiguration = dataSourceConfiguration;
    }

    public void start(StartContext context) throws StartException {
        ExceptionSupplier credentialSourceExceptionExceptionSupplier;
        AuthenticationContext authenticationContext;
        Class providerClass = (Class)this.driverInjector.getOptionalValue();
        if (this.xa) {
            if (!XADataSource.class.isAssignableFrom(providerClass)) {
                throw AgroalLogger.SERVICE_LOGGER.invalidXAConnectionProvider();
            }
        } else if (providerClass != null && !DataSource.class.isAssignableFrom(providerClass) && !Driver.class.isAssignableFrom(providerClass)) {
            throw AgroalLogger.SERVICE_LOGGER.invalidConnectionProvider();
        }
        this.dataSourceConfiguration.connectionPoolConfiguration().connectionFactoryConfiguration().connectionProviderClass(providerClass);
        if (this.jta || this.xa) {
            ContextTransactionManager transactionManager = ContextTransactionManager.getInstance();
            TransactionSynchronizationRegistry transactionSynchronizationRegistry = (TransactionSynchronizationRegistry)this.transactionSynchronizationRegistryInjector.getValue();
            if (transactionManager == null || transactionSynchronizationRegistry == null) {
                throw AgroalLogger.SERVICE_LOGGER.missingTransactionManager();
            }
            NarayanaTransactionIntegration txIntegration = new NarayanaTransactionIntegration((TransactionManager)transactionManager, transactionSynchronizationRegistry, this.jndiName, this.connectable);
            this.dataSourceConfiguration.connectionPoolConfiguration().transactionIntegration((TransactionIntegration)txIntegration);
        }
        if ((authenticationContext = (AuthenticationContext)this.authenticationContextInjector.getOptionalValue()) != null) {
            try {
                URI targetURI = new URI(this.jndiName);
                NameCallback nameCallback = new NameCallback("Username: ");
                PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
                CredentialCallback credentialCallback = new CredentialCallback(GSSKerberosCredential.class);
                AuthenticationConfiguration authenticationConfiguration = AUTH_CONFIG_CLIENT.getAuthenticationConfiguration(targetURI, authenticationContext, -1, "jdbc", "jboss");
                AUTH_CONFIG_CLIENT.getCallbackHandler(authenticationConfiguration).handle(new Callback[]{nameCallback, passwordCallback, credentialCallback});
                if (credentialCallback.getCredential() != null) {
                    GSSKerberosCredential kerberosCredential = (GSSKerberosCredential)credentialCallback.getCredential(GSSKerberosCredential.class);
                    this.dataSourceConfiguration.connectionPoolConfiguration().connectionFactoryConfiguration().principal((Principal)new NamePrincipal(kerberosCredential.getGssCredential().getName().toString()));
                    this.dataSourceConfiguration.connectionPoolConfiguration().connectionFactoryConfiguration().credential((Object)kerberosCredential.getKerberosTicket());
                    this.dataSourceConfiguration.connectionPoolConfiguration().connectionFactoryConfiguration().credential((Object)kerberosCredential.getGssCredential());
                }
                if (nameCallback.getName() != null) {
                    this.dataSourceConfiguration.connectionPoolConfiguration().connectionFactoryConfiguration().principal((Principal)new NamePrincipal(nameCallback.getName()));
                }
                if (passwordCallback.getPassword() != null) {
                    this.dataSourceConfiguration.connectionPoolConfiguration().connectionFactoryConfiguration().credential((Object)new SimplePassword(new String(passwordCallback.getPassword())));
                }
            }
            catch (IOException | URISyntaxException | UnsupportedCallbackException | GSSException e) {
                throw AgroalLogger.SERVICE_LOGGER.invalidAuthentication(e, this.dataSourceName);
            }
        }
        if ((credentialSourceExceptionExceptionSupplier = (ExceptionSupplier)this.credentialSourceSupplierInjector.getOptionalValue()) != null) {
            try {
                String password = new String(((ClearPassword)((PasswordCredential)((CredentialSource)credentialSourceExceptionExceptionSupplier.get()).getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword());
                this.dataSourceConfiguration.connectionPoolConfiguration().connectionFactoryConfiguration().credential((Object)new SimplePassword(password));
            }
            catch (Exception e) {
                throw AgroalLogger.SERVICE_LOGGER.invalidCredentialSourceSupplier(e, this.dataSourceName);
            }
        }
        try {
            this.agroalDataSource = AgroalDataSource.from((Supplier)this.dataSourceConfiguration, (AgroalDataSourceListener[])new AgroalDataSourceListener[]{new LoggingDataSourceListener(this.dataSourceName)});
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)this.jndiName);
            BinderService binderService = new BinderService(bindInfo.getBindName());
            ImmediateManagedReferenceFactory managedReferenceFactory = new ImmediateManagedReferenceFactory((Object)this.agroalDataSource);
            context.getChildTarget().addService(bindInfo.getBinderServiceName(), (Service)binderService).addInjectionValue((Injector)binderService.getManagedObjectInjector(), (Value)new ImmediateValue((Object)managedReferenceFactory)).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).install();
            if (this.xa) {
                AgroalLogger.SERVICE_LOGGER.startedXADataSource(this.dataSourceName, this.jndiName);
            } else {
                AgroalLogger.SERVICE_LOGGER.startedDataSource(this.dataSourceName, this.jndiName);
            }
        }
        catch (SQLException e) {
            this.agroalDataSource = null;
            if (this.xa) {
                throw AgroalLogger.SERVICE_LOGGER.xaDatasourceStartException(e, this.dataSourceName);
            }
            throw AgroalLogger.SERVICE_LOGGER.datasourceStartException(e, this.dataSourceName);
        }
    }

    public void stop(StopContext context) {
        this.agroalDataSource.close();
        if (this.xa) {
            AgroalLogger.SERVICE_LOGGER.stoppedXADataSource(this.dataSourceName);
        } else {
            AgroalLogger.SERVICE_LOGGER.stoppedDataSource(this.dataSourceName);
        }
    }

    public AgroalDataSource getValue() throws IllegalStateException, IllegalArgumentException {
        return this.agroalDataSource;
    }

    @Override
    public AgroalDataSource get() {
        return this.agroalDataSource;
    }

    public InjectedValue<Class> getDriverInjector() {
        return this.driverInjector;
    }

    public InjectedValue<AuthenticationContext> getAuthenticationContextInjector() {
        return this.authenticationContextInjector;
    }

    public InjectedValue<ExceptionSupplier<CredentialSource, Exception>> getCredentialSourceSupplierInjector() {
        return this.credentialSourceSupplierInjector;
    }

    InjectedValue<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
        return this.transactionSynchronizationRegistryInjector;
    }
}

