/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.console;

import org.jboss.migration.core.console.BasicResultHandlers;
import org.jboss.migration.core.console.UserConfirmation;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;

public class UserConfirmationServerMigrationTask
implements ServerMigrationTask {
    private final ServerMigrationTask task;
    private final String message;

    public UserConfirmationServerMigrationTask(ServerMigrationTask task, String message) {
        this.task = task;
        this.message = message;
    }

    @Override
    public ServerMigrationTaskName getName() {
        return this.task.getName();
    }

    protected ServerMigrationTaskResult confirmTaskRun(TaskContext context) {
        BasicResultHandlers.UserConfirmation resultHandler = new BasicResultHandlers.UserConfirmation();
        new UserConfirmation(context.getConsoleWrapper(), this.message, ServerMigrationLogger.ROOT_LOGGER.yesNo(), (UserConfirmation.ResultHandler)resultHandler).execute();
        switch (resultHandler.getResult()) {
            case NO: {
                return ServerMigrationTaskResult.SKIPPED;
            }
            case YES: {
                return this.runTask(context);
            }
        }
        return this.confirmTaskRun(context);
    }

    protected ServerMigrationTaskResult runTask(TaskContext context) {
        return this.task.run(context);
    }

    @Override
    public ServerMigrationTaskResult run(TaskContext context) {
        return context.isInteractive() ? this.confirmTaskRun(context) : this.runTask(context);
    }
}

