/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task.component;

import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.component.AfterTaskRun;
import org.jboss.migration.core.task.component.BeforeTaskRun;
import org.jboss.migration.core.task.component.BuildParameters;
import org.jboss.migration.core.task.component.TaskNameBuilder;
import org.jboss.migration.core.task.component.TaskSkipPolicy;

public interface ComponentTaskBuilder<P extends BuildParameters, T extends ComponentTaskBuilder<P, T>> {
    default public T name(String name) {
        return this.name(new ServerMigrationTaskName.Builder(name).build());
    }

    default public T name(ServerMigrationTaskName name) {
        return this.nameBuilder(parameters -> name);
    }

    public T nameBuilder(TaskNameBuilder<? super P> var1);

    default public T skipPolicy(TaskSkipPolicy skipPolicy) {
        return this.skipPolicyBuilder(parameters -> skipPolicy);
    }

    default public T skipPolicies(TaskSkipPolicy ... skipPolicies) {
        return this.skipPolicy(context -> {
            for (TaskSkipPolicy skipPolicy : skipPolicies) {
                if (!skipPolicy.isSkipped(context)) continue;
                return true;
            }
            return false;
        });
    }

    public T skipPolicyBuilder(TaskSkipPolicy.Builder<? super P> var1);

    default public T skipPolicyBuilders(TaskSkipPolicy.Builder<? super P> ... builders) {
        return this.skipPolicyBuilder(buildParameters -> context -> {
            for (TaskSkipPolicy.Builder builder : builders) {
                if (!builder.build(buildParameters).isSkipped(context)) continue;
                return true;
            }
            return false;
        });
    }

    default public T beforeRun(BeforeTaskRun beforeRun) {
        return this.beforeRunBuilder(parameters -> beforeRun);
    }

    public T beforeRunBuilder(BeforeTaskRun.Builder<? super P> var1);

    default public T afterRun(AfterTaskRun afterRun) {
        return this.afterRunBuilder(parameters -> afterRun);
    }

    public T afterRunBuilder(AfterTaskRun.Builder<? super P> var1);

    public ServerMigrationTask build(P var1);
}

