/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.rmi;

import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.rmi.RMIIIOPViolationException;
import org.wildfly.iiop.openjdk.rmi.Util;
import org.wildfly.iiop.openjdk.rmi.ValueAnalysis;
import org.wildfly.iiop.openjdk.rmi.WorkCacheManager;

public class ExceptionAnalysis
extends ValueAnalysis {
    private static WorkCacheManager cache = new WorkCacheManager(ExceptionAnalysis.class);
    private String exceptionRepositoryId;

    public static ExceptionAnalysis getExceptionAnalysis(Class cls) throws RMIIIOPViolationException {
        return (ExceptionAnalysis)cache.getAnalysis(cls);
    }

    public static void clearCache(ClassLoader classLoader) {
        cache.clearClassLoader(classLoader);
    }

    protected ExceptionAnalysis(Class cls) {
        super(cls);
    }

    @Override
    protected void doAnalyze() throws RMIIIOPViolationException {
        super.doAnalyze();
        if (!Exception.class.isAssignableFrom(this.cls) || RuntimeException.class.isAssignableFrom(this.cls)) {
            throw IIOPLogger.ROOT_LOGGER.badRMIIIOPExceptionType(this.cls.getName(), "1.2.6");
        }
        StringBuffer b = new StringBuffer("IDL:");
        String pkgName = this.cls.getPackage().getName();
        while (!"".equals(pkgName)) {
            int idx = pkgName.indexOf(46);
            String n = idx == -1 ? pkgName : pkgName.substring(0, idx);
            b.append(Util.javaToIDLName(n)).append('/');
            pkgName = idx == -1 ? "" : pkgName.substring(idx + 1);
        }
        String base = this.cls.getName();
        if ((base = base.substring(base.lastIndexOf(46) + 1)).endsWith("Exception")) {
            base = base.substring(0, base.length() - 9);
        }
        base = Util.javaToIDLName(base + "Ex");
        b.append(base).append(":1.0");
        this.exceptionRepositoryId = b.toString();
    }

    public String getExceptionRepositoryId() {
        return this.exceptionRepositoryId;
    }
}

