/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintKey;
import org.jboss.as.controller.access.management.AccessConstraintUtilization;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AbstractClassificationResource;
import org.jboss.as.domain.management.access.AccessConstraintAppliesToResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ApplicationClassificationConfigResourceDefinition
extends SimpleResourceDefinition {
    public static PathElement PATH_ELEMENT = PathElement.pathElement((String)"classification");
    public static SimpleAttributeDefinition DEFAULT_APPLICATION = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"default-application", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    public static SimpleAttributeDefinition CONFIGURED_APPLICATION = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"configured-application", (ModelType)ModelType.BOOLEAN, (boolean)true).setXmlName(Attribute.APPLICATION.getLocalName())).build();

    ApplicationClassificationConfigResourceDefinition() {
        super(PATH_ELEMENT, DomainManagementResolver.getResolver("core.access-control.constraint.application-classification-config"));
    }

    static Resource.ResourceEntry createResource(ApplicationTypeConfig applicationType, String configType, String name, AccessConstraintUtilizationRegistry registry) {
        return new ApplicationTypeConfigResource(PathElement.pathElement((String)"classification", (String)name), applicationType, configType, registry);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DEFAULT_APPLICATION, (OperationStepHandler)ApplicationTypeConfigReadAttributeHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CONFIGURED_APPLICATION, (OperationStepHandler)ApplicationTypeConfigReadAttributeHandler.INSTANCE, (OperationStepHandler)ApplicationTypeConfigWriteAttributeHandler.INSTANCE);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)new AccessConstraintAppliesToResourceDefinition());
    }

    private static class ApplicationTypeConfigResource
    extends AbstractClassificationResource {
        private final ApplicationTypeConfig applicationType;
        private final String configType;
        private final AccessConstraintUtilizationRegistry registry;

        ApplicationTypeConfigResource(PathElement pathElement, ApplicationTypeConfig classification, String configType, AccessConstraintUtilizationRegistry registry) {
            super(pathElement);
            this.applicationType = classification;
            this.configType = configType;
            this.registry = registry;
        }

        @Override
        public ModelNode getModel() {
            ModelNode model = new ModelNode();
            model.get(DEFAULT_APPLICATION.getName()).set(this.applicationType.isDefaultApplication());
            model.get(CONFIGURED_APPLICATION.getName()).set(this.getBoolean(this.applicationType.getConfiguredApplication()));
            return model;
        }

        @Override
        public void writeModel(ModelNode newModel) {
            if (newModel.hasDefined(CONFIGURED_APPLICATION.getName())) {
                boolean b = newModel.get(CONFIGURED_APPLICATION.getName()).asBoolean();
                this.applicationType.setConfiguredApplication(Boolean.valueOf(b));
            }
        }

        @Override
        public boolean isModelDefined() {
            return true;
        }

        private ModelNode getBoolean(Boolean booleanValue) {
            if (booleanValue == null) {
                return new ModelNode();
            }
            return new ModelNode(booleanValue.booleanValue());
        }

        public Set<String> getChildTypes() {
            return this.registry != null ? Collections.singleton("applies-to") : Collections.emptySet();
        }

        @Override
        Resource.ResourceEntry getChildEntry(String type, String name) {
            if (this.registry != null && "applies-to".equals(type)) {
                Map<PathAddress, AccessConstraintUtilization> utilizations = this.getAccessConstraintUtilizations();
                for (AccessConstraintUtilization acu : utilizations.values()) {
                    if (!name.equals(acu.getPathAddress().toCLIStyleString())) continue;
                    return AccessConstraintAppliesToResourceDefinition.createResource(acu);
                }
            }
            return null;
        }

        @Override
        public Set<String> getChildrenNames(String type) {
            if (this.registry != null && "applies-to".equals(type)) {
                Map<PathAddress, AccessConstraintUtilization> utilizations = this.getAccessConstraintUtilizations();
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                for (PathAddress pa : utilizations.keySet()) {
                    result.add(pa.toCLIStyleString());
                }
                return result;
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            if (this.registry != null && "applies-to".equals(childType)) {
                Map<PathAddress, AccessConstraintUtilization> utilizations = this.getAccessConstraintUtilizations();
                LinkedHashSet<Resource.ResourceEntry> result = new LinkedHashSet<Resource.ResourceEntry>();
                for (AccessConstraintUtilization acu : utilizations.values()) {
                    result.add(AccessConstraintAppliesToResourceDefinition.createResource(acu));
                }
                return result;
            }
            return Collections.emptySet();
        }

        private Map<PathAddress, AccessConstraintUtilization> getAccessConstraintUtilizations() {
            boolean core;
            AccessConstraintKey key = new AccessConstraintKey("application-classification", core, (core = "core".equals(this.configType)) ? null : this.configType, this.getPathElement().getValue());
            return this.registry.getAccessConstraintUtilizations(key);
        }
    }

    private static class ApplicationTypeConfigWriteAttributeHandler
    implements OperationStepHandler {
        static final ApplicationTypeConfigWriteAttributeHandler INSTANCE = new ApplicationTypeConfigWriteAttributeHandler();

        private ApplicationTypeConfigWriteAttributeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode value = operation.require("value");
            ApplicationTypeConfigResource resource = (ApplicationTypeConfigResource)context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            ModelNode modelNode = resource.getModel();
            final ModelNode configuredApplication = modelNode.get("configured-application");
            final ApplicationTypeConfig classification = resource.applicationType;
            classification.setConfiguredApplication(this.readValue(context, value, (AttributeDefinition)CONFIGURED_APPLICATION));
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    try {
                        classification.setConfiguredApplication(this.readValue(context, configuredApplication, (AttributeDefinition)CONFIGURED_APPLICATION));
                    }
                    catch (OperationFailedException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }

        private Boolean readValue(OperationContext context, ModelNode value, AttributeDefinition definition) throws OperationFailedException {
            if (value.isDefined()) {
                return definition.resolveValue(context, value).asBoolean();
            }
            return null;
        }
    }

    private static class ApplicationTypeConfigReadAttributeHandler
    implements OperationStepHandler {
        static final ApplicationTypeConfigReadAttributeHandler INSTANCE = new ApplicationTypeConfigReadAttributeHandler();

        private ApplicationTypeConfigReadAttributeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String attribute = operation.require("name").asString();
            ApplicationTypeConfigResource resource = (ApplicationTypeConfigResource)context.readResource(PathAddress.EMPTY_ADDRESS);
            ApplicationTypeConfig applicationType = resource.applicationType;
            Boolean result = null;
            if (attribute.equals(DEFAULT_APPLICATION.getName())) {
                result = applicationType.isDefaultApplication();
            } else if (attribute.equals(CONFIGURED_APPLICATION.getName())) {
                result = applicationType.getConfiguredApplication();
            }
            context.getResult();
            if (result != null) {
                context.getResult().set(result.booleanValue());
            }
        }
    }
}

