/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.AbstractSensitivity;
import org.jboss.as.controller.access.management.AccessConstraintKey;
import org.jboss.as.controller.access.management.AccessConstraintUtilization;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.parsing.Attribute;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AbstractClassificationResource;
import org.jboss.as.domain.management.access.AccessConstraintAppliesToResourceDefinition;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SensitivityResourceDefinition
extends SimpleResourceDefinition {
    public static PathElement PATH_ELEMENT = PathElement.pathElement((String)"classification");
    public static PathElement VAULT_ELEMENT = PathElement.pathElement((String)"constraint", (String)"vault-expression");
    public static SimpleAttributeDefinition DEFAULT_REQUIRES_ADDRESSABLE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"default-requires-addressable", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    public static SimpleAttributeDefinition DEFAULT_REQUIRES_READ = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"default-requires-read", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    public static SimpleAttributeDefinition DEFAULT_REQUIRES_WRITE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"default-requires-write", (ModelType)ModelType.BOOLEAN, (boolean)false).setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    public static SimpleAttributeDefinition CONFIGURED_REQUIRES_ADDRESSABLE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"configured-requires-addressable", (ModelType)ModelType.BOOLEAN, (boolean)true).setXmlName(Attribute.REQUIRES_ADDRESSABLE.getLocalName())).build();
    public static SimpleAttributeDefinition CONFIGURED_REQUIRES_READ = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"configured-requires-read", (ModelType)ModelType.BOOLEAN, (boolean)true).setXmlName(Attribute.REQUIRES_READ.getLocalName())).build();
    public static SimpleAttributeDefinition CONFIGURED_REQUIRES_WRITE = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)"configured-requires-write", (ModelType)ModelType.BOOLEAN, (boolean)true).setXmlName(Attribute.REQUIRES_WRITE.getLocalName())).build();
    private final boolean includeAddressable;
    private final boolean registerUtilization;

    public static List<AttributeDefinition> getWritableVaultAttributeDefinitions() {
        return Arrays.asList(CONFIGURED_REQUIRES_READ, CONFIGURED_REQUIRES_WRITE);
    }

    private SensitivityResourceDefinition(PathElement pathElement, ResourceDescriptionResolver resolver, boolean includeAddressable, boolean registerUtilization) {
        super(pathElement, resolver);
        this.includeAddressable = includeAddressable;
        this.registerUtilization = registerUtilization;
    }

    static SensitivityResourceDefinition createSensitivityClassification() {
        return new SensitivityResourceDefinition(PATH_ELEMENT, DomainManagementResolver.getResolver("core.access-control.constraint.sensitivity-classification-config"), true, true);
    }

    static SensitivityResourceDefinition createVaultExpressionConfiguration() {
        return new SensitivityResourceDefinition(VAULT_ELEMENT, DomainManagementResolver.getResolver("core.access-control.constraint.vault-expression-sensitivity"), false, false);
    }

    static Resource.ResourceEntry createVaultExpressionResource(AbstractSensitivity classification, PathElement pathElement) {
        return new SensitivityClassificationResource(pathElement, classification);
    }

    static Resource.ResourceEntry createSensitivityClassificationResource(AbstractSensitivity classification, String classificationType, String name, AccessConstraintUtilizationRegistry registry) {
        return new SensitivityClassificationResource(PathElement.pathElement((String)"classification", (String)name), classification, classificationType, registry);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        SensitivityClassificationWriteAttributeHandler write;
        SensitivityClassificationReadAttributeHandler read = this.includeAddressable ? SensitivityClassificationReadAttributeHandler.ADDRESSABLE_INSTANCE : SensitivityClassificationReadAttributeHandler.NON_ADDRESSABLE_INSTANCE;
        SensitivityClassificationWriteAttributeHandler sensitivityClassificationWriteAttributeHandler = write = this.includeAddressable ? SensitivityClassificationWriteAttributeHandler.ADDRESSABLE_INSTANCE : SensitivityClassificationWriteAttributeHandler.NON_ADDRESSABLE_INSTANCE;
        if (this.includeAddressable) {
            resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DEFAULT_REQUIRES_ADDRESSABLE, (OperationStepHandler)read);
        }
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DEFAULT_REQUIRES_READ, (OperationStepHandler)read);
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)DEFAULT_REQUIRES_WRITE, (OperationStepHandler)read);
        if (this.includeAddressable) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CONFIGURED_REQUIRES_ADDRESSABLE, (OperationStepHandler)read, (OperationStepHandler)write);
        }
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CONFIGURED_REQUIRES_READ, (OperationStepHandler)SensitivityClassificationReadAttributeHandler.ADDRESSABLE_INSTANCE, (OperationStepHandler)write);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)CONFIGURED_REQUIRES_WRITE, (OperationStepHandler)SensitivityClassificationReadAttributeHandler.ADDRESSABLE_INSTANCE, (OperationStepHandler)write);
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        if (this.registerUtilization) {
            resourceRegistration.registerSubModel((ResourceDefinition)new AccessConstraintAppliesToResourceDefinition());
        }
    }

    private static class SensitivityClassificationResource
    extends AbstractClassificationResource {
        private final AbstractSensitivity classification;
        private final AccessConstraintUtilizationRegistry registry;
        private final boolean includeAddressable;
        private final String classificationType;

        SensitivityClassificationResource(PathElement pathElement, AbstractSensitivity classification) {
            super(pathElement);
            this.classification = classification;
            this.includeAddressable = false;
            this.registry = null;
            this.classificationType = null;
        }

        SensitivityClassificationResource(PathElement pathElement, AbstractSensitivity classification, String classificationType, AccessConstraintUtilizationRegistry registry) {
            super(pathElement);
            this.classification = classification;
            this.includeAddressable = true;
            this.registry = registry;
            this.classificationType = classificationType;
        }

        @Override
        public ModelNode getModel() {
            ModelNode model = new ModelNode();
            if (this.includeAddressable) {
                model.get(DEFAULT_REQUIRES_ADDRESSABLE.getName()).set(this.classification.isDefaultRequiresAccessPermission());
            }
            model.get(DEFAULT_REQUIRES_READ.getName()).set(this.classification.isDefaultRequiresReadPermission());
            model.get(DEFAULT_REQUIRES_WRITE.getName()).set(this.classification.isDefaultRequiresWritePermission());
            if (this.includeAddressable) {
                model.get(CONFIGURED_REQUIRES_ADDRESSABLE.getName()).set(this.getBoolean(this.classification.getConfiguredRequiresAccessPermission()));
            }
            model.get(CONFIGURED_REQUIRES_READ.getName()).set(this.getBoolean(this.classification.getConfiguredRequiresReadPermission()));
            model.get(CONFIGURED_REQUIRES_WRITE.getName()).set(this.getBoolean(this.classification.getConfiguredRequiresWritePermission()));
            return model;
        }

        @Override
        public void writeModel(ModelNode newModel) {
            boolean b;
            if (this.includeAddressable && newModel.hasDefined(CONFIGURED_REQUIRES_ADDRESSABLE.getName())) {
                b = newModel.get(CONFIGURED_REQUIRES_ADDRESSABLE.getName()).asBoolean();
                this.classification.setConfiguredRequiresAccessPermission(Boolean.valueOf(b));
            }
            if (newModel.hasDefined(CONFIGURED_REQUIRES_READ.getName())) {
                b = newModel.get(CONFIGURED_REQUIRES_READ.getName()).asBoolean();
                this.classification.setConfiguredRequiresReadPermission(Boolean.valueOf(b));
            }
            if (newModel.hasDefined(CONFIGURED_REQUIRES_WRITE.getName())) {
                b = newModel.get(CONFIGURED_REQUIRES_WRITE.getName()).asBoolean();
                this.classification.setConfiguredRequiresWritePermission(Boolean.valueOf(b));
            }
        }

        @Override
        public boolean isModelDefined() {
            return true;
        }

        private ModelNode getBoolean(Boolean booleanValue) {
            if (booleanValue == null) {
                return new ModelNode();
            }
            return new ModelNode(booleanValue.booleanValue());
        }

        public Set<String> getChildTypes() {
            return this.registry == null ? Collections.emptySet() : Collections.singleton("applies-to");
        }

        @Override
        Resource.ResourceEntry getChildEntry(String type, String name) {
            if (this.registry != null && "applies-to".equals(type)) {
                Map<PathAddress, AccessConstraintUtilization> utilizations = this.getAccessConstraintUtilizations();
                for (AccessConstraintUtilization acu : utilizations.values()) {
                    if (!name.equals(acu.getPathAddress().toCLIStyleString())) continue;
                    return AccessConstraintAppliesToResourceDefinition.createResource(acu);
                }
            }
            return null;
        }

        @Override
        public Set<String> getChildrenNames(String type) {
            if (this.registry != null && "applies-to".equals(type)) {
                Map<PathAddress, AccessConstraintUtilization> utilizations = this.getAccessConstraintUtilizations();
                LinkedHashSet<String> result = new LinkedHashSet<String>();
                for (PathAddress pa : utilizations.keySet()) {
                    result.add(pa.toCLIStyleString());
                }
                return result;
            }
            return Collections.emptySet();
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            if (this.registry != null && "applies-to".equals(childType)) {
                Map<PathAddress, AccessConstraintUtilization> utilizations = this.getAccessConstraintUtilizations();
                LinkedHashSet<Resource.ResourceEntry> result = new LinkedHashSet<Resource.ResourceEntry>();
                for (AccessConstraintUtilization acu : utilizations.values()) {
                    result.add(AccessConstraintAppliesToResourceDefinition.createResource(acu));
                }
                return result;
            }
            return Collections.emptySet();
        }

        private Map<PathAddress, AccessConstraintUtilization> getAccessConstraintUtilizations() {
            boolean core;
            AccessConstraintKey key = new AccessConstraintKey("sensitivity-classification", core, (core = "core".equals(this.classificationType)) ? null : this.classificationType, this.getPathElement().getValue());
            return this.registry.getAccessConstraintUtilizations(key);
        }
    }

    private static class SensitivityClassificationWriteAttributeHandler
    implements OperationStepHandler {
        static final SensitivityClassificationWriteAttributeHandler ADDRESSABLE_INSTANCE = new SensitivityClassificationWriteAttributeHandler(true);
        static final SensitivityClassificationWriteAttributeHandler NON_ADDRESSABLE_INSTANCE = new SensitivityClassificationWriteAttributeHandler(false);
        private final boolean includeAddressable;

        SensitivityClassificationWriteAttributeHandler(boolean includeAddressable) {
            this.includeAddressable = includeAddressable;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            ModelNode modelNode = context.readResourceFromRoot(address).getModel();
            final ModelNode configuredRequiresAddressable = modelNode.get("configured-requires-addressable");
            final ModelNode configuredRequiresRead = modelNode.get("configured-requires-read");
            final ModelNode configuredRequiresWrite = modelNode.get("configured-requires-write");
            final String attribute = operation.require("name").asString();
            final ModelNode value = operation.require("value");
            SensitivityClassificationResource resource = (SensitivityClassificationResource)context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
            final AbstractSensitivity classification = resource.classification;
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    if (attribute.equals(CONFIGURED_REQUIRES_ADDRESSABLE.getName()) && !classification.isConfiguredRequiresAccessPermissionValid(value.asBooleanOrNull())) {
                        throw DomainManagementLogger.ROOT_LOGGER.imcompatibleConfiguredRequiresAttributeValue("configured-requires-addressable");
                    }
                    if (attribute.equals(CONFIGURED_REQUIRES_READ.getName())) {
                        if (!classification.isConfiguredRequiresReadPermissionValid(value.asBooleanOrNull())) {
                            throw DomainManagementLogger.ROOT_LOGGER.imcompatibleConfiguredRequiresAttributeValue("configured-requires-read");
                        }
                        classification.setConfiguredRequiresReadPermission(this.readValue(context, value, (AttributeDefinition)CONFIGURED_REQUIRES_READ));
                    } else if (attribute.equals(CONFIGURED_REQUIRES_WRITE.getName())) {
                        if (!classification.isConfiguredRequiresWritePermissionValid(value.asBooleanOrNull())) {
                            throw DomainManagementLogger.ROOT_LOGGER.imcompatibleConfiguredRequiresAttributeValue("configured-requires-write");
                        }
                        classification.setConfiguredRequiresWritePermission(this.readValue(context, value, (AttributeDefinition)CONFIGURED_REQUIRES_WRITE));
                    }
                }
            }, OperationContext.Stage.MODEL);
            if (attribute.equals(CONFIGURED_REQUIRES_ADDRESSABLE.getName()) && this.includeAddressable) {
                classification.setConfiguredRequiresAccessPermission(this.readValue(context, value, (AttributeDefinition)CONFIGURED_REQUIRES_ADDRESSABLE));
            } else if (attribute.equals(CONFIGURED_REQUIRES_READ.getName())) {
                classification.setConfiguredRequiresReadPermission(this.readValue(context, value, (AttributeDefinition)CONFIGURED_REQUIRES_READ));
            } else if (attribute.equals(CONFIGURED_REQUIRES_WRITE.getName())) {
                classification.setConfiguredRequiresWritePermission(this.readValue(context, value, (AttributeDefinition)CONFIGURED_REQUIRES_WRITE));
            } else {
                throw DomainManagementLogger.ROOT_LOGGER.invalidSensitiveClassificationAttribute(attribute);
            }
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    block5: {
                        try {
                            if (attribute.equals(CONFIGURED_REQUIRES_ADDRESSABLE.getName()) && includeAddressable) {
                                classification.setConfiguredRequiresAccessPermission(this.readValue(context, configuredRequiresAddressable, (AttributeDefinition)CONFIGURED_REQUIRES_ADDRESSABLE));
                                break block5;
                            }
                            if (attribute.equals(CONFIGURED_REQUIRES_READ.getName())) {
                                classification.setConfiguredRequiresReadPermission(this.readValue(context, configuredRequiresRead, (AttributeDefinition)CONFIGURED_REQUIRES_READ));
                                break block5;
                            }
                            if (attribute.equals(CONFIGURED_REQUIRES_WRITE.getName())) {
                                classification.setConfiguredRequiresWritePermission(this.readValue(context, configuredRequiresWrite, (AttributeDefinition)CONFIGURED_REQUIRES_WRITE));
                                break block5;
                            }
                            throw DomainManagementLogger.ROOT_LOGGER.invalidSensitiveClassificationAttribute(attribute);
                        }
                        catch (OperationFailedException e) {
                            throw DomainManagementLogger.ROOT_LOGGER.invalidSensitiveClassificationAttribute(attribute);
                        }
                    }
                }
            });
        }

        private Boolean readValue(OperationContext context, ModelNode value, AttributeDefinition definition) throws OperationFailedException {
            if (value.isDefined()) {
                return definition.resolveValue(context, value).asBoolean();
            }
            return null;
        }
    }

    private static class SensitivityClassificationReadAttributeHandler
    implements OperationStepHandler {
        static final SensitivityClassificationReadAttributeHandler ADDRESSABLE_INSTANCE = new SensitivityClassificationReadAttributeHandler(true);
        static final SensitivityClassificationReadAttributeHandler NON_ADDRESSABLE_INSTANCE = new SensitivityClassificationReadAttributeHandler(false);
        private final boolean includeAddressable;

        public SensitivityClassificationReadAttributeHandler(boolean includeAddressable) {
            this.includeAddressable = includeAddressable;
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            Boolean result;
            String attribute = operation.require("name").asString();
            SensitivityClassificationResource resource = (SensitivityClassificationResource)context.readResource(PathAddress.EMPTY_ADDRESS);
            AbstractSensitivity classification = resource.classification;
            if (attribute.equals(DEFAULT_REQUIRES_ADDRESSABLE.getName()) && this.includeAddressable) {
                result = classification.isDefaultRequiresAccessPermission();
            } else if (attribute.equals(DEFAULT_REQUIRES_READ.getName())) {
                result = classification.isDefaultRequiresReadPermission();
            } else if (attribute.equals(DEFAULT_REQUIRES_WRITE.getName())) {
                result = classification.isDefaultRequiresWritePermission();
            } else if (attribute.equals(CONFIGURED_REQUIRES_ADDRESSABLE.getName()) && this.includeAddressable) {
                result = classification.getConfiguredRequiresAccessPermission();
            } else if (attribute.equals(CONFIGURED_REQUIRES_READ.getName())) {
                result = classification.getConfiguredRequiresReadPermission();
            } else if (attribute.equals(CONFIGURED_REQUIRES_WRITE.getName())) {
                result = classification.getConfiguredRequiresWritePermission();
            } else {
                throw DomainManagementLogger.ROOT_LOGGER.invalidSensitiveClassificationAttribute(attribute);
            }
            context.getResult();
            if (result != null) {
                context.getResult().set(result.booleanValue());
            }
        }
    }
}

