/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import javax.security.auth.login.LoginException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.domain.management.SubjectIdentity;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.KeytabService;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class KeytabTestHandler
implements OperationStepHandler {
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("test", ControllerResolver.getResolver((String[])new String[]{"core.management.security-realm.server-identity.kerberos.keytab"})).setReadOnly().setReplyType(ModelType.STRING).build();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.readResource(PathAddress.EMPTY_ADDRESS, false);
        context.addStep(new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                ServiceController<KeytabService> serviceController = ManagementUtil.getKeytabService(context, operation);
                KeytabService keytabService = (KeytabService)serviceController.getService().getValue();
                SubjectIdentity si = null;
                try {
                    si = keytabService.createSubjectIdentity(false);
                    ModelNode result = context.getResult();
                    result.get("subject").set(si.getSubject().toString());
                }
                catch (LoginException e) {
                    throw DomainManagementLogger.SECURITY_LOGGER.unableToObtainTGT(e);
                }
                finally {
                    if (si != null) {
                        si.logout();
                    }
                }
                context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

