/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.HttpHandler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.LocationDefinition;
import org.wildfly.extension.undertow.LocationService;
import org.wildfly.extension.undertow.UndertowService;

class LocationAdd
extends AbstractAddStepHandler {
    static LocationAdd INSTANCE = new LocationAdd();

    private LocationAdd() {
        super(new AttributeDefinition[]{LocationDefinition.HANDLER});
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress hostAddress = context.getCurrentAddress().getParent();
        PathAddress serverAddress = hostAddress.getParent();
        String name = context.getCurrentAddressValue();
        String handler = LocationDefinition.HANDLER.resolveModelAttribute(context, model).asString();
        LocationService service = new LocationService(name);
        String serverName = serverAddress.getLastElement().getValue();
        String hostName = hostAddress.getLastElement().getValue();
        ServiceName serviceName = UndertowService.locationServiceName(serverName, hostName, name);
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(LocationDefinition.LOCATION_CAPABILITY, (Service)service).addCapabilityRequirement("org.wildfly.extension.undertow.handler", HttpHandler.class, service.getHttpHandler(), new String[]{handler}).addCapabilityRequirement("org.wildfly.undertow.host", Host.class, service.getHost(), new String[]{serverName, hostName});
        builder.setInitialMode(ServiceController.Mode.ACTIVE).addAliases(new ServiceName[]{serviceName}).install();
    }
}

