/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.connector.ByteBufferPool;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.server.handlers.cache.DirectBufferCache;
import io.undertow.servlet.api.CrawlerSessionManagerConfig;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.security.negotiation.NegotiationMechanismFactory;
import org.wildfly.extension.undertow.AbstractPersistentSessionManager;
import org.wildfly.extension.undertow.BufferCacheService;
import org.wildfly.extension.undertow.CrawlerSessionManagementDefinition;
import org.wildfly.extension.undertow.JSPConfig;
import org.wildfly.extension.undertow.JspDefinition;
import org.wildfly.extension.undertow.MimeMappingDefinition;
import org.wildfly.extension.undertow.PersistentSessionsDefinition;
import org.wildfly.extension.undertow.ServletContainerDefinition;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.SessionCookieConfig;
import org.wildfly.extension.undertow.SessionCookieDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.WebsocketsDefinition;
import org.wildfly.extension.undertow.security.digest.DigestAuthenticationMechanismFactory;
import org.xnio.XnioWorker;

final class ServletContainerAdd
extends AbstractBoottimeAddStepHandler {
    static final ServletContainerAdd INSTANCE = new ServletContainerAdd();

    ServletContainerAdd() {
        super(ServletContainerDefinition.ATTRIBUTES);
    }

    protected void performBoottime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.installRuntimeServices(context, resource.getModel(), context.getCurrentAddressValue());
    }

    public void installRuntimeServices(OperationContext context, ModelNode model, String name) throws OperationFailedException {
        ModelNode fullModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS), (int)2);
        SessionCookieConfig config = SessionCookieDefinition.INSTANCE.getConfig(context, fullModel.get(SessionCookieDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        CrawlerSessionManagerConfig crawlerSessionManagerConfig = CrawlerSessionManagementDefinition.INSTANCE.getConfig(context, fullModel.get(CrawlerSessionManagementDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        boolean persistentSessions = PersistentSessionsDefinition.isEnabled(context, fullModel.get(PersistentSessionsDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        boolean allowNonStandardWrappers = ServletContainerDefinition.ALLOW_NON_STANDARD_WRAPPERS.resolveModelAttribute(context, model).asBoolean();
        boolean proactiveAuth = ServletContainerDefinition.PROACTIVE_AUTHENTICATION.resolveModelAttribute(context, model).asBoolean();
        String bufferCache = ServletContainerDefinition.DEFAULT_BUFFER_CACHE.resolveModelAttribute(context, model).asString();
        boolean disableFileWatchService = ServletContainerDefinition.DISABLE_FILE_WATCH_SERVICE.resolveModelAttribute(context, model).asBoolean();
        boolean disableSessionIdReususe = ServletContainerDefinition.DISABLE_SESSION_ID_REUSE.resolveModelAttribute(context, model).asBoolean();
        JSPConfig jspConfig = JspDefinition.INSTANCE.getConfig(context, fullModel.get(JspDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        String stackTracesString = ServletContainerDefinition.STACK_TRACE_ON_ERROR.resolveModelAttribute(context, model).asString();
        ModelNode defaultEncodingValue = ServletContainerDefinition.DEFAULT_ENCODING.resolveModelAttribute(context, model);
        String defaultEncoding = defaultEncodingValue.isDefined() ? defaultEncodingValue.asString() : null;
        boolean useListenerEncoding = ServletContainerDefinition.USE_LISTENER_ENCODING.resolveModelAttribute(context, model).asBoolean();
        boolean ignoreFlush = ServletContainerDefinition.IGNORE_FLUSH.resolveModelAttribute(context, model).asBoolean();
        boolean eagerFilterInit = ServletContainerDefinition.EAGER_FILTER_INIT.resolveModelAttribute(context, model).asBoolean();
        boolean disableCachingForSecuredPages = ServletContainerDefinition.DISABLE_CACHING_FOR_SECURED_PAGES.resolveModelAttribute(context, model).asBoolean();
        int sessionIdLength = ServletContainerDefinition.SESSION_ID_LENGTH.resolveModelAttribute(context, model).asInt();
        int fileCacheMetadataSize = ServletContainerDefinition.FILE_CACHE_METADATA_SIZE.resolveModelAttribute(context, model).asInt();
        int fileCacheMaxFileSize = ServletContainerDefinition.FILE_CACHE_MAX_FILE_SIZE.resolveModelAttribute(context, model).asInt();
        ModelNode fileCacheTtlNode = ServletContainerDefinition.FILE_CACHE_TIME_TO_LIVE.resolveModelAttribute(context, model);
        Integer fileCacheTimeToLive = fileCacheTtlNode.isDefined() ? Integer.valueOf(fileCacheTtlNode.asInt()) : null;
        int defaultCookieVersion = ServletContainerDefinition.DEFAULT_COOKIE_VERSION.resolveModelAttribute(context, model).asInt();
        boolean preservePathOnForward = Boolean.parseBoolean(System.getProperty("io.undertow.servlet.dispatch.preserve_path_of_forward", "false"));
        Boolean directoryListingEnabled = null;
        if (model.hasDefined("directory-listing")) {
            directoryListingEnabled = ServletContainerDefinition.DIRECTORY_LISTING.resolveModelAttribute(context, model).asBoolean();
        }
        Integer maxSessions = null;
        if (model.hasDefined("max-sessions")) {
            maxSessions = ServletContainerDefinition.MAX_SESSIONS.resolveModelAttribute(context, model).asInt();
        }
        int sessionTimeout = ServletContainerDefinition.DEFAULT_SESSION_TIMEOUT.resolveModelAttribute(context, model).asInt();
        WebsocketsDefinition.WebSocketInfo webSocketInfo = WebsocketsDefinition.INSTANCE.getConfig(context, fullModel.get(WebsocketsDefinition.INSTANCE.getPathElement().getKeyValuePair()));
        HashMap<String, String> mimeMappings = new HashMap<String, String>();
        if (fullModel.hasDefined("mime-mapping")) {
            for (Object mapping : fullModel.get("mime-mapping").asPropertyList()) {
                mimeMappings.put(mapping.getName(), MimeMappingDefinition.VALUE.resolveModelAttribute(context, mapping.getValue()).asString());
            }
        }
        ArrayList<String> welcomeFiles = new ArrayList<String>();
        if (fullModel.hasDefined("welcome-file")) {
            for (Property welcome : fullModel.get("welcome-file").asPropertyList()) {
                welcomeFiles.add(welcome.getName());
            }
        }
        HashMap<String, AuthenticationMechanismFactory> authenticationMechanisms = new HashMap<String, AuthenticationMechanismFactory>();
        authenticationMechanisms.put("SPNEGO", (AuthenticationMechanismFactory)new NegotiationMechanismFactory());
        authenticationMechanisms.put("DIGEST", DigestAuthenticationMechanismFactory.FACTORY);
        ServletContainerService container = new ServletContainerService(allowNonStandardWrappers, ServletStackTraces.valueOf((String)stackTracesString.toUpperCase().replace('-', '_')), config, jspConfig, defaultEncoding, useListenerEncoding, ignoreFlush, eagerFilterInit, sessionTimeout, disableCachingForSecuredPages, webSocketInfo != null, webSocketInfo != null && webSocketInfo.isDispatchToWorker(), webSocketInfo != null && webSocketInfo.isPerMessageDeflate(), webSocketInfo == null ? -1 : webSocketInfo.getDeflaterLevel(), mimeMappings, welcomeFiles, directoryListingEnabled, proactiveAuth, sessionIdLength, authenticationMechanisms, maxSessions, crawlerSessionManagerConfig, disableFileWatchService, disableSessionIdReususe, fileCacheMetadataSize, fileCacheMaxFileSize, fileCacheTimeToLive, defaultCookieVersion, preservePathOnForward);
        CapabilityServiceBuilder builder = context.getCapabilityServiceTarget().addCapability(ServletContainerDefinition.SERVLET_CONTAINER_CAPABILITY, (Service)container);
        if (bufferCache != null) {
            builder.addDependency(BufferCacheService.SERVICE_NAME.append(new String[]{bufferCache}), DirectBufferCache.class, container.getBufferCacheInjectedValue());
        }
        if (persistentSessions) {
            builder.addDependency(AbstractPersistentSessionManager.SERVICE_NAME, SessionPersistenceManager.class, container.getSessionPersistenceManagerInjectedValue());
        }
        if (webSocketInfo != null) {
            builder.addCapabilityRequirement("org.wildfly.io.worker", XnioWorker.class, container.getWebsocketsWorker(), new String[]{webSocketInfo.getWorker()});
            builder.addCapabilityRequirement("org.wildfly.undertow.byte-buffer-pool", ByteBufferPool.class, container.getWebsocketsBufferPool(), new String[]{webSocketInfo.getBufferPool()});
        }
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND).addAliases(new ServiceName[]{UndertowService.SERVLET_CONTAINER.append(new String[]{name})}).install();
    }
}

