/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorServiceImpl;

public final class LazyInitializingBlockingTaskAwareExecutorService
implements BlockingTaskAwareExecutorService {
    private final ThreadPoolExecutorFactory<ExecutorService> executorFactory;
    private final ThreadFactory threadFactory;
    private final TimeService timeService;
    private final String controllerThreadName;
    private volatile BlockingTaskAwareExecutorService delegate;

    public LazyInitializingBlockingTaskAwareExecutorService(ThreadPoolExecutorFactory<ExecutorService> executorFactory, ThreadFactory threadFactory, TimeService timeService, String controllerThreadName) {
        this.executorFactory = executorFactory;
        this.threadFactory = threadFactory;
        this.timeService = timeService;
        this.controllerThreadName = controllerThreadName;
    }

    @Override
    public void execute(BlockingRunnable runnable) {
        this.initIfNeeded();
        this.delegate.execute(runnable);
    }

    @Override
    public void checkForReadyTasks() {
        if (this.delegate != null) {
            this.delegate.checkForReadyTasks();
        }
    }

    @Override
    public void shutdown() {
        if (this.delegate != null) {
            this.delegate.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.delegate == null) {
            return Collections.emptyList();
        }
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate == null || this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate == null || this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.delegate == null) {
            return true;
        }
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.initIfNeeded();
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.initIfNeeded();
        return this.delegate.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.initIfNeeded();
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.initIfNeeded();
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.initIfNeeded();
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.initIfNeeded();
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.initIfNeeded();
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.initIfNeeded();
        this.delegate.execute(command);
    }

    public BlockingTaskAwareExecutorService getExecutorService() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        if (this.delegate == null) {
            LazyInitializingBlockingTaskAwareExecutorService lazyInitializingBlockingTaskAwareExecutorService = this;
            synchronized (lazyInitializingBlockingTaskAwareExecutorService) {
                if (this.delegate == null) {
                    this.delegate = new BlockingTaskAwareExecutorServiceImpl(this.controllerThreadName, this.executorFactory.createExecutor(this.threadFactory), this.timeService);
                }
            }
        }
    }
}

