/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.logging.Level;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.RemotingExtension;
import org.jboss.as.remoting.RemotingSubsystemAdd;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.RemotingOptions;
import org.wildfly.extension.io.OptionAttributeDefinition;
import org.xnio.Option;

public class RemotingSubsystemRootResource
extends SimpleResourceDefinition {
    static final String IO_WORKER_CAPABILITY = "org.wildfly.io.worker";
    static final RuntimeCapability<Void> REMOTING_ENDPOINT_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.remoting.endpoint", Endpoint.class).build();
    private static final String ENDPOINT = "endpoint";
    static final SimpleAttributeDefinition WORKER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("worker", ModelType.STRING).setRequired(false)).setAttributeGroup("endpoint")).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).setValidator((ParameterValidator)new StringLengthValidator(1))).setDefaultValue(new ModelNode("default"))).setCapabilityReference("org.wildfly.io.worker", REMOTING_ENDPOINT_CAPABILITY)).build();
    private static final OptionAttributeDefinition SEND_BUFFER_SIZE = RemotingSubsystemRootResource.createOptionAttribute("send-buffer-size", RemotingOptions.SEND_BUFFER_SIZE, new ModelNode(8192));
    private static final OptionAttributeDefinition RECEIVE_BUFFER_SIZE = RemotingSubsystemRootResource.createOptionAttribute("receive-buffer-size", RemotingOptions.RECEIVE_BUFFER_SIZE, new ModelNode(8192));
    private static final OptionAttributeDefinition BUFFER_REGION_SIZE = RemotingSubsystemRootResource.createOptionAttribute("buffer-region-size", RemotingOptions.BUFFER_REGION_SIZE, null);
    private static final OptionAttributeDefinition TRANSMIT_WINDOW_SIZE = RemotingSubsystemRootResource.createOptionAttribute("transmit-window-size", RemotingOptions.TRANSMIT_WINDOW_SIZE, new ModelNode(131072));
    private static final OptionAttributeDefinition RECEIVE_WINDOW_SIZE = RemotingSubsystemRootResource.createOptionAttribute("receive-window-size", RemotingOptions.RECEIVE_WINDOW_SIZE, new ModelNode(131072));
    private static final OptionAttributeDefinition MAX_OUTBOUND_CHANNELS = RemotingSubsystemRootResource.createOptionAttribute("max-outbound-channels", RemotingOptions.MAX_OUTBOUND_CHANNELS, new ModelNode(40));
    private static final OptionAttributeDefinition MAX_INBOUND_CHANNELS = RemotingSubsystemRootResource.createOptionAttribute("max-inbound-channels", RemotingOptions.MAX_INBOUND_CHANNELS, new ModelNode(40));
    private static final OptionAttributeDefinition AUTHORIZE_ID = RemotingSubsystemRootResource.createOptionAttribute("authorize-id", RemotingOptions.AUTHORIZE_ID, null);
    private static final OptionAttributeDefinition AUTH_REALM = RemotingSubsystemRootResource.createOptionAttribute("auth-realm", RemotingOptions.AUTH_REALM, null);
    private static final OptionAttributeDefinition AUTHENTICATION_RETRIES = RemotingSubsystemRootResource.createOptionAttribute("authentication-retries", RemotingOptions.AUTHENTICATION_RETRIES, new ModelNode(3));
    private static final OptionAttributeDefinition MAX_OUTBOUND_MESSAGES = RemotingSubsystemRootResource.createOptionAttribute("max-outbound-messages", RemotingOptions.MAX_OUTBOUND_MESSAGES, new ModelNode(65535));
    private static final OptionAttributeDefinition MAX_INBOUND_MESSAGES = RemotingSubsystemRootResource.createOptionAttribute("max-inbound-messages", RemotingOptions.MAX_INBOUND_MESSAGES, new ModelNode(80));
    private static final OptionAttributeDefinition HEARTBEAT_INTERVAL = RemotingSubsystemRootResource.createOptionAttribute("heartbeat-interval", RemotingOptions.HEARTBEAT_INTERVAL, new ModelNode(60000));
    private static final OptionAttributeDefinition MAX_INBOUND_MESSAGE_SIZE = RemotingSubsystemRootResource.createOptionAttribute("max-inbound-message-size", RemotingOptions.MAX_INBOUND_MESSAGE_SIZE, new ModelNode(Long.MAX_VALUE));
    private static final OptionAttributeDefinition MAX_OUTBOUND_MESSAGE_SIZE = RemotingSubsystemRootResource.createOptionAttribute("max-outbound-message-size", RemotingOptions.MAX_OUTBOUND_MESSAGE_SIZE, new ModelNode(Long.MAX_VALUE));
    private static final OptionAttributeDefinition SERVER_NAME = RemotingSubsystemRootResource.createOptionAttribute("server-name", RemotingOptions.SERVER_NAME, null);
    static final OptionAttributeDefinition SASL_PROTOCOL = RemotingSubsystemRootResource.createOptionAttribute("sasl-protocol", RemotingOptions.SASL_PROTOCOL, new ModelNode("remote"));
    static final OptionAttributeDefinition[] OPTIONS = new OptionAttributeDefinition[]{SEND_BUFFER_SIZE, RECEIVE_BUFFER_SIZE, BUFFER_REGION_SIZE, TRANSMIT_WINDOW_SIZE, RECEIVE_WINDOW_SIZE, MAX_OUTBOUND_CHANNELS, MAX_INBOUND_CHANNELS, AUTHORIZE_ID, AUTH_REALM, AUTHENTICATION_RETRIES, MAX_OUTBOUND_MESSAGES, MAX_INBOUND_MESSAGES, HEARTBEAT_INTERVAL, MAX_INBOUND_MESSAGE_SIZE, MAX_OUTBOUND_MESSAGE_SIZE, SERVER_NAME, SASL_PROTOCOL};
    private static final String[] SERVER_ATTR_NAMES = new String[OPTIONS.length + 1];
    static final SimpleAttributeDefinition WORKER_READ_THREADS;
    static final SimpleAttributeDefinition WORKER_TASK_CORE_THREADS;
    static final SimpleAttributeDefinition WORKER_TASK_KEEPALIVE;
    static final SimpleAttributeDefinition WORKER_TASK_LIMIT;
    static final SimpleAttributeDefinition WORKER_TASK_MAX_THREADS;
    static final SimpleAttributeDefinition WORKER_WRITE_THREADS;
    static SimpleAttributeDefinition[] LEGACY_ATTRIBUTES;
    private static final PathElement PATH;
    private final Attributes attributes;

    static ResourceDefinition create(ProcessType processType, boolean forDomain) {
        return new RemotingSubsystemRootResource(new Attributes(processType, forDomain));
    }

    private RemotingSubsystemRootResource(Attributes attributes) {
        super(new SimpleResourceDefinition.Parameters(PATH, RemotingExtension.getResourceDescriptionResolver("remoting")).setAddHandler((OperationStepHandler)new RemotingSubsystemAdd(attributes)).setAddRestartLevel(OperationEntry.Flag.RESTART_NONE).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler()).setRemoveRestartLevel(OperationEntry.Flag.RESTART_ALL_SERVICES).setCapabilities(new RuntimeCapability[]{REMOTING_ENDPOINT_CAPABILITY}));
        this.attributes = attributes;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        if (this.attributes.legacy != null) {
            ModelOnlyWriteAttributeHandler threadWrites = new ModelOnlyWriteAttributeHandler(this.attributes.legacy);
            for (AttributeDefinition attribute : this.attributes.legacy) {
                resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)threadWrites);
            }
        }
        resourceRegistration.registerReadWriteAttribute(this.attributes.worker, null, (OperationStepHandler)new WorkerAttributeWriteHandler());
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(this.attributes.options);
        for (AttributeDefinition attribute : this.attributes.options) {
            resourceRegistration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    private static OptionAttributeDefinition createOptionAttribute(String name, Option<?> option, ModelNode defaultValue) {
        OptionAttributeDefinition.Builder builder = (OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)((OptionAttributeDefinition.Builder)OptionAttributeDefinition.builder((String)name, option).setAllowExpression(true)).setAttributeGroup(ENDPOINT)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
        if (defaultValue != null) {
            builder = (OptionAttributeDefinition.Builder)builder.setDefaultValue(defaultValue);
        }
        return builder.build();
    }

    private static SimpleAttributeDefinition createWorkerAttribute(String name, Attribute attribute, int defaultValue) {
        return ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((String)name, (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode().set(defaultValue))).setAlternatives(SERVER_ATTR_NAMES)).setXmlName(attribute.getLocalName())).setValidator((ParameterValidator)new IntRangeValidator(1))).setAllowExpression(true)).setDeprecated(ModelVersion.create((int)2, (int)0))).build();
    }

    static {
        RemotingSubsystemRootResource.SERVER_ATTR_NAMES[0] = WORKER.getName();
        for (int i = 0; i < OPTIONS.length; ++i) {
            RemotingSubsystemRootResource.SERVER_ATTR_NAMES[i + 1] = OPTIONS[i].getName();
        }
        WORKER_READ_THREADS = RemotingSubsystemRootResource.createWorkerAttribute("worker-read-threads", Attribute.WORKER_READ_THREADS, 1);
        WORKER_TASK_CORE_THREADS = RemotingSubsystemRootResource.createWorkerAttribute("worker-task-core-threads", Attribute.WORKER_TASK_CORE_THREADS, 4);
        WORKER_TASK_KEEPALIVE = RemotingSubsystemRootResource.createWorkerAttribute("worker-task-keepalive", Attribute.WORKER_TASK_KEEPALIVE, 60);
        WORKER_TASK_LIMIT = RemotingSubsystemRootResource.createWorkerAttribute("worker-task-limit", Attribute.WORKER_TASK_LIMIT, 16384);
        WORKER_TASK_MAX_THREADS = RemotingSubsystemRootResource.createWorkerAttribute("worker-task-max-threads", Attribute.WORKER_TASK_MAX_THREADS, 16);
        WORKER_WRITE_THREADS = RemotingSubsystemRootResource.createWorkerAttribute("worker-write-threads", Attribute.WORKER_WRITE_THREADS, 1);
        LEGACY_ATTRIBUTES = new SimpleAttributeDefinition[]{WORKER_READ_THREADS, WORKER_TASK_CORE_THREADS, WORKER_TASK_KEEPALIVE, WORKER_TASK_LIMIT, WORKER_TASK_MAX_THREADS, WORKER_WRITE_THREADS};
        PATH = PathElement.pathElement((String)"subsystem", (String)"remoting");
    }

    private static class WorkerThreadValidator
    implements ParameterValidator {
        private static final ParameterValidator INSTANCE = new WorkerThreadValidator();

        private WorkerThreadValidator() {
        }

        public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
            if (value.isDefined()) {
                throw RemotingLogger.ROOT_LOGGER.workerConfigurationIgnored();
            }
        }

        public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
            this.validateParameter(parameterName, value);
        }
    }

    static class Attributes {
        final boolean forDomain;
        private final AttributeDefinition[] legacy;
        private final AttributeDefinition worker;
        private final AttributeDefinition[] options;
        final AttributeDefinition[] all;

        private Attributes(ProcessType processType, boolean forDomain) {
            this.forDomain = forDomain;
            this.options = OPTIONS;
            if (processType.isServer()) {
                this.worker = WORKER;
                this.legacy = new AttributeDefinition[LEGACY_ATTRIBUTES.length];
                for (int i = 0; i < LEGACY_ATTRIBUTES.length; ++i) {
                    this.legacy[i] = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)LEGACY_ATTRIBUTES[i]).setValidator(WorkerThreadValidator.INSTANCE)).setDefaultValue(null)).build();
                }
            } else if (forDomain) {
                this.worker = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create((SimpleAttributeDefinition)WORKER).setCapabilityReference((CapabilityReferenceRecorder)null)).build();
                this.legacy = LEGACY_ATTRIBUTES;
            } else {
                this.worker = WORKER;
                this.legacy = null;
            }
            int count = this.options.length + 1 + (this.legacy == null ? 0 : this.legacy.length);
            this.all = new AttributeDefinition[count];
            int idx = 0;
            if (this.legacy != null) {
                System.arraycopy(this.legacy, 0, this.all, 0, this.legacy.length);
                idx += this.legacy.length;
            }
            this.all[idx] = this.worker;
            System.arraycopy(this.options, 0, this.all, idx + 1, this.options.length);
        }
    }

    private static class WorkerAttributeWriteHandler
    extends ReloadRequiredWriteAttributeHandler {
        WorkerAttributeWriteHandler() {
            super(new AttributeDefinition[]{WORKER});
        }

        protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            context.addResponseWarning(Level.WARNING, RemotingLogger.ROOT_LOGGER.warningOnWorkerChange(newValue.asString()));
        }
    }
}

