/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.io.IOException;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.core.model.test.CoreModelTestDelegate;
import org.jboss.as.core.model.test.KernelServices;
import org.jboss.as.core.model.test.KernelServicesBuilder;
import org.jboss.as.core.model.test.TestModelType;
import org.jboss.as.model.test.EAPRepositoryReachableUtil;
import org.jboss.as.model.test.ModelFixer;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.dmr.ModelNode;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;

public abstract class AbstractCoreModelTest {
    private final CoreModelTestDelegate delegate = new CoreModelTestDelegate(this.getClass());

    protected AbstractCoreModelTest() {
    }

    @Before
    public void initializeParser() throws Exception {
        this.delegate.initializeParser();
    }

    @After
    public void cleanup() throws Exception {
        this.delegate.cleanup();
        this.delegate.setCurrentTransformerClassloaderParameter(null);
    }

    CoreModelTestDelegate getDelegate() {
        return this.delegate;
    }

    protected KernelServicesBuilder createKernelServicesBuilder(TestModelType type) {
        return this.delegate.createKernelServicesBuilder(type);
    }

    protected ModelNode checkCoreModelTransformation(KernelServices kernelServices, ModelVersion modelVersion) throws IOException {
        return this.checkCoreModelTransformation(kernelServices, modelVersion, null, null);
    }

    protected ModelNode checkCoreModelTransformation(KernelServices kernelServices, ModelVersion modelVersion, ModelFixer legacyModelFixer, ModelFixer transformedModelFixer) throws IOException {
        return this.delegate.checkCoreModelTransformation(kernelServices, modelVersion, legacyModelFixer, transformedModelFixer);
    }

    protected static ModelNode checkOutcome(ModelNode result) {
        return ModelTestUtils.checkOutcome((ModelNode)result);
    }

    protected void ignoreThisTestIfEAPRepositoryIsNotReachable() {
        Assume.assumeTrue((boolean)EAPRepositoryReachableUtil.isReachable());
    }
}

