/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.host.controller.discovery.StaticDiscovery;
import org.jboss.as.host.controller.discovery.StaticDiscoveryResourceDefinition;
import org.jboss.as.host.controller.operations.AbstractDiscoveryOptionAddHandler;
import org.jboss.as.host.controller.operations.DomainControllerWriteAttributeHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.network.NetworkUtils;
import org.jboss.dmr.ModelNode;

public class StaticDiscoveryAddHandler
extends AbstractDiscoveryOptionAddHandler {
    private final LocalHostControllerInfoImpl hostControllerInfo;

    public StaticDiscoveryAddHandler(LocalHostControllerInfoImpl hostControllerInfo) {
        this.hostControllerInfo = hostControllerInfo;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            this.populateHostControllerInfo(this.hostControllerInfo, context, operation);
        } else {
            context.reloadRequired();
        }
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        StaticDiscoveryAddHandler.updateOptionsAttribute(context, operation, "static-discovery");
    }

    protected void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        ModelNode hostNode = StaticDiscoveryResourceDefinition.HOST.resolveModelAttribute(context, model);
        ModelNode portNode = StaticDiscoveryResourceDefinition.PORT.resolveModelAttribute(context, model);
        ModelNode protocolNode = DomainControllerWriteAttributeHandler.PROTOCOL.resolveModelAttribute(context, model);
        String remoteDcHost = !hostNode.isDefined() ? null : NetworkUtils.formatPossibleIpv6Address((String)hostNode.asString());
        int remoteDcPort = !portNode.isDefined() ? -1 : portNode.asInt();
        String remoteDcProtocol = protocolNode.asString();
        StaticDiscovery staticDiscoveryOption = new StaticDiscovery(remoteDcProtocol, remoteDcHost, remoteDcPort);
        hostControllerInfo.addRemoteDomainControllerDiscoveryOption(staticDiscoveryOption);
    }
}

