/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.management;

import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.wfly10.config.management.ManageableResourceType;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.ManagementOperationException;

public interface ManageableResource {
    public ManageableResourceType getResourceType();

    public String getResourceName();

    default public String getResourceAbsoluteName() {
        return this.getResourcePathAddress().toCLIStyleString();
    }

    public PathAddress getResourcePathAddress();

    public ModelNode getResourceConfiguration() throws ManagementOperationException;

    public void removeResource() throws ManagementOperationException;

    default public boolean isExistentResource() throws ManagementOperationException {
        ManageableResource parent = this.getParentResource();
        return parent != null ? parent.hasChildResource(this.getResourceType(), this.getResourceName()) : true;
    }

    public ManageableResource getParentResource();

    public ManageableServerConfiguration getServerConfiguration();

    public <T extends ManageableResource> T getChildResource(ManageableResourceType var1, String var2) throws ManagementOperationException;

    public <T extends ManageableResource> List<T> getChildResources(ManageableResourceType var1) throws ManagementOperationException;

    public <T extends ManageableResource> List<T> getChildResources(Class<T> var1) throws ManagementOperationException;

    public <T extends ManageableResource> List<T> getChildResources(Class<T> var1, String var2) throws ManagementOperationException;

    default public Set<ManageableResourceType> getChildResourceTypes() {
        return this.getResourceType().getChildTypes();
    }

    public Set<String> getChildResourceNames(ManageableResourceType var1) throws ManagementOperationException;

    default public <T extends ManageableResource> String getChildResourceAbsoluteName(ManageableResourceType resourceType, String resourceName) {
        return this.getChildResourcePathAddress(resourceType, resourceName).toCLIStyleString();
    }

    public <T extends ManageableResource> PathAddress getChildResourcePathAddress(ManageableResourceType var1, String var2);

    default public void removeChildResource(ManageableResourceType resourceType, String resourceName) throws ManagementOperationException {
        Object child = this.getChildResource(resourceType, resourceName);
        if (child != null) {
            child.removeResource();
        }
    }

    default public ModelNode getChildResourceConfiguration(ManageableResourceType resourceType, String resourceName) throws ManagementOperationException {
        Object child = this.getChildResource(resourceType, resourceName);
        return child != null ? child.getResourceConfiguration() : null;
    }

    default public boolean hasChildResource(ManageableResourceType resourceType, String resourceName) throws ManagementOperationException {
        return this.getChildResourceNames(resourceType).contains(resourceName);
    }

    public <T extends ManageableResource> Set<T> findResources(ManageableResourceType var1) throws ManagementOperationException;

    public <T extends ManageableResource> Set<T> findResources(Class<T> var1) throws ManagementOperationException;

    public <T extends ManageableResource> Set<T> findResources(ManageableResourceType var1, String var2) throws ManagementOperationException;

    public <T extends ManageableResource> Set<T> findResources(Class<T> var1, String var2) throws ManagementOperationException;
}

