/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.remoting;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class AddHttpConnectorIfMissing<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String DEFAULT_HTTP_CONNECTOR_NAME = "http-remoting-connector";
    public static final String DEFAULT_CONNECTOR_REF_NAME = "http";
    public static final String DEFAULT_SECURITY_REALM_NAME = "ApplicationRealm";
    public static final String TASK_NAME = "add-remoting-http-connector";
    private static final String HTTP_CONNECTOR = "http-connector";
    private static final String CONNECTOR_REF = "connector-ref";
    private static final String SECURITY_REALM = "security-realm";

    public AddHttpConnectorIfMissing() {
        this.subtaskName(TASK_NAME);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext taskContext, TaskEnvironment taskEnvironment) {
        PathAddress subsystemPathAddress = subsystemResource.getResourcePathAddress();
        ManageableServerConfiguration serverConfiguration = subsystemResource.getServerConfiguration();
        String httpConnectorName = taskEnvironment.getPropertyAsString("httpConnectorName", DEFAULT_HTTP_CONNECTOR_NAME);
        String connectorRefName = taskEnvironment.getPropertyAsString("connectorRefName", DEFAULT_CONNECTOR_REF_NAME);
        String securityRealmName = taskEnvironment.getPropertyAsString("securityRealmName", DEFAULT_SECURITY_REALM_NAME);
        if (!config.hasDefined(new String[]{HTTP_CONNECTOR, httpConnectorName})) {
            PathAddress httpRemotingConnectorPathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)HTTP_CONNECTOR, (String)httpConnectorName)});
            ModelNode httpRemotingConnectorAddOp = Util.createEmptyOperation((String)"add", (PathAddress)httpRemotingConnectorPathAddress);
            httpRemotingConnectorAddOp.get(CONNECTOR_REF).set(connectorRefName);
            httpRemotingConnectorAddOp.get(SECURITY_REALM).set(securityRealmName);
            serverConfiguration.executeManagementOperation(httpRemotingConnectorAddOp);
            taskContext.getLogger().debugf("Http connector %s added to Remoting subsystem configuration.", (Object)httpConnectorName);
            return ServerMigrationTaskResult.SUCCESS;
        }
        return ServerMigrationTaskResult.SKIPPED;
    }

    public static interface EnvironmentProperties {
        public static final String HTTP_CONNECTOR_NAME = "httpConnectorName";
        public static final String CONNECTOR_REF_NAME = "connectorRefName";
        public static final String SECURITY_REALM_NAME = "securityRealmName";
    }
}

