package org.jboss.weld.logging;

import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.reflect.Method;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.NoSuchMethodException;
import java.lang.reflect.Type;
import org.jboss.weld.logging.WeldLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.lang.Class;
import org.jboss.weld.exceptions.DefinitionException;
import java.util.Arrays;
import org.jboss.weld.exceptions.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-04-18T08:42:10+0000")
public class ReflectionLogger_$logger extends DelegatingBasicLogger implements ReflectionLogger,org.jboss.weld.logging.WeldLogger,BasicLogger,Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ReflectionLogger_$logger.class.getName();
    public ReflectionLogger_$logger(final Logger log) {
        super(log);
    }
    @Override
    public final void missingRetention(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, missingRetention$str(), param1);
    }
    private static final String missingRetention = "WELD-000600: {0} is missing @Retention(RUNTIME). Weld will use this annotation, however this may make the application unportable.";
    protected String missingRetention$str() {
        return missingRetention;
    }
    @Override
    public final void missingTarget(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, missingTarget$str(), param1);
    }
    private static final String missingTarget = "WELD-000601: {0} is missing @Target. Weld will use this annotation, however this may make the application unportable.";
    protected String missingTarget$str() {
        return missingTarget;
    }
    @Override
    public final void missingTargetTypeMethodOrTargetType(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, missingTargetTypeMethodOrTargetType$str(), param1);
    }
    private static final String missingTargetTypeMethodOrTargetType = "WELD-000602: {0} is not declared @Target(TYPE, METHOD) or @Target(TYPE). Weld will use this annotation, however this may make the application unportable.";
    protected String missingTargetTypeMethodOrTargetType$str() {
        return missingTargetTypeMethodOrTargetType;
    }
    @Override
    public final void missingTargetMethodFieldType(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, missingTargetMethodFieldType$str(), param1);
    }
    private static final String missingTargetMethodFieldType = "WELD-000604: {0} is not declared @Target(METHOD, FIELD, TYPE). Weld will use this annotation, however this may make the application unportable.";
    protected String missingTargetMethodFieldType$str() {
        return missingTargetMethodFieldType;
    }
    @Override
    public final void missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField$str(), param1);
    }
    private static final String missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField = "WELD-000605: {0} is not declared @Target(METHOD, FIELD, TYPE, PARAMETER), @Target(METHOD, TYPE), @Target(METHOD), @Target(TYPE) or @Target(FIELD). Weld will use this annotation, however this may make the application unportable.";
    protected String missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField$str() {
        return missingTargetMethodFieldTypeParameterOrTargetMethodTypeOrTargetMethodOrTargetTypeOrTargetField;
    }
    private static final String unableToGetParameterName = "WELD-000606: Unable to determine name of parameter";
    protected String unableToGetParameterName$str() {
        return unableToGetParameterName;
    }
    @Override
    public final IllegalArgumentException unableToGetParameterName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(unableToGetParameterName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String annotationMapNull = "WELD-000607: annotationMap cannot be null";
    protected String annotationMapNull$str() {
        return annotationMapNull;
    }
    @Override
    public final WeldException annotationMapNull() {
        final WeldException result = new WeldException(String.format(annotationMapNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String declaredAnnotationMapNull = "WELD-000608: declaredAnnotationMap cannot be null";
    protected String declaredAnnotationMapNull$str() {
        return declaredAnnotationMapNull;
    }
    @Override
    public final WeldException declaredAnnotationMapNull() {
        final WeldException result = new WeldException(String.format(declaredAnnotationMapNull$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToGetConstructorOnDeserialization = "WELD-000610: Unable to deserialize constructor. Declaring class {0}, index {1}";
    protected String unableToGetConstructorOnDeserialization$str() {
        return unableToGetConstructorOnDeserialization;
    }
    @Override
    public final WeldException unableToGetConstructorOnDeserialization(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(unableToGetConstructorOnDeserialization$str(), param1, param2), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToGetMethodOnDeserialization = "WELD-000611: Unable to deserialize method. Declaring class {0}, index {1}";
    protected String unableToGetMethodOnDeserialization$str() {
        return unableToGetMethodOnDeserialization;
    }
    @Override
    public final WeldException unableToGetMethodOnDeserialization(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(unableToGetMethodOnDeserialization$str(), param1, param2), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToGetFieldOnDeserialization = "WELD-000612: Unable to deserialize field. Declaring class {0}, field name {1}";
    protected String unableToGetFieldOnDeserialization$str() {
        return unableToGetFieldOnDeserialization;
    }
    @Override
    public final WeldException unableToGetFieldOnDeserialization(final Object param1, final Object param2, final Throwable cause) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(unableToGetFieldOnDeserialization$str(), param1, param2), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incorrectNumberOfAnnotatedParametersMethod = "WELD-000614: Incorrect number of AnnotatedParameters {0} on AnnotatedMethod {1}. AnnotatedMethod has {2} as parameters but should have {3} as parameters";
    protected String incorrectNumberOfAnnotatedParametersMethod$str() {
        return incorrectNumberOfAnnotatedParametersMethod;
    }
    @Override
    public final DefinitionException incorrectNumberOfAnnotatedParametersMethod(final Object param1, final Object param2, final Object param3, final Object param4) {
        final DefinitionException result = new DefinitionException(java.text.MessageFormat.format(incorrectNumberOfAnnotatedParametersMethod$str(), param1, param2, param3, param4));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String reflectionfactoryInstantiationFailed = "WELD-000616: Instantiation through ReflectionFactory of {0} failed";
    protected String reflectionfactoryInstantiationFailed$str() {
        return reflectionfactoryInstantiationFailed;
    }
    @Override
    public final WeldException reflectionfactoryInstantiationFailed(final Object param1, final Throwable cause) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(reflectionfactoryInstantiationFailed$str(), param1), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsafeInstantiationFailed = "WELD-000617: Instantiation through Unsafe of {0} failed";
    protected String unsafeInstantiationFailed$str() {
        return unsafeInstantiationFailed;
    }
    @Override
    public final WeldException unsafeInstantiationFailed(final Object param1, final Throwable cause) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(unsafeInstantiationFailed$str(), param1), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void lifecycleCallbackInterceptorWithInvalidBindingTarget(final Object interceptor, final Object binding, final Object elementTypes) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, lifecycleCallbackInterceptorWithInvalidBindingTarget$str(), interceptor, binding, elementTypes);
    }
    private static final String lifecycleCallbackInterceptorWithInvalidBindingTarget = "WELD-000619: A lifecycle callback interceptor declares an interceptor binding with target other than ElementType.TYPE\n  {0}\n  Binding: {1}\n  Target: {2}";
    protected String lifecycleCallbackInterceptorWithInvalidBindingTarget$str() {
        return lifecycleCallbackInterceptorWithInvalidBindingTarget;
    }
    @Override
    public final void missingTargetMethodFieldParameterType(final Object param1) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.DEBUG, null, missingTargetMethodFieldParameterType$str(), param1);
    }
    private static final String missingTargetMethodFieldParameterType = "WELD-000620: {0} is not declared @Target(METHOD, FIELD, PARAMETER, TYPE). Weld will use this annotation, however this may make the application unportable.";
    protected String missingTargetMethodFieldParameterType$str() {
        return missingTargetMethodFieldParameterType;
    }
    @Override
    public final void invalidInterceptorBindingTargetDeclaration(final Object param1, final Object param2, final Object param3, final Object param4) {
        super.log.logv(FQCN, org.jboss.logging.Logger.Level.WARN, null, invalidInterceptorBindingTargetDeclaration$str(), param1, param2, param3, param4);
    }
    private static final String invalidInterceptorBindingTargetDeclaration = "WELD-000621: Interceptor binding {0} with @Target defined as {1} should not be applied on interceptor binding {2} with @Target definition: {3}";
    protected String invalidInterceptorBindingTargetDeclaration$str() {
        return invalidInterceptorBindingTargetDeclaration;
    }
    private static final String illegalArgumentExceptionOnReflectionInvocation = "WELD-000622: IllegalArgumentException invoking {2} on {1} ({0}) with parameters {3}";
    protected String illegalArgumentExceptionOnReflectionInvocation$str() {
        return illegalArgumentExceptionOnReflectionInvocation;
    }
    @Override
    public final WeldException illegalArgumentExceptionOnReflectionInvocation(final Class<? extends Object> clazz, final Object instance, final Method method, final String parameters, final Throwable cause) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(illegalArgumentExceptionOnReflectionInvocation$str(), clazz, instance, method, parameters), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownType = "WELD-000623: Unknown type {0}.";
    protected String unknownType$str() {
        return unknownType;
    }
    @Override
    public final IllegalArgumentException unknownType(final Type type) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(unknownType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidTypeArgumentCombination = "WELD-000624: Invalid type argument combination: {0}; {1}.";
    protected String invalidTypeArgumentCombination$str() {
        return invalidTypeArgumentCombination;
    }
    @Override
    public final IllegalArgumentException invalidTypeArgumentCombination(final Type type1, final Type type2) {
        final IllegalArgumentException result = new IllegalArgumentException(java.text.MessageFormat.format(invalidTypeArgumentCombination$str(), type1, type2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchMethodWrapper = "WELD-000625: Unable to locate method: {0}";
    protected String noSuchMethodWrapper$str() {
        return noSuchMethodWrapper;
    }
    @Override
    public final WeldException noSuchMethodWrapper(final NoSuchMethodException cause, final String message) {
        final WeldException result = new WeldException(java.text.MessageFormat.format(noSuchMethodWrapper$str(), message), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void catchingDebug(final Throwable throwable) {
        super.log.logf(FQCN, org.jboss.logging.Logger.Level.DEBUG, throwable, catchingDebug$str());
    }
    private static final String catchingDebug = "Catching";
    protected String catchingDebug$str() {
        return catchingDebug;
    }
}
