/*
 * JBoss, Home of Professional Open Source
 * Copyright 2018, JBoss Inc., and individual contributors as indicated
 * by the @authors tag.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.as.domain.http.server;

import java.util.Locale;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class OperatingSystemDetector {
    public static final OperatingSystemDetector INSTANCE;

    static {
        final String os = System.getProperty("os.name");
        final boolean windows;
        if (os != null && os.toLowerCase(Locale.ENGLISH).contains("win")) {
            windows = true;
        } else {
            windows = false;
        }
        INSTANCE = new OperatingSystemDetector(windows);
    }

    private final boolean windows;

    private OperatingSystemDetector(boolean windows) {
        this.windows = windows;
    }

    public boolean isWindows() {
        return windows;
    }

}
