package org.jboss.as.server.deployment.scanner.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.io.File;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-05-13T10:28:51+0000")
public class DeploymentScannerLogger_$logger extends DelegatingBasicLogger implements DeploymentScannerLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DeploymentScannerLogger_$logger.class.getName();
    public DeploymentScannerLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotDeleteDeploymentProgressMarker(final File file) {
        super.log.logf(FQCN, WARN, null, cannotDeleteDeploymentProgressMarker$str(), file);
    }
    private static final String cannotDeleteDeploymentProgressMarker = "WFLYDS0001: Cannot delete deployment progress marker file %s";
    protected String cannotDeleteDeploymentProgressMarker$str() {
        return cannotDeleteDeploymentProgressMarker;
    }
    @Override
    public final void cannotRemoveDeploymentMarker(final String fileName) {
        super.log.logf(FQCN, WARN, null, cannotRemoveDeploymentMarker$str(), fileName);
    }
    private static final String cannotRemoveDeploymentMarker = "WFLYDS0002: Cannot remove extraneous deployment marker file %s";
    protected String cannotRemoveDeploymentMarker$str() {
        return cannotRemoveDeploymentMarker;
    }
    @Override
    public final void cannotRemoveDeploymentMarker(final File file) {
        super.log.logf(FQCN, WARN, null, cannotRemoveDeploymentMarker$str(), file);
    }
    @Override
    public final void deploymentNotFound(final String deploymentName) {
        super.log.logf(FQCN, WARN, null, deploymentNotFound$str(), deploymentName);
    }
    private static final String deploymentNotFound = "WFLYDS0003: Deployment of '%s' requested, but the deployment is not present";
    protected String deploymentNotFound$str() {
        return deploymentNotFound;
    }
    @Override
    public final void deploymentTriggered(final String fileName, final String marker) {
        super.log.logf(FQCN, INFO, null, deploymentTriggered$str(), fileName, marker);
    }
    private static final String deploymentTriggered = "WFLYDS0004: Found %1$s in deployment directory. To trigger deployment create a file called %1$s%2$s";
    protected String deploymentTriggered$str() {
        return deploymentTriggered;
    }
    @Override
    public final void errorWritingDeploymentMarker(final Throwable cause, final String markerFile) {
        super.log.logf(FQCN, ERROR, cause, errorWritingDeploymentMarker$str(), markerFile);
    }
    private static final String errorWritingDeploymentMarker = "WFLYDS0005: Caught exception writing deployment marker file %s";
    protected String errorWritingDeploymentMarker$str() {
        return errorWritingDeploymentMarker;
    }
    @Override
    public final void explodedAutoDeploymentContentWarning(final String marker, final String elementName) {
        super.log.logf(FQCN, WARN, null, explodedAutoDeploymentContentWarning$str(), marker, elementName);
    }
    private static final String explodedAutoDeploymentContentWarning = "WFLYDS0006: Reliable deployment behaviour is not possible when auto-deployment of exploded content is enabled (i.e. deployment without use of \"%s\"' marker files). Configuration of auto-deployment of exploded content is not recommended in any situation where reliability is desired. Configuring the deployment scanner's %s setting to \"false\" is recommended.";
    protected String explodedAutoDeploymentContentWarning$str() {
        return explodedAutoDeploymentContentWarning;
    }
    @Override
    public final void explodedDeploymentContentDeleted(final String fileName, final String marker) {
        super.log.logf(FQCN, WARN, null, explodedDeploymentContentDeleted$str(), fileName, marker);
    }
    private static final String explodedDeploymentContentDeleted = "WFLYDS0007: The deployment scanner found that the content for exploded deployment %1$s has been deleted, but auto-deploy/undeploy for exploded deployments is not enabled and the %1$s%2$s marker file for this deployment has not been removed. As a result, the deployment is not being undeployed, but resources needed by the deployment may have been deleted and application errors may occur. Deleting the %1$s%2$s marker file to trigger undeploy is recommended.";
    protected String explodedDeploymentContentDeleted$str() {
        return explodedDeploymentContentDeleted;
    }
    @Override
    public final void failedCheckingZipFile(final Throwable cause, final String fileName) {
        super.log.logf(FQCN, ERROR, cause, failedCheckingZipFile$str(), fileName);
    }
    private static final String failedCheckingZipFile = "WFLYDS0008: Failed checking whether %s was a complete zip";
    protected String failedCheckingZipFile$str() {
        return failedCheckingZipFile;
    }
    @Override
    public final void fileSystemDeploymentFailed(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, fileSystemDeploymentFailed$str());
    }
    private static final String fileSystemDeploymentFailed = "WFLYDS0009: File system deployment service failed";
    protected String fileSystemDeploymentFailed$str() {
        return fileSystemDeploymentFailed;
    }
    @Override
    public final void incompleteContent(final String name) {
        super.log.logf(FQCN, INFO, null, incompleteContent$str(), name);
    }
    private static final String incompleteContent = "WFLYDS0010: Scan found incompletely copied file content for deployment %s. Deployment changes will not be processed until all content is complete.";
    protected String incompleteContent$str() {
        return incompleteContent;
    }
    @Override
    public final void invalidExplodedDeploymentDirectory(final String fileName, final String deploymentDir) {
        super.log.logf(FQCN, ERROR, null, invalidExplodedDeploymentDirectory$str(), fileName, deploymentDir);
    }
    private static final String invalidExplodedDeploymentDirectory = "WFLYDS0011: The deployment scanner found a directory named %1$s that was not inside a directory whose name ends with .ear, .jar, .rar, .sar or .war. This is likely the result of unzipping an archive directly inside the %2$s directory, which is a user error. The %1$s directory will not be scanned for deployments, but it is possible that the scanner may find other files from the unzipped archive and attempt to deploy them, leading to errors.";
    protected String invalidExplodedDeploymentDirectory$str() {
        return invalidExplodedDeploymentDirectory;
    }
    @Override
    public final void scanException(final Throwable cause, final String fileName) {
        super.log.logf(FQCN, ERROR, cause, scanException$str(), fileName);
    }
    private static final String scanException = "WFLYDS0012: Scan of %s threw Exception";
    protected String scanException$str() {
        return scanException;
    }
    @Override
    public final void started(final String className, final String deploymentPath) {
        super.log.logf(FQCN, INFO, null, started$str(), className, deploymentPath);
    }
    private static final String started = "WFLYDS0013: Started %s for directory %s";
    protected String started$str() {
        return started;
    }
    @Override
    public final void unsafeAutoDeploy(final String marker1, final String marker2, final java.util.Set<String> problems) {
        super.log.logf(FQCN, WARN, null, unsafeAutoDeploy$str(), marker1, marker2, problems);
    }
    private static final String unsafeAutoDeploy = "WFLYDS0014: Scan found content configured for auto-deploy that could not be safely auto-deployed. See details above. Deployment changes will not be processed until all problematic content is either removed or whether to deploy the content or not is indicated via a %s or %s marker file. Problematic deployments are %s";
    protected String unsafeAutoDeploy$str() {
        return unsafeAutoDeploy;
    }
    @Override
    public final void reattemptingFailedDeployment(final String deploymentName) {
        super.log.logf(FQCN, INFO, null, reattemptingFailedDeployment$str(), deploymentName);
    }
    private static final String reattemptingFailedDeployment = "WFLYDS0015: Re-attempting failed deployment %s";
    protected String reattemptingFailedDeployment$str() {
        return reattemptingFailedDeployment;
    }
    @Override
    public final void failedCheckingXMLFile(final Throwable cause, final String fileName) {
        super.log.logf(FQCN, ERROR, cause, failedCheckingXMLFile$str(), fileName);
    }
    private static final String failedCheckingXMLFile = "WFLYDS0016: Failed checking whether %s was a complete XML";
    protected String failedCheckingXMLFile$str() {
        return failedCheckingXMLFile;
    }
    @Override
    public final void initialScanFailed(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, initialScanFailed$str());
    }
    private static final String initialScanFailed = "WFLYDS0017: Initial deployment scan failed";
    protected String initialScanFailed$str() {
        return initialScanFailed;
    }
    @Override
    public final void scannerDeploymentUndeployedButNotByScanner(final String deploymentName, final File marker) {
        super.log.logf(FQCN, INFO, null, scannerDeploymentUndeployedButNotByScanner$str(), deploymentName, marker);
    }
    private static final String scannerDeploymentUndeployedButNotByScanner = "WFLYDS0018: Deployment %s was previously deployed by this scanner but has been undeployed by another management tool. Marker file %s is being added to record this fact.";
    protected String scannerDeploymentUndeployedButNotByScanner$str() {
        return scannerDeploymentUndeployedButNotByScanner;
    }
    @Override
    public final void scannerDeploymentRemovedButNotByScanner(final String deploymentName, final File marker) {
        super.log.logf(FQCN, INFO, null, scannerDeploymentRemovedButNotByScanner$str(), deploymentName, marker);
    }
    private static final String scannerDeploymentRemovedButNotByScanner = "WFLYDS0019: Deployment %s was previously deployed by this scanner but has been removed from the server deployment list by another management tool. Marker file %s is being added to record this fact.";
    protected String scannerDeploymentRemovedButNotByScanner$str() {
        return scannerDeploymentRemovedButNotByScanner;
    }
    private static final String deploymentContentIncomplete = "WFLYDS0021: Deployment content %s appears to be incomplete and is not progressing toward completion. This content cannot be auto-deployed.%s";
    protected String deploymentContentIncomplete$str() {
        return deploymentContentIncomplete;
    }
    @Override
    public final String deploymentContentIncomplete(final File file, final String suffix) {
        return String.format(getLoggingLocale(), deploymentContentIncomplete$str(), file, suffix);
    }
    private static final String deploymentTimeout = "WFLYDS0022: Did not receive a response to the deployment operation within the allowed timeout period [%d seconds]. Check the server configuration file and the server logs to find more about the status of the deployment.";
    protected String deploymentTimeout$str() {
        return deploymentTimeout;
    }
    @Override
    public final String deploymentTimeout(final long timeout) {
        return String.format(getLoggingLocale(), deploymentTimeout$str(), timeout);
    }
    private static final String invalidZipFileFormat = "WFLYDS0025: File %s cannot be scanned because it does not begin with a ZIP file format local file header signature";
    protected String invalidZipFileFormat$str() {
        return invalidZipFileFormat;
    }
    @Override
    public final String invalidZipFileFormat(final String fileName) {
        return String.format(getLoggingLocale(), invalidZipFileFormat$str(), fileName);
    }
    private static final String invalidZip64FileFormat = "WFLYDS0026: File %s cannot be scanned because it uses the currently unsupported ZIP64 format";
    protected String invalidZip64FileFormat$str() {
        return invalidZip64FileFormat;
    }
    @Override
    public final String invalidZip64FileFormat(final String fileName) {
        return String.format(getLoggingLocale(), invalidZip64FileFormat$str(), fileName);
    }
    private static final String previousContentDeployed = " A previous version of this content was deployed and remains deployed.";
    protected String previousContentDeployed$str() {
        return previousContentDeployed;
    }
    @Override
    public final String previousContentDeployed() {
        return String.format(getLoggingLocale(), previousContentDeployed$str());
    }
    private static final String unsafeAutoDeploy2 = "WFLYDS0030: File %2$s was configured for auto-deploy but could not be safely auto-deployed. The reason the file could not be auto-deployed was: %1$s.  To enable deployment of this file create a file called %2$s%3$s";
    protected String unsafeAutoDeploy2$str() {
        return unsafeAutoDeploy2;
    }
    @Override
    public final String unsafeAutoDeploy2(final String errorMsg, final String fileName, final String marker) {
        return String.format(getLoggingLocale(), unsafeAutoDeploy2$str(), errorMsg, fileName, marker);
    }
    private static final String deploymentScannerNotForDomainMode = "WFLYDS0031: Extension with module 'org.jboss.as.deployment-scanner' cannot be installed in a managed domain. Please remove it and any subsystem referencing it";
    protected String deploymentScannerNotForDomainMode$str() {
        return deploymentScannerNotForDomainMode;
    }
    @Override
    public final IllegalStateException deploymentScannerNotForDomainMode() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), deploymentScannerNotForDomainMode$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotListDirectoryFiles = "WFLYDS0032: Failed to list files in directory %s. Check that the contents of the directory are readable.";
    protected String cannotListDirectoryFiles$str() {
        return cannotListDirectoryFiles;
    }
    @Override
    public final RuntimeException cannotListDirectoryFiles(final Throwable ioex, final File directory) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotListDirectoryFiles$str(), directory), ioex);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void scannerDeploymentRedeployedButNotByScanner(final String deploymentName, final File marker) {
        super.log.logf(FQCN, INFO, null, scannerDeploymentRedeployedButNotByScanner$str(), deploymentName, marker);
    }
    private static final String scannerDeploymentRedeployedButNotByScanner = "WFLYDS0033: Deployment %s was previously undeployed by this scanner but has been redeployed by another management tool. Marker file %s is being removed to record this fact.";
    protected String scannerDeploymentRedeployedButNotByScanner$str() {
        return scannerDeploymentRedeployedButNotByScanner;
    }
    @Override
    public final void failedStatusSynchronization(final Throwable cause, final String deploymentName) {
        super.log.logf(FQCN, ERROR, cause, failedStatusSynchronization$str(), deploymentName);
    }
    private static final String failedStatusSynchronization = "WFLYDS0034: Failed synchronizing status of deployment %s.";
    protected String failedStatusSynchronization$str() {
        return failedStatusSynchronization;
    }
    private static final String invalidXmlFileFound = "WFLYDS0035: Scan found %s which is not well-formed at lineNumber: %s, columnNumber: %s. Either the file was incompletely copied at the time of the scanning or it is just wrong.";
    protected String invalidXmlFileFound$str() {
        return invalidXmlFileFound;
    }
    @Override
    public final String invalidXmlFileFound(final String name, final int lineNumber, final int columnNumber) {
        return String.format(getLoggingLocale(), invalidXmlFileFound$str(), name, lineNumber, columnNumber);
    }
    private static final String deployModelOperationFailed = "WFLYDS0036: Deployment model operation failed. %s";
    protected String deployModelOperationFailed$str() {
        return deployModelOperationFailed;
    }
    @Override
    public final RuntimeException deployModelOperationFailed(final String msg) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), deployModelOperationFailed$str(), msg));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void directoryIsNonexistent(final String path) {
        super.log.logf(FQCN, WARN, null, directoryIsNonexistent$str(), path);
    }
    private static final String directoryIsNonexistent = "WFLYDS0037: %s does not exist";
    protected String directoryIsNonexistent$str() {
        return directoryIsNonexistent;
    }
    @Override
    public final void isNotADirectory(final String path) {
        super.log.logf(FQCN, WARN, null, isNotADirectory$str(), path);
    }
    private static final String isNotADirectory = "WFLYDS0038: %s is not a directory";
    protected String isNotADirectory$str() {
        return isNotADirectory;
    }
    @Override
    public final void directoryIsNotWritable(final String path) {
        super.log.logf(FQCN, WARN, null, directoryIsNotWritable$str(), path);
    }
    private static final String directoryIsNotWritable = "WFLYDS0039: %s is not writable";
    protected String directoryIsNotWritable$str() {
        return directoryIsNotWritable;
    }
    private static final String pathEntryNotFound = "WFLYDS0040: Could not find relative-to path entry for %s";
    protected String pathEntryNotFound$str() {
        return pathEntryNotFound;
    }
    @Override
    public final OperationFailedException pathEntryNotFound(final String pathName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), pathEntryNotFound$str(), pathName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void directoryIsNotReadable(final String path) {
        super.log.logf(FQCN, WARN, null, directoryIsNotReadable$str(), path);
    }
    private static final String directoryIsNotReadable = "WFLYDS0041: %s is not readable";
    protected String directoryIsNotReadable$str() {
        return directoryIsNotReadable;
    }
    @Override
    public final void bootTimeScanFailed(final String dir) {
        super.log.logf(FQCN, ERROR, null, bootTimeScanFailed$str(), dir);
    }
    private static final String bootTimeScanFailed = "WFLYDS0042: Boot-time scan failed due to inaccessible deployment directory: %s";
    protected String bootTimeScanFailed$str() {
        return bootTimeScanFailed;
    }
    @Override
    public final void scanFailed(final String dir) {
        super.log.logf(FQCN, WARN, null, scanFailed$str(), dir);
    }
    private static final String scanFailed = "WFLYDS0043: Deployment directory scan failed due to inaccessible deployment directory: %s";
    protected String scanFailed$str() {
        return scanFailed;
    }
}
