package org.jboss.hal.client.configuration.subsystem.ejb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_EjbView extends EjbView {

    private final org.jboss.hal.config.Environment environment;
    private final Metadata metadata45;
    private final Metadata metadata42;
    private final Metadata metadata40;
    private final Metadata metadata44;
    private final Metadata metadata43;
    private final Metadata metadata37;
    private final Metadata metadata41;
    private final Metadata metadata35;
    private final Metadata metadata39;
    private final Metadata metadata34;
    private final Metadata metadata38;
    private final Metadata metadata36;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_EjbView(MbuiContext mbuiContext, org.jboss.hal.config.Environment environment) {
        super(mbuiContext);

        this.environment = environment;
        AddressTemplate metadata45Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/mdb-delivery-group=*");
        this.metadata45 = mbuiContext.metadataRegistry().lookup(metadata45Template);
        AddressTemplate metadata42Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=iiop");
        this.metadata42 = mbuiContext.metadataRegistry().lookup(metadata42Template);
        AddressTemplate metadata40Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=async");
        this.metadata40 = mbuiContext.metadataRegistry().lookup(metadata40Template);
        AddressTemplate metadata44Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service");
        this.metadata44 = mbuiContext.metadataRegistry().lookup(metadata44Template);
        AddressTemplate metadata43Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=remote");
        this.metadata43 = mbuiContext.metadataRegistry().lookup(metadata43Template);
        AddressTemplate metadata37Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/strict-max-bean-instance-pool=*");
        this.metadata37 = mbuiContext.metadataRegistry().lookup(metadata37Template);
        AddressTemplate metadata41Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=identity");
        this.metadata41 = mbuiContext.metadataRegistry().lookup(metadata41Template);
        AddressTemplate metadata35Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*");
        this.metadata35 = mbuiContext.metadataRegistry().lookup(metadata35Template);
        AddressTemplate metadata39Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/passivation-store=*");
        this.metadata39 = mbuiContext.metadataRegistry().lookup(metadata39Template);
        AddressTemplate metadata34Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3");
        this.metadata34 = mbuiContext.metadataRegistry().lookup(metadata34Template);
        AddressTemplate metadata38Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/cache=*");
        this.metadata38 = mbuiContext.metadataRegistry().lookup(metadata38Template);
        AddressTemplate metadata36Template = AddressTemplate.of("/{selected.profile}/subsystem=ejb3/remoting-profile=*");
        this.metadata36 = mbuiContext.metadataRegistry().lookup(metadata36Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-configuration-form", metadata34)
            .onSave((form, changedValues) -> saveSingletonForm("Container", metadata34Template.resolve(mbuiContext.statementContext()), changedValues, metadata34))
            .prepareReset(form -> resetSingletonForm("Container", metadata34Template.resolve(mbuiContext.statementContext()), form, metadata34))
            .build();
        threadPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-thread-pool-form", metadata35)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Thread Pool", name, metadata35Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata35);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Thread Pool", name, metadata35Template.resolve(mbuiContext.statementContext(), name), form, metadata35);
            })
            .build();
        remotingProfileForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-remoting-profile-form", metadata36)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Remoting Profile", name, metadata36Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata36);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Remoting Profile", name, metadata36Template.resolve(mbuiContext.statementContext(), name), form, metadata36);
            })
            .build();
        beanPoolForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-bean-pool-form", metadata37)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Bean Pool", name, metadata37Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata37);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Bean Pool", name, metadata37Template.resolve(mbuiContext.statementContext(), name), form, metadata37);
            })
            .build();
        cacheForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-cache-form", metadata38)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Cache", name, metadata38Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata38);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Cache", name, metadata38Template.resolve(mbuiContext.statementContext(), name), form, metadata38);
            })
            .build();
        passivationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-passivation-form", metadata39)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Passivation", name, metadata39Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata39);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Passivation", name, metadata39Template.resolve(mbuiContext.statementContext(), name), form, metadata39);
            })
            .build();
        serviceAsyncForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-async-form", metadata40)
            .include("thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Async", metadata40Template.resolve(mbuiContext.statementContext()), changedValues, metadata40))
            .prepareReset(form -> resetSingletonForm("Async", metadata40Template.resolve(mbuiContext.statementContext()), form, metadata40))
            .build();
        serviceAsyncForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceIdentityForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-identity-form", metadata41)
            .singleton(
                () -> new Operation.Builder(metadata41Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("ejb3-service-identity-form", "Identity", metadata41Template))
            .prepareRemove(form -> removeSingletonForm("Identity", metadata41Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Identity", metadata41Template.resolve(mbuiContext.statementContext()), changedValues, metadata41))
            .prepareReset(form -> resetSingletonForm("Identity", metadata41Template.resolve(mbuiContext.statementContext()), form, metadata41))
            .build();
        serviceIiopForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-iiop-form", metadata42)
            .singleton(
                () -> new Operation.Builder(metadata42Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("ejb3-service-iiop-form", "IIOP", metadata42Template))
            .prepareRemove(form -> removeSingletonForm("IIOP", metadata42Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("IIOP", metadata42Template.resolve(mbuiContext.statementContext()), changedValues, metadata42))
            .prepareReset(form -> resetSingletonForm("IIOP", metadata42Template.resolve(mbuiContext.statementContext()), form, metadata42))
            .build();
        serviceRemoteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-remote-form", metadata43)
            .include("cluster", "connector-ref", "thread-pool-name", "execute-in-worker")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Remote", metadata43Template.resolve(mbuiContext.statementContext()), changedValues, metadata43))
            .prepareReset(form -> resetSingletonForm("Remote", metadata43Template.resolve(mbuiContext.statementContext()), form, metadata43))
            .build();
        serviceRemoteForm.getFormItem("cluster").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
        serviceRemoteForm.getFormItem("connector-ref").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=remoting/http-connector=*")));
        serviceRemoteForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        serviceTimerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("ejb3-service-timer-form", metadata44)
            .include("default-data-store", "thread-pool-name")
            .unsorted()
            .onSave((form, changedValues) -> saveSingletonForm("Timer", metadata44Template.resolve(mbuiContext.statementContext()), changedValues, metadata44))
            .prepareReset(form -> resetSingletonForm("Timer", metadata44Template.resolve(mbuiContext.statementContext()), form, metadata44))
            .build();
        List<AddressTemplate> serviceTimerFormTemplates = asList(
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/database-data-store=*"), 
            AddressTemplate.of("/{selected.profile}/subsystem=ejb3/service=timer-service/file-data-store=*"));
        serviceTimerForm.getFormItem("default-data-store").registerSuggestHandler(new ReadChildrenAutoComplete(
                    mbuiContext.dispatcher(), mbuiContext.statementContext(), serviceTimerFormTemplates));
        serviceTimerForm.getFormItem("thread-pool-name").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=ejb3/thread-pool=*")));
        mdbDeliveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-mdb-delivery-group-form", metadata45)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("MDB Delivery Group", name, metadata45Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata45);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("MDB Delivery Group", name, metadata45Template.resolve(mbuiContext.statementContext(), name), form, metadata45);
            })
            .build();

        threadPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-thread-pool-table", metadata35)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-thread-pool-table", Ids.ADD), "Thread Pool",
                metadata35Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Thread Pool", metadata35Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        remotingProfileTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-remoting-profile-table", metadata36)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-remoting-profile-table", Ids.ADD), "Remoting Profile",
                metadata36Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Remoting Profile", metadata36Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        beanPoolTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-bean-pool-table", metadata37)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-bean-pool-table", Ids.ADD), "Bean Pool",
                metadata37Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Bean Pool", metadata37Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        cacheTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-cache-table", metadata38)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-cache-table", Ids.ADD), "Cache",
                metadata38Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Cache", metadata38Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        passivationTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-passivation-table", metadata39)
            .button(mbuiContext.tableButtonFactory().add(metadata39Template, table -> {
                AddResourceDialog dialog = new AddResourceDialog(
                    Ids.build("ejb3-passivation-table", Ids.ADD),
                    mbuiContext.resources().messages().addResourceTitle("Passivation"),
                    metadata39,
                    asList("bean-cache", "cache-container", "max-size"),
                    (name, modelNode) -> {
                        ResourceAddress address = metadata39Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Passivation", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.getForm().getFormItem("cache-container").registerSuggestHandler(new ReadChildrenAutoComplete(
                                            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=infinispan/cache-container=*")));
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Passivation", metadata39Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        mdbDeliveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("ejb3-mdb-delivery-group-table", metadata45)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("ejb3-mdb-delivery-group-table", Ids.ADD), "MDB Delivery Group",
                metadata45Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("MDB Delivery Group", metadata45Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("ejb3-container-item", "Container", "fa fa-cogs");
        HTMLElement html106;
        HTMLElement ejb3ConfigurationItemElement = section()
            .add(html106 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Container</h1><p>${metadata34.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html106", html106);
        navigation.addSecondary("ejb3-container-item", "ejb3-configuration-item", "Container", ejb3ConfigurationItemElement);
        HTMLElement html108;
        HTMLElement ejb3ThreadPoolItemElement = section()
            .add(html108 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Thread Pool</h1><p>${metadata35.getDescription().getDescription()}</p>"))
                .asElement())
            .add(threadPoolTable)
            .add(threadPoolForm)
            .asElement();
        expressionElements.put("html108", html108);
        navigation.addSecondary("ejb3-container-item", "ejb3-thread-pool-item", "Thread Pool", ejb3ThreadPoolItemElement);
        HTMLElement html111;
        HTMLElement ejb3RemotingProfileItemElement = section()
            .add(html111 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remoting Profile</h1><p>${metadata36.getDescription().getDescription()}</p>"))
                .asElement())
            .add(remotingProfileTable)
            .add(remotingProfileForm)
            .asElement();
        expressionElements.put("html111", html111);
        navigation.addSecondary("ejb3-container-item", "ejb3-remoting-profile-item", "Remoting Profile", ejb3RemotingProfileItemElement);
        HTMLElement html114;
        HTMLElement ejb3BeanPoolItemElement = section()
            .add(html114 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Bean Pool</h1><p>${metadata37.getDescription().getDescription()}</p>"))
                .asElement())
            .add(beanPoolTable)
            .add(beanPoolForm)
            .asElement();
        expressionElements.put("html114", html114);
        navigation.addPrimary("ejb3-bean-pool-item", "Bean Pool", "pficon pficon-repository", ejb3BeanPoolItemElement);
        navigation.addPrimary("ejb3-state-item", "State Management", "fa fa-list-ul");
        HTMLElement html117;
        HTMLElement ejb3CacheItemElement = section()
            .add(html117 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cache</h1><p>${metadata38.getDescription().getDescription()}</p>"))
                .asElement())
            .add(cacheTable)
            .add(cacheForm)
            .asElement();
        expressionElements.put("html117", html117);
        navigation.addSecondary("ejb3-state-item", "ejb3-cache-item", "Cache", ejb3CacheItemElement);
        HTMLElement html120;
        HTMLElement ejb3PassivationItemElement = section()
            .add(html120 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Passivation</h1><p>${metadata39.getDescription().getDescription()}</p>"))
                .asElement())
            .add(passivationTable)
            .add(passivationForm)
            .asElement();
        expressionElements.put("html120", html120);
        navigation.addSecondary("ejb3-state-item", "ejb3-passivation-item", "Passivation", ejb3PassivationItemElement);
        navigation.addPrimary("ejb3-service-item", "Services", "pficon pficon-service");
        HTMLElement html123;
        HTMLElement ejb3ServiceAsyncItemElement = section()
            .add(html123 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Async</h1><p>${metadata40.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceAsyncForm)
            .asElement();
        expressionElements.put("html123", html123);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-async-item", "Async", ejb3ServiceAsyncItemElement);
        HTMLElement html125;
        HTMLElement ejb3ServiceIdentityItemElement = section()
            .add(html125 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Identity</h1><p>${metadata41.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceIdentityForm)
            .asElement();
        expressionElements.put("html125", html125);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-identity-item", "Identity", ejb3ServiceIdentityItemElement);
        HTMLElement html127;
        HTMLElement ejb3ServiceIiopItemElement = section()
            .add(html127 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>IIOP</h1><p>${metadata42.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceIiopForm)
            .asElement();
        expressionElements.put("html127", html127);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-iiop-item", "IIOP", ejb3ServiceIiopItemElement);
        HTMLElement html129;
        HTMLElement ejb3ServiceRemoteItemElement = section()
            .add(html129 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote</h1><p>${metadata43.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceRemoteForm)
            .asElement();
        expressionElements.put("html129", html129);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-remote-item", "Remote", ejb3ServiceRemoteItemElement);
        HTMLElement html131;
        HTMLElement ejb3ServiceTimerItemElement = section()
            .add(html131 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Timer</h1><p>${metadata44.getDescription().getDescription()}</p>"))
                .asElement())
            .add(serviceTimerForm)
            .asElement();
        expressionElements.put("html131", html131);
        navigation.addSecondary("ejb3-service-item", "ejb3-service-timer-item", "Timer", ejb3ServiceTimerItemElement);
        HTMLElement html133;
        HTMLElement ejb3MdbDeliveryGroupItemElement = section()
            .add(html133 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>MDB Delivery Group</h1><p>${metadata45.getDescription().getDescription()}</p>"))
                .asElement())
            .add(mdbDeliveryGroupTable)
            .add(mdbDeliveryGroupForm)
            .asElement();
        expressionElements.put("html133", html133);
        navigation.addPrimary("ejb3-mdb-delivery-group-item", "MDB Delivery", "fa fa-inbox", ejb3MdbDeliveryGroupItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(threadPoolTable);
        registerAttachable(threadPoolForm);
        registerAttachable(remotingProfileTable);
        registerAttachable(remotingProfileForm);
        registerAttachable(beanPoolTable);
        registerAttachable(beanPoolForm);
        registerAttachable(cacheTable);
        registerAttachable(cacheForm);
        registerAttachable(passivationTable);
        registerAttachable(passivationForm);
        registerAttachable(serviceAsyncForm);
        registerAttachable(serviceIdentityForm);
        registerAttachable(serviceIiopForm);
        registerAttachable(serviceRemoteForm);
        registerAttachable(serviceTimerForm);
        registerAttachable(mdbDeliveryGroupTable);
        registerAttachable(mdbDeliveryGroupForm);

        initElement(root);

        init();
    }

    @Override
    org.jboss.hal.config.Environment environment() {
    return environment;
    }

    @Override
    public void attach() {
        super.attach();

            threadPoolTable.bindForm(threadPoolForm);
            remotingProfileTable.bindForm(remotingProfileForm);
            beanPoolTable.bindForm(beanPoolForm);
            cacheTable.bindForm(cacheForm);
            passivationTable.bindForm(passivationForm);
            mdbDeliveryGroupTable.bindForm(mdbDeliveryGroupForm);

        TemplateUtil.replaceExpression(expressionElements.get("html106"), "${metadata34.getDescription().getDescription()}", String.valueOf(metadata34.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html108"), "${metadata35.getDescription().getDescription()}", String.valueOf(metadata35.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html111"), "${metadata36.getDescription().getDescription()}", String.valueOf(metadata36.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html114"), "${metadata37.getDescription().getDescription()}", String.valueOf(metadata37.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html117"), "${metadata38.getDescription().getDescription()}", String.valueOf(metadata38.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html120"), "${metadata39.getDescription().getDescription()}", String.valueOf(metadata39.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html123"), "${metadata40.getDescription().getDescription()}", String.valueOf(metadata40.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html125"), "${metadata41.getDescription().getDescription()}", String.valueOf(metadata41.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html127"), "${metadata42.getDescription().getDescription()}", String.valueOf(metadata42.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html129"), "${metadata43.getDescription().getDescription()}", String.valueOf(metadata43.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html131"), "${metadata44.getDescription().getDescription()}", String.valueOf(metadata44.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html133"), "${metadata45.getDescription().getDescription()}", String.valueOf(metadata45.getDescription().getDescription()));
    }
}
