package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ClusteringView extends ClusteringView {

    private final Metadata metadata47;
    private final Metadata metadata49;
    private final Metadata metadata50;
    private final Metadata metadata48;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ClusteringView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata47Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*");
        this.metadata47 = mbuiContext.metadataRegistry().lookup(metadata47Template);
        AddressTemplate metadata49Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*");
        this.metadata49 = mbuiContext.metadataRegistry().lookup(metadata49Template);
        AddressTemplate metadata50Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*");
        this.metadata50 = mbuiContext.metadataRegistry().lookup(metadata50Template);
        AddressTemplate metadata48Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*");
        this.metadata48 = mbuiContext.metadataRegistry().lookup(metadata48Template);
        this.expressionElements = new HashMap<>();

        broadcastGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-broadcast-group-form", metadata47)
            .include("broadcast-period", "connectors", "jgroups-cluster", "jgroups-channel", "jgroups-stack", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.BROADCAST_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.BROADCAST_GROUP, form))
            .build();
        broadcastGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        discoveryGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-discovery-group-form", metadata48)
            .include("initial-wait-timeout", "refresh-timeout", "jgroups-cluster", "jgroups-channel", "jgroups-stack", "socket-binding")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.DISCOVERY_GROUP, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.DISCOVERY_GROUP, form))
            .build();
        discoveryGroupForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        clusterConnectionForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-form", metadata49)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CLUSTER_CONNECTION, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CLUSTER_CONNECTION, form))
            .build();
        groupingHandlerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-form", metadata50)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.GROUPING_HANDLER, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.GROUPING_HANDLER, form))
            .build();

        broadcastGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-broadcast-group-table", metadata47)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.BROADCAST_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.BROADCAST_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/broadcast-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        discoveryGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-discovery-group-table", metadata48)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.DISCOVERY_GROUP), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.DISCOVERY_GROUP, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/discovery-group=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        clusterConnectionTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-cluster-connection-table", metadata49)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addClusterConnection(ServerSubResource.CLUSTER_CONNECTION), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CLUSTER_CONNECTION, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/cluster-connection=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        groupingHandlerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-grouping-handler-table", metadata50)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.GROUPING_HANDLER), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.GROUPING_HANDLER, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/grouping-handler=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html139;
        HTMLElement messagingBroadcastGroupItemElement = section()
            .add(html139 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Broadcast Group</h1><p>${metadata47.getDescription().getDescription()}</p>"))
                .asElement())
            .add(broadcastGroupTable)
            .add(broadcastGroupForm)
            .asElement();
        expressionElements.put("html139", html139);
        navigation.addPrimary("messaging-broadcast-group-item", "Broadcast Group", "fa fa-video-camera", messagingBroadcastGroupItemElement);
        HTMLElement html142;
        HTMLElement messagingDiscoveryGroupItemElement = section()
            .add(html142 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Discovery Group</h1><p>${metadata48.getDescription().getDescription()}</p>"))
                .asElement())
            .add(discoveryGroupTable)
            .add(discoveryGroupForm)
            .asElement();
        expressionElements.put("html142", html142);
        navigation.addPrimary("messaging-discovery-group-item", "Discovery Group", "fa fa-map-o", messagingDiscoveryGroupItemElement);
        HTMLElement html145;
        HTMLElement messagingClusterConnectionItemElement = section()
            .add(html145 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Cluster Connection</h1><p>${metadata49.getDescription().getDescription()}</p>"))
                .asElement())
            .add(clusterConnectionTable)
            .add(clusterConnectionForm)
            .asElement();
        expressionElements.put("html145", html145);
        navigation.addPrimary("messaging-cluster-connection-item", "Cluster Connection", "pficon pficon-network", messagingClusterConnectionItemElement);
        HTMLElement html148;
        HTMLElement messagingGroupingHandlerItemElement = section()
            .add(html148 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Grouping Handler</h1><p>${metadata50.getDescription().getDescription()}</p>"))
                .asElement())
            .add(groupingHandlerTable)
            .add(groupingHandlerForm)
            .asElement();
        expressionElements.put("html148", html148);
        navigation.addPrimary("messaging-grouping-handler-item", "Grouping Handler", "fa fa-object-group", messagingGroupingHandlerItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(broadcastGroupTable);
        registerAttachable(broadcastGroupForm);
        registerAttachable(discoveryGroupTable);
        registerAttachable(discoveryGroupForm);
        registerAttachable(clusterConnectionTable);
        registerAttachable(clusterConnectionForm);
        registerAttachable(groupingHandlerTable);
        registerAttachable(groupingHandlerForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            broadcastGroupTable.bindForm(broadcastGroupForm);
            discoveryGroupTable.bindForm(discoveryGroupForm);
            clusterConnectionTable.bindForm(clusterConnectionForm);
            groupingHandlerTable.bindForm(groupingHandlerForm);

        TemplateUtil.replaceExpression(expressionElements.get("html139"), "${metadata47.getDescription().getDescription()}", String.valueOf(metadata47.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html142"), "${metadata48.getDescription().getDescription()}", String.valueOf(metadata48.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html145"), "${metadata49.getDescription().getDescription()}", String.valueOf(metadata49.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html148"), "${metadata50.getDescription().getDescription()}", String.valueOf(metadata50.getDescription().getDescription()));
    }
}
