package org.jboss.hal.client.configuration.subsystem.microprofile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_MicroProfileConfigView extends MicroProfileConfigView {

    private final Metadata metadata16;
    private final Metadata metadata15;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_MicroProfileConfigView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata16Template = AddressTemplate.of("/{selected.profile}/subsystem=microprofile-config-smallrye/config-source-provider=*");
        this.metadata16 = mbuiContext.metadataRegistry().lookup(metadata16Template);
        AddressTemplate metadata15Template = AddressTemplate.of("/{selected.profile}/subsystem=microprofile-config-smallrye/config-source=*");
        this.metadata15 = mbuiContext.metadataRegistry().lookup(metadata15Template);
        this.expressionElements = new HashMap<>();

        configSourceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-form", metadata15)
            .customFormItem("class", attributeDescription -> new ClassFormItem())
            .include("dir")
            .include("properties")
            .include("ordinal")
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Config Source", name, metadata15Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata15);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Config Source", name, metadata15Template.resolve(mbuiContext.statementContext(), name), form, metadata15);
            })
            .build();
        configSourceProviderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-provider-form", metadata16)
            .customFormItem("class", attributeDescription -> new ClassFormItem())
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Config Source Provider", name, metadata16Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata16);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Config Source Provider", name, metadata16Template.resolve(mbuiContext.statementContext(), name), form, metadata16);
            })
            .build();

        configSourceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-table", metadata15)
            .button(mbuiContext.tableButtonFactory().add(metadata15Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("microprofile-config-source-table", Ids.ADD),
                    metadata15)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("class", attributeDescription -> new ClassFormItem())
                    .include("dir")
                    .include("properties")
                    .include("ordinal")
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Config Source"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata15Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Config Source", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Config Source", metadata15Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("ordinal")
            .build();
        configSourceProviderTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("microprofile-config-source-provider-table", metadata16)
            .button(mbuiContext.tableButtonFactory().add(metadata16Template, table -> {
                ModelNodeForm form = new ModelNodeForm.Builder(Ids.build("microprofile-config-source-provider-table", Ids.ADD),
                    metadata16)
                    .fromRequestProperties()
                    .unboundFormItem(new org.jboss.hal.core.mbui.dialog.NameItem(), 0)
                    .customFormItem("class", attributeDescription -> new ClassFormItem())
                    .unsorted()
                    .build();
                AddResourceDialog dialog = new AddResourceDialog(
                    mbuiContext.resources().messages().addResourceTitle("Config Provider"),
                    form,
                    (name, modelNode) -> {
                        ResourceAddress address = metadata16Template.resolve(mbuiContext.statementContext(), name);
                        mbuiContext.crud().add("Config Provider", name, address, modelNode, (n, a) -> presenter.reload());
                    });
                dialog.show();
            }))
            .button(mbuiContext.tableButtonFactory().remove("Config Provider", metadata16Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html47;
        HTMLElement microprofileConfigSourceItemElement = section()
            .add(html47 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Config Sources</h1><p>${metadata15.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configSourceTable)
            .add(configSourceForm)
            .asElement();
        expressionElements.put("html47", html47);
        navigation.addPrimary("microprofile-config-source-item", "Config Sources", "fa fa-cogs", microprofileConfigSourceItemElement);
        HTMLElement html50;
        HTMLElement microprofileConfigSourceProviderItemElement = section()
            .add(html50 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Config Providers</h1><p>${metadata16.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configSourceProviderTable)
            .add(configSourceProviderForm)
            .asElement();
        expressionElements.put("html50", html50);
        navigation.addPrimary("microprofile-config-source-provider-item", "Config Providers", "pficon pficon-services", microprofileConfigSourceProviderItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configSourceTable);
        registerAttachable(configSourceForm);
        registerAttachable(configSourceProviderTable);
        registerAttachable(configSourceProviderForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            configSourceTable.bindForm(configSourceForm);
            configSourceProviderTable.bindForm(configSourceProviderForm);

        TemplateUtil.replaceExpression(expressionElements.get("html47"), "${metadata15.getDescription().getDescription()}", String.valueOf(metadata15.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html50"), "${metadata16.getDescription().getDescription()}", String.valueOf(metadata16.getDescription().getDescription()));
    }
}
