package org.jboss.hal.client.runtime.host;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_HostView extends HostView {

    private final Metadata metadata56;
    private final Metadata metadata60;
    private final Metadata metadata58;
    private final Metadata metadata59;
    private final Metadata metadata57;
    private final Metadata metadata61;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_HostView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata56Template = AddressTemplate.of("/{selected.host}");
        this.metadata56 = mbuiContext.metadataRegistry().lookup(metadata56Template);
        AddressTemplate metadata60Template = AddressTemplate.of("/{selected.host}/socket-binding-group=*");
        this.metadata60 = mbuiContext.metadataRegistry().lookup(metadata60Template);
        AddressTemplate metadata58Template = AddressTemplate.of("/{selected.host}/jvm=*");
        this.metadata58 = mbuiContext.metadataRegistry().lookup(metadata58Template);
        AddressTemplate metadata59Template = AddressTemplate.of("/{selected.host}/path=*");
        this.metadata59 = mbuiContext.metadataRegistry().lookup(metadata59Template);
        AddressTemplate metadata57Template = AddressTemplate.of("/{selected.host}/interface=*");
        this.metadata57 = mbuiContext.metadataRegistry().lookup(metadata57Template);
        AddressTemplate metadata61Template = AddressTemplate.of("/{selected.host}/system-property=*");
        this.metadata61 = mbuiContext.metadataRegistry().lookup(metadata61Template);
        this.expressionElements = new HashMap<>();

        hostConfigurationForm = new ModelNodeForm.Builder<org.jboss.hal.core.runtime.host.Host>("host-configuration-form", metadata56)
            .includeRuntime()
            .include("name", "organization", "directory-grouping", "uuid", "release-codename", "release-version", "product-name", "product-version", "management-major-version", "management-minor-version", "management-micro-version", "running-mode", "host-state", "suspend-state")
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveHost(form, changedValues))
            .prepareReset(form -> resetSingletonForm("Host Configuration", metadata56Template.resolve(mbuiContext.statementContext()), form, metadata56))
            .build();
        hostInterfaceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-form", metadata57)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Interface", name, metadata57Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata57);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Interface", name, metadata57Template.resolve(mbuiContext.statementContext(), name), form, metadata57);
            })
            .build();
        hostJvmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-form", metadata58)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("JVM", name, metadata58Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata58);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("JVM", name, metadata58Template.resolve(mbuiContext.statementContext(), name), form, metadata58);
            })
            .build();
        hostPathForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-path-form", metadata59)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Path", name, metadata59Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata59);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Path", name, metadata59Template.resolve(mbuiContext.statementContext(), name), form, metadata59);
            })
            .build();
        hostSocketBindingGroupForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-form", metadata60)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Socket Binding Group", name, metadata60Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata60);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Socket Binding Group", name, metadata60Template.resolve(mbuiContext.statementContext(), name), form, metadata60);
            })
            .build();
        hostSystemPropertyForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-form", metadata61)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("System Property", name, metadata61Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata61);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("System Property", name, metadata61Template.resolve(mbuiContext.statementContext(), name), form, metadata61);
            })
            .build();

        hostInterfaceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-interface-table", metadata57)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-interface-table", Ids.ADD), "Interface",
                metadata57Template, asList("inet-address"), (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Interface", metadata57Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostJvmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-jvm-table", metadata58)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-jvm-table", Ids.ADD), "JVM",
                metadata58Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("JVM", metadata58Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        hostPathTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-path-table", metadata59)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-path-table", Ids.ADD), "Path",
                metadata59Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Path", metadata59Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name", "path")
            .build();
        hostSocketBindingGroupTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-socket-binding-group-table", metadata60)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-socket-binding-group-table", Ids.ADD), "Socket Binding Group",
                metadata60Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Socket Binding Group", metadata60Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .columns("name")
            .build();
        hostSystemPropertyTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("host-system-property-table", metadata61)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("host-system-property-table", Ids.ADD), "System Property",
                metadata61Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("System Property", metadata61Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("value")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html168;
        HTMLElement hostConfigurationItemElement = section()
            .add(html168 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1 id=\"host-configuration-title\" /><p>${metadata56.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostConfigurationForm)
            .asElement();
        expressionElements.put("html168", html168);
        navigation.addPrimary("host-configuration-item", "Configuration", "pficon pficon-settings", hostConfigurationItemElement);
        HTMLElement html170;
        HTMLElement hostInterfaceItemElement = section()
            .add(html170 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Interfaces</h1><p>${metadata57.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostInterfaceTable)
            .add(hostInterfaceForm)
            .asElement();
        expressionElements.put("html170", html170);
        navigation.addPrimary("host-interface-item", "Interfaces", "fa fa-exchange", hostInterfaceItemElement);
        HTMLElement html173;
        HTMLElement hostJvmItemElement = section()
            .add(html173 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>JVMs</h1><p>${metadata58.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostJvmTable)
            .add(hostJvmForm)
            .asElement();
        expressionElements.put("html173", html173);
        navigation.addPrimary("host-jvm-item", "JVMs", "fa fa-coffee", hostJvmItemElement);
        HTMLElement html176;
        HTMLElement hostPathItemElement = section()
            .add(html176 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Paths</h1><p>${metadata59.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostPathTable)
            .add(hostPathForm)
            .asElement();
        expressionElements.put("html176", html176);
        navigation.addPrimary("host-path-item", "Paths", "fa fa-folder-open", hostPathItemElement);
        HTMLElement html179;
        HTMLElement hostSocketBindingGroupItemElement = section()
            .add(html179 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Socket Binding Groups</h1><p>${metadata60.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostSocketBindingGroupTable)
            .add(hostSocketBindingGroupForm)
            .asElement();
        expressionElements.put("html179", html179);
        navigation.addPrimary("host-socket-binding-group-item", "Socket Binding Groups", "fa fa-object-group", hostSocketBindingGroupItemElement);
        HTMLElement html182;
        HTMLElement hostSystemPropertyItemElement = section()
            .add(html182 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>System Properties</h1><p>${metadata61.getDescription().getDescription()}</p>"))
                .asElement())
            .add(hostSystemPropertyTable)
            .add(hostSystemPropertyForm)
            .asElement();
        expressionElements.put("html182", html182);
        navigation.addPrimary("host-system-property-item", "System Properties", "fa fa-list-ul", hostSystemPropertyItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(hostConfigurationForm);
        registerAttachable(hostInterfaceTable);
        registerAttachable(hostInterfaceForm);
        registerAttachable(hostJvmTable);
        registerAttachable(hostJvmForm);
        registerAttachable(hostPathTable);
        registerAttachable(hostPathForm);
        registerAttachable(hostSocketBindingGroupTable);
        registerAttachable(hostSocketBindingGroupForm);
        registerAttachable(hostSystemPropertyTable);
        registerAttachable(hostSystemPropertyForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            hostInterfaceTable.bindForm(hostInterfaceForm);
            hostJvmTable.bindForm(hostJvmForm);
            hostPathTable.bindForm(hostPathForm);
            hostSocketBindingGroupTable.bindForm(hostSocketBindingGroupForm);
            hostSystemPropertyTable.bindForm(hostSystemPropertyForm);

        TemplateUtil.replaceExpression(expressionElements.get("html168"), "${metadata56.getDescription().getDescription()}", String.valueOf(metadata56.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html170"), "${metadata57.getDescription().getDescription()}", String.valueOf(metadata57.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html173"), "${metadata58.getDescription().getDescription()}", String.valueOf(metadata58.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html176"), "${metadata59.getDescription().getDescription()}", String.valueOf(metadata59.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html179"), "${metadata60.getDescription().getDescription()}", String.valueOf(metadata60.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html182"), "${metadata61.getDescription().getDescription()}", String.valueOf(metadata61.getDescription().getDescription()));
    }
}
