/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl;

import java.util.Map;
import org.apache.activemq.artemis.api.core.ActiveMQClusterSecurityException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQSecurityException;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.protocol.core.Channel;
import org.apache.activemq.artemis.core.protocol.core.ChannelHandler;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.Packet;
import org.apache.activemq.artemis.core.protocol.core.ServerSessionPacketHandler;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreProtocolManager;
import org.apache.activemq.artemis.core.protocol.core.impl.CoreSessionCallback;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ActiveMQExceptionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CheckFailoverMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CheckFailoverReplyMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateQueueMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.CreateSessionResponseMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReattachSessionMessage;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.ReattachSessionResponseMessage;
import org.apache.activemq.artemis.core.security.ActiveMQPrincipal;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerProducerImpl;
import org.apache.activemq.artemis.core.version.Version;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.jboss.logging.Logger;

public class ActiveMQPacketHandler
implements ChannelHandler {
    private static final Logger logger = Logger.getLogger(ActiveMQPacketHandler.class);
    private final ActiveMQServer server;
    private final Channel channel1;
    private final CoreRemotingConnection connection;
    private final CoreProtocolManager protocolManager;

    public ActiveMQPacketHandler(CoreProtocolManager protocolManager, ActiveMQServer server, Channel channel1, CoreRemotingConnection connection) {
        this.protocolManager = protocolManager;
        this.server = server;
        this.channel1 = channel1;
        this.connection = connection;
    }

    public void handlePacket(Packet packet) {
        byte type = packet.getType();
        switch (type) {
            case 30: {
                CreateSessionMessage request = (CreateSessionMessage)packet;
                this.handleCreateSession(request);
                break;
            }
            case -4: {
                CheckFailoverMessage request = (CheckFailoverMessage)packet;
                this.handleCheckForFailover(request);
                break;
            }
            case 32: {
                ReattachSessionMessage request = (ReattachSessionMessage)packet;
                this.handleReattachSession(request);
                break;
            }
            case 34: {
                CreateQueueMessage request = (CreateQueueMessage)packet;
                this.handleCreateQueue(request);
                break;
            }
            default: {
                ActiveMQServerLogger.LOGGER.invalidPacket(packet);
            }
        }
    }

    private void handleCheckForFailover(CheckFailoverMessage failoverMessage) {
        String nodeID = failoverMessage.getNodeID();
        boolean okToFailover = nodeID == null || this.server.getNodeID().toString().equals(nodeID) || !this.server.getHAPolicy().canScaleDown() || this.server.hasScaledDown(new SimpleString(nodeID));
        this.channel1.send((Packet)new CheckFailoverReplyMessage(okToFailover));
    }

    private void handleCreateSession(CreateSessionMessage request) {
        ActiveMQExceptionMessage response;
        boolean incompatibleVersion = false;
        try {
            Version version = this.server.getVersion();
            if (!version.isCompatible(request.getVersion())) {
                throw ActiveMQMessageBundle.BUNDLE.incompatibleClientServer();
            }
            if (!this.server.isStarted()) {
                throw ActiveMQMessageBundle.BUNDLE.serverNotStarted();
            }
            if (this.connection.getChannelVersion() == 0) {
                this.connection.setChannelVersion(request.getVersion());
            } else if (this.connection.getChannelVersion() != request.getVersion()) {
                ActiveMQServerLogger.LOGGER.incompatibleVersionAfterConnect(request.getVersion(), this.connection.getChannelVersion());
            }
            Channel channel = this.connection.getChannel(request.getSessionChannelID(), request.getWindowSize());
            ActiveMQPrincipal activeMQPrincipal = null;
            if (request.getUsername() == null) {
                activeMQPrincipal = this.connection.getDefaultActiveMQPrincipal();
            }
            OperationContext sessionOperationContext = this.server.newOperationContext();
            Map<SimpleString, RoutingType> routingTypeMap = this.protocolManager.getPrefixes();
            CoreSessionCallback sessionCallback = new CoreSessionCallback(request.getName(), this.protocolManager, channel, (RemotingConnection)this.connection);
            ServerSession session = this.server.createSession(request.getName(), activeMQPrincipal == null ? request.getUsername() : activeMQPrincipal.getUserName(), activeMQPrincipal == null ? request.getPassword() : activeMQPrincipal.getPassword(), request.getMinLargeMessageSize(), (RemotingConnection)this.connection, request.isAutoCommitSends(), request.isAutoCommitAcks(), request.isPreAcknowledge(), request.isXA(), request.getDefaultAddress(), sessionCallback, true, sessionOperationContext, routingTypeMap);
            ServerProducerImpl serverProducer = new ServerProducerImpl(session.getName(), "CORE", request.getDefaultAddress());
            session.addProducer(serverProducer);
            ServerSessionPacketHandler handler = new ServerSessionPacketHandler(this.server, this.protocolManager, session, this.server.getStorageManager(), channel);
            channel.setHandler((ChannelHandler)handler);
            sessionCallback.setSessionHandler(handler);
            this.protocolManager.addSessionHandler(request.getName(), handler);
            response = new CreateSessionResponseMessage(this.server.getVersion().getIncrementingVersion());
        }
        catch (ActiveMQClusterSecurityException | ActiveMQSecurityException e) {
            ActiveMQServerLogger.LOGGER.securityProblemWhileCreatingSession(e.getMessage());
            response = new ActiveMQExceptionMessage((ActiveMQException)e);
        }
        catch (ActiveMQException e) {
            if (e.getType() == ActiveMQExceptionType.INCOMPATIBLE_CLIENT_SERVER_VERSIONS) {
                incompatibleVersion = true;
                logger.debug((Object)"Sending ActiveMQException after Incompatible client", (Throwable)e);
            } else {
                ActiveMQServerLogger.LOGGER.failedToCreateSession((Exception)((Object)e));
            }
            response = new ActiveMQExceptionMessage(e);
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToCreateSession(e);
            response = new ActiveMQExceptionMessage((ActiveMQException)new ActiveMQInternalErrorException());
        }
        if (incompatibleVersion) {
            this.channel1.sendAndFlush((Packet)response);
        } else {
            this.channel1.send((Packet)response);
        }
    }

    private void handleReattachSession(ReattachSessionMessage request) {
        ReattachSessionResponseMessage response = null;
        try {
            if (!this.server.isStarted()) {
                response = new ReattachSessionResponseMessage(-1, false);
            }
            logger.debug((Object)("Reattaching request from " + this.connection.getRemoteAddress()));
            ServerSessionPacketHandler sessionHandler = this.protocolManager.getSessionHandler(request.getName());
            if (sessionHandler == null) {
                response = new ReattachSessionResponseMessage(-1, false);
            } else if (sessionHandler.getChannel().getConfirmationWindowSize() == -1) {
                ActiveMQServerLogger.LOGGER.reattachRequestFailed(this.connection.getRemoteAddress());
                sessionHandler.closeListeners();
                sessionHandler.close();
                response = new ReattachSessionResponseMessage(-1, false);
            } else {
                int serverLastConfirmedCommandID = sessionHandler.transferConnection(this.connection, request.getLastConfirmedCommandID());
                response = new ReattachSessionResponseMessage(serverLastConfirmedCommandID, true);
            }
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToReattachSession(e);
            response = new ActiveMQExceptionMessage((ActiveMQException)new ActiveMQInternalErrorException());
        }
        this.channel1.send((Packet)response);
    }

    private void handleCreateQueue(CreateQueueMessage request) {
        try {
            this.server.createQueue(request.getAddress(), null, request.getQueueName(), request.getFilterString(), request.isDurable(), request.isTemporary());
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToHandleCreateQueue(e);
        }
    }
}

