/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.AbstractSequentialList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerImpl;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.message.LargeBodyEncoder;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.SlowConsumerDetectionListener;
import org.apache.activemq.artemis.core.server.impl.ServerSessionImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.collections.LinkedListIterator;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class ServerConsumerImpl
implements ServerConsumer,
ReadyListener {
    private static final Logger logger = Logger.getLogger(ServerConsumerImpl.class);
    private final long id;
    private final long sequentialID;
    protected final Queue messageQueue;
    private final Filter filter;
    private final int minLargeMessageSize;
    private final ServerSession session;
    protected final Object lock = new Object();
    private final boolean supportLargeMessage;
    private Object protocolData;
    private Object protocolContext;
    private final ActiveMQServer server;
    private SlowConsumerDetectionListener slowConsumerListener;
    private final ReadWriteLock lockDelivery = new ReentrantReadWriteLock();
    private volatile AtomicInteger availableCredits = new AtomicInteger(0);
    private boolean started;
    private volatile LargeMessageDeliverer largeMessageDeliverer = null;
    private final boolean browseOnly;
    protected BrowserDeliverer browserDeliverer;
    private final boolean strictUpdateDeliveryCount;
    private final StorageManager storageManager;
    protected final Deque<MessageReference> deliveringRefs = new ConcurrentLinkedDeque<MessageReference>();
    private final SessionCallback callback;
    private boolean preAcknowledge;
    private final ManagementService managementService;
    private final Binding binding;
    private boolean transferring = false;
    private final long creationTime;
    private AtomicLong consumerRateCheckTime = new AtomicLong(System.currentTimeMillis());
    private AtomicLong messageConsumedSnapshot = new AtomicLong(0L);
    private long acks;
    private boolean requiresLegacyPrefix = false;
    private boolean anycast = false;
    private boolean isClosed = false;
    private final Runnable resumeLargeMessageRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ServerConsumerImpl.this.lock;
            synchronized (object) {
                try {
                    if (ServerConsumerImpl.this.largeMessageDeliverer == null || ServerConsumerImpl.this.largeMessageDeliverer.deliver()) {
                        ServerConsumerImpl.this.forceDelivery();
                    }
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorRunningLargeMessageDeliverer(e);
                }
            }
        }
    };

    @Override
    public String debug() {
        return this.toString() + "::Delivering " + this.deliveringRefs.size();
    }

    public ServerConsumerImpl(long id, ServerSession session, QueueBinding binding, Filter filter, boolean started, boolean browseOnly, StorageManager storageManager, SessionCallback callback, boolean preAcknowledge, boolean strictUpdateDeliveryCount, ManagementService managementService, ActiveMQServer server) throws Exception {
        this(id, session, binding, filter, started, browseOnly, storageManager, callback, preAcknowledge, strictUpdateDeliveryCount, managementService, true, null, server);
    }

    public ServerConsumerImpl(long id, ServerSession session, QueueBinding binding, Filter filter, boolean started, boolean browseOnly, StorageManager storageManager, SessionCallback callback, boolean preAcknowledge, boolean strictUpdateDeliveryCount, ManagementService managementService, boolean supportLargeMessage, Integer credits, ActiveMQServer server) throws Exception {
        this.id = id;
        this.sequentialID = server.getStorageManager().generateID();
        this.filter = filter;
        this.session = session;
        this.binding = binding;
        this.messageQueue = binding.getQueue();
        this.started = browseOnly || started;
        this.browseOnly = browseOnly;
        this.storageManager = storageManager;
        this.callback = callback;
        this.preAcknowledge = preAcknowledge;
        this.managementService = managementService;
        this.minLargeMessageSize = session.getMinLargeMessageSize();
        this.strictUpdateDeliveryCount = strictUpdateDeliveryCount;
        this.creationTime = System.currentTimeMillis();
        if (browseOnly) {
            this.browserDeliverer = new BrowserDeliverer(this.messageQueue.browserIterator());
        } else {
            this.messageQueue.addConsumer(this);
        }
        this.supportLargeMessage = supportLargeMessage;
        if (credits != null) {
            if (credits == -1) {
                this.availableCredits = null;
            } else {
                this.availableCredits.set(credits);
            }
        }
        this.server = server;
        if (session.getRemotingConnection() instanceof CoreRemotingConnection) {
            CoreRemotingConnection coreRemotingConnection = (CoreRemotingConnection)session.getRemotingConnection();
            if (session.getMetaData("jms-session") != null && coreRemotingConnection.getChannelVersion() < 129) {
                this.requiresLegacyPrefix = true;
                if (this.getQueue().getRoutingType().equals((Object)RoutingType.ANYCAST)) {
                    this.anycast = true;
                }
            }
        }
    }

    public void readyForWriting() {
        this.promptDelivery();
    }

    @Override
    public long sequentialID() {
        return this.sequentialID;
    }

    @Override
    public Object getProtocolData() {
        return this.protocolData;
    }

    @Override
    public void setProtocolData(Object protocolData) {
        this.protocolData = protocolData;
    }

    @Override
    public void setlowConsumerDetection(SlowConsumerDetectionListener listener) {
        this.slowConsumerListener = listener;
    }

    @Override
    public SlowConsumerDetectionListener getSlowConsumerDetecion() {
        return this.slowConsumerListener;
    }

    @Override
    public void fireSlowConsumer() {
        if (this.slowConsumerListener != null) {
            this.slowConsumerListener.onSlowConsumer(this);
        }
    }

    @Override
    public Object getProtocolContext() {
        return this.protocolContext;
    }

    @Override
    public void setProtocolContext(Object protocolContext) {
        this.protocolContext = protocolContext;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public boolean isBrowseOnly() {
        return this.browseOnly;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getConnectionID() {
        return this.session.getConnectionID().toString();
    }

    @Override
    public String getSessionID() {
        return this.session.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getDeliveringMessages() {
        LinkedList<MessageReference> refs = new LinkedList<MessageReference>();
        Object object = this.lock;
        synchronized (object) {
            List<MessageReference> refsOnConsumer = this.session.getInTXMessagesForConsumer(this.id);
            if (refsOnConsumer != null) {
                refs.addAll(refsOnConsumer);
            }
            refs.addAll(this.deliveringRefs);
        }
        return refs;
    }

    @Override
    public boolean supportsDirectDelivery() {
        return this.callback.supportsDirectDelivery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleStatus handle(MessageReference ref) throws Exception {
        AtomicInteger checkInteger = this.availableCredits;
        if (this.callback != null && !this.callback.hasCredits(this) || checkInteger != null && checkInteger.get() <= 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + " is busy for the lack of credits. Current credits = " + this.availableCredits + " Can't receive reference " + ref));
            }
            return HandleStatus.BUSY;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.callback.isWritable(this, this.protocolContext) || !this.started || this.transferring) {
                return HandleStatus.BUSY;
            }
            if (this.largeMessageDeliverer != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(this + " is busy delivering large message " + this.largeMessageDeliverer + ", can't deliver reference " + ref));
                }
                return HandleStatus.BUSY;
            }
            Message message = ref.getMessage();
            if (!message.acceptsConsumer(this.sequentialID())) {
                return HandleStatus.NO_MATCH;
            }
            if (this.filter != null && !this.filter.match(message)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Reference " + ref + " is a noMatch on consumer " + this));
                }
                return HandleStatus.NO_MATCH;
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ServerConsumerImpl::" + this + " Handling reference " + ref));
            }
            if (!this.browseOnly) {
                if (!this.preAcknowledge) {
                    this.deliveringRefs.add(ref);
                }
                ref.handled();
                ref.setConsumerId(this.id);
                ref.incrementDeliveryCount();
                if (this.strictUpdateDeliveryCount && !ref.isPaged() && ref.getMessage().isDurable() && ref.getQueue().isDurableMessage() && !ref.getQueue().isInternalQueue() && !ref.isPaged()) {
                    this.storageManager.updateDeliveryCount(ref);
                }
                if (this.preAcknowledge) {
                    if (message.isLargeMessage()) {
                        ((LargeServerMessage)message).incrementDelayDeletionCount();
                    }
                    ref.getQueue().acknowledge(ref, this);
                    ++this.acks;
                }
                if (message.isLargeMessage() && this.supportLargeMessage) {
                    this.largeMessageDeliverer = new LargeMessageDeliverer((LargeServerMessage)message, ref);
                }
            }
            this.lockDelivery.readLock().lock();
            return HandleStatus.HANDLED;
        }
    }

    @Override
    public void proceedDeliver(MessageReference reference) throws Exception {
        try {
            Message message = reference.getMessage();
            if (this.server.hasBrokerPlugins()) {
                this.server.callBrokerPlugins(plugin -> plugin.beforeDeliver(this, reference));
            }
            if (message.isLargeMessage() && this.supportLargeMessage) {
                if (this.largeMessageDeliverer == null) {
                    this.largeMessageDeliverer = new LargeMessageDeliverer((LargeServerMessage)message, reference);
                }
                this.largeMessageDeliverer.deliver();
            } else {
                this.deliverStandardMessage(reference, message);
            }
        }
        finally {
            this.lockDelivery.readLock().unlock();
            this.callback.afterDelivery();
            if (this.server.hasBrokerPlugins()) {
                this.server.callBrokerPlugins(plugin -> plugin.afterDeliver(this, reference));
            }
        }
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public synchronized void close(boolean failed) throws Exception {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("ServerConsumerImpl::" + this + " being closed with failed=" + failed), (Throwable)new Exception("trace"));
        }
        if (this.server.hasBrokerPlugins()) {
            this.server.callBrokerPlugins(plugin -> plugin.beforeCloseConsumer(this, failed));
        }
        this.setStarted(false);
        LargeMessageDeliverer del = this.largeMessageDeliverer;
        if (del != null) {
            del.finish();
        }
        this.removeItself();
        List refs = this.cancelRefs(failed, false, null);
        Iterator iter = ((AbstractSequentialList)refs).iterator();
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        while (iter.hasNext()) {
            MessageReference ref = (MessageReference)iter.next();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ServerConsumerImpl::" + this + " cancelling reference " + ref));
            }
            ref.getQueue().cancel(tx, ref, true);
        }
        tx.rollback();
        this.messageQueue.recheckRefCount(this.session.getSessionContext());
        if (!this.browseOnly) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, this.binding.getAddress());
            props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, this.binding.getClusterName());
            props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, this.binding.getRoutingName());
            props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, this.filter == null ? null : this.filter.getFilterString());
            props.putIntProperty(ManagementHelper.HDR_DISTANCE, this.binding.getDistance());
            props.putIntProperty(ManagementHelper.HDR_CONSUMER_COUNT, this.messageQueue.getConsumerCount());
            props.putSimpleStringProperty(ManagementHelper.HDR_USER, SimpleString.toSimpleString((String)this.session.getUsername()));
            props.putSimpleStringProperty(ManagementHelper.HDR_REMOTE_ADDRESS, SimpleString.toSimpleString((String)((ServerSessionImpl)this.session).getRemotingConnection().getRemoteAddress()));
            props.putSimpleStringProperty(ManagementHelper.HDR_SESSION_NAME, SimpleString.toSimpleString((String)this.session.getName()));
            Notification notification = new Notification(null, (NotificationType)CoreNotificationType.CONSUMER_CLOSED, props);
            this.managementService.sendNotification(notification);
        }
        if (this.server.hasBrokerPlugins()) {
            this.server.callBrokerPlugins(plugin -> plugin.afterCloseConsumer(this, failed));
        }
    }

    @Override
    public void removeItself() throws Exception {
        if (this.browseOnly) {
            this.browserDeliverer.close();
        } else {
            this.messageQueue.removeConsumer(this);
        }
        this.session.removeConsumer(this.id);
    }

    @Override
    public void forceDelivery(long sequence) {
        this.forceDelivery(sequence, () -> {
            CoreMessage forcedDeliveryMessage = new CoreMessage(this.storageManager.generateID(), 50);
            forcedDeliveryMessage.putLongProperty(ClientConsumerImpl.FORCED_DELIVERY_MESSAGE, sequence);
            forcedDeliveryMessage.setAddress(this.messageQueue.getName());
            this.applyPrefixForLegacyConsumer((Message)forcedDeliveryMessage);
            this.callback.sendMessage(null, (Message)forcedDeliveryMessage, this, 0);
        });
    }

    public synchronized void forceDelivery(final long sequence, final Runnable r) {
        this.promptDelivery();
        this.messageQueue.getExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Object object = ServerConsumerImpl.this.lock;
                    synchronized (object) {
                        if (ServerConsumerImpl.this.transferring) {
                            ServerConsumerImpl.this.messageQueue.getExecutor().execute(new Runnable(){

                                @Override
                                public void run() {
                                    ServerConsumerImpl.this.forceDelivery(sequence, r);
                                }
                            });
                            return;
                        }
                    }
                    r.run();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorSendingForcedDelivery(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<MessageReference> cancelRefs(boolean failed, boolean lastConsumedAsDelivered, Transaction tx) throws Exception {
        boolean performACK = lastConsumedAsDelivered;
        try {
            LargeMessageDeliverer pendingLargeMessageDeliverer = this.largeMessageDeliverer;
            if (pendingLargeMessageDeliverer != null) {
                pendingLargeMessageDeliverer.finish();
            }
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorResttingLargeMessage(e, this.largeMessageDeliverer);
        }
        finally {
            this.largeMessageDeliverer = null;
        }
        LinkedList<MessageReference> refs = new LinkedList<MessageReference>();
        Object object = this.lock;
        synchronized (object) {
            if (!this.deliveringRefs.isEmpty()) {
                for (MessageReference ref : this.deliveringRefs) {
                    if (performACK) {
                        ref.acknowledge(tx, this);
                        performACK = false;
                    } else {
                        refs.add(ref);
                        this.updateDeliveryCountForCanceledRef(ref, failed);
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("ServerConsumerImpl::" + this + " Preparing Cancelling list for messageID = " + ref.getMessage().getMessageID() + ", ref = " + ref));
                }
                this.deliveringRefs.clear();
            }
        }
        return refs;
    }

    protected void updateDeliveryCountForCanceledRef(MessageReference ref, boolean failed) {
        if (!this.callback.updateDeliveryCountAfterCancel(this, ref, failed) && !failed) {
            ref.decrementDeliveryCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStarted(boolean started) {
        Object object = this.lock;
        synchronized (object) {
            boolean locked = this.lockDelivery();
            try {
                this.started = this.browseOnly || started;
            }
            finally {
                if (locked) {
                    this.lockDelivery.writeLock().unlock();
                }
            }
        }
        if (started) {
            this.promptDelivery();
        }
    }

    private boolean lockDelivery() {
        try {
            if (!this.lockDelivery.writeLock().tryLock(30L, TimeUnit.SECONDS)) {
                ActiveMQServerLogger.LOGGER.timeoutLockingConsumer();
                if (this.server != null) {
                    this.server.threadDump();
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            ActiveMQServerLogger.LOGGER.failedToFinishDelivery(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransferring(boolean transferring) {
        Object object = this.lock;
        synchronized (object) {
            boolean locked = this.lockDelivery();
            try {
                this.transferring = transferring;
            }
            finally {
                if (locked) {
                    this.lockDelivery.writeLock().unlock();
                }
            }
        }
        if (transferring) {
            FutureLatch future = new FutureLatch();
            this.messageQueue.getExecutor().execute((Runnable)future);
            boolean ok = future.await(10000L);
            if (!ok) {
                ActiveMQServerLogger.LOGGER.errorTransferringConsumer();
            }
        }
        if (!transferring) {
            this.promptDelivery();
        }
    }

    @Override
    public void receiveCredits(int credits) {
        if (credits == -1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + ":: FlowControl::Received disable flow control message"));
            }
            this.availableCredits = null;
            this.promptDelivery();
        } else if (credits == 0) {
            logger.debug((Object)(this + ":: FlowControl::Received reset flow control message"));
            this.availableCredits.set(0);
        } else {
            int previous = this.availableCredits.getAndAdd(credits);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this + "::FlowControl::Received " + credits + " credits, previous value = " + previous + " currentValue = " + this.availableCredits.get()));
            }
            if (previous <= 0 && previous + credits > 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)(this + "::calling promptDelivery from receiving credits"));
                }
                this.promptDelivery();
            }
        }
    }

    @Override
    public Queue getQueue() {
        return this.messageQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<MessageReference> getDeliveringReferencesBasedOnProtocol(boolean remove, Object protocolDataStart, Object protocolDataEnd) {
        LinkedList<MessageReference> retReferences = new LinkedList<MessageReference>();
        boolean hit = false;
        Object object = this.lock;
        synchronized (object) {
            Iterator<MessageReference> referenceIterator = this.deliveringRefs.iterator();
            while (referenceIterator.hasNext()) {
                MessageReference reference = referenceIterator.next();
                if (!hit) {
                    boolean bl = hit = reference.getProtocolData() != null && reference.getProtocolData().equals(protocolDataStart);
                }
                if (!hit) continue;
                if (remove) {
                    referenceIterator.remove();
                }
                retReferences.add(reference);
                if (reference.getProtocolData() == null || !reference.getProtocolData().equals(protocolDataEnd)) continue;
                break;
            }
        }
        return retReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void acknowledge(Transaction tx, long messageID) throws Exception {
        if (this.browseOnly) {
            return;
        }
        boolean startedTransaction = false;
        if (tx == null) {
            startedTransaction = true;
            tx = new TransactionImpl(this.storageManager);
        }
        try {
            MessageReference ref;
            do {
                Object object = this.lock;
                synchronized (object) {
                    ref = this.deliveringRefs.poll();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("ACKing ref " + ref + " on tx= " + tx + ", consumer=" + this));
                }
                if (ref == null) {
                    ActiveMQIllegalStateException ils = ActiveMQMessageBundle.BUNDLE.consumerNoReference(this.id, messageID, this.messageQueue.getName());
                    tx.markAsRollbackOnly((ActiveMQException)((Object)ils));
                    throw ils;
                }
                ref.acknowledge(tx, this);
                ++this.acks;
            } while (ref.getMessageID() != messageID);
            if (startedTransaction) {
                tx.commit();
            }
        }
        catch (ActiveMQException e) {
            if (startedTransaction) {
                tx.rollback();
            } else {
                tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorAckingMessage((Exception)e);
            ActiveMQIllegalStateException activeMQIllegalStateException = new ActiveMQIllegalStateException(e.getMessage());
            if (startedTransaction) {
                tx.rollback();
            } else {
                tx.markAsRollbackOnly((ActiveMQException)((Object)activeMQIllegalStateException));
            }
            throw activeMQIllegalStateException;
        }
    }

    @Override
    public synchronized void individualAcknowledge(Transaction tx, long messageID) throws Exception {
        if (this.browseOnly) {
            return;
        }
        boolean startedTransaction = false;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("individualACK messageID=" + messageID));
        }
        if (tx == null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"individualACK starting new TX");
            }
            startedTransaction = true;
            tx = new TransactionImpl(this.storageManager);
        }
        try {
            MessageReference ref = this.removeReferenceByID(messageID);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("ACKing ref " + ref + " on tx= " + tx + ", consumer=" + this));
            }
            if (ref == null) {
                ActiveMQIllegalStateException ils = new ActiveMQIllegalStateException("Cannot find ref to ack " + messageID);
                tx.markAsRollbackOnly((ActiveMQException)((Object)ils));
                throw ils;
            }
            ref.acknowledge(tx, this);
            ++this.acks;
            if (startedTransaction) {
                tx.commit();
            }
        }
        catch (ActiveMQException e) {
            if (startedTransaction) {
                tx.rollback();
            } else {
                tx.markAsRollbackOnly(e);
            }
            throw e;
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.errorAckingMessage((Exception)e);
            ActiveMQIllegalStateException hqex = new ActiveMQIllegalStateException(e.getMessage());
            if (startedTransaction) {
                tx.rollback();
            } else {
                tx.markAsRollbackOnly((ActiveMQException)((Object)hqex));
            }
            throw hqex;
        }
    }

    @Override
    public synchronized void individualCancel(long messageID, boolean failed) throws Exception {
        if (this.browseOnly) {
            return;
        }
        MessageReference ref = this.removeReferenceByID(messageID);
        if (ref == null) {
            throw new IllegalStateException("Cannot find ref to ack " + messageID);
        }
        if (!failed) {
            ref.decrementDeliveryCount();
        }
        ref.getQueue().cancel(ref, System.currentTimeMillis());
    }

    @Override
    public synchronized void reject(long messageID) throws Exception {
        if (this.browseOnly) {
            return;
        }
        MessageReference ref = this.removeReferenceByID(messageID);
        if (ref == null) {
            return;
        }
        ref.getQueue().sendToDeadLetterAddress(null, ref);
    }

    @Override
    public synchronized void backToDelivering(MessageReference reference) {
        this.deliveringRefs.addFirst(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MessageReference removeReferenceByID(long messageID) throws Exception {
        if (this.browseOnly) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.deliveringRefs.isEmpty()) {
                return null;
            }
            if (this.deliveringRefs.peek().getMessage().getMessageID() == messageID) {
                return this.deliveringRefs.poll();
            }
            Iterator<MessageReference> iter = this.deliveringRefs.iterator();
            MessageReference ref = null;
            while (iter.hasNext()) {
                MessageReference theRef = iter.next();
                if (theRef.getMessage().getMessageID() != messageID) continue;
                iter.remove();
                ref = theRef;
                break;
            }
            return ref;
        }
    }

    public AtomicInteger getAvailableCredits() {
        return this.availableCredits;
    }

    public String toString() {
        return "ServerConsumerImpl [id=" + this.id + ", filter=" + this.filter + ", binding=" + this.binding + "]";
    }

    @Override
    public String toManagementString() {
        return "ServerConsumer [id=" + this.getConnectionID() + ":" + this.getSessionID() + ":" + this.id + ", filter=" + this.filter + ", binding=" + this.binding.toManagementString() + "]";
    }

    @Override
    public void disconnect() {
        this.callback.disconnect(this, this.getQueue().getName());
    }

    public float getRate() {
        float timeSlice = (float)(System.currentTimeMillis() - this.consumerRateCheckTime.getAndSet(System.currentTimeMillis())) / 1000.0f;
        if (timeSlice == 0.0f) {
            this.messageConsumedSnapshot.getAndSet(this.acks);
            return 0.0f;
        }
        return BigDecimal.valueOf((float)(this.acks - this.messageConsumedSnapshot.getAndSet(this.acks)) / timeSlice).setScale(2, 0).floatValue();
    }

    @Override
    public void promptDelivery() {
        if (this.largeMessageDeliverer != null) {
            this.resumeLargeMessage();
        } else {
            this.forceDelivery();
        }
    }

    private void forceDelivery() {
        if (this.browseOnly) {
            this.messageQueue.getExecutor().execute(this.browserDeliverer);
        } else {
            this.messageQueue.deliverAsync();
        }
    }

    private void resumeLargeMessage() {
        this.messageQueue.getExecutor().execute(this.resumeLargeMessageRunnable);
    }

    private void deliverStandardMessage(MessageReference ref, Message message) throws ActiveMQException {
        this.applyPrefixForLegacyConsumer(message);
        int packetSize = this.callback.sendMessage(ref, message, this, ref.getDeliveryCount());
        if (this.availableCredits != null) {
            this.availableCredits.addAndGet(-packetSize);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(this + "::FlowControl::delivery standard taking " + packetSize + " from credits, available now is " + this.availableCredits));
            }
        }
    }

    private void applyPrefixForLegacyConsumer(Message message) {
        if (this.requiresLegacyPrefix) {
            if (this.anycast) {
                if (!message.getAddress().startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString())) {
                    message.setAddress(PacketImpl.OLD_QUEUE_PREFIX + message.getAddress());
                }
            } else if (!message.getAddress().startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString())) {
                message.setAddress(PacketImpl.OLD_TOPIC_PREFIX + message.getAddress());
            }
        }
    }

    public void setPreAcknowledge(boolean preAcknowledge) {
        this.preAcknowledge = preAcknowledge;
    }

    @Override
    public long getSequentialID() {
        return this.sequentialID;
    }

    @Override
    public SimpleString getQueueName() {
        return this.getQueue().getName();
    }

    @Override
    public RoutingType getQueueType() {
        return this.getQueue().getRoutingType();
    }

    @Override
    public SimpleString getQueueAddress() {
        return this.getQueue().getAddress();
    }

    @Override
    public String getSessionName() {
        return this.session.getName();
    }

    @Override
    public String getConnectionClientID() {
        return this.session.getRemotingConnection().getClientID();
    }

    @Override
    public String getConnectionProtocolName() {
        return this.session.getRemotingConnection().getProtocolName();
    }

    @Override
    public String getConnectionLocalAddress() {
        return this.session.getRemotingConnection().getTransportConnection().getLocalAddress();
    }

    @Override
    public String getConnectionRemoteAddress() {
        return this.session.getRemotingConnection().getTransportConnection().getRemoteAddress();
    }

    protected class BrowserDeliverer
    implements Runnable {
        protected MessageReference current = null;
        public final LinkedListIterator<MessageReference> iterator;

        public BrowserDeliverer(LinkedListIterator<MessageReference> iterator) {
            this.iterator = iterator;
        }

        public synchronized void close() {
            this.iterator.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            block13: {
                if (this.current != null) {
                    try {
                        HandleStatus status = ServerConsumerImpl.this.handle(this.current);
                        if (status == HandleStatus.BUSY) {
                            return;
                        }
                        if (status == HandleStatus.HANDLED) {
                            ServerConsumerImpl.this.proceedDeliver(this.current);
                        }
                        this.current = null;
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorBrowserHandlingMessage(e, this.current);
                        return;
                    }
                }
                MessageReference ref = null;
                try {
                    while (true) {
                        HandleStatus status;
                        ref = null;
                        Queue queue = ServerConsumerImpl.this.messageQueue;
                        synchronized (queue) {
                            if (!this.iterator.hasNext()) {
                                ServerConsumerImpl.this.callback.browserFinished(ServerConsumerImpl.this);
                                break block13;
                            }
                            ref = (MessageReference)this.iterator.next();
                            status = ServerConsumerImpl.this.handle(ref);
                        }
                        if (status == HandleStatus.HANDLED) {
                            ServerConsumerImpl.this.proceedDeliver(ref);
                            continue;
                        }
                        if (status == HandleStatus.BUSY) break;
                    }
                    this.current = ref;
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorBrowserHandlingMessage(e, ref);
                }
            }
        }

        public boolean isBrowsed() {
            ServerConsumerImpl.this.messageQueue.deliverAsync();
            boolean b = !this.iterator.hasNext();
            return b;
        }
    }

    private final class LargeMessageDeliverer {
        private long sizePendingLargeMessage;
        private LargeServerMessage largeMessage;
        private final MessageReference ref;
        private boolean sentInitialPacket = false;
        private long positionPendingLargeMessage;
        private LargeBodyEncoder context;
        private ByteBuffer chunkBytes;

        private LargeMessageDeliverer(LargeServerMessage message, MessageReference ref) throws Exception {
            this.largeMessage = message;
            this.largeMessage.incrementDelayDeletionCount();
            this.ref = ref;
            this.chunkBytes = null;
        }

        public String toString() {
            return "ServerConsumerImpl$LargeMessageDeliverer[ref=[" + this.ref + "]]";
        }

        private ByteBuffer acquireHeapBodyBuffer(int requiredCapacity) {
            if (this.chunkBytes == null || this.chunkBytes.capacity() != requiredCapacity) {
                this.chunkBytes = ByteBuffer.allocate(requiredCapacity);
            } else {
                this.chunkBytes.clear();
            }
            return this.chunkBytes;
        }

        private void releaseHeapBodyBuffer() {
            this.chunkBytes = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean deliver() throws Exception {
            ServerConsumerImpl.this.lockDelivery.readLock().lock();
            try {
                if (!ServerConsumerImpl.this.started) {
                    boolean bl = false;
                    return bl;
                }
                LargeServerMessage currentLargeMessage = this.largeMessage;
                if (currentLargeMessage == null) {
                    boolean bl = true;
                    return bl;
                }
                if (ServerConsumerImpl.this.availableCredits != null && ServerConsumerImpl.this.availableCredits.get() <= 0) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(this + "::FlowControl::delivery largeMessage interrupting as there are no more credits, available=" + ServerConsumerImpl.this.availableCredits));
                    }
                    this.releaseHeapBodyBuffer();
                    boolean bl = false;
                    return bl;
                }
                if (!this.sentInitialPacket) {
                    int credits;
                    this.context = currentLargeMessage.getBodyEncoder();
                    this.sizePendingLargeMessage = this.context.getLargeBodySize();
                    this.context.open();
                    this.sentInitialPacket = true;
                    int packetSize = ServerConsumerImpl.this.callback.sendLargeMessage(this.ref, (Message)currentLargeMessage, ServerConsumerImpl.this, this.context.getLargeBodySize(), this.ref.getDeliveryCount());
                    if (ServerConsumerImpl.this.availableCredits != null) {
                        credits = ServerConsumerImpl.this.availableCredits.addAndGet(-packetSize);
                        if (credits <= 0) {
                            this.releaseHeapBodyBuffer();
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)(this + "::FlowControl::" + " deliver initialpackage with " + packetSize + " delivered, available now = " + ServerConsumerImpl.this.availableCredits));
                        }
                    }
                    ServerConsumerImpl.this.resumeLargeMessage();
                    credits = 0;
                    return credits != 0;
                }
                if (ServerConsumerImpl.this.availableCredits != null && ServerConsumerImpl.this.availableCredits.get() <= 0) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(this + "::FlowControl::deliverLargeMessage Leaving loop of send LargeMessage because of credits, available=" + ServerConsumerImpl.this.availableCredits));
                    }
                    this.releaseHeapBodyBuffer();
                    boolean packetSize = false;
                    return packetSize;
                }
                int localChunkLen = (int)Math.min(this.sizePendingLargeMessage - this.positionPendingLargeMessage, (long)ServerConsumerImpl.this.minLargeMessageSize);
                ByteBuffer bodyBuffer = this.acquireHeapBodyBuffer(localChunkLen);
                assert (bodyBuffer.remaining() == localChunkLen);
                int readBytes = this.context.encode(bodyBuffer);
                assert (readBytes == localChunkLen);
                byte[] body = bodyBuffer.array();
                assert (body.length == readBytes);
                int packetSize = ServerConsumerImpl.this.callback.sendLargeMessageContinuation(ServerConsumerImpl.this, body, this.positionPendingLargeMessage + (long)localChunkLen < this.sizePendingLargeMessage, false);
                int chunkLen = body.length;
                if (ServerConsumerImpl.this.availableCredits != null) {
                    int credits = ServerConsumerImpl.this.availableCredits.addAndGet(-packetSize);
                    if (credits <= 0) {
                        this.releaseHeapBodyBuffer();
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)(this + "::FlowControl::largeMessage deliver continuation, packetSize=" + packetSize + " available now=" + ServerConsumerImpl.this.availableCredits));
                    }
                }
                this.positionPendingLargeMessage += (long)chunkLen;
                if (this.positionPendingLargeMessage < this.sizePendingLargeMessage) {
                    ServerConsumerImpl.this.resumeLargeMessage();
                    boolean bl = false;
                    return bl;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"Finished deliverLargeMessage");
                }
                this.finish();
                boolean bl = true;
                return bl;
            }
            finally {
                ServerConsumerImpl.this.lockDelivery.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() throws Exception {
            Object object = ServerConsumerImpl.this.lock;
            synchronized (object) {
                this.releaseHeapBodyBuffer();
                if (this.largeMessage == null) {
                    return;
                }
                if (this.context != null) {
                    this.context.close();
                    this.context = null;
                }
                this.largeMessage.releaseResources();
                this.largeMessage.decrementDelayDeletionCount();
                if (ServerConsumerImpl.this.preAcknowledge && !ServerConsumerImpl.this.browseOnly) {
                    this.largeMessage.decrementDelayDeletionCount();
                }
                ServerConsumerImpl.this.largeMessageDeliverer = null;
                this.largeMessage = null;
            }
        }
    }
}

