/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.function.Supplier;
import org.jgroups.Header;
import org.jgroups.util.Bits;

public class Frag3Header
extends Header {
    protected int id;
    protected int frag_id;
    protected int num_frags;
    protected int original_length;
    protected int offset;

    public Frag3Header() {
    }

    public Frag3Header(int id, int frag_id, int num_frags) {
        this.id = id;
        this.frag_id = frag_id;
        this.num_frags = num_frags;
    }

    public Frag3Header(int id, int frag_id, int num_frags, int original_length, int offset) {
        this.id = id;
        this.frag_id = frag_id;
        this.num_frags = num_frags;
        this.original_length = original_length;
        this.offset = offset;
    }

    @Override
    public short getMagicId() {
        return 91;
    }

    @Override
    public Supplier<? extends Header> create() {
        return Frag3Header::new;
    }

    @Override
    public String toString() {
        return String.format("[id=%d, frag-id=%d, num_frags=%d orig-length=%d, offset=%d]", this.id, this.frag_id, this.num_frags, this.original_length, this.offset);
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        Bits.writeInt(this.id, out);
        Bits.writeInt(this.frag_id, out);
        Bits.writeInt(this.num_frags, out);
        Bits.writeInt(this.original_length, out);
        Bits.writeInt(this.offset, out);
    }

    @Override
    public int serializedSize() {
        return Bits.size(this.id) + Bits.size(this.frag_id) + Bits.size(this.num_frags) + Bits.size(this.original_length) + Bits.size(this.offset);
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        this.id = Bits.readInt(in);
        this.frag_id = Bits.readInt(in);
        this.num_frags = Bits.readInt(in);
        this.original_length = Bits.readInt(in);
        this.offset = Bits.readInt(in);
    }
}

