/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session.fine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.NotSerializableException;
import org.infinispan.context.Flag;
import org.wildfly.clustering.ee.Mutator;
import org.wildfly.clustering.ee.infinispan.CacheEntryMutator;
import org.wildfly.clustering.ee.infinispan.CacheProperties;
import org.wildfly.clustering.marshalling.spi.Marshaller;
import org.wildfly.clustering.web.infinispan.session.SessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.FineImmutableSessionAttributes;
import org.wildfly.clustering.web.infinispan.session.fine.SessionAttributeKey;
import org.wildfly.clustering.web.session.SessionAttributeImmutability;

public class FineSessionAttributes<V>
extends FineImmutableSessionAttributes<V>
implements SessionAttributes {
    private final AtomicInteger sequence;
    private final ConcurrentMap<String, Integer> names;
    private final Mutator namesMutator;
    private final Cache<SessionAttributeKey, V> cache;
    private final Map<String, Mutator> mutations = new ConcurrentHashMap<String, Mutator>();
    private final Marshaller<Object, V> marshaller;
    private final CacheProperties properties;

    public FineSessionAttributes(String id, AtomicInteger sequence, ConcurrentMap<String, Integer> names, Mutator namesMutator, Cache<SessionAttributeKey, V> cache, Marshaller<Object, V> marshaller, CacheProperties properties) {
        super(id, names, cache, marshaller);
        this.sequence = sequence;
        this.names = names;
        this.namesMutator = namesMutator;
        this.cache = cache;
        this.marshaller = marshaller;
        this.properties = properties;
    }

    public Object removeAttribute(String name) {
        Integer attributeId = (Integer)this.names.remove(name);
        if (attributeId == null) {
            return null;
        }
        this.namesMutator.mutate();
        SessionAttributeKey key = this.createKey(attributeId);
        Object result = this.read(name, this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).remove((Object)key));
        this.mutations.remove(name);
        return result;
    }

    public Object setAttribute(String name, Object attribute) {
        if (attribute == null) {
            return this.removeAttribute(name);
        }
        if (this.properties.isMarshalling() && !this.marshaller.isMarshallable(attribute)) {
            throw new IllegalArgumentException((Throwable)new NotSerializableException(attribute.getClass().getName()));
        }
        Object value = this.marshaller.write(attribute);
        int currentId = this.sequence.get();
        int attributeId = this.names.computeIfAbsent(name, key -> this.sequence.incrementAndGet());
        if (attributeId > currentId) {
            this.namesMutator.mutate();
        }
        SessionAttributeKey key2 = this.createKey(attributeId);
        Object result = this.read(name, this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FORCE_SYNCHRONOUS}).put((Object)key2, value));
        if (this.properties.isTransactional()) {
            this.mutations.put(name, Mutator.PASSIVE);
        } else if (SessionAttributeImmutability.INSTANCE.test(attribute)) {
            this.mutations.remove(name);
        } else {
            this.mutations.put(name, (Mutator)new CacheEntryMutator(this.cache, (Object)key2, value));
        }
        return result;
    }

    @Override
    public Object getAttribute(String name) {
        Integer attributeId = (Integer)this.names.get(name);
        if (attributeId == null) {
            return null;
        }
        SessionAttributeKey key = this.createKey(attributeId);
        Object value = this.cache.get((Object)key);
        Object attribute = this.read(name, value);
        if (attribute != null && !SessionAttributeImmutability.INSTANCE.test(attribute)) {
            this.mutations.putIfAbsent(name, (Mutator)new CacheEntryMutator(this.cache, (Object)key, value));
        }
        return attribute;
    }

    @Override
    public void close() {
        for (Mutator mutator : this.mutations.values()) {
            mutator.mutate();
        }
        this.mutations.clear();
    }
}

