/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.jboss.as.clustering.infinispan.BatcherFactory;
import org.jboss.as.clustering.infinispan.DefaultCache;
import org.wildfly.clustering.infinispan.spi.CacheContainer;

public class DefaultCacheContainer
extends AbstractDelegatingEmbeddedCacheManager
implements CacheContainer,
EmbeddedCacheManagerAdmin {
    private final BatcherFactory batcherFactory;

    public DefaultCacheContainer(EmbeddedCacheManager container, BatcherFactory batcherFactory) {
        super(container);
        this.batcherFactory = batcherFactory;
    }

    public Address getAddress() {
        Address address = super.getAddress();
        return address != null ? address : LocalModeAddress.INSTANCE;
    }

    public Address getCoordinator() {
        Address coordinator = super.getCoordinator();
        return coordinator != null ? coordinator : LocalModeAddress.INSTANCE;
    }

    public List<Address> getMembers() {
        List<Address> members = super.getMembers();
        return members != null ? members : Collections.singletonList(LocalModeAddress.INSTANCE);
    }

    public void start() {
    }

    public void stop() {
    }

    public <K, V> Cache<K, V> getCache() {
        return this.wrap(this.cm.getCache());
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.wrap(this.cm.getCache(cacheName));
    }

    @Deprecated
    public <K, V> Cache<K, V> getCache(String cacheName, String configurationName) {
        return this.wrap(this.cm.getCache(cacheName, configurationName));
    }

    public <K, V> Cache<K, V> getCache(String cacheName, boolean createIfAbsent) {
        return this.wrap(this.cm.getCache(cacheName, createIfAbsent));
    }

    @Deprecated
    public <K, V> Cache<K, V> getCache(String cacheName, String configurationTemplate, boolean createIfAbsent) {
        return this.wrap(this.cm.getCache(cacheName, configurationTemplate, createIfAbsent));
    }

    private <K, V> Cache<K, V> wrap(Cache<K, V> cache) {
        return new DefaultCache((EmbeddedCacheManager)this, this.batcherFactory, cache.getAdvancedCache());
    }

    public EmbeddedCacheManager startCaches(String ... cacheNames) {
        super.startCaches(cacheNames);
        return this;
    }

    public EmbeddedCacheManagerAdmin administration() {
        return this;
    }

    public EmbeddedCacheManagerAdmin withFlags(CacheContainerAdmin.AdminFlag ... flags) {
        return this;
    }

    public EmbeddedCacheManagerAdmin withFlags(EnumSet<CacheContainerAdmin.AdminFlag> flags) {
        return this;
    }

    public <K, V> Cache<K, V> createCache(String name, String template) {
        return this.createCache(name, this.getCacheConfiguration(name));
    }

    public <K, V> Cache<K, V> getOrCreateCache(String name, String template) {
        return this.getOrCreateCache(name, this.getCacheConfiguration(name));
    }

    public synchronized <K, V> Cache<K, V> createCache(String name, Configuration configuration) {
        this.defineConfiguration(name, configuration);
        return this.getCache(name);
    }

    public synchronized <K, V> Cache<K, V> getOrCreateCache(String name, Configuration configuration) {
        return this.getCacheConfiguration(name) != null ? this.createCache(name, configuration) : this.getCache(name);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CacheContainer)) {
            return false;
        }
        CacheContainer container = (CacheContainer)object;
        return this.getName().equals(container.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

