/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.naming;

import java.util.HashSet;
import java.util.Map;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.ValueManagedReferenceFactory;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Values;

public class InApplicationClientBindingProcessor
implements DeploymentUnitProcessor {
    private final boolean appclient;

    public InApplicationClientBindingProcessor(boolean appclient) {
        this.appclient = appclient;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription == null) {
            return;
        }
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        if (DeploymentTypeMarker.isType(DeploymentType.WAR, deploymentUnit) || DeploymentTypeMarker.isType(DeploymentType.APPLICATION_CLIENT, deploymentUnit)) {
            ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName());
            this.bindServices(deploymentUnit, serviceTarget, moduleContextServiceName);
        }
        for (ComponentDescription component : moduleDescription.getComponentDescriptions()) {
            if (component.getNamingMode() != ComponentNamingMode.CREATE) continue;
            ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)moduleDescription.getApplicationName(), (String)moduleDescription.getModuleName(), (String)component.getComponentName());
            this.bindServices(deploymentUnit, serviceTarget, compContextServiceName);
        }
    }

    private void bindServices(DeploymentUnit deploymentUnit, ServiceTarget serviceTarget, ServiceName contextServiceName) {
        ServiceName inAppClientServiceName = contextServiceName.append(new String[]{"InAppClientContainer"});
        BinderService inAppClientContainerService = new BinderService("InAppClientContainer");
        serviceTarget.addService(inAppClientServiceName, (Service)inAppClientContainerService).addInjection((Injector)inAppClientContainerService.getManagedObjectInjector(), (Object)new ValueManagedReferenceFactory(Values.immediateValue((Object)this.appclient))).addDependency(contextServiceName, ServiceBasedNamingStore.class, (Injector)inAppClientContainerService.getNamingStoreInjector()).install();
        Map jndiComponentDependencies = (Map)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPONENT_JNDI_DEPENDENCIES);
        HashSet<ServiceName> jndiDependencies = (HashSet<ServiceName>)jndiComponentDependencies.get(contextServiceName);
        if (jndiDependencies == null) {
            jndiDependencies = new HashSet<ServiceName>();
            jndiComponentDependencies.put(contextServiceName, jndiDependencies);
        }
        jndiDependencies.add(inAppClientServiceName);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

