/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.bridge.local;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.as.controller.ModelController;
import org.jboss.as.core.model.bridge.impl.ClassLoaderObjectConverterImpl;
import org.jboss.as.core.model.bridge.local.ClassLoaderObjectConverter;
import org.jboss.as.core.model.bridge.shared.ObjectSerializer;
import org.jboss.dmr.ModelNode;

public class OperationTransactionControlProxy
implements ModelController.OperationTransactionControl {
    final ClassLoaderObjectConverter converter = new ClassLoaderObjectConverterImpl(ObjectSerializer.class.getClassLoader(), this.getClass().getClassLoader());
    final Object mainTransactionControl;

    public OperationTransactionControlProxy(Object mainTransactionControl) {
        this.mainTransactionControl = mainTransactionControl;
    }

    public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
        Class<?> mainClass = this.mainTransactionControl.getClass();
        ClassLoader mainCl = mainClass.getClassLoader();
        try {
            Method method = mainClass.getMethod("operationPrepared", mainCl.loadClass(ModelController.OperationTransaction.class.getName()), mainCl.loadClass(ModelNode.class.getName()));
            method.setAccessible(true);
            Class<?> mainOpTxClass = mainCl.loadClass(OperationTransactionProxy.class.getName());
            Constructor<?> ctor = mainOpTxClass.getConstructors()[0];
            Object mainOpTxProxy = ctor.newInstance(transaction);
            method.invoke(this.mainTransactionControl, mainOpTxProxy, this.convertModelNodeToMainCl(result));
        }
        catch (Exception e) {
            OperationTransactionControlProxy.unwrapInvocationTargetRuntimeException(e);
            throw new RuntimeException(e);
        }
    }

    private Object convertModelNodeToMainCl(ModelNode modelNode) throws Exception {
        ObjectSerializer localSerializer = ObjectSerializer.FACTORY.createSerializer(this.getClass().getClassLoader());
        ObjectSerializer mainSerializer = ObjectSerializer.FACTORY.createSerializer(ObjectSerializer.class.getClassLoader());
        return mainSerializer.deserializeModelNode(localSerializer.serializeModelNode(modelNode));
    }

    private static void unwrapInvocationTargetRuntimeException(Exception e) {
        Throwable t;
        e.printStackTrace();
        if (e instanceof InvocationTargetException && (t = e.getCause()) instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
    }

    public static class OperationTransactionProxy
    implements ModelController.OperationTransaction {
        private final Object tx;

        public OperationTransactionProxy(Object tx) {
            this.tx = tx;
        }

        public void commit() {
            this.invoke("commit");
        }

        public void rollback() {
            this.invoke("rollback");
        }

        private void invoke(String name) {
            try {
                Method m = this.tx.getClass().getMethod(name, new Class[0]);
                m.setAccessible(true);
                m.invoke(this.tx, new Object[0]);
            }
            catch (Exception e) {
                OperationTransactionControlProxy.unwrapInvocationTargetRuntimeException(e);
                throw new RuntimeException(e);
            }
        }
    }
}

