/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.core.model.test;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.VaultReader;
import org.jboss.as.server.services.security.AbstractVaultReader;
import org.jboss.as.server.services.security.VaultReaderException;

public class TestVaultReader
extends AbstractVaultReader {
    private volatile String fqn;
    private final Map<String, Object> options = new HashMap<String, Object>();

    protected void createVault(String fqn, Map<String, Object> options) throws VaultReaderException {
        assert (this.fqn == null) : "vault already initialized";
        String string = this.fqn = fqn == null ? "default" : fqn;
        if (options != null) {
            this.options.putAll(options);
        }
    }

    protected void createVault(String fqn, String module, Map<String, Object> options) throws VaultReaderException {
        this.createVault(fqn, options);
    }

    protected void destroyVault() {
        this.fqn = null;
        this.options.clear();
    }

    public boolean isVaultFormat(String encrypted) {
        return encrypted != null && STANDARD_VAULT_PATTERN.matcher(encrypted).matches();
    }

    public String retrieveFromVault(String encrypted) {
        if (this.isVaultFormat(encrypted)) {
            String[] split;
            String vault = this.fqn;
            if (vault != null && (split = encrypted.split("::"))[1].equals(vault)) {
                Object value = this.options.get(split[2]);
                if (value == null) {
                    value = split[3];
                }
                return value.toString();
            }
            throw new VaultReader.NoSuchItemException();
        }
        return encrypted;
    }
}

