/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.ap.internal.checks.annotationparameters;

import java.util.regex.Pattern;
import javax.lang.model.element.AnnotationMirror;
import org.hibernate.validator.ap.internal.checks.annotationparameters.AnnotationParametersAbstractCheck;
import org.hibernate.validator.ap.internal.util.AnnotationApiHelper;

public abstract class AnnotationMessageCheck
extends AnnotationParametersAbstractCheck {
    private static final String WORDS_SEPARATED_WITH_DOTS = "(\\w)+(\\.(\\w)+)*";
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("(\\w)+(\\.(\\w)+)*|\\{(\\w)+(\\.(\\w)+)*|(\\w)+(\\.(\\w)+)*\\}");

    public AnnotationMessageCheck(AnnotationApiHelper annotationApiHelper) {
        super(annotationApiHelper, new String[0]);
    }

    @Override
    protected boolean canCheckThisAnnotation(AnnotationMirror annotation) {
        return true;
    }

    protected boolean checkMessage(String message) {
        return MESSAGE_PATTERN.matcher(message).matches();
    }
}

