/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.hibernate5;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.infinispan.hibernate.cache.spi.EmbeddedCacheManagerProvider;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;
import org.jboss.as.jpa.hibernate5.HibernateSecondLevelCache;
import org.jipijapa.cache.spi.Classification;
import org.jipijapa.cache.spi.Wrapper;
import org.jipijapa.event.impl.internal.Notification;

public class ManagedEmbeddedCacheManagerProvider
implements EmbeddedCacheManagerProvider {
    public static final String CACHE_CONTAINER = "hibernate.cache.infinispan.container";
    public static final String DEFAULT_CACHE_CONTAINER = "hibernate";
    public static final String SHARED = "hibernate.cache.infinispan.shared";
    public static final String DEFAULT_SHARED = "true";

    public EmbeddedCacheManager getEmbeddedCacheManager(Properties properties) {
        Properties settings = new Properties();
        String container = properties.getProperty(CACHE_CONTAINER, DEFAULT_CACHE_CONTAINER);
        settings.setProperty("container", container);
        if (!Boolean.parseBoolean(properties.getProperty(SHARED, DEFAULT_SHARED))) {
            HibernateSecondLevelCache.addSecondLevelCacheDependencies(properties, null);
            settings.setProperty("cachetype", "private");
            String name = properties.getProperty("hibernate.session_factory_name");
            if (name != null) {
                settings.setProperty("name", name);
            }
            settings.setProperty("caches", String.join((CharSequence)" ", HibernateSecondLevelCache.findCaches(properties)));
        }
        try {
            return new JipiJapaCacheManager(Notification.startCache((Classification)Classification.INFINISPAN, (Properties)settings));
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static class JipiJapaCacheManager
    extends AbstractDelegatingEmbeddedCacheManager {
        private final Wrapper wrapper;

        JipiJapaCacheManager(Wrapper wrapper) {
            super((EmbeddedCacheManager)wrapper.getValue());
            this.wrapper = wrapper;
        }

        public void stop() {
            Notification.stopCache((Classification)Classification.INFINISPAN, (Wrapper)this.wrapper);
        }

        public void close() {
            this.stop();
        }
    }
}

