package org.jboss.as.repository.logging;

import java.util.Locale;
import java.nio.file.Path;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.as.repository.ExplodedContentException;
import java.lang.RuntimeException;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-06-26T14:53:01+0000")
public class DeploymentRepositoryLogger_$logger extends DelegatingBasicLogger implements DeploymentRepositoryLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = DeploymentRepositoryLogger_$logger.class.getName();
    public DeploymentRepositoryLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void contentAdded(final String path) {
        super.log.logf(FQCN, INFO, null, contentAdded$str(), path);
    }
    private static final String contentAdded = "WFLYDR0001: Content added at location %s";
    protected String contentAdded$str() {
        return contentAdded;
    }
    @Override
    public final void contentRemoved(final String path) {
        super.log.logf(FQCN, INFO, null, contentRemoved$str(), path);
    }
    private static final String contentRemoved = "WFLYDR0002: Content removed from location %s";
    protected String contentRemoved$str() {
        return contentRemoved;
    }
    @Override
    public final void cannotDeleteTempFile(final Throwable cause, final String path) {
        super.log.logf(FQCN, WARN, cause, cannotDeleteTempFile$str(), path);
    }
    private static final String cannotDeleteTempFile = "WFLYDR0003: Cannot delete temp file %s, will be deleted on exit";
    protected String cannotDeleteTempFile$str() {
        return cannotDeleteTempFile;
    }
    private static final String cannotCreateDirectory = "WFLYDR0004: Cannot create directory %s";
    protected String cannotCreateDirectory$str() {
        return cannotCreateDirectory;
    }
    @Override
    public final IllegalStateException cannotCreateDirectory(final Throwable cause, final String path) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotCreateDirectory$str(), path), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotObtainSha1 = "WFLYDR0005: Cannot obtain SHA-1 %s";
    protected String cannotObtainSha1$str() {
        return cannotObtainSha1;
    }
    @Override
    public final IllegalStateException cannotObtainSha1(final Throwable cause, final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotObtainSha1$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String directoryNotWritable = "WFLYDR0006: Directory %s is not writable";
    protected String directoryNotWritable$str() {
        return directoryNotWritable;
    }
    @Override
    public final IllegalStateException directoryNotWritable(final String path) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), directoryNotWritable$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notADirectory = "WFLYDR0007: %s is not a directory";
    protected String notADirectory$str() {
        return notADirectory;
    }
    @Override
    public final IllegalStateException notADirectory(final String path) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notADirectory$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void obsoleteContentCleaned(final String contentIdentifier) {
        super.log.logf(FQCN, INFO, null, obsoleteContentCleaned$str(), contentIdentifier);
    }
    private static final String obsoleteContentCleaned = "WFLYDR0009: Content %s is obsolete and will be removed";
    protected String obsoleteContentCleaned$str() {
        return obsoleteContentCleaned;
    }
    @Override
    public final void contentDeletionError(final Throwable cause, final String name) {
        super.log.logf(FQCN, ERROR, cause, contentDeletionError$str(), name);
    }
    private static final String contentDeletionError = "WFLYDR0010: Couldn't delete content %s";
    protected String contentDeletionError$str() {
        return contentDeletionError;
    }
    @Override
    public final void localContentListError(final String name) {
        super.log.logf(FQCN, INFO, null, localContentListError$str(), name);
    }
    private static final String localContentListError = "WFLYDR0011: Couldn't list directory files for %s";
    protected String localContentListError$str() {
        return localContentListError;
    }
    private static final String hashingError = "WFLYDR0012: Cannot hash current deployment content %s";
    protected String hashingError$str() {
        return hashingError;
    }
    @Override
    public final RuntimeException hashingError(final Throwable cause, final Path path) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), hashingError$str(), path), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String forbiddenPath = "WFLYDR0013: Access denied to the content at %s in the deployment";
    protected String forbiddenPath$str() {
        return forbiddenPath;
    }
    @Override
    public final IllegalArgumentException forbiddenPath(final String path) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), forbiddenPath$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void couldNotDeleteDeployment(final Exception ex, final String path) {
        super.log.logf(FQCN, ERROR, ex, couldNotDeleteDeployment$str(), path);
    }
    private static final String couldNotDeleteDeployment = "WFLYDR0014: Error deleting deployment %s";
    protected String couldNotDeleteDeployment$str() {
        return couldNotDeleteDeployment;
    }
    private static final String notAnArchive = "WFLYDR0015: %s is not an archive file";
    protected String notAnArchive$str() {
        return notAnArchive;
    }
    @Override
    public final IllegalStateException notAnArchive(final String path) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notAnArchive$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String archiveNotFound = "WFLYDR0016: Achive file %s not found";
    protected String archiveNotFound$str() {
        return archiveNotFound;
    }
    @Override
    public final ExplodedContentException archiveNotFound(final String path) {
        final ExplodedContentException result = new ExplodedContentException(String.format(getLoggingLocale(), archiveNotFound$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void contentExploded(final String path) {
        super.log.logf(FQCN, INFO, null, contentExploded$str(), path);
    }
    private static final String contentExploded = "WFLYDR0017: Content exploded at location %s";
    protected String contentExploded$str() {
        return contentExploded;
    }
    private static final String errorExplodingContent = "WFLYDR0018: Error exploding content for %s";
    protected String errorExplodingContent$str() {
        return errorExplodingContent;
    }
    @Override
    public final ExplodedContentException errorExplodingContent(final Exception ex, final String path) {
        final ExplodedContentException result = new ExplodedContentException(String.format(getLoggingLocale(), errorExplodingContent$str(), path), ex);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorLockingDeployment = "WFLYDR0019: Deployment is locked by another operation";
    protected String errorLockingDeployment$str() {
        return errorLockingDeployment;
    }
    @Override
    public final ExplodedContentException errorLockingDeployment() {
        final ExplodedContentException result = new ExplodedContentException(String.format(getLoggingLocale(), errorLockingDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorAccessingDeployment = "WFLYDR0020: Error accessing deployment files";
    protected String errorAccessingDeployment$str() {
        return errorAccessingDeployment;
    }
    @Override
    public final ExplodedContentException errorAccessingDeployment(final Exception ex) {
        final ExplodedContentException result = new ExplodedContentException(String.format(getLoggingLocale(), errorAccessingDeployment$str()), ex);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorUpdatingDeployment = "WFLYDR0021: Error updating content of exploded deployment";
    protected String errorUpdatingDeployment$str() {
        return errorUpdatingDeployment;
    }
    @Override
    public final ExplodedContentException errorUpdatingDeployment(final Exception ex) {
        final ExplodedContentException result = new ExplodedContentException(String.format(getLoggingLocale(), errorUpdatingDeployment$str()), ex);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorCopyingDeployment = "WFLYDR0022: Error copying files of exploded deployment to %s";
    protected String errorCopyingDeployment$str() {
        return errorCopyingDeployment;
    }
    @Override
    public final ExplodedContentException errorCopyingDeployment(final Exception ex, final String target) {
        final ExplodedContentException result = new ExplodedContentException(String.format(getLoggingLocale(), errorCopyingDeployment$str(), target), ex);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotDeleteFile(final Exception ex, final Path path) {
        super.log.logf(FQCN, ERROR, ex, cannotDeleteFile$str(), path);
    }
    private static final String cannotDeleteFile = "WFLYDR0023: Error deleting file %s";
    protected String cannotDeleteFile$str() {
        return cannotDeleteFile;
    }
    @Override
    public final void cannotCopyFile(final Exception ex, final Path path) {
        super.log.logf(FQCN, ERROR, ex, cannotCopyFile$str(), path);
    }
    private static final String cannotCopyFile = "WFLYDR0024: Error copying file %s";
    protected String cannotCopyFile$str() {
        return cannotCopyFile;
    }
}
