package org.jboss.as.process.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.marshalling.Marshaller;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.net.ServerSocket;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import java.io.UTFDataFormatException;
import org.jboss.logging.BasicLogger;
import java.io.EOFException;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import org.jboss.marshalling.Unmarshaller;
import java.net.InetAddress;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-06-26T14:53:03+0000")
public class ProcessLogger_$logger extends DelegatingBasicLogger implements ProcessLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProcessLogger_$logger.class.getName();
    public ProcessLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void attemptToReconnectNonExistentProcess(final String processName) {
        super.log.logf(FQCN, WARN, null, attemptToReconnectNonExistentProcess$str(), processName);
    }
    private static final String attemptToReconnectNonExistentProcess = "WFLYPC0001: Attempted to reconnect non-existent process '%s'";
    protected String attemptToReconnectNonExistentProcess$str() {
        return attemptToReconnectNonExistentProcess;
    }
    @Override
    public final void attemptToRemoveNonExistentProcess(final String processName) {
        super.log.logf(FQCN, WARN, null, attemptToRemoveNonExistentProcess$str(), processName);
    }
    private static final String attemptToRemoveNonExistentProcess = "WFLYPC0002: Attempted to remove non-existent process '%s'";
    protected String attemptToRemoveNonExistentProcess$str() {
        return attemptToRemoveNonExistentProcess;
    }
    @Override
    public final void attemptToStartNonExistentProcess(final String processName) {
        super.log.logf(FQCN, WARN, null, attemptToStartNonExistentProcess$str(), processName);
    }
    private static final String attemptToStartNonExistentProcess = "WFLYPC0003: Attempted to start non-existent process '%s'";
    protected String attemptToStartNonExistentProcess$str() {
        return attemptToStartNonExistentProcess;
    }
    @Override
    public final void attemptToStopNonExistentProcess(final String processName) {
        super.log.logf(FQCN, WARN, null, attemptToStopNonExistentProcess$str(), processName);
    }
    private static final String attemptToStopNonExistentProcess = "WFLYPC0004: Attempted to stop non-existent process '%s'";
    protected String attemptToStopNonExistentProcess$str() {
        return attemptToStopNonExistentProcess;
    }
    @Override
    public final void duplicateProcessName(final String processName) {
        super.log.logf(FQCN, WARN, null, duplicateProcessName$str(), processName);
    }
    private static final String duplicateProcessName = "WFLYPC0005: Attempted to register duplicate named process '%s'";
    protected String duplicateProcessName$str() {
        return duplicateProcessName;
    }
    @Override
    public final void failedToSendAuthKey(final String processName, final Throwable error) {
        super.log.logf(FQCN, WARN, null, failedToSendAuthKey$str(), processName, error);
    }
    private static final String failedToSendAuthKey = "WFLYPC0006: Failed to send authentication key to process '%s': %s";
    protected String failedToSendAuthKey$str() {
        return failedToSendAuthKey;
    }
    @Override
    public final void failedToSendDataBytes(final Throwable cause, final String processName) {
        super.log.logf(FQCN, ERROR, cause, failedToSendDataBytes$str(), processName);
    }
    private static final String failedToSendDataBytes = "WFLYPC0007: Failed to send data bytes to process '%s' input stream";
    protected String failedToSendDataBytes$str() {
        return failedToSendDataBytes;
    }
    @Override
    public final void failedToSendReconnect(final Throwable cause, final String processName) {
        super.log.logf(FQCN, ERROR, cause, failedToSendReconnect$str(), processName);
    }
    private static final String failedToSendReconnect = "WFLYPC0008: Failed to send reconnect message to process '%s' input stream";
    protected String failedToSendReconnect$str() {
        return failedToSendReconnect;
    }
    @Override
    public final void failedToStartProcess(final Throwable cause, final String processName) {
        super.log.logf(FQCN, ERROR, cause, failedToStartProcess$str(), processName);
    }
    private static final String failedToStartProcess = "WFLYPC0009: Failed to start process '%s'";
    protected String failedToStartProcess$str() {
        return failedToStartProcess;
    }
    @Override
    public final void failedToWriteMessage(final String messageType, final Throwable t) {
        super.log.logf(FQCN, ERROR, null, failedToWriteMessage$str(), messageType, t);
    }
    private static final String failedToWriteMessage = "WFLYPC0010: Failed to write %s message to connection: %s";
    protected String failedToWriteMessage$str() {
        return failedToWriteMessage;
    }
    @Override
    public final void processFinished(final String processName, final int exitCode) {
        super.log.logf(FQCN, INFO, null, processFinished$str(), processName, exitCode);
    }
    private static final String processFinished = "WFLYPC0011: Process '%s' finished with an exit status of %d";
    protected String processFinished$str() {
        return processFinished;
    }
    @Override
    public final void receivedInvalidVersion(final InetAddress address) {
        super.log.logf(FQCN, WARN, null, receivedInvalidVersion$str(), address);
    }
    private static final String receivedInvalidVersion = "WFLYPC0012: Received connection with invalid version from %s";
    protected String receivedInvalidVersion$str() {
        return receivedInvalidVersion;
    }
    @Override
    public final void receivedUnknownGreetingCode(final int code, final InetAddress address) {
        super.log.logf(FQCN, WARN, null, receivedUnknownGreetingCode$str(), code, address);
    }
    private static final String receivedUnknownGreetingCode = "WFLYPC0013: Received unrecognized greeting code 0x%02x from %s";
    protected String receivedUnknownGreetingCode$str() {
        return receivedUnknownGreetingCode;
    }
    @Override
    public final void receivedUnknownCredentials(final InetAddress address) {
        super.log.logf(FQCN, WARN, null, receivedUnknownCredentials$str(), address);
    }
    private static final String receivedUnknownCredentials = "WFLYPC0014: Received connection with unknown credentials from %s";
    protected String receivedUnknownCredentials$str() {
        return receivedUnknownCredentials;
    }
    @Override
    public final void receivedUnknownMessageCode(final int code) {
        super.log.logf(FQCN, WARN, null, receivedUnknownMessageCode$str(), code);
    }
    private static final String receivedUnknownMessageCode = "WFLYPC0015: Received unknown message with code 0x%02x";
    protected String receivedUnknownMessageCode$str() {
        return receivedUnknownMessageCode;
    }
    @Override
    public final void shutdownComplete() {
        super.log.logf(FQCN, INFO, null, shutdownComplete$str());
    }
    private static final String shutdownComplete = "WFLYPC0016: All processes finished; exiting";
    protected String shutdownComplete$str() {
        return shutdownComplete;
    }
    @Override
    public final void shuttingDown() {
        super.log.logf(FQCN, INFO, null, shuttingDown$str());
    }
    private static final String shuttingDown = "WFLYPC0017: Shutting down process controller";
    protected String shuttingDown$str() {
        return shuttingDown;
    }
    @Override
    public final void startingProcess(final String processName) {
        super.log.logf(FQCN, INFO, null, startingProcess$str(), processName);
    }
    private static final String startingProcess = "WFLYPC0018: Starting process '%s'";
    protected String startingProcess$str() {
        return startingProcess;
    }
    @Override
    public final void stoppingProcess(final String processName) {
        super.log.logf(FQCN, INFO, null, stoppingProcess$str(), processName);
    }
    private static final String stoppingProcess = "WFLYPC0019: Stopping process '%s'";
    protected String stoppingProcess$str() {
        return stoppingProcess;
    }
    @Override
    public final void streamProcessingFailed(final String processName, final Throwable error) {
        super.log.logf(FQCN, ERROR, null, streamProcessingFailed$str(), processName, error);
    }
    private static final String streamProcessingFailed = "WFLYPC0020: Stream processing failed for process '%s': %s";
    protected String streamProcessingFailed$str() {
        return streamProcessingFailed;
    }
    @Override
    public final void waitingToRestart(final int seconds, final String processName) {
        super.log.logf(FQCN, INFO, null, waitingToRestart$str(), seconds, processName);
    }
    private static final String waitingToRestart = "WFLYPC0021: Waiting %d seconds until trying to restart process %s.";
    protected String waitingToRestart$str() {
        return waitingToRestart;
    }
    @Override
    public final void failedToKillProcess(final String process) {
        super.log.logf(FQCN, WARN, null, failedToKillProcess$str(), process);
    }
    private static final String failedToKillProcess = "WFLYPC0022: Failed to kill process '%s', trying to destroy the process instead.";
    protected String failedToKillProcess$str() {
        return failedToKillProcess;
    }
    private static final String argUsage = "Usage: %s [args...]%nwhere args include:";
    protected String argUsage$str() {
        return argUsage;
    }
    @Override
    public final String argUsage(final String executableName) {
        return String.format(getLoggingLocale(), argUsage$str(), executableName);
    }
    private static final String argBackup = "Keep a copy of the persistent domain configuration even if this host is not the Domain Controller. If ignore-unused-configuration is unset in host.xml, then the complete domain configuration will be stored, otherwise the configured value of ignore-unused-configuration will be used.";
    protected String argBackup$str() {
        return argBackup;
    }
    @Override
    public final String argBackup() {
        return String.format(getLoggingLocale(), argBackup$str());
    }
    private static final String argCachedDc = "If this host is not the Domain Controller and cannot contact the Domain Controller at boot, a locally cached copy of the domain configuration is used for boot (if available, see --backup.) The Domain Controller is background polled until it becomes available. Note that starting a host with --cached-dc when the Domain Controller is available will cache a copy of the domain configuration even if --backup is not used.";
    protected String argCachedDc$str() {
        return argCachedDc;
    }
    @Override
    public final String argCachedDc() {
        return String.format(getLoggingLocale(), argCachedDc$str());
    }
    private static final String argDomainConfig = "Name of the domain configuration file to use (default is \"domain.xml\") (Same as -c)";
    protected String argDomainConfig$str() {
        return argDomainConfig;
    }
    @Override
    public final String argDomainConfig() {
        return String.format(getLoggingLocale(), argDomainConfig$str());
    }
    private static final String argShortDomainConfig = "Name of the domain configuration file to use (default is \"domain.xml\") (Same as --domain-config)";
    protected String argShortDomainConfig$str() {
        return argShortDomainConfig;
    }
    @Override
    public final String argShortDomainConfig() {
        return String.format(getLoggingLocale(), argShortDomainConfig$str());
    }
    private static final String argReadOnlyDomainConfig = "Name of the domain configuration file to use. This differs from '--domain-config', '-c' and '-domain-config' in that the initial file is never overwritten.";
    protected String argReadOnlyDomainConfig$str() {
        return argReadOnlyDomainConfig;
    }
    @Override
    public final String argReadOnlyDomainConfig() {
        return String.format(getLoggingLocale(), argReadOnlyDomainConfig$str());
    }
    private static final String argHelp = "Display this message and exit";
    protected String argHelp$str() {
        return argHelp;
    }
    @Override
    public final String argHelp() {
        return String.format(getLoggingLocale(), argHelp$str());
    }
    private static final String argInterProcessHcAddress = "Address on which the host controller should listen for communication from the process controller";
    protected String argInterProcessHcAddress$str() {
        return argInterProcessHcAddress;
    }
    @Override
    public final String argInterProcessHcAddress() {
        return String.format(getLoggingLocale(), argInterProcessHcAddress$str());
    }
    private static final String argInterProcessHcPort = "Port on which the host controller should listen for communication from the process controller";
    protected String argInterProcessHcPort$str() {
        return argInterProcessHcPort;
    }
    @Override
    public final String argInterProcessHcPort() {
        return String.format(getLoggingLocale(), argInterProcessHcPort$str());
    }
    private static final String argHostConfig = "Name of the host configuration file to use (default is \"host.xml\")";
    protected String argHostConfig$str() {
        return argHostConfig;
    }
    @Override
    public final String argHostConfig() {
        return String.format(getLoggingLocale(), argHostConfig$str());
    }
    private static final String argReadOnlyHostConfig = "Name of the host configuration file to use. This differs from '--host-config' in that the initial file is never overwritten.";
    protected String argReadOnlyHostConfig$str() {
        return argReadOnlyHostConfig;
    }
    @Override
    public final String argReadOnlyHostConfig() {
        return String.format(getLoggingLocale(), argReadOnlyHostConfig$str());
    }
    private static final String argPcAddress = "Address on which the process controller listens for communication from processes it controls";
    protected String argPcAddress$str() {
        return argPcAddress;
    }
    @Override
    public final String argPcAddress() {
        return String.format(getLoggingLocale(), argPcAddress$str());
    }
    private static final String argPcPort = "Port on which the process controller listens for communication from processes it controls";
    protected String argPcPort$str() {
        return argPcPort;
    }
    @Override
    public final String argPcPort() {
        return String.format(getLoggingLocale(), argPcPort$str());
    }
    private static final String argProperties = "Load system properties from the given url";
    protected String argProperties$str() {
        return argProperties;
    }
    @Override
    public final String argProperties() {
        return String.format(getLoggingLocale(), argProperties$str());
    }
    private static final String argSystem = "Set a system property";
    protected String argSystem$str() {
        return argSystem;
    }
    @Override
    public final String argSystem() {
        return String.format(getLoggingLocale(), argSystem$str());
    }
    private static final String argVersion = "Print version and exit";
    protected String argVersion$str() {
        return argVersion;
    }
    @Override
    public final String argVersion() {
        return String.format(getLoggingLocale(), argVersion$str());
    }
    private static final String argPublicBindAddress = "Set system property jboss.bind.address to the given value";
    protected String argPublicBindAddress$str() {
        return argPublicBindAddress;
    }
    @Override
    public final String argPublicBindAddress() {
        return String.format(getLoggingLocale(), argPublicBindAddress$str());
    }
    private static final String argInterfaceBindAddress = "Set system property jboss.bind.address.<interface> to the given value";
    protected String argInterfaceBindAddress$str() {
        return argInterfaceBindAddress;
    }
    @Override
    public final String argInterfaceBindAddress() {
        return String.format(getLoggingLocale(), argInterfaceBindAddress$str());
    }
    private static final String argDefaultMulticastAddress = "Set system property jboss.default.multicast.address to the given value";
    protected String argDefaultMulticastAddress$str() {
        return argDefaultMulticastAddress;
    }
    @Override
    public final String argDefaultMulticastAddress() {
        return String.format(getLoggingLocale(), argDefaultMulticastAddress$str());
    }
    private static final String argAdminOnly = "Set the host controller's running type to ADMIN_ONLY causing it to open administrative interfaces and accept management requests but not start servers or, if this host controller is the master for the domain, accept incoming connections from slave host controllers.";
    protected String argAdminOnly$str() {
        return argAdminOnly;
    }
    @Override
    public final String argAdminOnly() {
        return String.format(getLoggingLocale(), argAdminOnly$str());
    }
    private static final String argMasterAddress = "Set system property jboss.domain.master.address to the given value. In a default slave Host Controller config, this is used to configure the address of the master Host Controller.";
    protected String argMasterAddress$str() {
        return argMasterAddress;
    }
    @Override
    public final String argMasterAddress() {
        return String.format(getLoggingLocale(), argMasterAddress$str());
    }
    private static final String argMasterPort = "Set system property jboss.domain.master.port to the given value. In a default slave Host Controller config, this is used to configure the port used for native management communication by the master Host Controller.";
    protected String argMasterPort$str() {
        return argMasterPort;
    }
    @Override
    public final String argMasterPort() {
        return String.format(getLoggingLocale(), argMasterPort$str());
    }
    private static final String argSecMgr = "Runs the server with a security manager installed.";
    protected String argSecMgr$str() {
        return argSecMgr;
    }
    @Override
    public final String argSecMgr() {
        return String.format(getLoggingLocale(), argSecMgr$str());
    }
    private static final String noArgValue = "WFLYPC0023: No value was provided for argument %s";
    protected String noArgValue$str() {
        return noArgValue;
    }
    @Override
    public final String noArgValue(final String argument) {
        return String.format(getLoggingLocale(), noArgValue$str(), argument);
    }
    private static final String invalidAuthKeyLen = "WFLYPC0025: Authentication key must be 24 bytes long";
    protected String invalidAuthKeyLen$str() {
        return invalidAuthKeyLen;
    }
    @Override
    public final IllegalArgumentException invalidAuthKeyLen() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAuthKeyLen$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidLength = "WFLYPC0029: %s length is invalid";
    protected String invalidLength$str() {
        return invalidLength;
    }
    @Override
    public final IllegalArgumentException invalidLength(final String parameterName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidLength$str(), parameterName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidOption = "WFLYPC0030: Invalid option: %s";
    protected String invalidOption$str() {
        return invalidOption;
    }
    @Override
    public final IllegalArgumentException invalidOption(final String option) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidOption$str(), option));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullCommandComponent = "WFLYPC0031: Command contains a null component";
    protected String nullCommandComponent$str() {
        return nullCommandComponent;
    }
    @Override
    public final IllegalArgumentException nullCommandComponent() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullCommandComponent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedToAcceptConnection(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToAcceptConnection$str());
    }
    private static final String failedToAcceptConnection = "WFLYPC0033: Failed to accept a connection";
    protected String failedToAcceptConnection$str() {
        return failedToAcceptConnection;
    }
    @Override
    public final void failedToCloseResource(final Throwable cause, final Object resource) {
        super.log.logf(FQCN, ERROR, cause, failedToCloseResource$str(), resource);
    }
    private static final String failedToCloseResource = "WFLYPC0034: Failed to close resource %s";
    protected String failedToCloseResource$str() {
        return failedToCloseResource;
    }
    @Override
    public final void failedToCloseServerSocket(final Throwable cause, final ServerSocket socket) {
        super.log.logf(FQCN, ERROR, cause, failedToCloseServerSocket$str(), socket);
    }
    private static final String failedToCloseServerSocket = "WFLYPC0035: Failed to close the server socket %s";
    protected String failedToCloseServerSocket$str() {
        return failedToCloseServerSocket;
    }
    @Override
    public final void failedToCloseSocket(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToCloseSocket$str());
    }
    private static final String failedToCloseSocket = "WFLYPC0036: Failed to close a socket";
    protected String failedToCloseSocket$str() {
        return failedToCloseSocket;
    }
    @Override
    public final void failedToFinishMarshaller(final Throwable cause, final Marshaller marshaller) {
        super.log.logf(FQCN, ERROR, cause, failedToFinishMarshaller$str(), marshaller);
    }
    private static final String failedToFinishMarshaller = "WFLYPC0037: Failed to finish the marshaller %s";
    protected String failedToFinishMarshaller$str() {
        return failedToFinishMarshaller;
    }
    @Override
    public final void failedToFinishUnmarshaller(final Throwable cause, final Unmarshaller unmarshaller) {
        super.log.logf(FQCN, ERROR, cause, failedToFinishUnmarshaller$str(), unmarshaller);
    }
    private static final String failedToFinishUnmarshaller = "WFLYPC0038: Failed to finish the unmarshaller %s";
    protected String failedToFinishUnmarshaller$str() {
        return failedToFinishUnmarshaller;
    }
    @Override
    public final void failedToHandleIncomingConnection(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToHandleIncomingConnection$str());
    }
    private static final String failedToHandleIncomingConnection = "WFLYPC0039: Failed to handle incoming connection";
    protected String failedToHandleIncomingConnection$str() {
        return failedToHandleIncomingConnection;
    }
    @Override
    public final void failedToHandleSocketFailure(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToHandleSocketFailure$str());
    }
    private static final String failedToHandleSocketFailure = "WFLYPC0040: Failed to handle socket failure condition";
    protected String failedToHandleSocketFailure$str() {
        return failedToHandleSocketFailure;
    }
    @Override
    public final void failedToHandleSocketFinished(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToHandleSocketFinished$str());
    }
    private static final String failedToHandleSocketFinished = "WFLYPC0041: Failed to handle socket finished condition";
    protected String failedToHandleSocketFinished$str() {
        return failedToHandleSocketFinished;
    }
    @Override
    public final void failedToHandleSocketShutdown(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToHandleSocketShutdown$str());
    }
    private static final String failedToHandleSocketShutdown = "WFLYPC0042: Failed to handle socket shut down condition";
    protected String failedToHandleSocketShutdown$str() {
        return failedToHandleSocketShutdown;
    }
    @Override
    public final void failedToReadMessage(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToReadMessage$str());
    }
    private static final String failedToReadMessage = "WFLYPC0043: Failed to read a message";
    protected String failedToReadMessage$str() {
        return failedToReadMessage;
    }
    @Override
    public final void leakedMessageOutputStream() {
        super.log.logf(FQCN, WARN, null, leakedMessageOutputStream$str());
    }
    private static final String leakedMessageOutputStream = "WFLYPC0044: Leaked a message output stream; cleaning";
    protected String leakedMessageOutputStream$str() {
        return leakedMessageOutputStream;
    }
    private static final String failedToCreateServerThread = "WFLYPC0045: Failed to create server thread";
    protected String failedToCreateServerThread$str() {
        return failedToCreateServerThread;
    }
    @Override
    public final IOException failedToCreateServerThread() {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToCreateServerThread$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToReadObject = "WFLYPC0046: Failed to read object";
    protected String failedToReadObject$str() {
        return failedToReadObject;
    }
    @Override
    public final IOException failedToReadObject(final Throwable cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToReadObject$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidByte0 = "WFLYPC0047: Invalid byte";
    protected String invalidByte0$str() {
        return invalidByte0;
    }
    @Override
    public final UTFDataFormatException invalidByte() {
        final UTFDataFormatException result = new UTFDataFormatException(String.format(getLoggingLocale(), invalidByte0$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidByte2 = "WFLYPC0048: Invalid byte:%s(%d)";
    protected String invalidByte2$str() {
        return invalidByte2;
    }
    @Override
    public final UTFDataFormatException invalidByte(final char c, final int i) {
        final UTFDataFormatException result = new UTFDataFormatException(String.format(getLoggingLocale(), invalidByte2$str(), c, i));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidByteToken = "WFLYPC0049: Invalid byte token.  Expecting '%s' received '%s'";
    protected String invalidByteToken$str() {
        return invalidByteToken;
    }
    @Override
    public final IOException invalidByteToken(final int expected, final byte actual) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidByteToken$str(), expected, actual));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCommandByte = "WFLYPC0050: Invalid command byte read: %s";
    protected String invalidCommandByte$str() {
        return invalidCommandByte;
    }
    @Override
    public final IOException invalidCommandByte(final int commandByte) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidCommandByte$str(), commandByte));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidStartChunk = "WFLYPC0051: Invalid start chunk start [%s]";
    protected String invalidStartChunk$str() {
        return invalidStartChunk;
    }
    @Override
    public final IOException invalidStartChunk(final int chunk) {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidStartChunk$str(), chunk));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String readBytes = "WFLYPC0056: Read %d bytes.";
    protected String readBytes$str() {
        return readBytes;
    }
    @Override
    public final EOFException readBytes(final int bytesRead) {
        final EOFException result = new EOFException(String.format(getLoggingLocale(), readBytes$str(), bytesRead));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String streamClosed = "WFLYPC0058: Stream closed";
    protected String streamClosed$str() {
        return streamClosed;
    }
    @Override
    public final IOException streamClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), streamClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String threadCreationRefused = "WFLYPC0059: Thread creation was refused";
    protected String threadCreationRefused$str() {
        return threadCreationRefused;
    }
    @Override
    public final IllegalStateException threadCreationRefused() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), threadCreationRefused$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedEndOfStream = "WFLYPC0060: Unexpected end of stream";
    protected String unexpectedEndOfStream$str() {
        return unexpectedEndOfStream;
    }
    @Override
    public final EOFException unexpectedEndOfStream() {
        final EOFException result = new EOFException(String.format(getLoggingLocale(), unexpectedEndOfStream$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String writeChannelClosed = "WFLYPC0061: Write channel closed";
    protected String writeChannelClosed$str() {
        return writeChannelClosed;
    }
    @Override
    public final IOException writeChannelClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), writeChannelClosed$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String writesAlreadyShutdown = "WFLYPC0062: Writes are already shut down";
    protected String writesAlreadyShutdown$str() {
        return writesAlreadyShutdown;
    }
    @Override
    public final IOException writesAlreadyShutdown() {
        final IOException result = new IOException(String.format(getLoggingLocale(), writesAlreadyShutdown$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void attemptingToKillProcess(final String process, final long timeout) {
        super.log.logf(FQCN, INFO, null, attemptingToKillProcess$str(), process, timeout);
    }
    private static final String attemptingToKillProcess = "WFLYPC0063: Process '%s' did not complete normal stop within %d ms; attempting to kill process using OS calls";
    protected String attemptingToKillProcess$str() {
        return attemptingToKillProcess;
    }
    @Override
    public final void jpsCommandNotFound(final String process) {
        super.log.logf(FQCN, INFO, null, jpsCommandNotFound$str(), process);
    }
    private static final String jpsCommandNotFound = "WFLYPC0064: Cannot locate process '%s' -- could not find the 'jps' command";
    protected String jpsCommandNotFound$str() {
        return jpsCommandNotFound;
    }
    @Override
    public final void processNotFound(final String process) {
        super.log.logf(FQCN, INFO, null, processNotFound$str(), process);
    }
    private static final String processNotFound = "WFLYPC0065: No process identifiable as '%s' could be found";
    protected String processNotFound$str() {
        return processNotFound;
    }
    @Override
    public final void multipleProcessesFound(final String process) {
        super.log.logf(FQCN, INFO, null, multipleProcessesFound$str(), process);
    }
    private static final String multipleProcessesFound = "WFLYPC0066: Multiple processes identifiable as '%s' found; OS level kill cannot be safely performed";
    protected String multipleProcessesFound$str() {
        return multipleProcessesFound;
    }
    @Override
    public final void destroyingProcess(final String process, final long timeout) {
        super.log.logf(FQCN, INFO, null, destroyingProcess$str(), process, timeout);
    }
    private static final String destroyingProcess = "WFLYPC0067: Process '%s' did not complete normal stop within %d ms; attempting to destroy process using java.lang.Process.destroyForcibly()";
    protected String destroyingProcess$str() {
        return destroyingProcess;
    }
}
