package org.jboss.as.patching.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.ContentConflictsException;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.as.patching.validation.PatchingArtifact.ArtifactState;
import org.jboss.as.controller.OperationFailedException;
import java.lang.String;
import java.io.IOException;
import java.io.SyncFailedException;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import org.jboss.as.patching.metadata.ContentItem;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-06-26T14:54:29+0000")
public class PatchLogger_$logger extends DelegatingBasicLogger implements PatchLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = PatchLogger_$logger.class.getName();
    public PatchLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotDeleteFile(final String name) {
        super.log.logf(FQCN, WARN, null, cannotDeleteFile$str(), name);
    }
    private static final String cannotDeleteFile = "WFLYPAT0001: Cannot delete file %s";
    protected String cannotDeleteFile$str() {
        return cannotDeleteFile;
    }
    @Override
    public final void cannotInvalidateZip(final String name) {
        super.log.logf(FQCN, WARN, null, cannotInvalidateZip$str(), name);
    }
    private static final String cannotInvalidateZip = "WFLYPAT0002: Cannot invalidate %s";
    protected String cannotInvalidateZip$str() {
        return cannotInvalidateZip;
    }
    private static final String detectedConflicts = "Conflicts detected";
    protected String detectedConflicts$str() {
        return detectedConflicts;
    }
    @Override
    public final String detectedConflicts() {
        return String.format(getLoggingLocale(), detectedConflicts$str());
    }
    private static final String cliFailedToResolveDistribution = "failed to resolve a jboss.home.dir use the --distribution attribute to point to a valid installation";
    protected String cliFailedToResolveDistribution$str() {
        return cliFailedToResolveDistribution;
    }
    @Override
    public final IllegalStateException cliFailedToResolveDistribution() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cliFailedToResolveDistribution$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String installationNoLayersConfigFound = "No layers directory found at %s";
    protected String installationNoLayersConfigFound$str() {
        return installationNoLayersConfigFound;
    }
    @Override
    public final IllegalStateException installationNoLayersConfigFound(final String path) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), installationNoLayersConfigFound$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String installationMissingLayer = "Cannot find layer '%s' under directory %s";
    protected String installationMissingLayer$str() {
        return installationMissingLayer;
    }
    @Override
    public final IllegalStateException installationMissingLayer(final String layer, final String path) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), installationMissingLayer$str(), layer, path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String installationInvalidLayerConfiguration = "no associated module or bundle repository with layer '%s'";
    protected String installationInvalidLayerConfiguration$str() {
        return installationInvalidLayerConfiguration;
    }
    @Override
    public final IllegalStateException installationInvalidLayerConfiguration(final String layerName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), installationInvalidLayerConfiguration$str(), layerName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String installationDuplicateLayer = "Duplicate %s '%s'";
    protected String installationDuplicateLayer$str() {
        return installationDuplicateLayer;
    }
    @Override
    public final IllegalStateException installationDuplicateLayer(final String type, final String layer) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), installationDuplicateLayer$str(), type, layer));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notADirectory = "Not a directory %s";
    protected String notADirectory$str() {
        return notADirectory;
    }
    @Override
    public final IllegalStateException notADirectory(final String path) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notADirectory$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchTypesDontMatch = "patch types don't match";
    protected String patchTypesDontMatch$str() {
        return patchTypesDontMatch;
    }
    @Override
    public final IllegalStateException patchTypesDontMatch() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), patchTypesDontMatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidRollbackInformation = "invalid rollback information";
    protected String invalidRollbackInformation$str() {
        return invalidRollbackInformation;
    }
    @Override
    public final PatchingException invalidRollbackInformation() {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), invalidRollbackInformation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String doesNotApply = "WFLYPAT0003: Patch does not apply - expected (%s), but was (%s)";
    protected String doesNotApply$str() {
        return doesNotApply;
    }
    @Override
    public final PatchingException doesNotApply(final String appliesTo, final String version) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), doesNotApply$str(), appliesTo, version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToDelete = "WFLYPAT0004: Failed to delete (%s)";
    protected String failedToDelete$str() {
        return failedToDelete;
    }
    @Override
    public final IOException failedToDelete(final String path) {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToDelete$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateDirectory = "WFLYPAT0005: Failed to create directory (%s)";
    protected String cannotCreateDirectory$str() {
        return cannotCreateDirectory;
    }
    @Override
    public final IOException cannotCreateDirectory(final String path) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotCreateDirectory$str(), path));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String fileDoesNotExist = "WFLYPAT0008: File at path specified by argument %s does not exist";
    protected String fileDoesNotExist$str() {
        return fileDoesNotExist;
    }
    @Override
    public final String fileDoesNotExist(final String arg) {
        return String.format(getLoggingLocale(), fileDoesNotExist$str(), arg);
    }
    private static final String cannotRollbackPatch = "WFLYPAT0011: Cannot rollback patch (%s)";
    protected String cannotRollbackPatch$str() {
        return cannotRollbackPatch;
    }
    @Override
    public final PatchingException cannotRollbackPatch(final String id) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), cannotRollbackPatch$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String alreadyApplied = "WFLYPAT0012: Patch '%s' already applied";
    protected String alreadyApplied$str() {
        return alreadyApplied;
    }
    @Override
    public final PatchingException alreadyApplied(final String patchId) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), alreadyApplied$str(), patchId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchLayer = "WFLYPAT0013: There is no layer called %s installed";
    protected String noSuchLayer$str() {
        return noSuchLayer;
    }
    @Override
    public final PatchingException noSuchLayer(final String name) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), noSuchLayer$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToResolvePatch = "WFLYPAT0014: Failed to resolve a valid patch descriptor for %s %s";
    protected String failedToResolvePatch$str() {
        return failedToResolvePatch;
    }
    @Override
    public final PatchingException failedToResolvePatch(final String product, final String version) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), failedToResolvePatch$str(), product, version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiresPatch = "WFLYPAT0015: Requires patch '%s'";
    protected String requiresPatch$str() {
        return requiresPatch;
    }
    @Override
    public final PatchingException requiresPatch(final String patchId) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), requiresPatch$str(), patchId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String incompatiblePatch = "WFLYPAT0016: Patch is incompatible with patch '%s'";
    protected String incompatiblePatch$str() {
        return incompatiblePatch;
    }
    @Override
    public final PatchingException incompatiblePatch(final String patchId) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), incompatiblePatch$str(), patchId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String conflictsDetected = "WFLYPAT0017: Conflicts detected";
    protected String conflictsDetected$str() {
        return conflictsDetected;
    }
    @Override
    public final ContentConflictsException conflictsDetected(final java.util.Collection<ContentItem> conflicts) {
        final ContentConflictsException result = new ContentConflictsException(String.format(getLoggingLocale(), conflictsDetected$str()), conflicts);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongCopiedContent = "WFLYPAT0018: copied content does not match expected hash for item: %s";
    protected String wrongCopiedContent$str() {
        return wrongCopiedContent;
    }
    @Override
    public final SyncFailedException wrongCopiedContent(final ContentItem item) {
        final SyncFailedException result = new SyncFailedException(String.format(getLoggingLocale(), wrongCopiedContent$str(), item));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalPatchName = "WFLYPAT0019: invalid patch name '%s'";
    protected String illegalPatchName$str() {
        return illegalPatchName;
    }
    @Override
    public final IllegalArgumentException illegalPatchName(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalPatchName$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPatchesApplied = "WFLYPAT0020: Cannot rollback. No patches applied.";
    protected String noPatchesApplied$str() {
        return noPatchesApplied;
    }
    @Override
    public final IllegalArgumentException noPatchesApplied() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noPatchesApplied$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String patchNotFoundInHistory = "WFLYPAT0021: Patch '%s' not found in history.";
    protected String patchNotFoundInHistory$str() {
        return patchNotFoundInHistory;
    }
    @Override
    public final PatchingException patchNotFoundInHistory(final String patchId) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), patchNotFoundInHistory$str(), patchId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToShowHistory = "WFLYPAT0023: Failed to show history of patches";
    protected String failedToShowHistory$str() {
        return failedToShowHistory;
    }
    @Override
    public final OperationFailedException failedToShowHistory(final Throwable cause) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), failedToShowHistory$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String serverRequiresRestart = "WFLYPAT0024: Unable to apply or rollback a patch when the server is in a restart-required state.";
    protected String serverRequiresRestart$str() {
        return serverRequiresRestart;
    }
    @Override
    public final OperationFailedException serverRequiresRestart() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), serverRequiresRestart$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadIdentity = "WFLYPAT0025: failed to load identity info";
    protected String failedToLoadIdentity$str() {
        return failedToLoadIdentity;
    }
    @Override
    public final String failedToLoadIdentity() {
        return String.format(getLoggingLocale(), failedToLoadIdentity$str());
    }
    private static final String noMorePatches = "WFLYPAT0026: No more patches";
    protected String noMorePatches$str() {
        return noMorePatches;
    }
    @Override
    public final String noMorePatches() {
        return String.format(getLoggingLocale(), noMorePatches$str());
    }
    private static final String noPatchHistory = "WFLYPAT0027: No patch history %s";
    protected String noPatchHistory$str() {
        return noPatchHistory;
    }
    @Override
    public final String noPatchHistory(final String path) {
        return String.format(getLoggingLocale(), noPatchHistory$str(), path);
    }
    private static final String patchIsMissingFile = "WFLYPAT0028: Patch is missing file %s";
    protected String patchIsMissingFile$str() {
        return patchIsMissingFile;
    }
    @Override
    public final String patchIsMissingFile(final String path) {
        return String.format(getLoggingLocale(), patchIsMissingFile$str(), path);
    }
    private static final String fileIsNotReadable = "WFLYPAT0029: File is not readable %s";
    protected String fileIsNotReadable$str() {
        return fileIsNotReadable;
    }
    @Override
    public final String fileIsNotReadable(final String path) {
        return String.format(getLoggingLocale(), fileIsNotReadable$str(), path);
    }
    private static final String layerNotFound = "WFLYPAT0030: Layer not found %s";
    protected String layerNotFound$str() {
        return layerNotFound;
    }
    @Override
    public final String layerNotFound(final String name) {
        return String.format(getLoggingLocale(), layerNotFound$str(), name);
    }
    @Override
    public final void failedToUndoChange(final String name) {
        super.log.logf(FQCN, ERROR, null, failedToUndoChange$str(), name);
    }
    private static final String failedToUndoChange = "WFLYPAT0031: failed to undo change for: '%s'";
    protected String failedToUndoChange$str() {
        return failedToUndoChange;
    }
    private static final String missingArtifact = "WFLYPAT0032: missing: '%s'";
    protected String missingArtifact$str() {
        return missingArtifact;
    }
    @Override
    public final String missingArtifact(final ArtifactState state) {
        return String.format(getLoggingLocale(), missingArtifact$str(), state);
    }
    private static final String inconsistentArtifact = "WFLYPAT0033: inconsistent state: '%s'";
    protected String inconsistentArtifact$str() {
        return inconsistentArtifact;
    }
    @Override
    public final String inconsistentArtifact(final ArtifactState state) {
        return String.format(getLoggingLocale(), inconsistentArtifact$str(), state);
    }
    private static final String artifactInError = "WFLYPAT0034: in error: '%s'";
    protected String artifactInError$str() {
        return artifactInError;
    }
    @Override
    public final String artifactInError(final ArtifactState state) {
        return String.format(getLoggingLocale(), artifactInError$str(), state);
    }
    @Override
    public final void cannotRenameFile(final String name) {
        super.log.logf(FQCN, WARN, null, cannotRenameFile$str(), name);
    }
    private static final String cannotRenameFile = "WFLYPAT0035: Cannot rename file %s";
    protected String cannotRenameFile$str() {
        return cannotRenameFile;
    }
    private static final String cannotRenameFileDuringBackup = "WFLYPAT0036: Cannot process backup by renaming file %s";
    protected String cannotRenameFileDuringBackup$str() {
        return cannotRenameFileDuringBackup;
    }
    @Override
    public final IllegalStateException cannotRenameFileDuringBackup(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotRenameFileDuringBackup$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotRenameFileDuringRestore = "WFLYPAT0037: Cannot process restore by renaming file %s";
    protected String cannotRenameFileDuringRestore$str() {
        return cannotRenameFileDuringRestore;
    }
    @Override
    public final IllegalStateException cannotRenameFileDuringRestore(final String name) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotRenameFileDuringRestore$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateElementPatchId = "WFLYPAT0038: Duplicate element patch-id (%s)";
    protected String duplicateElementPatchId$str() {
        return duplicateElementPatchId;
    }
    @Override
    public final IllegalStateException duplicateElementPatchId(final String id) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), duplicateElementPatchId$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String productVersionDidNotMatchInstalled = "WFLYPAT0039: Requested %s version %s did not match the installed version %s";
    protected String productVersionDidNotMatchInstalled$str() {
        return productVersionDidNotMatchInstalled;
    }
    @Override
    public final String productVersionDidNotMatchInstalled(final String product, final String expected, final String installed) {
        return String.format(getLoggingLocale(), productVersionDidNotMatchInstalled$str(), product, expected, installed);
    }
    private static final String failedToLoadInfo = "WFLYPAT0040: failed to load %s info";
    protected String failedToLoadInfo$str() {
        return failedToLoadInfo;
    }
    @Override
    public final String failedToLoadInfo(final String name) {
        return String.format(getLoggingLocale(), failedToLoadInfo$str(), name);
    }
    private static final String patchIdFoundInMoreThanOneStream = "WFLYPAT0041: Patch %s found in more than one stream: %s and %s";
    protected String patchIdFoundInMoreThanOneStream$str() {
        return patchIdFoundInMoreThanOneStream;
    }
    @Override
    public final String patchIdFoundInMoreThanOneStream(final String id, final String stream1, final String stream2) {
        return String.format(getLoggingLocale(), patchIdFoundInMoreThanOneStream$str(), id, stream1, stream2);
    }
    private static final String patchBundleIsEmpty = "WFLYPAT0042: Patch bundle is empty";
    protected String patchBundleIsEmpty$str() {
        return patchBundleIsEmpty;
    }
    @Override
    public final String patchBundleIsEmpty() {
        return String.format(getLoggingLocale(), patchBundleIsEmpty$str());
    }
    private static final String contentItemTypeMissing = "WFLYPAT0043: Content item type is missing in '%s'";
    protected String contentItemTypeMissing$str() {
        return contentItemTypeMissing;
    }
    @Override
    public final PatchingException contentItemTypeMissing(final String condition) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), contentItemTypeMissing$str(), condition));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedContentType = "WFLYPAT0044: Unsupported content type '%s'";
    protected String unsupportedContentType$str() {
        return unsupportedContentType;
    }
    @Override
    public final String unsupportedContentType(final String type) {
        return String.format(getLoggingLocale(), unsupportedContentType$str(), type);
    }
    private static final String unrecognizedConditionFormat = "WFLYPAT0045: Unrecognized condition format '%s'";
    protected String unrecognizedConditionFormat$str() {
        return unrecognizedConditionFormat;
    }
    @Override
    public final PatchingException unrecognizedConditionFormat(final String condition) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), unrecognizedConditionFormat$str(), condition));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCopyFilesToTempDir = "WFLYPAT0046: Cannot copy files to temporary directory %s: %s. Note that '-Djava.io.tmpdir' switch can be used to set different temporary directory.";
    protected String cannotCopyFilesToTempDir$str() {
        return cannotCopyFilesToTempDir;
    }
    @Override
    public final PatchingException cannotCopyFilesToTempDir(final String tempDir, final String reason, final Throwable cause) {
        final PatchingException result = new PatchingException(String.format(getLoggingLocale(), cannotCopyFilesToTempDir$str(), tempDir, reason), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCopyFiles = "WFLYPAT0047: Cannot copy files from %s to %s: %s";
    protected String cannotCopyFiles$str() {
        return cannotCopyFiles;
    }
    @Override
    public final IOException cannotCopyFiles(final String from, final String to, final String reason, final Throwable cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotCopyFiles$str(), from, to, reason), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void deleteRollbackError(final String path, final String message) {
        super.log.logf(FQCN, ERROR, null, deleteRollbackError$str(), path, message);
    }
    private static final String deleteRollbackError = "WFLYPAT0048: Error when restoring file[%s] - %s";
    protected String deleteRollbackError$str() {
        return deleteRollbackError;
    }
    private static final String failedToDeleteBackup = "WFLYPAT0049: Some backup files were not removed.";
    protected String failedToDeleteBackup$str() {
        return failedToDeleteBackup;
    }
    @Override
    public final IOException failedToDeleteBackup() {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToDeleteBackup$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void logPatchingInfo(final String identityName, final String cp, final String patches) {
        super.log.logf(FQCN, INFO, null, logPatchingInfo$str(), identityName, cp, patches);
    }
    private static final String logPatchingInfo = "WFLYPAT0050: %s cumulative patch ID is: %s, one-off patches include: %s";
    protected String logPatchingInfo$str() {
        return logPatchingInfo;
    }
}
