package org.wildfly.iiop.openjdk.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.net.MalformedURLException;
import org.jboss.logging.DelegatingBasicLogger;
import org.wildfly.iiop.openjdk.rmi.ir.IRConstructionException;
import java.lang.String;
import org.jboss.logging.Logger;
import org.omg.CORBA.BAD_INV_ORDER;
import java.lang.RuntimeException;
import javax.naming.InvalidNameException;
import javax.naming.ConfigurationException;
import org.jboss.logging.BasicLogger;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import javax.naming.NamingException;
import org.jboss.msc.service.StartException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import org.omg.CORBA.NO_PERMISSION;
import javax.annotation.Generated;
import org.jboss.as.controller.OperationFailedException;
import org.omg.CORBA.MARSHAL;
import java.io.IOException;
import java.lang.Exception;
import java.lang.Throwable;
import java.lang.Object;
import org.wildfly.iiop.openjdk.rmi.RMIIIOPViolationException;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-07-22T08:29:40+0000")
public class IIOPLogger_$logger extends DelegatingBasicLogger implements IIOPLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = IIOPLogger_$logger.class.getName();
    public IIOPLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void activatingSubsystem() {
        super.log.logf(FQCN, INFO, null, activatingSubsystem$str());
    }
    private static final String activatingSubsystem = "WFLYIIOP0001: Activating IIOP Subsystem";
    protected String activatingSubsystem$str() {
        return activatingSubsystem;
    }
    @Override
    public final void failedToFetchCSIv2Policy(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, failedToFetchCSIv2Policy$str());
    }
    private static final String failedToFetchCSIv2Policy = "WFLYIIOP0002: Error fetching CSIv2Policy";
    protected String failedToFetchCSIv2Policy$str() {
        return failedToFetchCSIv2Policy;
    }
    @Override
    public final void caughtExceptionEncodingGSSUPMechOID(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, caughtExceptionEncodingGSSUPMechOID$str());
    }
    private static final String caughtExceptionEncodingGSSUPMechOID = "WFLYIIOP0003: Caught exception while encoding GSSUPMechOID";
    protected String caughtExceptionEncodingGSSUPMechOID$str() {
        return caughtExceptionEncodingGSSUPMechOID;
    }
    @Override
    public final void logInternalError(final Exception cause) {
        super.log.logf(FQCN, ERROR, cause, logInternalError$str());
    }
    private static final String logInternalError = "WFLYIIOP0004: Internal error";
    protected String logInternalError$str() {
        return logInternalError;
    }
    @Override
    public final void failedToCreateNamingContext(final Exception cause) {
        super.log.logf(FQCN, ERROR, cause, failedToCreateNamingContext$str());
    }
    private static final String failedToCreateNamingContext = "WFLYIIOP0005: Failed to create CORBA naming context";
    protected String failedToCreateNamingContext$str() {
        return failedToCreateNamingContext;
    }
    @Override
    public final void failedToUnbindObject(final Object name) {
        super.log.logf(FQCN, WARN, null, failedToUnbindObject$str(), name);
    }
    private static final String failedToUnbindObject = "WFLYIIOP0006: Unbind failed for %s";
    protected String failedToUnbindObject$str() {
        return failedToUnbindObject;
    }
    @Override
    public final void failedToObtainJSSEDomain(final String securityDomain) {
        super.log.logf(FQCN, ERROR, null, failedToObtainJSSEDomain$str(), securityDomain);
    }
    private static final String failedToObtainJSSEDomain = "WFLYIIOP0007: Failed to obtain JSSE security domain with name %s";
    protected String failedToObtainJSSEDomain$str() {
        return failedToObtainJSSEDomain;
    }
    @Override
    public final void corbaNamingServiceStarted() {
        super.log.logf(FQCN, INFO, null, corbaNamingServiceStarted$str());
    }
    private static final String corbaNamingServiceStarted = "WFLYIIOP0008: CORBA Naming Service started";
    protected String corbaNamingServiceStarted$str() {
        return corbaNamingServiceStarted;
    }
    @Override
    public final void corbaORBServiceStarted() {
        super.log.logf(FQCN, INFO, null, corbaORBServiceStarted$str());
    }
    private static final String corbaORBServiceStarted = "WFLYIIOP0009: CORBA ORB Service started";
    protected String corbaORBServiceStarted$str() {
        return corbaORBServiceStarted;
    }
    @Override
    public final void warnClassDescDoesNotConformToSpec() {
        super.log.logf(FQCN, WARN, null, warnClassDescDoesNotConformToSpec$str());
    }
    private static final String warnClassDescDoesNotConformToSpec = "WFLYIIOP0010: Compatibility problem: Class javax.rmi.CORBA.ClassDesc does not conform to the Java(TM) Language to IDL Mapping Specification (01-06-07), section 1.3.5.11";
    protected String warnClassDescDoesNotConformToSpec$str() {
        return warnClassDescDoesNotConformToSpec;
    }
    @Override
    public final void warnCouldNotDeactivateIRObject(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, warnCouldNotDeactivateIRObject$str());
    }
    private static final String warnCouldNotDeactivateIRObject = "WFLYIIOP0011: Could not deactivate IR object";
    protected String warnCouldNotDeactivateIRObject$str() {
        return warnCouldNotDeactivateIRObject;
    }
    @Override
    public final void warnCouldNotDeactivateAnonIRObject(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, warnCouldNotDeactivateAnonIRObject$str());
    }
    private static final String warnCouldNotDeactivateAnonIRObject = "WFLYIIOP0012: Could not deactivate anonymous IR object";
    protected String warnCouldNotDeactivateAnonIRObject$str() {
        return warnCouldNotDeactivateAnonIRObject;
    }
    private static final String noSecurityDomainOrSSLContextsSpecified = "WFLYIIOP0013: SSL support has been enabled but no security domain or client/server SSL contexts have been specified";
    protected String noSecurityDomainOrSSLContextsSpecified$str() {
        return noSecurityDomainOrSSLContextsSpecified;
    }
    @Override
    public final OperationFailedException noSecurityDomainOrSSLContextsSpecified() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), noSecurityDomainOrSSLContextsSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedException = "WFLYIIOP0014: Unexpected exception";
    protected String unexpectedException$str() {
        return unexpectedException;
    }
    @Override
    public final RuntimeException unexpectedException(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unexpectedException$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedContextErrorInSASReply = "WFLYIIOP0015: Unexpected ContextError in SAS reply";
    protected String unexpectedContextErrorInSASReply$str() {
        return unexpectedContextErrorInSASReply;
    }
    @Override
    public final NO_PERMISSION unexpectedContextErrorInSASReply(final int minorCode, final CompletionStatus status) {
        final NO_PERMISSION result = new NO_PERMISSION(String.format(getLoggingLocale(), unexpectedContextErrorInSASReply$str()), minorCode, status);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorParsingSASReply = "WFLYIIOP0016: Could not parse SAS reply: %s";
    protected String errorParsingSASReply$str() {
        return errorParsingSASReply;
    }
    @Override
    public final MARSHAL errorParsingSASReply(final Exception e, final int minorCode, final CompletionStatus status) {
        final MARSHAL result = new MARSHAL(String.format(getLoggingLocale(), errorParsingSASReply$str(), e), minorCode, status);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorRegisteringSASCurrentInitRef = "WFLYIIOP0017: Could not register initial reference for SASCurrent";
    protected String errorRegisteringSASCurrentInitRef$str() {
        return errorRegisteringSASCurrentInitRef;
    }
    @Override
    public final RuntimeException errorRegisteringSASCurrentInitRef(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorRegisteringSASCurrentInitRef$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingSASContext = "WFLYIIOP0018: SAS context does not exist";
    protected String missingSASContext$str() {
        return missingSASContext;
    }
    @Override
    public final NO_PERMISSION missingSASContext() {
        final NO_PERMISSION result = new NO_PERMISSION(String.format(getLoggingLocale(), missingSASContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorDecodingInitContextToken = "WFLYIIOP0019: Could not decode initial context token";
    protected String errorDecodingInitContextToken$str() {
        return errorDecodingInitContextToken;
    }
    @Override
    public final NO_PERMISSION errorDecodingInitContextToken() {
        final NO_PERMISSION result = new NO_PERMISSION(String.format(getLoggingLocale(), errorDecodingInitContextToken$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorDecodingTargetInContextToken = "WFLYIIOP0020: Could not decode target name in initial context token";
    protected String errorDecodingTargetInContextToken$str() {
        return errorDecodingTargetInContextToken;
    }
    @Override
    public final NO_PERMISSION errorDecodingTargetInContextToken() {
        final NO_PERMISSION result = new NO_PERMISSION(String.format(getLoggingLocale(), errorDecodingTargetInContextToken$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorDecodingPrincipalName = "WFLYIIOP0021: Could not decode incoming principal name";
    protected String errorDecodingPrincipalName$str() {
        return errorDecodingPrincipalName;
    }
    @Override
    public final NO_PERMISSION errorDecodingPrincipalName() {
        final NO_PERMISSION result = new NO_PERMISSION(String.format(getLoggingLocale(), errorDecodingPrincipalName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorDecodingContextData = "WFLYIIOP0022: Exception decoding context data in %s";
    protected String errorDecodingContextData$str() {
        return errorDecodingContextData;
    }
    @Override
    public final RuntimeException errorDecodingContextData(final String interceptorName, final Throwable e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorDecodingContextData$str(), interceptorName), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalBatchSize = "WFLYIIOP0023: Batch size not numeric: %s";
    protected String illegalBatchSize$str() {
        return illegalBatchSize;
    }
    @Override
    public final IllegalArgumentException illegalBatchSize(final String batch) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalBatchSize$str(), batch));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorGettingBindingList = "WFLYIIOP0024: Error getting binding list";
    protected String errorGettingBindingList$str() {
        return errorGettingBindingList;
    }
    @Override
    public final NamingException errorGettingBindingList() {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), errorGettingBindingList$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorGeneratingObjectViaFactory = "WFLYIIOP0025: Error generating object via object factory";
    protected String errorGeneratingObjectViaFactory$str() {
        return errorGeneratingObjectViaFactory;
    }
    @Override
    public final NamingException errorGeneratingObjectViaFactory() {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), errorGeneratingObjectViaFactory$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorConstructingCNCtx = "WFLYIIOP0026: Error constructing context: either ORB or NamingContext must be supplied";
    protected String errorConstructingCNCtx$str() {
        return errorConstructingCNCtx;
    }
    @Override
    public final ConfigurationException errorConstructingCNCtx() {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), errorConstructingCNCtx$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notANamingContext = "WFLYIIOP0027: %s does not name a NamingContext";
    protected String notANamingContext$str() {
        return notANamingContext;
    }
    @Override
    public final ConfigurationException notANamingContext(final String name) {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), notANamingContext$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorConvertingIORToNamingCtx = "WFLYIIOP0028: Cannot convert IOR to NamingContext: %s";
    protected String errorConvertingIORToNamingCtx$str() {
        return errorConvertingIORToNamingCtx;
    }
    @Override
    public final ConfigurationException errorConvertingIORToNamingCtx(final String ior) {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), errorConvertingIORToNamingCtx$str(), ior));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorResolvingNSInitRef = "WFLYIIOP0029: ORB.resolve_initial_references(\"NameService\") does not return a NamingContext";
    protected String errorResolvingNSInitRef$str() {
        return errorResolvingNSInitRef;
    }
    @Override
    public final ConfigurationException errorResolvingNSInitRef() {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), errorResolvingNSInitRef$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cosNamingNotRegisteredCorrectly = "WFLYIIOP0030: COS Name Service not registered with ORB under the name 'NameService'";
    protected String cosNamingNotRegisteredCorrectly$str() {
        return cosNamingNotRegisteredCorrectly;
    }
    @Override
    public final NamingException cosNamingNotRegisteredCorrectly() {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), cosNamingNotRegisteredCorrectly$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorConnectingToORB = "WFLYIIOP0031: Cannot connect to ORB";
    protected String errorConnectingToORB$str() {
        return errorConnectingToORB;
    }
    @Override
    public final NamingException errorConnectingToORB() {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), errorConnectingToORB$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidURLOrIOR = "WFLYIIOP0032: Invalid IOR or URL: %s";
    protected String invalidURLOrIOR$str() {
        return invalidURLOrIOR;
    }
    @Override
    public final NamingException invalidURLOrIOR(final String ior) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), invalidURLOrIOR$str(), ior));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidObjectReference = "WFLYIIOP0033: Invalid object reference:  %s";
    protected String invalidObjectReference$str() {
        return invalidObjectReference;
    }
    @Override
    public final NamingException invalidObjectReference(final String ior) {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), invalidObjectReference$str(), ior));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String urlDoesNotContainIOR = "WFLYIIOP0034: %s does not contain an IOR";
    protected String urlDoesNotContainIOR$str() {
        return urlDoesNotContainIOR;
    }
    @Override
    public final ConfigurationException urlDoesNotContainIOR(final String url) {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), urlDoesNotContainIOR$str(), url));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notACorbaObject = "WFLYIIOP0035: Only instances of org.omg.CORBA.Object can be bound";
    protected String notACorbaObject$str() {
        return notACorbaObject;
    }
    @Override
    public final IllegalArgumentException notACorbaObject() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notACorbaObject$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noReferenceFound = "WFLYIIOP0036: No object reference bound for specified name";
    protected String noReferenceFound$str() {
        return noReferenceFound;
    }
    @Override
    public final NamingException noReferenceFound() {
        final NamingException result = new NamingException(String.format(getLoggingLocale(), noReferenceFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEmptyName = "WFLYIIOP0037: Invalid empty name";
    protected String invalidEmptyName$str() {
        return invalidEmptyName;
    }
    @Override
    public final InvalidNameException invalidEmptyName() {
        final InvalidNameException result = new InvalidNameException(String.format(getLoggingLocale(), invalidEmptyName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unescapedCharacter = "WFLYIIOP0038: %s: unescaped \\ at end of component";
    protected String unescapedCharacter$str() {
        return unescapedCharacter;
    }
    @Override
    public final InvalidNameException unescapedCharacter(final String cnString) {
        final InvalidNameException result = new InvalidNameException(String.format(getLoggingLocale(), unescapedCharacter$str(), cnString));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidEscapedCharacter = "WFLYIIOP0039: %s: Invalid character being escaped";
    protected String invalidEscapedCharacter$str() {
        return invalidEscapedCharacter;
    }
    @Override
    public final InvalidNameException invalidEscapedCharacter(final String cnString) {
        final InvalidNameException result = new InvalidNameException(String.format(getLoggingLocale(), invalidEscapedCharacter$str(), cnString));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidURL = "WFLYIIOP0040: Invalid %s URL: %s";
    protected String invalidURL$str() {
        return invalidURL;
    }
    @Override
    public final MalformedURLException invalidURL(final String protocol, final String url) {
        final MalformedURLException result = new MalformedURLException(String.format(getLoggingLocale(), invalidURL$str(), protocol, url));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String problemInvokingPortableRemoteObjectToStub = "WFLYIIOP0041: Problem with PortableRemoteObject.toStub(); object not exported or stub not found";
    protected String problemInvokingPortableRemoteObjectToStub$str() {
        return problemInvokingPortableRemoteObjectToStub;
    }
    @Override
    public final ConfigurationException problemInvokingPortableRemoteObjectToStub() {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), problemInvokingPortableRemoteObjectToStub$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInvokePortableRemoteObjectToStub = "WFLYIIOP0042: Cannot invoke javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)";
    protected String cannotInvokePortableRemoteObjectToStub$str() {
        return cannotInvokePortableRemoteObjectToStub;
    }
    @Override
    public final ConfigurationException cannotInvokePortableRemoteObjectToStub() {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), cannotInvokePortableRemoteObjectToStub$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noMethodDefForPortableRemoteObjectToStub = "WFLYIIOP0043: No method definition for javax.rmi.PortableRemoteObject.toStub(java.rmi.Remote)";
    protected String noMethodDefForPortableRemoteObjectToStub$str() {
        return noMethodDefForPortableRemoteObjectToStub;
    }
    @Override
    public final IllegalStateException noMethodDefForPortableRemoteObjectToStub() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noMethodDefForPortableRemoteObjectToStub$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String problemInvokingStubConnect = "WFLYIIOP0044: Problem invoking javax.rmi.CORBA.Stub.connect()";
    protected String problemInvokingStubConnect$str() {
        return problemInvokingStubConnect;
    }
    @Override
    public final ConfigurationException problemInvokingStubConnect() {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), problemInvokingStubConnect$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInvokeStubConnect = "WFLYIIOP0045: Cannot invoke javax.rmi.CORBA.Stub.connect()";
    protected String cannotInvokeStubConnect$str() {
        return cannotInvokeStubConnect;
    }
    @Override
    public final ConfigurationException cannotInvokeStubConnect() {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), cannotInvokeStubConnect$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noMethodDefForStubConnect = "WFLYIIOP0046: No method definition for javax.rmi.CORBA.Stub.connect(org.omg.CORBA.ORB)";
    protected String noMethodDefForStubConnect$str() {
        return noMethodDefForStubConnect;
    }
    @Override
    public final IllegalStateException noMethodDefForStubConnect() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noMethodDefForStubConnect$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIIOPURLVersion = "WFLYIIOP0047: Invalid IIOP URL version: %s";
    protected String invalidIIOPURLVersion$str() {
        return invalidIIOPURLVersion;
    }
    @Override
    public final MalformedURLException invalidIIOPURLVersion(final String version) {
        final MalformedURLException result = new MalformedURLException(String.format(getLoggingLocale(), invalidIIOPURLVersion$str(), version));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unavailableRMIPackages = "WFLYIIOP0048: javax.rmi packages not available";
    protected String unavailableRMIPackages$str() {
        return unavailableRMIPackages;
    }
    @Override
    public final ConfigurationException unavailableRMIPackages() {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), unavailableRMIPackages$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unavailableISOLatin1Decoder = "WFLYIIOP0049: ISO-Latin-1 decoder unavailable";
    protected String unavailableISOLatin1Decoder$str() {
        return unavailableISOLatin1Decoder;
    }
    @Override
    public final MalformedURLException unavailableISOLatin1Decoder() {
        final MalformedURLException result = new MalformedURLException(String.format(getLoggingLocale(), unavailableISOLatin1Decoder$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidURIEncoding = "WFLYIIOP0050: Invalid URI encoding: %s";
    protected String invalidURIEncoding$str() {
        return invalidURIEncoding;
    }
    @Override
    public final MalformedURLException invalidURIEncoding(final String encoding) {
        final MalformedURLException result = new MalformedURLException(String.format(getLoggingLocale(), invalidURIEncoding$str(), encoding));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLookupJSSEDomain = "WFLYIIOP0051: Error configuring domain socket factory: failed to lookup JSSE security domain";
    protected String failedToLookupJSSEDomain$str() {
        return failedToLookupJSSEDomain;
    }
    @Override
    public final ConfigurationException failedToLookupJSSEDomain() {
        final ConfigurationException result = new ConfigurationException(String.format(getLoggingLocale(), failedToLookupJSSEDomain$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorObtainingKeyManagers = "WFLYIIOP0052: keyManager[] is null for security domain %s";
    protected String errorObtainingKeyManagers$str() {
        return errorObtainingKeyManagers;
    }
    @Override
    public final IOException errorObtainingKeyManagers(final String securityDomain) {
        final IOException result = new IOException(String.format(getLoggingLocale(), errorObtainingKeyManagers$str(), securityDomain));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToGetSSLContext = "WFLYIIOP0053: Failed to get SSL context";
    protected String failedToGetSSLContext$str() {
        return failedToGetSSLContext;
    }
    @Override
    public final IOException failedToGetSSLContext(final Throwable cause) {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToGetSSLContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToStartJBossCOSNaming = "WFLYIIOP0054: Failed to start the JBoss Corba Naming Service";
    protected String failedToStartJBossCOSNaming$str() {
        return failedToStartJBossCOSNaming;
    }
    @Override
    public final StartException failedToStartJBossCOSNaming(final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToStartJBossCOSNaming$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String foreignTransaction = "WFLYIIOP0055: Foreign Transaction";
    protected String foreignTransaction$str() {
        return foreignTransaction;
    }
    @Override
    public final UnsupportedOperationException foreignTransaction() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), foreignTransaction$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorEncodingContext = "WFLYIIOP0056: Exception raised during encoding";
    protected String errorEncodingContext$str() {
        return errorEncodingContext;
    }
    @Override
    public final RuntimeException errorEncodingContext(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorEncodingContext$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorGettingSlotInTxInterceptor = "WFLYIIOP0057: Exception getting slot in TxServerInterceptor";
    protected String errorGettingSlotInTxInterceptor$str() {
        return errorGettingSlotInTxInterceptor;
    }
    @Override
    public final RuntimeException errorGettingSlotInTxInterceptor(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorGettingSlotInTxInterceptor$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorSettingSlotInTxInterceptor = "WFLYIIOP0058: Exception setting slot in TxServerInterceptor";
    protected String errorSettingSlotInTxInterceptor$str() {
        return errorSettingSlotInTxInterceptor;
    }
    @Override
    public final RuntimeException errorSettingSlotInTxInterceptor(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorSettingSlotInTxInterceptor$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAnalyzeNullClass = "WFLYIIOP0059: Cannot analyze a null class";
    protected String cannotAnalyzeNullClass$str() {
        return cannotAnalyzeNullClass;
    }
    @Override
    public final IllegalArgumentException cannotAnalyzeNullClass() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotAnalyzeNullClass$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String badConstantType = "WFLYIIOP0060: Bad type for a constant: %s";
    protected String badConstantType$str() {
        return badConstantType;
    }
    @Override
    public final IllegalArgumentException badConstantType(final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), badConstantType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAnalyzeSpecialClass = "WFLYIIOP0061: Cannot analyze special class: %s";
    protected String cannotAnalyzeSpecialClass$str() {
        return cannotAnalyzeSpecialClass;
    }
    @Override
    public final IllegalArgumentException cannotAnalyzeSpecialClass(final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotAnalyzeSpecialClass$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAnAccessor = "WFLYIIOP0062: Not an accessor: %s";
    protected String notAnAccessor$str() {
        return notAnAccessor;
    }
    @Override
    public final IllegalArgumentException notAnAccessor(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAnAccessor$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAnClassOrInterface = "WFLYIIOP0063: Not a class or interface: %s";
    protected String notAnClassOrInterface$str() {
        return notAnClassOrInterface;
    }
    @Override
    public final IllegalArgumentException notAnClassOrInterface(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAnClassOrInterface$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAnInterface = "WFLYIIOP0064: Class %s is not an interface";
    protected String notAnInterface$str() {
        return notAnInterface;
    }
    @Override
    public final IllegalArgumentException notAnInterface(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAnInterface$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAPrimitive = "WFLYIIOP0065: Not a primitive type: %s";
    protected String notAPrimitive$str() {
        return notAPrimitive;
    }
    @Override
    public final IllegalArgumentException notAPrimitive(final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAPrimitive$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String badRMIIIOPConstantType = "WFLYIIOP0066: Field %s of interface %s is a constant, but it is not primitive or String";
    protected String badRMIIIOPConstantType$str() {
        return badRMIIIOPConstantType;
    }
    @Override
    public final RMIIIOPViolationException badRMIIIOPConstantType(final String field, final String intface, final String section) {
        final RMIIIOPViolationException result = new RMIIIOPViolationException(String.format(getLoggingLocale(), badRMIIIOPConstantType$str(), field, intface), section);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String badRMIIIOPExceptionType = "WFLYIIOP0067: Exception type %s must be a checked exception class";
    protected String badRMIIIOPExceptionType$str() {
        return badRMIIIOPExceptionType;
    }
    @Override
    public final RMIIIOPViolationException badRMIIIOPExceptionType(final String type, final String section) {
        final RMIIIOPViolationException result = new RMIIIOPViolationException(String.format(getLoggingLocale(), badRMIIIOPExceptionType$str(), type), section);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String badRMIIIOPMethodSignature = "WFLYIIOP0068: All interface methods must throw javax.rmi.RemoteException but method %s of interface %s does not";
    protected String badRMIIIOPMethodSignature$str() {
        return badRMIIIOPMethodSignature;
    }
    @Override
    public final RMIIIOPViolationException badRMIIIOPMethodSignature(final String method, final String intface, final String section) {
        final RMIIIOPViolationException result = new RMIIIOPViolationException(String.format(getLoggingLocale(), badRMIIIOPMethodSignature$str(), method, intface), section);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nameCannotBeNullEmptyOrQualified = "WFLYIIOP0069: Name cannot be null, empty or qualified";
    protected String nameCannotBeNullEmptyOrQualified$str() {
        return nameCannotBeNullEmptyOrQualified;
    }
    @Override
    public final IllegalArgumentException nameCannotBeNullEmptyOrQualified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nameCannotBeNullEmptyOrQualified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String primitivesHaveNoIRIds = "WFLYIIOP0070: Primitive types have no IR IDs";
    protected String primitivesHaveNoIRIds$str() {
        return primitivesHaveNoIRIds;
    }
    @Override
    public final IllegalArgumentException primitivesHaveNoIRIds() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), primitivesHaveNoIRIds$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unavailableSHADigest = "WFLYIIOP0071: No SHA message digest available";
    protected String unavailableSHADigest$str() {
        return unavailableSHADigest;
    }
    @Override
    public final RuntimeException unavailableSHADigest(final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unavailableSHADigest$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownPrimitiveType = "WFLYIIOP0072: Unknown primitive type: %s";
    protected String unknownPrimitiveType$str() {
        return unknownPrimitiveType;
    }
    @Override
    public final RuntimeException unknownPrimitiveType(final String type) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unknownPrimitiveType$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAnalyzeStringType = "WFLYIIOP0073: Cannot analyze java.lang.String: it is a special case";
    protected String cannotAnalyzeStringType$str() {
        return cannotAnalyzeStringType;
    }
    @Override
    public final IllegalArgumentException cannotAnalyzeStringType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotAnalyzeStringType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAnalyzeClassType = "WFLYIIOP0074: Cannot analyze java.lang.Class: it is a special case";
    protected String cannotAnalyzeClassType$str() {
        return cannotAnalyzeClassType;
    }
    @Override
    public final IllegalArgumentException cannotAnalyzeClassType() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cannotAnalyzeClassType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueTypeCantImplementRemote = "WFLYIIOP0075: Value type %s cannot implement java.rmi.Remote";
    protected String valueTypeCantImplementRemote$str() {
        return valueTypeCantImplementRemote;
    }
    @Override
    public final RMIIIOPViolationException valueTypeCantImplementRemote(final String type, final String section) {
        final RMIIIOPViolationException result = new RMIIIOPViolationException(String.format(getLoggingLocale(), valueTypeCantImplementRemote$str(), type), section);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueTypeCantBeProxy = "WFLYIIOP0076: Value type %s cannot be a proxy or inner class";
    protected String valueTypeCantBeProxy$str() {
        return valueTypeCantBeProxy;
    }
    @Override
    public final RMIIIOPViolationException valueTypeCantBeProxy(final String type) {
        final RMIIIOPViolationException result = new RMIIIOPViolationException(String.format(getLoggingLocale(), valueTypeCantBeProxy$str(), type));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorLoadingClass = "WFLYIIOP0077: Error loading class %s";
    protected String errorLoadingClass$str() {
        return errorLoadingClass;
    }
    @Override
    public final RuntimeException errorLoadingClass(final String type, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorLoadingClass$str(), type), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noReadMethodInHelper = "WFLYIIOP0078: No read method in helper class %s";
    protected String noReadMethodInHelper$str() {
        return noReadMethodInHelper;
    }
    @Override
    public final RuntimeException noReadMethodInHelper(final String type, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), noReadMethodInHelper$str(), type), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noWriteMethodInHelper = "WFLYIIOP0079: No write method in helper class %s";
    protected String noWriteMethodInHelper$str() {
        return noWriteMethodInHelper;
    }
    @Override
    public final RuntimeException noWriteMethodInHelper(final String type, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), noWriteMethodInHelper$str(), type), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorUnmarshaling = "WFLYIIOP0080: Error unmarshaling %s";
    protected String errorUnmarshaling$str() {
        return errorUnmarshaling;
    }
    @Override
    public final RuntimeException errorUnmarshaling(final Class<?> type, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorUnmarshaling$str(), type), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorMarshaling = "WFLYIIOP0081: Error marshaling %s";
    protected String errorMarshaling$str() {
        return errorMarshaling;
    }
    @Override
    public final RuntimeException errorMarshaling(final Class<?> type, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorMarshaling$str(), type), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotObtainExceptionRepositoryID = "WFLYIIOP0082: Cannot obtain exception repository id for %s";
    protected String cannotObtainExceptionRepositoryID$str() {
        return cannotObtainExceptionRepositoryID;
    }
    @Override
    public final RuntimeException cannotObtainExceptionRepositoryID(final String type, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotObtainExceptionRepositoryID$str(), type), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorMashalingParams = "WFLYIIOP0083: Cannot marshal parameter: unexpected number of parameters";
    protected String errorMashalingParams$str() {
        return errorMashalingParams;
    }
    @Override
    public final RuntimeException errorMashalingParams() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), errorMashalingParams$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotChangeRMIIIOPMapping = "WFLYIIOP0084: Cannot change RMI/IIOP mapping";
    protected String cannotChangeRMIIIOPMapping$str() {
        return cannotChangeRMIIIOPMapping;
    }
    @Override
    public final BAD_INV_ORDER cannotChangeRMIIIOPMapping() {
        final BAD_INV_ORDER result = new BAD_INV_ORDER(String.format(getLoggingLocale(), cannotChangeRMIIIOPMapping$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String badKindForTypeCode = "WFLYIIOP0085: Bad kind %d for TypeCode";
    protected String badKindForTypeCode$str() {
        return badKindForTypeCode;
    }
    @Override
    public final RuntimeException badKindForTypeCode(final int kind) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), badKindForTypeCode$str(), kind));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongInterfaceRepository = "WFLYIIOP0086: Wrong interface repository";
    protected String wrongInterfaceRepository$str() {
        return wrongInterfaceRepository;
    }
    @Override
    public final IRConstructionException wrongInterfaceRepository() {
        final IRConstructionException result = new IRConstructionException(String.format(getLoggingLocale(), wrongInterfaceRepository$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateRepositoryName = "WFLYIIOP0087: Duplicate repository name";
    protected String duplicateRepositoryName$str() {
        return duplicateRepositoryName;
    }
    @Override
    public final IRConstructionException duplicateRepositoryName() {
        final IRConstructionException result = new IRConstructionException(String.format(getLoggingLocale(), duplicateRepositoryName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNullClass = "WFLYIIOP0088: Invalid null class";
    protected String invalidNullClass$str() {
        return invalidNullClass;
    }
    @Override
    public final IllegalArgumentException invalidNullClass() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNullClass$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String badClassForConstant = "WFLYIIOP0089: Bad class %s for a constant";
    protected String badClassForConstant$str() {
        return badClassForConstant;
    }
    @Override
    public final IRConstructionException badClassForConstant(final String className) {
        final IRConstructionException result = new IRConstructionException(String.format(getLoggingLocale(), badClassForConstant$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownTypeCodeForClass = "WFLYIIOP0090: TypeCode for class %s is unknown";
    protected String unknownTypeCodeForClass$str() {
        return unknownTypeCodeForClass;
    }
    @Override
    public final IRConstructionException unknownTypeCodeForClass(final String className) {
        final IRConstructionException result = new IRConstructionException(String.format(getLoggingLocale(), unknownTypeCodeForClass$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String duplicateTypeCodeForClass = "WFLYIIOP0091: TypeCode for class %s already established";
    protected String duplicateTypeCodeForClass$str() {
        return duplicateTypeCodeForClass;
    }
    @Override
    public final IRConstructionException duplicateTypeCodeForClass(final String className) {
        final IRConstructionException result = new IRConstructionException(String.format(getLoggingLocale(), duplicateTypeCodeForClass$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String collisionWhileCreatingPackage = "WFLYIIOP0092: Name collision while creating package";
    protected String collisionWhileCreatingPackage$str() {
        return collisionWhileCreatingPackage;
    }
    @Override
    public final IRConstructionException collisionWhileCreatingPackage() {
        final IRConstructionException result = new IRConstructionException(String.format(getLoggingLocale(), collisionWhileCreatingPackage$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classIsNotArray = "WFLYIIOP0093: Class %s is not an array class";
    protected String classIsNotArray$str() {
        return classIsNotArray;
    }
    @Override
    public final IRConstructionException classIsNotArray(final String className) {
        final IRConstructionException result = new IRConstructionException(String.format(getLoggingLocale(), classIsNotArray$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDestroyRMIIIOPMapping = "WFLYIIOP0094: Cannot destroy RMI/IIOP mapping";
    protected String cannotDestroyRMIIIOPMapping$str() {
        return cannotDestroyRMIIIOPMapping;
    }
    @Override
    public final BAD_INV_ORDER cannotDestroyRMIIIOPMapping() {
        final BAD_INV_ORDER result = new BAD_INV_ORDER(String.format(getLoggingLocale(), cannotDestroyRMIIIOPMapping$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String badKindForSuperValueType = "WFLYIIOP0095: Bad kind for super valuetype of %s";
    protected String badKindForSuperValueType$str() {
        return badKindForSuperValueType;
    }
    @Override
    public final IRConstructionException badKindForSuperValueType(final String id) {
        final IRConstructionException result = new IRConstructionException(String.format(getLoggingLocale(), badKindForSuperValueType$str(), id));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorResolvingRefToImplementedInterface = "WFLYIIOP0096: ValueDef %s unable to resolve reference to implemented interface %s";
    protected String errorResolvingRefToImplementedInterface$str() {
        return errorResolvingRefToImplementedInterface;
    }
    @Override
    public final IRConstructionException errorResolvingRefToImplementedInterface(final String id, final String intface) {
        final IRConstructionException result = new IRConstructionException(String.format(getLoggingLocale(), errorResolvingRefToImplementedInterface$str(), id, intface));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorResolvingRefToAbstractValuetype = "WFLYIIOP0097: ValueDef %s unable to resolve reference to abstract base valuetype %s";
    protected String errorResolvingRefToAbstractValuetype$str() {
        return errorResolvingRefToAbstractValuetype;
    }
    @Override
    public final IRConstructionException errorResolvingRefToAbstractValuetype(final String id, final String valuetype) {
        final IRConstructionException result = new IRConstructionException(String.format(getLoggingLocale(), errorResolvingRefToAbstractValuetype$str(), id, valuetype));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorResolvingInitRef = "WFLYIIOP0098: Failed to resolve initial reference %s";
    protected String errorResolvingInitRef$str() {
        return errorResolvingInitRef;
    }
    @Override
    public final StartException errorResolvingInitRef(final String refName, final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), errorResolvingInitRef$str(), refName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorCreatingPOAFromParent = "WFLYIIOP0099: Failed to create POA from parent";
    protected String errorCreatingPOAFromParent$str() {
        return errorCreatingPOAFromParent;
    }
    @Override
    public final StartException errorCreatingPOAFromParent(final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), errorCreatingPOAFromParent$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPOACreationArgs = "WFLYIIOP0100: Unable to instantiate POA: either the running ORB or the parent POA must be specified";
    protected String invalidPOACreationArgs$str() {
        return invalidPOACreationArgs;
    }
    @Override
    public final StartException invalidPOACreationArgs() {
        final StartException result = new StartException(String.format(getLoggingLocale(), invalidPOACreationArgs$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorActivatingPOA = "WFLYIIOP0101: Failed to activate POA";
    protected String errorActivatingPOA$str() {
        return errorActivatingPOA;
    }
    @Override
    public final StartException errorActivatingPOA(final Throwable cause) {
        final StartException result = new StartException(String.format(getLoggingLocale(), errorActivatingPOA$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionDestroingIterator = "WFLYIIOP0102: Caught exception destroying Iterator %s";
    protected String exceptionDestroingIterator$str() {
        return exceptionDestroingIterator;
    }
    @Override
    public final INTERNAL exceptionDestroingIterator(final String cause) {
        final INTERNAL result = new INTERNAL(String.format(getLoggingLocale(), exceptionDestroingIterator$str(), cause));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sslNotConfigured = "WFLYIIOP0103: IOR settings imply ssl connections usage, but secure connections have not been configured";
    protected String sslNotConfigured$str() {
        return sslNotConfigured;
    }
    @Override
    public final OperationFailedException sslNotConfigured() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), sslNotConfigured$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String inconsistentSupportedTransportConfig = "WFLYIIOP0104: Inconsistent transport-config configuration: %s is supported, please configure it to %s value";
    protected String inconsistentSupportedTransportConfig$str() {
        return inconsistentSupportedTransportConfig;
    }
    @Override
    public final String inconsistentSupportedTransportConfig(final String transportAttributeName, final String suggested) {
        return String.format(getLoggingLocale(), inconsistentSupportedTransportConfig$str(), transportAttributeName, suggested);
    }
    private static final String inconsistentUnsupportedTransportConfig = "WFLYIIOP0105: Inconsistent transport-config configuration: %s is not supported, please remove it or configure it to none value";
    protected String inconsistentUnsupportedTransportConfig$str() {
        return inconsistentUnsupportedTransportConfig;
    }
    @Override
    public final String inconsistentUnsupportedTransportConfig(final String transportAttributeName) {
        return String.format(getLoggingLocale(), inconsistentUnsupportedTransportConfig$str(), transportAttributeName);
    }
    private static final String inconsistentRequiredTransportConfig = "WFLYIIOP0106: Inconsistent transport-config configuration: %s is set to true, please configure %s as required";
    protected String inconsistentRequiredTransportConfig$str() {
        return inconsistentRequiredTransportConfig;
    }
    @Override
    public final String inconsistentRequiredTransportConfig(final String requiredAttributeName, final String transportAttributeName) {
        return String.format(getLoggingLocale(), inconsistentRequiredTransportConfig$str(), requiredAttributeName, transportAttributeName);
    }
    @Override
    public final void cannotCreateSSLSocket() {
        super.log.logf(FQCN, WARN, null, cannotCreateSSLSocket$str());
    }
    private static final String cannotCreateSSLSocket = "WFLYIIOP0109: SSL socket is required by server but secure connections have not been configured";
    protected String cannotCreateSSLSocket$str() {
        return cannotCreateSSLSocket;
    }
    private static final String serverDoesNotSupportSsl = "WFLYIIOP0110: Client requires SSL but server does not support it";
    protected String serverDoesNotSupportSsl$str() {
        return serverDoesNotSupportSsl;
    }
    @Override
    public final IllegalStateException serverDoesNotSupportSsl() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverDoesNotSupportSsl$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sslPortWithoutSslConfiguration = "WFLYIIOP0111: SSL has not been configured but ssl-port property has been specified - the connection will use clear-text protocol";
    protected String sslPortWithoutSslConfiguration$str() {
        return sslPortWithoutSslConfiguration;
    }
    @Override
    public final String sslPortWithoutSslConfiguration() {
        return String.format(getLoggingLocale(), sslPortWithoutSslConfiguration$str());
    }
    private static final String ineffectiveAuthenticationContextConfiguration = "WFLYIIOP0113: Authentication context has been defined but it is ineffective because the security initializer is not set to 'elytron'";
    protected String ineffectiveAuthenticationContextConfiguration$str() {
        return ineffectiveAuthenticationContextConfiguration;
    }
    @Override
    public final OperationFailedException ineffectiveAuthenticationContextConfiguration() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), ineffectiveAuthenticationContextConfiguration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String elytronInitializerNotSupportedInPreviousVersions = "WFLYIIOP0114: Elytron security initializer not supported in previous iiop-openjdk versions and can't be converted";
    protected String elytronInitializerNotSupportedInPreviousVersions$str() {
        return elytronInitializerNotSupportedInPreviousVersions;
    }
    @Override
    public final String elytronInitializerNotSupportedInPreviousVersions() {
        return String.format(getLoggingLocale(), elytronInitializerNotSupportedInPreviousVersions$str());
    }
    private static final String noSocketBindingsConfigured = "WFLYIIOP0115: No IIOP socket bindings have been configured";
    protected String noSocketBindingsConfigured$str() {
        return noSocketBindingsConfigured;
    }
    @Override
    public final IllegalStateException noSocketBindingsConfigured() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSocketBindingsConfigured$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void wontUseCleartextSocket() {
        super.log.logf(FQCN, WARN, null, wontUseCleartextSocket$str());
    }
    private static final String wontUseCleartextSocket = "WFLYIIOP0117: CLEARTEXT in IIOP subsystem won't be used because server-requires-ssl parameter have been set to true";
    protected String wontUseCleartextSocket$str() {
        return wontUseCleartextSocket;
    }
}
