/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2015, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.as.cli.operation.impl;

import java.util.List;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.operation.OperationRequestCompleter;

/**
 *
 * @author Alexey Loubyansky
 */
public class HeadersCompleter implements CommandLineCompleter {

    public static final HeadersCompleter INSTANCE = new HeadersCompleter();

    private final DefaultCallbackHandler handler = new DefaultCallbackHandler();

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {

        // if this is value completion of --headers, the parser trims values, so last spaces will be removed
        // which is not good here
        final String originalBuffer = ctx.getParsedCommandLine().getOriginalLine();
        int valueIndex = originalBuffer.lastIndexOf(buffer);
        if(valueIndex == -1) {
            return -1;
        }
        buffer = originalBuffer.substring(valueIndex);
        if (buffer.isEmpty()) {
            candidates.add("{");
            return 0;
        }
        try {
            handler.parseOperation(null, buffer, ctx);
        } catch (CommandFormatException e) {
            //e.printStackTrace();
            return -1;
        }
        if(handler.endsOnHeaderListStart() || handler.hasHeaders()) {
            return OperationRequestCompleter.INSTANCE.complete(ctx, handler, buffer, cursor, candidates);
        }
        return -1;
    }
}
