package org.jboss.hal.client.configuration.subsystem.messaging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_ConnectionView extends ConnectionView {

    private final Metadata metadata14;
    private final Metadata metadata13;
    private final Metadata metadata11;
    private final Metadata metadata9;
    private final Metadata metadata6;
    private final Metadata metadata12;
    private final Metadata metadata10;
    private final Metadata metadata7;
    private final Metadata metadata8;
    private final Metadata metadata5;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_ConnectionView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata14Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*");
        this.metadata14 = mbuiContext.metadataRegistry().lookup(metadata14Template);
        AddressTemplate metadata13Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*");
        this.metadata13 = mbuiContext.metadataRegistry().lookup(metadata13Template);
        AddressTemplate metadata11Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*");
        this.metadata11 = mbuiContext.metadataRegistry().lookup(metadata11Template);
        AddressTemplate metadata9Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/connector=*");
        this.metadata9 = mbuiContext.metadataRegistry().lookup(metadata9Template);
        AddressTemplate metadata6Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*");
        this.metadata6 = mbuiContext.metadataRegistry().lookup(metadata6Template);
        AddressTemplate metadata12Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*");
        this.metadata12 = mbuiContext.metadataRegistry().lookup(metadata12Template);
        AddressTemplate metadata10Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*");
        this.metadata10 = mbuiContext.metadataRegistry().lookup(metadata10Template);
        AddressTemplate metadata7Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*");
        this.metadata7 = mbuiContext.metadataRegistry().lookup(metadata7Template);
        AddressTemplate metadata8Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*");
        this.metadata8 = mbuiContext.metadataRegistry().lookup(metadata8Template);
        AddressTemplate metadata5Template = AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*");
        this.metadata5 = mbuiContext.metadataRegistry().lookup(metadata5Template);
        this.expressionElements = new HashMap<>();

        acceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-form", metadata5)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.ACCEPTOR, form))
            .build();
        acceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-form", metadata6)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_ACCEPTOR, form))
            .build();
        httpAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-form", metadata7)
            .include("http-listener", "upgrade-legacy", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_ACCEPTOR, form))
            .build();
        httpAcceptorForm.getFormItem("http-listener").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=undertow/server=*/http-listener=*")));
        remoteAcceptorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-form", metadata8)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_ACCEPTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_ACCEPTOR, form))
            .build();
        remoteAcceptorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-form", metadata9)
            .include("factory-class", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR, form))
            .build();
        connectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        inVmConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-form", metadata10)
            .include("server-id", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.IN_VM_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.IN_VM_CONNECTOR, form))
            .build();
        httpConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-form", metadata11)
            .include("endpoint", "server-name", "socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.HTTP_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.HTTP_CONNECTOR, form))
            .build();
        httpConnectorForm.getFormItem("endpoint").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/{selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*")));
        httpConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        remoteConnectorForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-form", metadata12)
            .include("socket-binding", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.REMOTE_CONNECTOR, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.REMOTE_CONNECTOR, form))
            .build();
        remoteConnectorForm.getFormItem("socket-binding").registerSuggestHandler(new ReadChildrenAutoComplete(
            mbuiContext.dispatcher(), mbuiContext.statementContext(), AddressTemplate.of("/socket-binding-group=*/socket-binding=*")));
        connectorServiceForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-form", metadata13)
            .include("factory-class", "params")
            .unsorted()
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTOR_SERVICE, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTOR_SERVICE, form))
            .build();
        connectionFactoryForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-form", metadata14)
            .onSave((form, changedValues) -> presenter.save(ServerSubResource.CONNECTION_FACTORY, form, changedValues))
            .prepareReset(form -> presenter.reset(ServerSubResource.CONNECTION_FACTORY, form))
            .build();

        acceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-acceptor-table", metadata5)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        inVmAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-acceptor-table", metadata6)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.IN_VM_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.IN_VM_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("server-id")
            .build();
        httpAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-acceptor-table", metadata7)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttp(ServerSubResource.HTTP_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.HTTP_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        remoteAcceptorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-acceptor-table", metadata8)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemote(ServerSubResource.REMOTE_ACCEPTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.REMOTE_ACCEPTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-acceptor=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        connectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-table", metadata9)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        inVmConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-in-vm-connector-table", metadata10)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.IN_VM_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.IN_VM_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/in-vm-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("server-id")
            .build();
        httpConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-http-connector-table", metadata11)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addHttpConnector(), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.HTTP_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/http-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        remoteConnectorTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-remote-connector-table", metadata12)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addRemote(ServerSubResource.REMOTE_CONNECTOR), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.REMOTE_CONNECTOR, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/remote-connector=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        connectorServiceTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connector-service-table", metadata13)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTOR_SERVICE), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTOR_SERVICE, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connector-service=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        connectionFactoryTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("messaging-connection-factory-table", metadata14)
            .button(mbuiContext.resources().constants().add(), table -> presenter.add(ServerSubResource.CONNECTION_FACTORY), Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.remove(ServerSubResource.CONNECTION_FACTORY, table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=messaging-activemq/server=*/connection-factory=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();

        navigation = new VerticalNavigation();
        navigation.addPrimary("messaging-acceptor-group-item", "Acceptor", "fa fa-sign-in");
        HTMLElement html16;
        HTMLElement messagingAcceptorItemElement = section()
            .add(html16 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Acceptor</h1><p>${metadata5.getDescription().getDescription()}</p>"))
                .asElement())
            .add(acceptorTable)
            .add(acceptorForm)
            .asElement();
        expressionElements.put("html16", html16);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-acceptor-item", "Generic", messagingAcceptorItemElement);
        HTMLElement html19;
        HTMLElement messagingInVmAcceptorItemElement = section()
            .add(html19 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Acceptor</h1><p>${metadata6.getDescription().getDescription()}</p>"))
                .asElement())
            .add(inVmAcceptorTable)
            .add(inVmAcceptorForm)
            .asElement();
        expressionElements.put("html19", html19);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-in-vm-acceptor-item", "In VM", messagingInVmAcceptorItemElement);
        HTMLElement html22;
        HTMLElement messagingHttpAcceptorItemElement = section()
            .add(html22 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Acceptor</h1><p>${metadata7.getDescription().getDescription()}</p>"))
                .asElement())
            .add(httpAcceptorTable)
            .add(httpAcceptorForm)
            .asElement();
        expressionElements.put("html22", html22);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-http-acceptor-item", "HTTP", messagingHttpAcceptorItemElement);
        HTMLElement html25;
        HTMLElement messagingRemoteAcceptorItemElement = section()
            .add(html25 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Acceptor</h1><p>${metadata8.getDescription().getDescription()}</p>"))
                .asElement())
            .add(remoteAcceptorTable)
            .add(remoteAcceptorForm)
            .asElement();
        expressionElements.put("html25", html25);
        navigation.addSecondary("messaging-acceptor-group-item", "messaging-remote-acceptor-item", "Remote", messagingRemoteAcceptorItemElement);
        navigation.addPrimary("messaging-connector-group-item", "Connector", "fa fa-link");
        HTMLElement html28;
        HTMLElement messagingConnectorItemElement = section()
            .add(html28 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Generic Connector</h1><p>${metadata9.getDescription().getDescription()}</p>"))
                .asElement())
            .add(connectorTable)
            .add(connectorForm)
            .asElement();
        expressionElements.put("html28", html28);
        navigation.addSecondary("messaging-connector-group-item", "messaging-connector-item", "Generic", messagingConnectorItemElement);
        HTMLElement html31;
        HTMLElement messagingInVmConnectorItemElement = section()
            .add(html31 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>In VM Connector</h1><p>${metadata10.getDescription().getDescription()}</p>"))
                .asElement())
            .add(inVmConnectorTable)
            .add(inVmConnectorForm)
            .asElement();
        expressionElements.put("html31", html31);
        navigation.addSecondary("messaging-connector-group-item", "messaging-in-vm-connector-item", "In VM", messagingInVmConnectorItemElement);
        HTMLElement html34;
        HTMLElement messagingHttpConnectorItemElement = section()
            .add(html34 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>HTTP Connector</h1><p>${metadata11.getDescription().getDescription()}</p>"))
                .asElement())
            .add(httpConnectorTable)
            .add(httpConnectorForm)
            .asElement();
        expressionElements.put("html34", html34);
        navigation.addSecondary("messaging-connector-group-item", "messaging-http-connector-item", "HTTP", messagingHttpConnectorItemElement);
        HTMLElement html37;
        HTMLElement messagingRemoteConnectorItemElement = section()
            .add(html37 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Remote Connector</h1><p>${metadata12.getDescription().getDescription()}</p>"))
                .asElement())
            .add(remoteConnectorTable)
            .add(remoteConnectorForm)
            .asElement();
        expressionElements.put("html37", html37);
        navigation.addSecondary("messaging-connector-group-item", "messaging-remote-connector-item", "Remote", messagingRemoteConnectorItemElement);
        HTMLElement html40;
        HTMLElement messagingConnectorServiceItemElement = section()
            .add(html40 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connector Service</h1><p>${metadata13.getDescription().getDescription()}</p>"))
                .asElement())
            .add(connectorServiceTable)
            .add(connectorServiceForm)
            .asElement();
        expressionElements.put("html40", html40);
        navigation.addPrimary("messaging-connector-service-item", "Connector Service", "pficon pficon-service", messagingConnectorServiceItemElement);
        HTMLElement html43;
        HTMLElement messagingConnectionFactoryItemElement = section()
            .add(html43 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Connection Factory</h1><p>${metadata14.getDescription().getDescription()}</p>"))
                .asElement())
            .add(connectionFactoryTable)
            .add(connectionFactoryForm)
            .asElement();
        expressionElements.put("html43", html43);
        navigation.addPrimary("messaging-connection-factory-item", "Connection Factory", "fa fa-cubes", messagingConnectionFactoryItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(acceptorTable);
        registerAttachable(acceptorForm);
        registerAttachable(inVmAcceptorTable);
        registerAttachable(inVmAcceptorForm);
        registerAttachable(httpAcceptorTable);
        registerAttachable(httpAcceptorForm);
        registerAttachable(remoteAcceptorTable);
        registerAttachable(remoteAcceptorForm);
        registerAttachable(connectorTable);
        registerAttachable(connectorForm);
        registerAttachable(inVmConnectorTable);
        registerAttachable(inVmConnectorForm);
        registerAttachable(httpConnectorTable);
        registerAttachable(httpConnectorForm);
        registerAttachable(remoteConnectorTable);
        registerAttachable(remoteConnectorForm);
        registerAttachable(connectorServiceTable);
        registerAttachable(connectorServiceForm);
        registerAttachable(connectionFactoryTable);
        registerAttachable(connectionFactoryForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            acceptorTable.bindForm(acceptorForm);
            inVmAcceptorTable.bindForm(inVmAcceptorForm);
            httpAcceptorTable.bindForm(httpAcceptorForm);
            remoteAcceptorTable.bindForm(remoteAcceptorForm);
            connectorTable.bindForm(connectorForm);
            inVmConnectorTable.bindForm(inVmConnectorForm);
            httpConnectorTable.bindForm(httpConnectorForm);
            remoteConnectorTable.bindForm(remoteConnectorForm);
            connectorServiceTable.bindForm(connectorServiceForm);
            connectionFactoryTable.bindForm(connectionFactoryForm);

        TemplateUtil.replaceExpression(expressionElements.get("html16"), "${metadata5.getDescription().getDescription()}", String.valueOf(metadata5.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html19"), "${metadata6.getDescription().getDescription()}", String.valueOf(metadata6.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html22"), "${metadata7.getDescription().getDescription()}", String.valueOf(metadata7.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html25"), "${metadata8.getDescription().getDescription()}", String.valueOf(metadata8.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html28"), "${metadata9.getDescription().getDescription()}", String.valueOf(metadata9.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html31"), "${metadata10.getDescription().getDescription()}", String.valueOf(metadata10.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html34"), "${metadata11.getDescription().getDescription()}", String.valueOf(metadata11.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html37"), "${metadata12.getDescription().getDescription()}", String.valueOf(metadata12.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html40"), "${metadata13.getDescription().getDescription()}", String.valueOf(metadata13.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html43"), "${metadata14.getDescription().getDescription()}", String.valueOf(metadata14.getDescription().getDescription()));
    }
}
