package org.jboss.hal.client.configuration.subsystem.security;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_SecurityView extends SecurityView {

    private final Metadata metadata141;
    private final Metadata metadata144;
    private final Metadata metadata142;
    private final Metadata metadata140;
    private final Metadata metadata145;
    private final Metadata metadata143;
    private final Metadata metadata139;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_SecurityView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata141Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-store=*");
        this.metadata141 = mbuiContext.metadataRegistry().lookup(metadata141Template);
        AddressTemplate metadata144Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-store=*");
        this.metadata144 = mbuiContext.metadataRegistry().lookup(metadata144Template);
        AddressTemplate metadata142Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-realm=*");
        this.metadata142 = mbuiContext.metadataRegistry().lookup(metadata142Template);
        AddressTemplate metadata140Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-key-manager=*");
        this.metadata140 = mbuiContext.metadataRegistry().lookup(metadata140Template);
        AddressTemplate metadata145Template = AddressTemplate.of("/{selected.profile}/subsystem=security/vault=classic");
        this.metadata145 = mbuiContext.metadataRegistry().lookup(metadata145Template);
        AddressTemplate metadata143Template = AddressTemplate.of("/{selected.profile}/subsystem=security/elytron-trust-manager=*");
        this.metadata143 = mbuiContext.metadataRegistry().lookup(metadata143Template);
        AddressTemplate metadata139Template = AddressTemplate.of("/{selected.profile}/subsystem=security");
        this.metadata139 = mbuiContext.metadataRegistry().lookup(metadata139Template);
        this.expressionElements = new HashMap<>();

        configurationForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-configuration-form", metadata139)
            .onSave((form, changedValues) -> saveSingletonForm("Configuration", metadata139Template.resolve(mbuiContext.statementContext()), changedValues, metadata139))
            .prepareReset(form -> resetSingletonForm("Configuration", metadata139Template.resolve(mbuiContext.statementContext()), form, metadata139))
            .build();
        keyManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-form", metadata140)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Manager", name, metadata140Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata140);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Manager", name, metadata140Template.resolve(mbuiContext.statementContext(), name), form, metadata140);
            })
            .build();
        keyStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-form", metadata141)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Key Store", name, metadata141Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata141);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Key Store", name, metadata141Template.resolve(mbuiContext.statementContext(), name), form, metadata141);
            })
            .build();
        realmForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-form", metadata142)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Realm", name, metadata142Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata142);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Realm", name, metadata142Template.resolve(mbuiContext.statementContext(), name), form, metadata142);
            })
            .build();
        trustManagerForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-form", metadata143)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Manager", name, metadata143Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata143);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Manager", name, metadata143Template.resolve(mbuiContext.statementContext(), name), form, metadata143);
            })
            .build();
        trustStoreForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-form", metadata144)
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Elytron Trust Store", name, metadata144Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata144);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Elytron Trust Store", name, metadata144Template.resolve(mbuiContext.statementContext(), name), form, metadata144);
            })
            .build();
        vaultForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.ModelNode>("security-vault-form", metadata145)
            .singleton(
                () -> new Operation.Builder(metadata145Template.resolve(mbuiContext.statementContext()), READ_RESOURCE_OPERATION).build(),
                () -> addSingleton("security-vault-form", "Vault", metadata145Template))
            .prepareRemove(form -> removeSingletonForm("Vault", metadata145Template.resolve(mbuiContext.statementContext()), form))
            .onSave((form, changedValues) -> saveSingletonForm("Vault", metadata145Template.resolve(mbuiContext.statementContext()), changedValues, metadata145))
            .prepareReset(form -> resetSingletonForm("Vault", metadata145Template.resolve(mbuiContext.statementContext()), form, metadata145))
            .build();

        keyManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-manager-table", metadata140)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-manager-table", Ids.ADD), "Elytron Key Manager",
                metadata140Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Manager", metadata140Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("legacy-jsse-config")
            .build();
        keyStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-key-store-table", metadata141)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-key-store-table", Ids.ADD), "Elytron Key Store",
                metadata141Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Key Store", metadata141Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("legacy-jsse-config")
            .build();
        realmTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-realm-table", metadata142)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-realm-table", Ids.ADD), "Elytron Realm",
                metadata142Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Realm", metadata142Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("legacy-jaas-config")
            .build();
        trustManagerTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-manager-table", metadata143)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-manager-table", Ids.ADD), "Elytron Trust Manager",
                metadata143Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Manager", metadata143Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("legacy-jsse-config")
            .build();
        trustStoreTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("security-elytron-trust-store-table", metadata144)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("security-elytron-trust-store-table", Ids.ADD), "Elytron Trust Store",
                metadata144Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Elytron Trust Store", metadata144Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("legacy-jsse-config")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html417;
        HTMLElement securityConfigurationItemElement = section()
            .add(html417 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Configuration</h1><p>${metadata139.getDescription().getDescription()}</p>"))
                .asElement())
            .add(configurationForm)
            .asElement();
        expressionElements.put("html417", html417);
        navigation.addPrimary("security-configuration-item", "Configuration", "pficon pficon-settings", securityConfigurationItemElement);
        HTMLElement html419;
        HTMLElement securityElytronKeyManagerItemElement = section()
            .add(html419 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Manager</h1><p>${metadata140.getDescription().getDescription()}</p>"))
                .asElement())
            .add(keyManagerTable)
            .add(keyManagerForm)
            .asElement();
        expressionElements.put("html419", html419);
        navigation.addPrimary("security-elytron-key-manager-item", "Key Manager", "fa fa-key", securityElytronKeyManagerItemElement);
        HTMLElement html422;
        HTMLElement securityElytronKeyStoreItemElement = section()
            .add(html422 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Key Store</h1><p>${metadata141.getDescription().getDescription()}</p>"))
                .asElement())
            .add(keyStoreTable)
            .add(keyStoreForm)
            .asElement();
        expressionElements.put("html422", html422);
        navigation.addPrimary("security-elytron-key-store-item", "Key Store", "fa fa-key", securityElytronKeyStoreItemElement);
        HTMLElement html425;
        HTMLElement securityElytronRealmItemElement = section()
            .add(html425 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Realm</h1><p>${metadata142.getDescription().getDescription()}</p>"))
                .asElement())
            .add(realmTable)
            .add(realmForm)
            .asElement();
        expressionElements.put("html425", html425);
        navigation.addPrimary("security-elytron-realm-item", "Realm", "fa fa-map", securityElytronRealmItemElement);
        HTMLElement html428;
        HTMLElement securityElytronTrustManagerItemElement = section()
            .add(html428 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Manager</h1><p>${metadata143.getDescription().getDescription()}</p>"))
                .asElement())
            .add(trustManagerTable)
            .add(trustManagerForm)
            .asElement();
        expressionElements.put("html428", html428);
        navigation.addPrimary("security-elytron-trust-manager-item", "Trust Manager", "fa fa-lock", securityElytronTrustManagerItemElement);
        HTMLElement html431;
        HTMLElement securityElytronTrustStoreItemElement = section()
            .add(html431 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Elytron Trust Store</h1><p>${metadata144.getDescription().getDescription()}</p>"))
                .asElement())
            .add(trustStoreTable)
            .add(trustStoreForm)
            .asElement();
        expressionElements.put("html431", html431);
        navigation.addPrimary("security-elytron-trust-store-item", "Trust Store", "fa fa-lock", securityElytronTrustStoreItemElement);
        HTMLElement html434;
        HTMLElement securityVaultItemElement = section()
            .add(html434 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Vault</h1><p>${metadata145.getDescription().getDescription()}</p>"))
                .asElement())
            .add(vaultForm)
            .asElement();
        expressionElements.put("html434", html434);
        navigation.addPrimary("security-vault-item", "Vault", "fa fa-shield", securityVaultItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(configurationForm);
        registerAttachable(keyManagerTable);
        registerAttachable(keyManagerForm);
        registerAttachable(keyStoreTable);
        registerAttachable(keyStoreForm);
        registerAttachable(realmTable);
        registerAttachable(realmForm);
        registerAttachable(trustManagerTable);
        registerAttachable(trustManagerForm);
        registerAttachable(trustStoreTable);
        registerAttachable(trustStoreForm);
        registerAttachable(vaultForm);

        initElement(root);

    }

    @Override
    public void attach() {
        super.attach();

            keyManagerTable.bindForm(keyManagerForm);
            keyStoreTable.bindForm(keyStoreForm);
            realmTable.bindForm(realmForm);
            trustManagerTable.bindForm(trustManagerForm);
            trustStoreTable.bindForm(trustStoreForm);

        TemplateUtil.replaceExpression(expressionElements.get("html417"), "${metadata139.getDescription().getDescription()}", String.valueOf(metadata139.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html419"), "${metadata140.getDescription().getDescription()}", String.valueOf(metadata140.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html422"), "${metadata141.getDescription().getDescription()}", String.valueOf(metadata141.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html425"), "${metadata142.getDescription().getDescription()}", String.valueOf(metadata142.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html428"), "${metadata143.getDescription().getDescription()}", String.valueOf(metadata143.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html431"), "${metadata144.getDescription().getDescription()}", String.valueOf(metadata144.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html434"), "${metadata145.getDescription().getDescription()}", String.valueOf(metadata145.getDescription().getDescription()));
    }
}
