package org.jboss.hal.client.configuration.subsystem.undertow;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.inject.Inject;

import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import elemental2.dom.HTMLElement;
import org.jboss.gwt.elemento.core.builder.ElementsBuilder;
import org.jboss.gwt.elemento.core.Elements;
import org.jboss.gwt.elemento.template.TemplateUtil;
import org.jboss.hal.ballroom.form.Form;
import org.jboss.hal.ballroom.table.Scope;
import org.jboss.hal.ballroom.LayoutBuilder;
import org.jboss.hal.ballroom.autocomplete.ReadChildrenAutoComplete;
import org.jboss.hal.ballroom.VerticalNavigation;
import org.jboss.hal.core.mbui.dialog.AddResourceDialog;
import org.jboss.hal.core.mbui.form.GroupedForm;
import org.jboss.hal.core.mbui.form.ModelNodeForm;
import org.jboss.hal.core.mbui.table.ModelNodeTable;
import org.jboss.hal.core.mbui.MbuiContext;
import org.jboss.hal.dmr.Operation;
import org.jboss.hal.dmr.ResourceAddress;
import org.jboss.hal.meta.AddressTemplate;
import org.jboss.hal.meta.Metadata;
import org.jboss.hal.meta.security.Constraint;
import org.jboss.hal.resources.Ids;
import org.jboss.hal.spi.Message;
import org.jboss.hal.spi.MessageEvent;

import static java.util.Arrays.asList;
import static org.jboss.gwt.elemento.core.Elements.*;
import static org.jboss.hal.ballroom.LayoutBuilder.column;
import static org.jboss.hal.ballroom.LayoutBuilder.row;
import static org.jboss.hal.dmr.ModelDescriptionConstants.ADD;
import static org.jboss.hal.dmr.ModelDescriptionConstants.READ_RESOURCE_OPERATION;

/*
 * WARNING! This class is generated. Do not modify.
 */
@Generated("org.jboss.hal.processor.mbui.MbuiViewProcessor")
public final class Mbui_FilterView extends FilterView {

    private final Metadata metadata92;
    private final Metadata metadata91;
    private final Metadata metadata94;
    private final Metadata metadata90;
    private final Metadata metadata96;
    private final Metadata metadata93;
    private final Metadata metadata97;
    private final Metadata metadata95;
    private final Map<String, HTMLElement> expressionElements;

    @Inject
    @SuppressWarnings("unchecked")
    public Mbui_FilterView(MbuiContext mbuiContext) {
        super(mbuiContext);

        AddressTemplate metadata92Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/expression-filter=*");
        this.metadata92 = mbuiContext.metadataRegistry().lookup(metadata92Template);
        AddressTemplate metadata91Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/error-page=*");
        this.metadata91 = mbuiContext.metadataRegistry().lookup(metadata91Template);
        AddressTemplate metadata94Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/mod-cluster=*");
        this.metadata94 = mbuiContext.metadataRegistry().lookup(metadata94Template);
        AddressTemplate metadata90Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/custom-filter=*");
        this.metadata90 = mbuiContext.metadataRegistry().lookup(metadata90Template);
        AddressTemplate metadata96Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/response-header=*");
        this.metadata96 = mbuiContext.metadataRegistry().lookup(metadata96Template);
        AddressTemplate metadata93Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/gzip=*");
        this.metadata93 = mbuiContext.metadataRegistry().lookup(metadata93Template);
        AddressTemplate metadata97Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/rewrite=*");
        this.metadata97 = mbuiContext.metadataRegistry().lookup(metadata97Template);
        AddressTemplate metadata95Template = AddressTemplate.of("/{selected.profile}/subsystem=undertow/configuration=filter/request-limit=*");
        this.metadata95 = mbuiContext.metadataRegistry().lookup(metadata95Template);
        this.expressionElements = new HashMap<>();

        customFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-form", metadata90)
            .include("class-name")
            .include("module")
            .include("parameters")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 3)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Custom Filter", name, metadata90Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata90);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Custom Filter", name, metadata90Template.resolve(mbuiContext.statementContext(), name), form, metadata90);
            })
            .build();
        errorPageForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-form", metadata91)
            .include("code")
            .include("path")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Error Page", name, metadata91Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata91);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Error Page", name, metadata91Template.resolve(mbuiContext.statementContext(), name), form, metadata91);
            })
            .build();
        expressionFilterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-form", metadata92)
            .include("expression")
            .include("module")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Expression Filter", name, metadata92Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata92);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Expression Filter", name, metadata92Template.resolve(mbuiContext.statementContext(), name), form, metadata92);
            })
            .build();
        gzipForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-form", metadata93)
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 0)
            .unsorted()
            .onSave((form, changedValues) -> noop())
            .build();
        modClusterForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-form", metadata94)
            .include("advertise-frequency")
            .include("advertise-path")
            .include("advertise-protocol")
            .include("advertise-socket-binding")
            .include("broken-node-timeout")
            .include("cached-connections-per-thread")
            .include("connection-idle-timeout")
            .include("connections-per-thread")
            .include("enable-http2")
            .include("health-check-interval")
            .include("http2-enable-push")
            .include("http2-header-table-size")
            .include("http2-initial-window-size")
            .include("http2-max-concurrent-streams")
            .include("http2-max-frame-size")
            .include("http2-max-header-list-size")
            .include("management-access-predicate")
            .include("management-socket-binding")
            .include("max-ajp-packet-size")
            .include("max-request-time")
            .include("max-retries")
            .include("request-queue-size")
            .include("security-key")
            .include("security-realm")
            .include("ssl-context")
            .include("use-alias")
            .include("worker")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 27)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Mod Cluster", name, metadata94Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata94);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Mod Cluster", name, metadata94Template.resolve(mbuiContext.statementContext(), name), form, metadata94);
            })
            .build();
        requestLimitForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-form", metadata95)
            .include("max-concurrent-requests")
            .include("queue-size")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Request Limit", name, metadata95Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata95);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Request Limit", name, metadata95Template.resolve(mbuiContext.statementContext(), name), form, metadata95);
            })
            .build();
        responseHeaderForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-form", metadata96)
            .include("header-name")
            .include("header-value")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> presenter.saveResponseHeader(form, changedValues))
            .prepareReset(form -> presenter.resetResponseHeader(form))
            .build();
        rewriteForm = new ModelNodeForm.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-form", metadata97)
            .include("redirect")
            .include("target")
            .unboundFormItem(new org.jboss.hal.ballroom.form.TextBoxItem("hosts", mbuiContext.resources().constants().hostsUsingThisFilter()), 2)
            .unsorted()
            .onSave((form, changedValues) -> {
                String name = form.getModel().getName();
                saveForm("Rewrite", name, metadata97Template.resolve(mbuiContext.statementContext(), name), changedValues, metadata97);
            })
            .prepareReset(form -> {
                String name = form.getModel().getName();
                resetForm("Rewrite", name, metadata97Template.resolve(mbuiContext.statementContext(), name), form, metadata97);
            })
            .build();

        customFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-custom-filter-table", metadata90)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-custom-filter-table", Ids.ADD), "Custom Filter",
                metadata90Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Custom Filter", metadata90Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        errorPageTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-error-page-table", metadata91)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-error-page-table", Ids.ADD), "Error Page",
                metadata91Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Error Page", metadata91Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("code")
            .build();
        expressionFilterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-expression-filter-table", metadata92)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-expression-filter-table", Ids.ADD), "Expression Filter",
                metadata92Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Expression Filter", metadata92Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("expression")
            .build();
        gzipTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-gzip-table", metadata93)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-gzip-table", Ids.ADD), "GZip",
                metadata93Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("GZip", metadata93Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .build();
        modClusterTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-mod-cluster-table", metadata94)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-mod-cluster-table", Ids.ADD), "Mod Cluster",
                metadata94Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Mod Cluster", metadata94Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("management-socket-binding")
            .build();
        requestLimitTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-request-limit-table", metadata95)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-request-limit-table", Ids.ADD), "Request Limit",
                metadata95Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Request Limit", metadata95Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("max-concurrent-requests")
            .build();
        responseHeaderTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-response-header-table", metadata96)
            .button(mbuiContext.resources().constants().add(), table -> presenter.addResponseHeader(), Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:add)"))
            .button(mbuiContext.resources().constants().remove(), table -> presenter.removeResponseHeader(table.selectedRow()), Scope.SELECTED, Constraint.parse("executable({selected.profile}/subsystem=undertow/configuration=filter/response-header=*:remove)"))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.get("header-name").asString()).asString())
            .column("value", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.get("header-value").asString()).asString())
            .build();
        rewriteTable = new ModelNodeTable.Builder<org.jboss.hal.dmr.NamedNode>("undertow-rewrite-table", metadata97)
            .button(mbuiContext.tableButtonFactory().add(Ids.build("undertow-rewrite-table", Ids.ADD), "Rewrite",
                metadata97Template,
                (name, address) -> presenter.reload()))
            .button(mbuiContext.tableButtonFactory().remove("Rewrite", metadata97Template,
                table -> table.selectedRow().getName(),
                () -> presenter.reload()))
            .column("name", (cell, type, row, meta) -> SafeHtmlUtils.fromString(row.getName()).asString())
            .column("target")
            .build();

        navigation = new VerticalNavigation();
        HTMLElement html265;
        HTMLElement undertowCustomFilterItemElement = section()
            .add(html265 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Custom Filter</h1><p>${metadata90.getDescription().getDescription()}</p>"))
                .asElement())
            .add(customFilterTable)
            .add(customFilterForm)
            .asElement();
        expressionElements.put("html265", html265);
        navigation.addPrimary("undertow-custom-filter-item", "Custom Filter", "fa fa-file-o", undertowCustomFilterItemElement);
        HTMLElement html268;
        HTMLElement undertowErrorPageItemElement = section()
            .add(html268 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Error Page</h1><p>${metadata91.getDescription().getDescription()}</p>"))
                .asElement())
            .add(errorPageTable)
            .add(errorPageForm)
            .asElement();
        expressionElements.put("html268", html268);
        navigation.addPrimary("undertow-error-page-item", "Error Page", "fa fa-bug", undertowErrorPageItemElement);
        HTMLElement html271;
        HTMLElement undertowExpressionFilterItemElement = section()
            .add(html271 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Expression Filter</h1><p>${metadata92.getDescription().getDescription()}</p>"))
                .asElement())
            .add(expressionFilterTable)
            .add(expressionFilterForm)
            .asElement();
        expressionElements.put("html271", html271);
        navigation.addPrimary("undertow-expression-filter-item", "Expression Filter", "fa fa-terminal", undertowExpressionFilterItemElement);
        HTMLElement html274;
        HTMLElement undertowGzipItemElement = section()
            .add(html274 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>GZip</h1><p>${metadata93.getDescription().getDescription()}</p>"))
                .asElement())
            .add(gzipTable)
            .add(gzipForm)
            .asElement();
        expressionElements.put("html274", html274);
        navigation.addPrimary("undertow-gzip-item", "GZip", "fa fa-archive", undertowGzipItemElement);
        HTMLElement html277;
        HTMLElement undertowModClusterItemElement = section()
            .add(html277 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Mod Cluster</h1><p>${metadata94.getDescription().getDescription()}</p>"))
                .asElement())
            .add(modClusterTable)
            .add(modClusterForm)
            .asElement();
        expressionElements.put("html277", html277);
        navigation.addPrimary("undertow-mod-cluster-item", "Mod Cluster Filter", "pficon pficon-cluster", undertowModClusterItemElement);
        HTMLElement html280;
        HTMLElement undertowRequestLimitItemElement = section()
            .add(html280 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Request Limit</h1><p>${metadata95.getDescription().getDescription()}</p>"))
                .asElement())
            .add(requestLimitTable)
            .add(requestLimitForm)
            .asElement();
        expressionElements.put("html280", html280);
        navigation.addPrimary("undertow-request-limit-item", "Request Limit", "fa fa-ban", undertowRequestLimitItemElement);
        HTMLElement html283;
        HTMLElement undertowResponseHeaderItemElement = section()
            .add(html283 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Response Header</h1><p>${metadata96.getDescription().getDescription()}</p>"))
                .asElement())
            .add(responseHeaderTable)
            .add(responseHeaderForm)
            .asElement();
        expressionElements.put("html283", html283);
        navigation.addPrimary("undertow-response-header-item", "Response Header", "fa fa-exchange", undertowResponseHeaderItemElement);
        HTMLElement html286;
        HTMLElement undertowRewriteItemElement = section()
            .add(html286 = div()
                .innerHtml(SafeHtmlUtils.fromSafeConstant("<h1>Rewrite</h1><p>${metadata97.getDescription().getDescription()}</p>"))
                .asElement())
            .add(rewriteTable)
            .add(rewriteForm)
            .asElement();
        expressionElements.put("html286", html286);
        navigation.addPrimary("undertow-rewrite-item", "Rewrite", "fa fa-refresh", undertowRewriteItemElement);
        HTMLElement root = row()
            .add(column()
                .addAll(navigation.panes()))
            .asElement();

        registerAttachable(navigation);
        registerAttachable(customFilterTable);
        registerAttachable(customFilterForm);
        registerAttachable(errorPageTable);
        registerAttachable(errorPageForm);
        registerAttachable(expressionFilterTable);
        registerAttachable(expressionFilterForm);
        registerAttachable(gzipTable);
        registerAttachable(gzipForm);
        registerAttachable(modClusterTable);
        registerAttachable(modClusterForm);
        registerAttachable(requestLimitTable);
        registerAttachable(requestLimitForm);
        registerAttachable(responseHeaderTable);
        registerAttachable(responseHeaderForm);
        registerAttachable(rewriteTable);
        registerAttachable(rewriteForm);

        initElement(root);

        init();
    }

    @Override
    public void attach() {
        super.attach();

            customFilterTable.bindForm(customFilterForm);
            errorPageTable.bindForm(errorPageForm);
            expressionFilterTable.bindForm(expressionFilterForm);
            modClusterTable.bindForm(modClusterForm);
            requestLimitTable.bindForm(requestLimitForm);
            responseHeaderTable.bindForm(responseHeaderForm);
            rewriteTable.bindForm(rewriteForm);

        TemplateUtil.replaceExpression(expressionElements.get("html265"), "${metadata90.getDescription().getDescription()}", String.valueOf(metadata90.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html268"), "${metadata91.getDescription().getDescription()}", String.valueOf(metadata91.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html271"), "${metadata92.getDescription().getDescription()}", String.valueOf(metadata92.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html274"), "${metadata93.getDescription().getDescription()}", String.valueOf(metadata93.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html277"), "${metadata94.getDescription().getDescription()}", String.valueOf(metadata94.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html280"), "${metadata95.getDescription().getDescription()}", String.valueOf(metadata95.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html283"), "${metadata96.getDescription().getDescription()}", String.valueOf(metadata96.getDescription().getDescription()));
        TemplateUtil.replaceExpression(expressionElements.get("html286"), "${metadata97.getDescription().getDescription()}", String.valueOf(metadata97.getDescription().getDescription()));
    }
}
