/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.NamedComponentFactory;
import org.infinispan.factories.SecurityActions;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;

@SurvivesRestarts
@Scope(value=Scopes.NAMED_CACHE)
public abstract class AbstractComponentRegistry
implements Lifecycle,
Cloneable {
    private final boolean trace = this.getLog().isTraceEnabled();
    private static final String DEPENDENCIES_ENABLE_JVMOPTION = "infinispan.debugDependencies";
    public static final boolean DEBUG_DEPENDENCIES = Boolean.getBoolean("infinispan.debugDependencies");
    private Stack<String> debugStack = DEBUG_DEPENDENCIES ? new Stack() : null;
    private static final Object NULL_COMPONENT = new Object();
    private final ConcurrentMap<String, Component> componentLookup = new ConcurrentHashMap<String, Component>(1);
    protected volatile ComponentStatus state = ComponentStatus.INSTANTIATED;
    private static final PrioritizedMethod[] EMPTY_PRIO_METHODS = new PrioritizedMethod[0];

    public ComponentStatus getStatus() {
        return this.state;
    }

    protected abstract ClassLoader getClassLoader();

    protected abstract Log getLog();

    public abstract ComponentMetadataRepo getComponentMetadataRepo();

    public void wireDependencies(Object target) throws CacheConfigurationException {
        try {
            Class<?> targetClass = target.getClass();
            ComponentMetadata metadata = this.getComponentMetadataRepo().findComponentMetadata(targetClass);
            if (metadata == null) {
                return;
            }
            for (ComponentMetadata.InjectFieldMetadata injectFieldMetadata : metadata.getInjectFields()) {
                Class componentClass;
                Field field = injectFieldMetadata.getField();
                if (field == null) {
                    if (System.getSecurityManager() == null) {
                        Class fieldClass = ReflectionUtil.getClassForName((String)injectFieldMetadata.getFieldClassName(), (ClassLoader)this.getClassLoader());
                        try {
                            field = fieldClass.getDeclaredField(injectFieldMetadata.getFieldName());
                        }
                        catch (NoSuchFieldException e) {
                            throw new CacheException((Throwable)e);
                        }
                    } else {
                        field = AccessController.doPrivileged(() -> {
                            Class fieldClass = ReflectionUtil.getClassForName((String)injectFieldMetadata.getFieldClassName(), (ClassLoader)this.getClassLoader());
                            try {
                                return fieldClass.getDeclaredField(injectFieldMetadata.getFieldName());
                            }
                            catch (NoSuchFieldException e) {
                                throw new CacheException((Throwable)e);
                            }
                        });
                    }
                    injectFieldMetadata.setField(field);
                }
                if ((componentClass = injectFieldMetadata.getComponentClass()) == null) {
                    componentClass = System.getSecurityManager() == null ? ReflectionUtil.getClassForName((String)injectFieldMetadata.getComponentType(), (ClassLoader)this.getClassLoader()) : AccessController.doPrivileged(() -> ReflectionUtil.getClassForName((String)injectFieldMetadata.getComponentType(), (ClassLoader)this.getClassLoader()));
                    injectFieldMetadata.setComponentClass(componentClass);
                }
                this.setInjectionField(target, injectFieldMetadata);
            }
            for (Serializable serializable : metadata.getInjectMethods()) {
                Method method;
                Class<?>[] methodParameters = ((ComponentMetadata.InjectMetadata)serializable).getParameterClasses();
                if (methodParameters == null) {
                    methodParameters = System.getSecurityManager() == null ? ReflectionUtil.toClassArray((String[])((ComponentMetadata.InjectMetadata)serializable).getParameters(), (ClassLoader)this.getClassLoader()) : AccessController.doPrivileged(() -> this.lambda$wireDependencies$2((ComponentMetadata.InjectMetadata)serializable));
                    ((ComponentMetadata.InjectMetadata)serializable).setParameterClasses(methodParameters);
                }
                if ((method = ((ComponentMetadata.InjectMetadata)serializable).getMethod()) == null) {
                    method = System.getSecurityManager() == null ? ReflectionUtil.findMethod(targetClass, (String)((ComponentMetadata.InjectMetadata)serializable).getMethodName(), (Class[])((ComponentMetadata.InjectMetadata)serializable).getParameterClasses()) : AccessController.doPrivileged(() -> AbstractComponentRegistry.lambda$wireDependencies$3(targetClass, (ComponentMetadata.InjectMetadata)serializable));
                    ((ComponentMetadata.InjectMetadata)serializable).setMethod(method);
                }
                this.invokeInjectionMethod(target, (ComponentMetadata.InjectMetadata)serializable);
            }
        }
        catch (IllegalLifecycleStateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to configure component (type: " + target.getClass() + ", instance " + target + ")", (Throwable)e);
        }
    }

    public final synchronized void registerComponent(Object component, Class<?> type) {
        this.registerComponent(component, type.getName(), type.equals(component.getClass()));
    }

    public final synchronized void registerComponent(Object component, String name) {
        this.registerComponent(component, name, name.equals(component.getClass().getName()));
    }

    public final synchronized void registerComponent(Object component, String name, boolean nameIsFQCN) {
        this.registerComponentInternal(component, name, nameIsFQCN);
    }

    protected final synchronized void registerNonVolatileComponent(Object component, String name) {
        this.registerComponentInternal(component, name, false);
    }

    protected final synchronized void registerNonVolatileComponent(Object component, Class<?> type) {
        this.registerComponentInternal(component, type.getName(), true);
    }

    protected synchronized void registerComponentInternal(Object component, String name, boolean nameIsFQCN) {
        Component c;
        if (this.state.isStopping() || this.state.isTerminated()) {
            throw new IllegalLifecycleStateException("Trying to register a component after stopping: " + name);
        }
        if (component == null) {
            throw new NullPointerException("Cannot register a null component under name [" + name + "]");
        }
        Component old = (Component)this.componentLookup.get(name);
        if (old != null && old.instance.equals(component)) {
            this.getLog().tracef("Attempting to register a component equal to one that already exists under the same name (%s).  Not doing anything.", name);
            return;
        }
        if (old != null) {
            this.getLog().tracef("Replacing old component %s with new instance %s", old, component);
            old.instance = component;
            old.methodsScanned = false;
            c = old;
        } else {
            c = new Component();
            c.name = name;
            c.instance = component;
            this.componentLookup.put(name, c);
        }
        c.metadata = this.getComponentMetadataRepo().findComponentMetadata(component.getClass());
        try {
            c.buildInjectionFieldsList();
            c.buildInjectionMethodsList();
        }
        catch (ClassNotFoundException cnfe) {
            throw new CacheException("Error injecting dependencies for component " + name, (Throwable)cnfe);
        }
        c.injectDependencies();
        if (old == null) {
            this.getLog().tracef("Registering component %s under name %s", c, name);
        }
        if (this.state == ComponentStatus.RUNNING || this.state == ComponentStatus.INITIALIZING) {
            this.populateLifeCycleMethods(c);
            try {
                this.invokePrioritizedMethods(Arrays.asList(c.startMethods));
            }
            catch (Throwable t) {
                this.componentLookup.remove(name);
                this.handleLifecycleTransitionFailure(t);
            }
        }
    }

    private void invokeInjectionMethod(Object o, ComponentMetadata.InjectMetadata injectMetadata) {
        Class<?>[] dependencies = injectMetadata.getParameterClasses();
        Object[] params = new Object[dependencies.length];
        if (this.trace) {
            this.getLog().tracef("Injecting dependencies for method [%s] on an instance of [%s].", injectMetadata, o.getClass().getName());
        }
        for (int i = 0; i < dependencies.length; ++i) {
            String name = injectMetadata.getParameterName(i);
            boolean nameIsFQCN = !injectMetadata.isParameterNameSet(i);
            params[i] = this.getOrCreateComponent(dependencies[i], name, nameIsFQCN);
        }
        if (System.getSecurityManager() == null) {
            ReflectionUtil.invokeAccessibly((Object)o, (Method)injectMetadata.getMethod(), (Object[])params);
        } else {
            AccessController.doPrivileged(() -> ReflectionUtil.invokeAccessibly((Object)o, (Method)injectMetadata.getMethod(), (Object[])params));
        }
    }

    private void setInjectionField(Object o, ComponentMetadata.InjectFieldMetadata injectFieldMetadata) {
        if (this.trace) {
            this.getLog().tracef("Injecting dependency for field [%s.%s] on an instance of [%s]", injectFieldMetadata.getFieldClassName(), injectFieldMetadata.getFieldName(), o.getClass().getName());
        }
        String name = injectFieldMetadata.getComponentName();
        boolean isFQCN = false;
        if (name == null) {
            isFQCN = true;
            name = injectFieldMetadata.getComponentType();
        }
        Object component = this.getOrCreateComponent(injectFieldMetadata.getComponentClass(), name, isFQCN);
        if (System.getSecurityManager() == null) {
            ReflectionUtil.setAccessibly((Object)o, (Field)injectFieldMetadata.getField(), component);
        } else {
            AccessController.doPrivileged(() -> {
                ReflectionUtil.setAccessibly((Object)o, (Field)injectFieldMetadata.getField(), (Object)component);
                return null;
            });
        }
    }

    protected synchronized <T> T getOrCreateComponent(Class<T> componentClass) {
        return this.getOrCreateComponent(componentClass, componentClass.getName(), true);
    }

    protected <T> T getOrCreateComponent(Class<T> componentClass, String name) {
        return this.getOrCreateComponent(componentClass, name, false);
    }

    protected synchronized <T> T getOrCreateComponent(Class<T> componentClass, String name, boolean nameIsFQCN) {
        Object component;
        Component oldWrapper;
        if (DEBUG_DEPENDENCIES) {
            this.debugStack.push(name);
        }
        if ((oldWrapper = this.lookupComponent(componentClass.getName(), name, nameIsFQCN)) != null) {
            component = this.unwrapComponent(oldWrapper);
        } else {
            AbstractComponentFactory factory = this.getFactory(componentClass);
            this.getLog().tracef("Creating component %s with factory %s", name, factory.getClass());
            Object object = component = factory instanceof NamedComponentFactory ? ((NamedComponentFactory)factory).construct(componentClass, name) : factory.construct(componentClass);
            if (component != null) {
                this.registerComponent(component, name, nameIsFQCN);
            } else {
                this.getLog().tracef("Registering a null for component %s", name);
                this.registerNullComponent(name);
            }
        }
        if (DEBUG_DEPENDENCIES) {
            this.debugStack.pop();
        }
        return (T)component;
    }

    protected synchronized AbstractComponentFactory getFactory(Class<?> componentClass) {
        AbstractComponentFactory cf;
        this.getLog().tracef("Looking up factory for class %s", componentClass);
        String cfClass = this.getComponentMetadataRepo().findFactoryForComponent(componentClass);
        if (cfClass == null) {
            this.throwStackAwareConfigurationException("No registered default factory for component '" + componentClass + "' found!");
        }
        if ((cf = (AbstractComponentFactory)this.getComponent(cfClass)) == null) {
            cf = this.createComponentFactoryInternal(componentClass, cfClass);
        }
        Component c = this.lookupComponent(cfClass, cfClass, true);
        if (c.instance != cf) {
            this.throwStackAwareConfigurationException("Component factory " + cfClass + " incorrectly registered!");
        }
        return cf;
    }

    protected synchronized AbstractComponentFactory createComponentFactoryInternal(Class<?> componentClass, String cfClass) {
        AbstractComponentFactory component = (AbstractComponentFactory)this.getComponent(cfClass);
        if (component != null) {
            return component;
        }
        this.getLog().tracef("Creating factory %s for component %s", cfClass, componentClass);
        AbstractComponentFactory cf = this.instantiateFactory(cfClass);
        if (cf == null) {
            this.throwStackAwareConfigurationException("Unable to locate component factory for component " + componentClass);
        }
        this.registerComponent((Object)cf, cfClass);
        return cf;
    }

    protected Component lookupComponent(String componentClassName, String componentName, boolean nameIsFQCN) {
        return (Component)this.componentLookup.get(componentName);
    }

    AbstractComponentFactory instantiateFactory(String factoryName) {
        Class factory = Util.loadClass((String)factoryName, (ClassLoader)this.getClass().getClassLoader());
        if (AutoInstantiableFactory.class.isAssignableFrom(factory)) {
            try {
                return (AbstractComponentFactory)factory.newInstance();
            }
            catch (Exception e) {
                throw new CacheConfigurationException("Unable to instantiate factory " + factory + "  Debug stack: " + this.debugStack, (Throwable)e);
            }
        }
        throw new CacheConfigurationException("Cannot auto-instantiate factory " + factory + " as it doesn't implement " + AutoInstantiableFactory.class.getSimpleName() + "!  Debug stack: " + this.debugStack);
    }

    protected final synchronized void registerNullComponent(String name) {
        this.registerComponent(NULL_COMPONENT, name, false);
    }

    protected Configuration getConfiguration() {
        return this.getComponent(Configuration.class);
    }

    public <T> T getComponent(Class<T> type) {
        String className = type.getName();
        return this.getComponent(className, className, true);
    }

    public <T> T getComponent(String componentClassName) {
        return this.getComponent(componentClassName, componentClassName, true);
    }

    public <T> T getComponent(String componentClassName, String name) {
        return this.getComponent(componentClassName, name, false);
    }

    public <T> T getComponent(Class<T> componentClass, String name) {
        return this.getComponent(componentClass.getName(), name, false);
    }

    public <T> T getComponent(String componentClassName, String name, boolean nameIsFQCN) {
        Component wrapper = this.lookupComponent(componentClassName, name, nameIsFQCN);
        if (wrapper == null) {
            return null;
        }
        return (T)this.unwrapComponent(wrapper);
    }

    public <T> Optional<T> getOptionalComponent(Class<T> type) {
        return Optional.ofNullable(this.getComponent(type));
    }

    private Object unwrapComponent(Component wrapper) {
        return wrapper.instance == NULL_COMPONENT ? null : wrapper.instance;
    }

    protected ClassLoader registerDefaultClassLoader(ClassLoader loader) {
        ClassLoader loaderToUse = loader == null ? this.getClass().getClassLoader() : loader;
        this.registerComponent((Object)loaderToUse, ClassLoader.class);
        return loaderToUse;
    }

    public void rewire() {
        for (Component c : new HashSet(this.componentLookup.values())) {
            c.injectDependencies();
        }
    }

    private void populateLifecycleMethods() {
        for (Component c : this.componentLookup.values()) {
            this.populateLifeCycleMethods(c);
        }
    }

    private PrioritizedMethod[] processPrioritizedMethods(ComponentMetadata.PrioritizedMethodMetadata[] methodMetadata, Class<?> componentClass, Component c) {
        Object[] retval;
        int numStartMethods = methodMetadata.length;
        if (numStartMethods == 0) {
            retval = EMPTY_PRIO_METHODS;
        } else {
            retval = new PrioritizedMethod[numStartMethods];
            for (int i = 0; i < numStartMethods; ++i) {
                retval[i] = new PrioritizedMethod();
                ((PrioritizedMethod)retval[i]).component = c;
                ((PrioritizedMethod)retval[i]).metadata = methodMetadata[i];
                if (methodMetadata[i].getMethod() != null) continue;
                Method method = ReflectionUtil.findMethod(componentClass, (String)methodMetadata[i].getMethodName());
                methodMetadata[i].setMethod(method);
            }
            if (retval.length > 1) {
                Arrays.sort(retval);
            }
        }
        return retval;
    }

    private void populateLifeCycleMethods(Component c) {
        if (!c.methodsScanned) {
            c.methodsScanned = true;
            Class<?> componentClass = c.instance.getClass();
            c.startMethods = this.processPrioritizedMethods(c.metadata.getStartMethods(), componentClass, c);
            c.postStartMethods = this.processPrioritizedMethods(c.metadata.getPostStartMethods(), componentClass, c);
            c.stopMethods = this.processPrioritizedMethods(c.metadata.getStopMethods(), componentClass, c);
        }
    }

    public synchronized void resetVolatileComponents() {
        this.getLog().tracef("Resetting volatile components", new Object[0]);
        for (Component c : new HashSet(this.componentLookup.values())) {
            if (c.metadata.isSurvivesRestarts()) continue;
            this.getLog().tracef("Removing volatile component %s", c.name);
            this.componentLookup.remove(c.name);
        }
        if (this.trace) {
            this.getLog().tracef("Reset volatile components. Registry now contains %s", this.componentLookup.keySet());
        }
    }

    public void start() {
        this.state = ComponentStatus.INITIALIZING;
        try {
            this.internalStart();
        }
        catch (Throwable t) {
            this.handleLifecycleTransitionFailure(t);
        }
    }

    protected void postStart() {
        ArrayList<PrioritizedMethod> methods = new ArrayList<PrioritizedMethod>(this.componentLookup.size());
        for (Component c : this.componentLookup.values()) {
            Collections.addAll(methods, c.postStartMethods);
        }
        this.invokePrioritizedMethods(methods);
    }

    public synchronized void stop() {
        if (!this.state.stopAllowed()) {
            this.getLog().debugf("Ignoring call to stop() as current state is %s", (Object)this.state);
            return;
        }
        boolean failed = this.state == ComponentStatus.FAILED;
        try {
            this.internalStop();
        }
        catch (Throwable t) {
            if (failed) {
                this.getLog().failedToCallStopAfterFailure(t);
            }
            failed = true;
            this.handleLifecycleTransitionFailure(t);
        }
        finally {
            if (!failed) {
                this.state = ComponentStatus.TERMINATED;
            }
        }
    }

    private void handleLifecycleTransitionFailure(Throwable t) {
        this.state = ComponentStatus.FAILED;
        if (t.getCause() != null && t.getCause() instanceof CacheConfigurationException) {
            throw (CacheConfigurationException)t.getCause();
        }
        if (t.getCause() != null && t.getCause() instanceof InvocationTargetException && t.getCause().getCause() != null && t.getCause().getCause() instanceof CacheConfigurationException) {
            throw (CacheConfigurationException)t.getCause().getCause();
        }
        if (t instanceof CacheException) {
            throw (CacheException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new CacheException(t);
    }

    private void internalStart() throws CacheException, IllegalArgumentException {
        this.populateLifecycleMethods();
        ArrayList<PrioritizedMethod> methods = new ArrayList<PrioritizedMethod>(this.componentLookup.size());
        for (Component c : this.componentLookup.values()) {
            Collections.addAll(methods, c.startMethods);
        }
        this.invokePrioritizedMethods(methods);
        this.addShutdownHook();
        this.state = ComponentStatus.RUNNING;
    }

    private void invokePrioritizedMethods(List<PrioritizedMethod> startMethods) {
        SecurityActions.run(() -> {
            boolean traceEnabled = this.getLog().isTraceEnabled();
            Collections.sort(startMethods);
            for (PrioritizedMethod em : startMethods) {
                if (traceEnabled) {
                    this.getLog().tracef("Invoking start method %s on component %s", em.metadata, em.component.getName());
                }
                em.invoke();
            }
        });
    }

    protected void addShutdownHook() {
    }

    protected void removeShutdownHook() {
    }

    private void internalStop() {
        this.state = ComponentStatus.STOPPING;
        this.removeShutdownHook();
        ArrayList stopMethods = new ArrayList(this.componentLookup.size());
        for (Component c : this.componentLookup.values()) {
            if (c.stopMethods == null) continue;
            Collections.addAll(stopMethods, c.stopMethods);
        }
        Collections.sort(stopMethods);
        SecurityActions.run(() -> {
            boolean traceEnabled = this.getLog().isTraceEnabled();
            for (PrioritizedMethod em : stopMethods) {
                if (traceEnabled) {
                    this.getLog().tracef("Invoking stop method %s on component %s", em.metadata, em.component.getName());
                }
                try {
                    em.invoke();
                }
                catch (Throwable t) {
                    this.getLog().componentFailedToStop(t);
                }
            }
        });
        this.resetVolatileComponents();
    }

    public boolean invocationsAllowed(boolean originLocal) {
        this.getLog().trace("Testing if invocations are allowed.");
        if (this.state.allowInvocations()) {
            return true;
        }
        if (originLocal) {
            return false;
        }
        this.getLog().trace("Is remotely originating.");
        if (this.state == ComponentStatus.INITIALIZING) {
            this.getLog().trace("Cache is initializing; block.");
            try {
                this.blockUntilCacheStarts();
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.getLog().cacheNotStarted();
        }
        return false;
    }

    private void blockUntilCacheStarts() throws InterruptedException, IllegalStateException {
        int pollFrequencyMS = 20;
        TimeService timeService = this.getTimeService();
        long startupWaitTime = this.getConfiguration().clustering().stateTransfer().timeout();
        long giveUpTime = timeService.expectedEndTime(startupWaitTime, TimeUnit.MILLISECONDS);
        while (!timeService.isTimeExpired(giveUpTime) && !this.state.allowInvocations()) {
            Thread.sleep(pollFrequencyMS);
        }
        if (!this.state.allowInvocations()) {
            throw new IllegalStateException("Cache not in STARTED state, even after waiting " + startupWaitTime + " millis.");
        }
    }

    public Set<Component> getRegisteredComponents() {
        HashSet defensiveCopy = new HashSet(this.componentLookup.values());
        return Collections.unmodifiableSet(defensiveCopy);
    }

    public AbstractComponentRegistry clone() throws CloneNotSupportedException {
        AbstractComponentRegistry dolly = (AbstractComponentRegistry)super.clone();
        dolly.state = ComponentStatus.INSTANTIATED;
        return dolly;
    }

    public abstract TimeService getTimeService();

    protected void throwStackAwareConfigurationException(String message) {
        if (this.debugStack == null) {
            throw new CacheConfigurationException(message + ". To get more detail set the system property " + DEPENDENCIES_ENABLE_JVMOPTION + " to true");
        }
        throw new CacheConfigurationException(message + " Debug stack: " + this.debugStack);
    }

    private static /* synthetic */ Method lambda$wireDependencies$3(Class targetClass, ComponentMetadata.InjectMetadata injectMetadata) throws Exception {
        return ReflectionUtil.findMethod((Class)targetClass, (String)injectMetadata.getMethodName(), (Class[])injectMetadata.getParameterClasses());
    }

    private /* synthetic */ Class[] lambda$wireDependencies$2(ComponentMetadata.InjectMetadata injectMetadata) throws Exception {
        return ReflectionUtil.toClassArray((String[])injectMetadata.getParameters(), (ClassLoader)this.getClassLoader());
    }

    static class PrioritizedMethod
    implements Comparable<PrioritizedMethod> {
        ComponentMetadata.PrioritizedMethodMetadata metadata;
        Component component;

        PrioritizedMethod() {
        }

        @Override
        public int compareTo(PrioritizedMethod o) {
            int anotherVal;
            int thisVal = this.metadata.getPriority();
            return thisVal < (anotherVal = o.metadata.getPriority()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PrioritizedMethod)) {
                return false;
            }
            PrioritizedMethod that = (PrioritizedMethod)o;
            if (this.component != null ? !this.component.equals(that.component) : that.component != null) {
                return false;
            }
            return this.metadata != null ? this.metadata.equals(that.metadata) : that.metadata == null;
        }

        public int hashCode() {
            int result = this.metadata != null ? this.metadata.hashCode() : 0;
            result = 31 * result + (this.component != null ? this.component.hashCode() : 0);
            return result;
        }

        void invoke() {
            ReflectionUtil.invokeAccessibly((Object)this.component.instance, (Method)this.metadata.getMethod(), null);
        }

        public String toString() {
            return "PrioritizedMethod{method=" + this.metadata + ", priority=" + this.metadata.getPriority() + '}';
        }
    }

    public class Component {
        Object instance;
        String name;
        boolean methodsScanned;
        ComponentMetadata.InjectMetadata[] injectionMethods;
        ComponentMetadata.InjectFieldMetadata[] injectionFields;
        PrioritizedMethod[] startMethods;
        PrioritizedMethod[] postStartMethods;
        PrioritizedMethod[] stopMethods;
        ComponentMetadata metadata;

        public String toString() {
            return "Component{instance=" + this.instance + ", name=" + this.name + '}';
        }

        public void injectDependencies() {
            if (this.injectionFields != null && this.injectionFields.length > 0) {
                for (Serializable serializable : this.injectionFields) {
                    AbstractComponentRegistry.this.setInjectionField(this.instance, (ComponentMetadata.InjectFieldMetadata)serializable);
                }
            }
            if (this.injectionMethods != null && this.injectionMethods.length > 0) {
                for (Serializable serializable : this.injectionMethods) {
                    AbstractComponentRegistry.this.invokeInjectionMethod(this.instance, (ComponentMetadata.InjectMetadata)serializable);
                }
            }
        }

        public Object getInstance() {
            return this.instance;
        }

        public String getName() {
            return this.name;
        }

        public ComponentMetadata getMetadata() {
            return this.metadata;
        }

        public void buildInjectionMethodsList() throws ClassNotFoundException {
            this.injectionMethods = this.metadata.getInjectMethods();
            if (this.injectionMethods != null && this.injectionMethods.length > 0) {
                Class<?> clazz = this.instance.getClass();
                for (ComponentMetadata.InjectMetadata meta : this.injectionMethods) {
                    Method m;
                    Object[] parameterClasses = meta.getParameterClasses();
                    if (parameterClasses == null) {
                        parameterClasses = ReflectionUtil.toClassArray((String[])meta.getParameters(), (ClassLoader)AbstractComponentRegistry.this.getClassLoader());
                        meta.setParameterClasses((Class<?>[])parameterClasses);
                    }
                    if ((m = meta.getMethod()) != null) continue;
                    try {
                        m = ReflectionUtil.findMethod(clazz, (String)meta.getMethodName(), (Class[])parameterClasses);
                    }
                    catch (CacheException e) {
                        throw new CacheException("Injection method not found in class " + clazz + ": " + meta.getMethodName() + Arrays.toString(parameterClasses), (Throwable)e);
                    }
                    meta.setMethod(m);
                }
            }
        }

        public void buildInjectionFieldsList() throws ClassNotFoundException {
            this.injectionFields = this.metadata.getInjectFields();
            if (this.injectionFields == null || this.injectionFields.length == 0) {
                return;
            }
            Class<?> clazz = this.instance.getClass();
            for (ComponentMetadata.InjectFieldMetadata meta : this.injectionFields) {
                if (meta.getComponentClass() == null) {
                    meta.setComponentClass(ReflectionUtil.getClassForName((String)meta.getComponentType(), (ClassLoader)AbstractComponentRegistry.this.getClassLoader()));
                }
                if (meta.getField() != null) continue;
                Class fieldClass = ReflectionUtil.getClassForName((String)meta.getFieldClassName(), (ClassLoader)AbstractComponentRegistry.this.getClassLoader());
                try {
                    meta.setField(fieldClass.getDeclaredField(meta.getFieldName()));
                }
                catch (NoSuchFieldException e) {
                    throw new CacheException("Injection field " + meta.getFieldClassName() + "." + meta.getFieldName() + " not found in " + clazz, (Throwable)e);
                }
            }
        }
    }
}

