/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task.component;

import java.util.Collection;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.BuildParameters;
import org.jboss.migration.core.task.component.ComponentTaskBuilder;

public interface TaskRunnable {
    public ServerMigrationTaskResult run(TaskContext var1);

    @FunctionalInterface
    public static interface Builder<P extends BuildParameters> {
        public TaskRunnable build(P var1);

        public static <T extends BuildParameters, R extends BuildParameters> Builder<R> of(BuildParameters.Mapper<R, T> mapper, Builder<? super T> tBuilder) {
            return r -> context -> {
                ServerMigrationTaskResult.Builder resultBuilder = new ServerMigrationTaskResult.Builder().skipped();
                for (BuildParameters t : (Collection)mapper.apply(r)) {
                    if (tBuilder.build((Object)t).run(context).getStatus() != ServerMigrationTaskResult.Status.SUCCESS) continue;
                    resultBuilder.success();
                }
                return resultBuilder.build();
            };
        }

        public static <T extends BuildParameters, R extends BuildParameters> Builder<R> of(BuildParameters.Mapper<R, T> mapper, ComponentTaskBuilder<? super T, ?> tBuilder) {
            return Builder.of(mapper, (? super T params) -> context -> context.execute(tBuilder.build((Object)params)).getResult());
        }

        public static <T extends BuildParameters, R extends BuildParameters> Builder<R> of(Collection<T> params, Builder<? super T> tBuilder) {
            return r -> context -> {
                ServerMigrationTaskResult.Builder resultBuilder = new ServerMigrationTaskResult.Builder().skipped();
                for (BuildParameters t : params) {
                    if (tBuilder.build((Object)t).run(context).getStatus() != ServerMigrationTaskResult.Status.SUCCESS) continue;
                    resultBuilder.success();
                }
                return resultBuilder.build();
            };
        }

        public static <T extends BuildParameters, R extends BuildParameters> Builder<R> of(Collection<T> tParams, ComponentTaskBuilder<? super T, ?> tBuilder) {
            return Builder.of(tParams, (? super T params) -> context -> context.execute(tBuilder.build((Object)params)).getResult());
        }
    }
}

