/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import org.jboss.msc.Service;
import org.jboss.msc.service.DelegatingServiceBuilder;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.server.singleton.LocalSingletonService;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.service.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.service.SingletonServiceConfigurator;

public class LocalSingletonServiceConfigurator
extends SimpleServiceNameProvider
implements SingletonServiceConfigurator {
    public LocalSingletonServiceConfigurator(ServiceName name) {
        super(name);
    }

    public SingletonServiceBuilder<?> build(ServiceTarget target) {
        return new LocalSingletonServiceBuilder(target.addService(this.getServiceName()));
    }

    public SingletonServiceConfigurator requireQuorum(int quorum) {
        return this;
    }

    public SingletonServiceConfigurator electionPolicy(SingletonElectionPolicy policy) {
        return this;
    }

    private static class LocalSingletonServiceBuilder<T>
    extends DelegatingServiceBuilder<T>
    implements SingletonServiceBuilder<T> {
        LocalSingletonServiceBuilder(ServiceBuilder<T> builder) {
            super(builder);
        }

        public ServiceBuilder<T> setInstance(Service service) {
            return super.setInstance((Service)new LocalSingletonService(service));
        }
    }
}

