/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.tools.xml;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stax.StAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientRequestor;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.cli.commands.ActionAbstract;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.tools.xml.XMLMessageImporter;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.activemq.artemis.utils.ListUtil;
import org.jboss.logging.Logger;

@Command(name="imp", description="Import all message-data using an XML that could be interpreted by any system.")
public final class XmlDataImporter
extends ActionAbstract {
    private static final Logger logger = Logger.getLogger(XmlDataImporter.class);
    private XMLStreamReader reader;
    private XMLMessageImporter messageReader;
    ClientSession managementSession;
    boolean localSession = false;
    final Map<String, String> addressMap = new HashMap<String, String>();
    final Map<String, Long> queueIDs = new HashMap<String, Long>();
    HashMap<String, String> oldPrefixTranslation = new HashMap();
    private ClientSession session;
    @Option(name={"--host"}, description="The host used to import the data (default localhost)")
    public String host = "localhost";
    @Option(name={"--port"}, description="The port used to import the data (default 61616)")
    public int port = 61616;
    @Option(name={"--transaction"}, description="If this is set to true you will need a whole transaction to commit at the end. (default false)")
    public boolean transactional;
    @Option(name={"--user"}, description="User name used to import the data. (default null)")
    public String user = null;
    @Option(name={"--password"}, description="User name used to import the data. (default null)")
    public String password = null;
    @Option(name={"--input"}, description="The input file name (default=exp.dmp)", required=true)
    public String input = "exp.dmp";
    @Option(name={"--sort"}, description="Sort the messages from the input (used for older versions that won't sort messages)")
    public boolean sort = false;
    @Option(name={"--legacy-prefixes"}, description="Do not remove prefixes from legacy imports")
    public boolean legacyPrefixes = false;
    TreeSet<XMLMessageImporter.MessageInfo> messages;

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public Object execute(ActionContext context) throws Exception {
        this.process(this.input, this.host, this.port, this.transactional);
        return null;
    }

    public void process(String inputFileName, String host, int port, boolean transactional) throws Exception {
        try (FileInputStream inputFile = new FileInputStream(inputFileName);){
            this.process(inputFile, host, port, transactional);
        }
    }

    public void process(InputStream inputStream, ClientSession session) throws Exception {
        this.process(inputStream, session, null);
    }

    public void process(InputStream inputStream, ClientSession session, ClientSession managementSession) throws Exception {
        this.reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        this.messageReader = new XMLMessageImporter(this.reader, session);
        this.messageReader.setOldPrefixTranslation(this.oldPrefixTranslation);
        this.session = session;
        this.managementSession = managementSession != null ? managementSession : session;
        this.processXml();
    }

    public void process(InputStream inputStream, String host, int port, boolean transactional) throws Exception {
        ClientSession managementSession;
        ClientSession session;
        HashMap<String, String> connectionParams = new HashMap<String, String>();
        connectionParams.put("host", host);
        connectionParams.put("port", Integer.toString(port));
        ServerLocator serverLocator = ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NettyConnectorFactory.class.getName(), connectionParams)});
        ClientSessionFactory sf = serverLocator.createSessionFactory();
        if (this.user != null || this.password != null) {
            session = sf.createSession(this.user, this.password, false, !transactional, true, false, 0);
            managementSession = sf.createSession(this.user, this.password, false, true, true, false, 0);
        } else {
            session = sf.createSession(false, !transactional, true);
            managementSession = sf.createSession(false, true, true);
        }
        this.localSession = true;
        this.process(inputStream, session, managementSession);
    }

    public void validate(String fileName) throws Exception {
        try (FileInputStream file = new FileInputStream(fileName);){
            this.validate(file);
        }
    }

    public void validate(InputStream inputStream) throws Exception {
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(inputStream);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(XmlDataImporter.findResource("schema/artemis-import-export.xsd"));
        Validator validator = schema.newValidator();
        validator.validate(new StAXSource(reader));
        reader.close();
    }

    private static URL findResource(final String resourceName) {
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return ClassloadingUtil.findResource((String)resourceName);
            }
        });
    }

    private void processXml() throws Exception {
        if (this.sort) {
            this.messages = new TreeSet<XMLMessageImporter.MessageInfo>(new Comparator<XMLMessageImporter.MessageInfo>(){

                @Override
                public int compare(XMLMessageImporter.MessageInfo o1, XMLMessageImporter.MessageInfo o2) {
                    if (o1.id == o2.id) {
                        return 0;
                    }
                    if (o1.id > o2.id) {
                        return 1;
                    }
                    return -1;
                }
            });
        }
        try {
            while (this.reader.hasNext()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("EVENT:[" + this.reader.getLocation().getLineNumber() + "][" + this.reader.getLocation().getColumnNumber() + "] "));
                }
                if (this.reader.getEventType() == 1) {
                    if ("binding".equals(this.reader.getLocalName())) {
                        this.oldBinding();
                    } else if ("queue-binding".equals(this.reader.getLocalName())) {
                        this.bindQueue();
                    } else if ("address-binding".equals(this.reader.getLocalName())) {
                        this.bindAddress();
                    } else if ("message".equals(this.reader.getLocalName())) {
                        this.processMessage();
                    }
                }
                this.reader.next();
            }
            if (this.sort) {
                for (XMLMessageImporter.MessageInfo msgtmp : this.messages) {
                    this.sendMessage(msgtmp.queues, msgtmp.message, msgtmp.tempFile);
                }
            }
            if (!this.session.isAutoCommitSends()) {
                this.session.commit();
            }
        }
        finally {
            if (this.localSession) {
                this.session.close();
                this.managementSession.close();
            }
        }
    }

    private void processMessage() throws Exception {
        XMLMessageImporter.MessageInfo info = this.messageReader.readMessage(false);
        if (this.sort) {
            this.messages.add(info);
        } else {
            this.sendMessage(info.queues, info.message, info.tempFile);
        }
    }

    private void sendMessage(List<String> queues, Message message, File tempFileName) throws Exception {
        StringBuilder logMessage = new StringBuilder();
        String destination = this.addressMap.get(queues.get(0));
        logMessage.append("Sending ").append(message).append(" to address: ").append(destination).append("; routed to queues: ");
        ByteBuffer buffer = ByteBuffer.allocate(queues.size() * 8);
        for (String queue : queues) {
            long queueID;
            if (this.queueIDs.containsKey(queue)) {
                queueID = this.queueIDs.get(queue);
            } else {
                try (ClientRequestor requestor = new ClientRequestor(this.managementSession, "activemq.management");){
                    ClientMessage managementMessage = this.managementSession.createMessage(false);
                    ManagementHelper.putAttribute((ICoreMessage)managementMessage, (String)("queue." + queue), (String)"ID");
                    this.managementSession.start();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Requesting ID for: " + queue));
                    }
                    ClientMessage reply = requestor.request(managementMessage);
                    Number idObject = (Number)ManagementHelper.getResult((ICoreMessage)reply);
                    queueID = idObject.longValue();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("ID for " + queue + " is: " + queueID));
                }
                this.queueIDs.put(queue, queueID);
            }
            logMessage.append(queue).append(", ");
            buffer.putLong(queueID);
        }
        logMessage.delete(logMessage.length() - 2, logMessage.length());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)logMessage);
        }
        message.putBytesProperty(Message.HDR_ROUTE_TO_IDS, buffer.array());
        try (ClientProducer producer = this.session.createProducer(destination);){
            producer.send(message);
        }
        if (tempFileName != null) {
            try {
                this.session.commit();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!tempFileName.delete()) {
                ActiveMQServerLogger.LOGGER.couldNotDeleteTempFile(tempFileName.getAbsolutePath());
            }
        }
    }

    private void oldBinding() throws Exception {
        ClientSession.AddressQuery addressQuery;
        String newQueueName;
        String newaddress;
        String queueName = "";
        String address = "";
        String filter = "";
        block10: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "address": {
                    address = this.reader.getAttributeValue(i);
                    continue block10;
                }
                case "queue-name": {
                    queueName = this.reader.getAttributeValue(i);
                    continue block10;
                }
                case "filter-string": {
                    filter = this.reader.getAttributeValue(i);
                }
            }
        }
        if (queueName == null || address == null || filter == null) {
            throw new IllegalStateException("invalid format, missing queue, address or filter");
        }
        RoutingType routingType = RoutingType.MULTICAST;
        if (address.startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString())) {
            routingType = RoutingType.ANYCAST;
            if (!this.legacyPrefixes) {
                address = newaddress = address.substring(PacketImpl.OLD_QUEUE_PREFIX.length());
            }
        } else if (address.startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString())) {
            routingType = RoutingType.MULTICAST;
            if (!this.legacyPrefixes) {
                address = newaddress = address.substring(PacketImpl.OLD_TOPIC_PREFIX.length());
            }
        }
        if (queueName.startsWith(PacketImpl.OLD_QUEUE_PREFIX.toString())) {
            if (!this.legacyPrefixes) {
                newQueueName = queueName.substring(PacketImpl.OLD_QUEUE_PREFIX.length());
                this.oldPrefixTranslation.put(queueName, newQueueName);
                queueName = newQueueName;
            }
        } else if (queueName.startsWith(PacketImpl.OLD_TOPIC_PREFIX.toString()) && !this.legacyPrefixes) {
            newQueueName = queueName.substring(PacketImpl.OLD_TOPIC_PREFIX.length());
            this.oldPrefixTranslation.put(queueName, newQueueName);
            queueName = newQueueName;
        }
        if (!(addressQuery = this.session.addressQuery(SimpleString.toSimpleString((String)address))).isExists()) {
            this.session.createAddress(SimpleString.toSimpleString((String)address), routingType, true);
        }
        if (!filter.equals("__AMQX=-1")) {
            ClientSession.QueueQuery queueQuery = this.session.queueQuery(new SimpleString(queueName));
            if (!queueQuery.isExists()) {
                this.session.createQueue(address, routingType, queueName, filter, true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Binding queue(name=" + queueName + ", address=" + address + ", filter=" + filter + ")"));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Binding " + queueName + " already exists so won't re-bind."));
            }
        }
        this.addressMap.put(queueName, address);
    }

    private void bindQueue() throws Exception {
        String queueName = "";
        String address = "";
        String filter = "";
        String routingType = "";
        block12: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName;
            switch (attributeName = this.reader.getAttributeLocalName(i)) {
                case "address": {
                    address = this.reader.getAttributeValue(i);
                    continue block12;
                }
                case "name": {
                    queueName = this.reader.getAttributeValue(i);
                    continue block12;
                }
                case "filter-string": {
                    filter = this.reader.getAttributeValue(i);
                    continue block12;
                }
                case "routing-type": {
                    routingType = this.reader.getAttributeValue(i);
                }
            }
        }
        ClientSession.QueueQuery queueQuery = this.session.queueQuery(new SimpleString(queueName));
        if (!queueQuery.isExists()) {
            this.session.createQueue(address, RoutingType.valueOf((String)routingType), queueName, filter, true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Binding queue(name=" + queueName + ", address=" + address + ", filter=" + filter + ")"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Binding " + queueName + " already exists so won't re-bind."));
        }
        this.addressMap.put(queueName, address);
    }

    private void bindAddress() throws Exception {
        String addressName = "";
        String routingTypes = "";
        block8: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String attributeName = this.reader.getAttributeLocalName(i);
            switch (attributeName) {
                case "name": {
                    addressName = this.reader.getAttributeValue(i);
                    continue block8;
                }
                case "routing-types": {
                    routingTypes = this.reader.getAttributeValue(i);
                }
            }
        }
        ClientSession.AddressQuery addressQuery = this.session.addressQuery(new SimpleString(addressName));
        if (!addressQuery.isExists()) {
            EnumSet<RoutingType> set = EnumSet.noneOf(RoutingType.class);
            for (String routingType : ListUtil.toList((String)routingTypes)) {
                set.add(RoutingType.valueOf((String)routingType));
            }
            this.session.createAddress(SimpleString.toSimpleString((String)addressName), set, false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Binding address(name=" + addressName + ", routingTypes=" + routingTypes + ")"));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Binding " + addressName + " already exists so won't re-bind."));
        }
    }
}

